/***************************************************************************
    file	         : kb_complinkdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>
#include	<qregexp.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_attr.h"
#include	"kb_complink.h"


#ifndef 	_WIN32
#include 	"kb_complinkdlg.moc"
#else
#include 	"kb_complinkdlg.h"
#endif



/*  KBCompLinkPropDlg							*/
/*  KBCompLinkPropDlg							*/
/*		: Constructor for item properties dialog		*/
/*  item	: KBCompLink *	   : Parent item			*/
/*  caption	: const char *     : Dialog box caption			*/
/*  attribs	: QList<KBAttr>&   : List of attributes			*/
/*  iniAttr	: cchar *	   : Initial attribute			*/
/*  (returns)	: KBCompLinkPropDlg:					*/

KBCompLinkPropDlg::KBCompLinkPropDlg
	(	KBCompLink	*compLink,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBPropDlg	(compLink, caption, attribs, iniAttr),
	m_compLink	(compLink),
	m_overrideDlg	(&topWidget, compLink)
{
	m_overrideDlg.hide () ;
}

/*  KBCompLinkPropDlg							*/
/*  ~KBCompLinkPropDlg							*/
/*		: Destructor for component link properties dialog	*/
/*  (returns)	: void	:						*/

KBCompLinkPropDlg::~KBCompLinkPropDlg ()
{
}

/*  KBCompLinkPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBCompLinkPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	if (aName == "override")
	{
		m_overrideDlg.startUp() ;
		setUserWidget (&m_overrideDlg) ;
		return	true  ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBCompLinkDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBCompLinkPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	if (aName == "hidden")
	{
		setProperty (aName, m_overrideDlg.getText()) ;
		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBCompLinkDlg							*/
/*  clickOK	  : Handle OK button click				*/
/*  (returns)	  : void	:					*/

void	KBCompLinkPropDlg::clickOK ()
{
	m_overrideDlg.fixUp   () ;
	KBPropDlg   ::clickOK () ;
}

/*  KBCompLinkPropDlg							*/
/*  preExec	: Execute dialog					*/
/*  (returns)	: void		:					*/

void	KBCompLinkPropDlg::preExec ()
{
	setProperty ("override", m_overrideDlg.getText()) ;
}



/*  compLinkPropDlg							*/
/*		  : Run the complink properties dialog			*/
/*  compLink	  : KBCompLink *  : Parent object			*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : bool	  : Success				*/

bool 	LIBKBASE_API compLinkPropDlg
	(	KBCompLink	*compLink,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBCompLinkPropDlg fDlg (compLink, caption, attribs, iniAttr) ;
	return	fDlg.exec () ;
}
