/***************************************************************************
    file	         : kb_attritem.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ATTRITEM_H
#define	__KB_ATTRITEM_H


#include	<qlist.h>
#include	<qstring.h>
#include	<qwidget.h>
#include	<qcombobox.h>
#include	<qlistview.h>

#include	"kb_classes.h"
#include	"libkbase_exports.h"


struct	LIBKBASE_API	IntChoice
{
	int	value	;
	cchar	*descr	;
}	;


/*  KBAttrItem								*/
/*  --------								*/
/*  This class contains information about each attribute that appears	*/
/*  in a properties dialog box.	Derived classes handle special display	*/
/*  requirements.							*/

class	KBAttrDlg	;

class	LIBKBASE_API	KBAttrItem
{
protected :

	KBAttr			*m_attr		;
	QString			m_value		;
	QList<QListViewItem>	m_lvitems	;

public	:

	KBAttrItem 			(KBAttr *) ;
	virtual ~KBAttrItem		()	;

	virtual	QString		displayValue	() ;
	void			display		() ;


	void			appendItem	(QListViewItem *) ;

	virtual	QString		&value		() ;
	virtual	void		setValue	(const QString &) ;
	virtual	void		clear		() ;
	virtual	void		save		() ;

	virtual	KBAttrDlg	*getAttrDlg	(QWidget *, QDict<KBAttrItem> &) ;

	inline	KBAttr	*attr	()
	{
		return	m_attr	;
	}

	static	void	showChoices	(IntChoice *, const QString &, QComboBox * = 0) ;
}	;

#endif	// __KB_ATTRITEM_H
