/***************************************************************************
    file	         : kb_attralign.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_attralign.h"

#if		! __KB_RUNTIME

#include	"kb_attraligndlg.h"


/*  KBAttrAlign								*/
/*  getAttrDlg	: Get dialog component for alignment			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrDlg *		: Actually KBAttrAlignDlg	*/

KBAttrDlg
	*KBAttrAlign::getAttrDlg
	(	QWidget			*parent,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
{
	return	new KBAttrAlignDlg (parent, this, item, attrDict) ;
}

/*  KBAttrAlign								*/
/*  displayValue: Get display text for value				*/
/*  value	: const QString & : Actual value			*/
/*  (returns)	: QString	  : Display text for value		*/

QString	KBAttrAlign::displayValue
	(	const QString	&value
	)
{
	QString	text	= "" ;
	uint	v	= value.toInt() ;

	if (v != RICHTEXT)
	{
		QString	lr	;
		QString	ud	;

		switch (v & Horizontal_Mask)
		{
			case 0		      :
			case Qt::AlignLeft    : lr = TR("left"  ) ; break ;
			case Qt::AlignHCenter : lr = TR("center") ; break ;
			case Qt::AlignRight   : lr = TR("right" ) ; break ;
			default	: break ;
		}

		switch (v & Vertical_Mask)
		{
			case 0		      :
			case Qt::AlignTop     : ud = TR("top"   ) ; break ;
			case Qt::AlignVCenter : ud = TR("center") ; break ;
			case Qt::AlignBottom  : ud = TR("bottom") ; break ;
			default	: break ;
		}

		text	= lr + "," + ud ;
	}
	else	text	= "richtext"	;

	return	text	;
}

#endif

/*  KBAttrAlign								*/
/*  replicate	: Replicate attribute with new owner			*/
/*  (returns)	: KBAttr *	: Replicant				*/

KBAttr	*KBAttrAlign::replicate
	(	KBNode	*owner
	)
{
	return	new KBAttrAlign (owner, name, getValue(), nFlags) ;
}

int	KBAttrAlign::dummy ()
{
	return	0	;
}
