/***************************************************************************
    file	         : kb_macroquery.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_macroquery.h"
#include	"kb_objbase.h"
#include	"kb_form.h"


/*  KBMacroOpenQuery							*/
/*  KBMacroOpenQuery							*/
/* 		: Macro to open a query					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroOpenQuery::KBMacroOpenQuery
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "OpenQuery")
{
}

/*  KBMacroOpenQuery							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroOpenQuery::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroOpenQuery							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroOpenQuery::execute
	(	KBError		&pError
	)
{
	KBLocation location 
	(	m_exec->getDBInfo (),
		"query",
		m_exec->getServer (),
		m_args[0]
	)	;

	QDict<QString>	pDict	;
	KBNode		*node	;
	KB::ShowAs	showAs	= m_args[1] == "Design" ? KB::ShowAsDesign : KB::ShowAsData ;

	KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
						   (	location,
						 	showAs,
						 	pDict,
						 	pError
						   )	;

	fprintf
	(	stderr,
		"Macro::openQuery: rc=%d\n",
		(int)rc
	)	;

	if ((rc != KB::ShowRCOK) && (rc != KB::ShowRCCancel))
		return	false	;

	node = KBAppPtr::getCallback()->objectNode(location) ;

	fprintf
	(	stderr,
		"Macro::openQuery: node=[%p]\n",
		(void *)node
	)	;

	m_exec->addNode ("query", node) ;
	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroCloseQuery							*/
/*  KBMacroCloseQuery							*/
/* 		: Macro to close a query					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroCloseQuery::KBMacroCloseQuery
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "CloseQuery")
{
}

/*  KBMacroCloseQuery							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroCloseQuery::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 1, pError) ;
}

/*  KBMacroCloseQuery							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroCloseQuery::execute
	(	KBError		&
	)
{
	KBNode	  *node = m_exec->getNode (m_args[0], "query") ;

	if ((node != 0) && (node->isForm() != 0))
		node->isForm()->getDocRoot()->doRequestClose(1) ;

	return	true	;
}

/*  ------------------------------------------------------------------  */


NEWMACRO(OpenQuery )
NEWMACRO(CloseQuery)

/*  ------------------------------------------------------------------  */

#ifdef	__DOCS
  <macro name="OpenQuery">
    <arg type="object:query" legend="Query Name"/>
    <arg type="choice" legend="Mode">
      <choice value="Data"/>
      <choice value="Design"/>
    </arg>
      <![CDATA[
        <h3>Open Query</h3>
        Opens the named query. Control will return immediately.
      ]]>
  </macro>
  <macro name="CloseQuery">
    <arg type="object:query" legend="Query Name"/>
      <![CDATA[
        <h3>Close Query</h3>
        Closes the named query.
      ]]>
  </macro>
#endif	// __DOCS
