/***************************************************************************
    file	         : kb_macroreport.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_macroreport.h"
#include	"kb_objbase.h"
#include	"kb_report.h"


/*  KBMacroOpenReport							*/
/*  KBMacroOpenReport							*/
/* 		: Macro to open a report				*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroOpenReport::KBMacroOpenReport
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "OpenReport")
{
}

/*  KBMacroOpenReport							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroOpenReport::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroOpenReport							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroOpenReport::execute
	(	KBError		&pError
	)
{
	KBLocation location 
	(	m_exec->getDBInfo (),
		"report",
		m_exec->getServer (),
		m_args[0]
	)	;

	QDict<QString>	pDict	;
	KBNode		*node	;
	KB::ShowAs	showAs	= m_args[1] == "Design" ? KB::ShowAsDesign : KB::ShowAsData ;

	KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
						   (	location,
						 	showAs,
						 	pDict,
						 	pError
						   )	;
	fprintf
	(	stderr,
		"Macro::openReport: rc=%d\n",
		(int)rc
	)	;

	if ((rc != KB::ShowRCOK) && (rc != KB::ShowRCCancel))
		return	false	;

	node = KBAppPtr::getCallback()->objectNode(location) ;

	fprintf
	(	stderr,
		"Macro::openReport: node=[%p]\n",
		(void *)node
	)	;

	m_exec->addNode ("report", node) ;
	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroCloseReport							*/
/*  KBMacroCloseReport							*/
/* 		: Macro to close a report				*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroCloseReport::KBMacroCloseReport
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "CloseReport")
{
}

/*  KBMacroCloseReport							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroCloseReport::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 1, pError) ;
}

/*  KBMacroCloseReport							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroCloseReport::execute
	(	KBError		&
	)
{
	KBNode 	*node = m_exec->getNode (m_args[0], "report")  ;

	if ((node != 0) && (node->isReport() != 0))
		node->isReport()->getDocRoot()->doRequestClose(1) ;

	return	true	;
}

/*  ------------------------------------------------------------------  */


NEWMACRO(OpenReport )
NEWMACRO(CloseReport)

/*  ------------------------------------------------------------------  */

#ifdef	__DOCS
  <macro name="OpenReport">
    <arg type="text" legend="Report Name"/>
    <arg type="choice" legend="Mode">
      <choice value="Data"/>
      <choice value="Design"/>
    </arg>
      <![CDATA[
        <h3>Open Report</h3>
        Opens the named report. Control will return immediately, unless the
        report is modal, in which case execution is paused until the user
        closes the report.
      ]]>
  </macro>
  <macro name="CloseReport">
    <arg type="text" legend="Report Name"/>
      <![CDATA[
        <h3>Close Report</h3>
        Closes the named report.
      ]]>
  </macro>
#endif	// __DOCS
