/***************************************************************************
    file	         : string.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>
#include	<setjmp.h>
#include	<ctype.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"


/*L el_ston	: Convert string to number				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Number				*/

LFUNC	VALUE	el_ston
	(	VALUE	*argv
	)
{
	char	*tail	;
	char	*str	= argv[0].val.str->text  ;
	int	num	= strtol (str, &tail, 0) ;

	if ((*tail != 0) && (argv[1].val.num != 0))
		el_error ("String \"%s\" is not a number", str) ;

	return	VALUE (num) ;
}

/*L el_stod	: Convert string to double				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Number				*/

LFUNC	VALUE	el_stod
	(	VALUE	*argv
	)
{
	char	*tail	;
	char	*str	= argv[0].val.str->text ;
	VALUE	resval	;

	resval.tag	= &tagDBL ;
	resval.val.dbl	= strtod (str, &tail) ;
	if ((*tail != 0) && (argv[1].val.num != 0))
		el_error ("String \"%s\" is not a double", str) ;
	return	resval	;
}

/*L el_strlen	: Find length of string					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: String length				*/

LFUNC	VALUE	el_strlen
	(	VALUE	*argv
	)
{
	return	VALUE (strlen (argv[0].val.str->text)) ;
}

/*L el_substr	: Extract substring					*/
/*  argv	: VALUE *	: Arguments				*/
/* (returns)	: VALUE		: String				*/

LFUNC	VALUE	el_substr
	(	VALUE	*argv
	)
{
	VALUE	resval	;
	char	*str	= argv[0].val.str->text ;
	int	off	= argv[1].val.num ;
	int	len	= argv[2].val.num ;
	STRING	*string	;

	/* Ensure that the offset and the length are not negative. If	*/
	/* so then set them to zero.					*/
	if (off < 0) off = 0 ;
	if (len < 0) len = 0 ;

	/* If the string is not long enough then the length of the	*/
	/* substring is truncated to the maximum possible. Then try to	*/
	/* allocate sufficient space for the result.			*/
	if ((unsigned)(off + len) > strlen (str)) len = strlen (str) - off ;

	string = new STRING (len + 1) ;

	/* Copy in the substring. There is no need to terminate it as	*/
	/* the space was allocated with a call to "el_allocate".	*/
	resval.tag	= &tagSTR  ;
	resval.val.str	= string   ;
	strncpy	(string->text, &str[off], len) ;

	return	resval ;
}

/*L el_index	: See if character is in string				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Index (-1 if not found)		*/

LFUNC	VALUE	el_index
	(	VALUE	*argv
	)
{
	char	*str	= argv[0].val.str->text		;
	char	*pos	= strchr (str, argv[1].val.num)	;
	int	num	= pos == NULL ? -1 : pos - str  ;
	return	VALUE (num) ;
}

/*L el_stoc	: Convert string to character				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

LFUNC	VALUE	el_stoc
	(	VALUE	*argv
	)
{
	return	VALUE (argv[0].val.str->text[0]) ;
}

/*L el_escape	: Process string for escapes				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

LFUNC	VALUE	el_escape
	(	VALUE	*argv
	)
{
	const char	*srce	= argv[0].val.str->text	;
	int		ext	= argv[1].val.num	;

	/* Allocate space for the processed string. Since this cannot	*/
	/* exceed the source in length, allocate that much.		*/
	STRING	*str	= new STRING (strlen(srce))	;
	char	*dest	= str->text 			;

	while (*srce)
		if (*srce == '\\')
			srce	= _el_escape (++srce, dest++, ext) ;
		else	*dest++	= *srce++ ;

	*dest	= 0	;
	return	VALUE (str) ;
}

/*L el_split	: Split string into tokens				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Vector of tokens			*/

LFUNC	VALUE	el_split
	(	VALUE	*argv
	)
{
	char	*str	= argv[0].val.str->text	;
	int	sep	= argv[1].val.num	;
	int	maxt	= argv[2].val.num	;
	VEC	*tokvec	;
	int	ntok	;
	char	*sptr1	;
	char	*sptr2	;

	if (maxt == 0) maxt = 0x7fff ;

	/* Count the number of tokens in the string and allocate a	*/
	/* vector. Note that the number of tokens is one greater than	*/
	/* the number of separators, and is limited to the maximum	*/
	/* number of tokens.						*/
	for (sptr1 = str, ntok = 1 ; *sptr1 != 0 ; sptr1 += 1)
	{	if (*sptr1 ==  sep) ntok += 1 ;
		if (ntok   >= maxt) break ;
	}

	VALUE	resval	(tokvec = new VEC (ntok)) ;

	/* Now split the string up into the tokens, storing these in	*/
	/* successing elements of the vector.				*/
	for (sptr1 = sptr2 = str, ntok = 0 ;; )
		if ((*sptr2 == sep) || (*sptr2 == 0))
		{	if ((*sptr2 == 0) || (ntok < maxt - 1))
			{	STRING	*str = new STRING (sptr2 - sptr1 + 1) ;
				memcpy (str->text, sptr1, sptr2 - sptr1) ;
				tokvec->vals[ntok] = str ;
				if (*sptr2 == 0) break ;
				sptr1  = sptr2	= sptr2 + 1 ;
				ntok  += 1	;
			}
			else	sptr2 += 1	;
		}
		else	sptr2 += 1	;

	return	resval	;
		
}

static	MC	el_strSpec   [] =
{
	{	"length",	{ 				0 },	el_strlen	},
	{	"split",	{ &tagNUM, &tagNUM,		0 },	el_split	},
	{	"substr",	{ &tagNUM, &tagNUM,		0 },	el_substr	},
	{	"tochar",	{ 				0 },	el_stoc		},
	{	"tonum",	{ &tagNUM,			0 },	el_ston		},
	{	"todouble",	{ &tagNUM,			0 },	el_stod		},
	{	"index",	{ &tagNUM,			0 },	el_index	},
	{	"esccape",	{ &tagNUM,			0 },	el_escape	},
	{	NULL,		{				0 },	NULL		}
}	;

static	ELTAG	*el_strAllow [] =
{
	&tagSTR,
	0
}	;

METHSET	el_strMethSet =
{
	0,
	el_strAllow,
	el_strSpec
}	;

/*  STRING								*/
/*  STRING	: Constructor for STRING object				*/
/*  _text	: const char *	: Text string				*/
/*  (returns)	: STRING						*/

STRING::STRING
	(	const char	*_text
	)
	:
	text	((char *)el_allocate(strlen(_text) + 1, "STRING::STRING"))
{
	strcpy	(text, _text) ;
//	fprintf	(stderr, "alloc STRING %08x (%s)\n", (unsigned int)this, text) ;
}

/*  STRING								*/
/*  STRING	: Constructor for STRING object				*/
/*  len		: int		: Length to allocate			*/
/*  (returns)	: STRING						*/

STRING::STRING
	(	int	len
	)
	:
	text	((char *)el_allocate(len + 1, "STRING::STRING"))
{
	text[0]	= 0 ;
//	fprintf	(stderr, "alloc STRING %08x [%d]\n", (unsigned int)this, len + 1) ;
}

/*  STRING								*/
/*  ~STRING	: Destructor for STRING object				*/
/*  (returns)	:		:					*/

STRING::~STRING ()
{
//	fprintf	(stderr, "free  STRING %08x (%s)\n", (unsigned int)this, text) ;
	free	((void *)text) ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for a string			*/
/*  str		: STRING *	: The string				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	STRING	*str
	)
{
	tag	= &tagSTR ;
	val.str	= str	  ;
}

void	VALUE::operator =
	(	STRING	*str
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagSTR ;
	val.str	= str	  ;
}
