/***************************************************************************
    file	         : kb_locator.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#if		__KB_KDE

#include	<kglobal.h>
#include	<kstddirs.h>
#include	<kinstance.h>



/*  locateDir	: Locate a directory of specified type			*/
/*  type	: const char *	  : Directory type			*/
/*  name	: const QString & : Directory name			*/
/*  (returns)	: QString	  : Path				*/

QString	locateDir
	(	const char	*type,
		const QString	&name
	)
{	return	KGlobal::instance()->dirs()->findResourceDir (type, name) ;
}

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
	return	locate	(type, name) ;
}

#endif		// __KB_KDE

/*  ------------------------------------------------------------------  */
/*  QT3/Linux								*/
/*  ------------------------------------------------------------------  */

#if		__KB_TKC && ! __KB_EMBEDDED && ! defined(_WIN32)

#include	<stdio.h>
#include	<stdlib.h>

#include	<qstring.h>
#include 	<qdir.h>

static	QString	rootdir	= ROOTDIR ;

#define	DATAPATH	"/share/apps/rekall/"
#define	DOCPATH		"/share/doc/HTML/en/rekall/"

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
//	fprintf	(stderr, "locateFile: %s: %s (with %s)\n",
//			 type,
//			 (const char *)name,
//			 (const char *)rootdir) ;

	if (qstrcmp (type, "appdata") == 0)
		return	rootdir + DATAPATH + name ;

	if (qstrcmp (type, "doc") == 0)
		return	rootdir + DOCPATH  + name ;

	return	QString::null ;
}

/*  locateDir	: Locate a directory of specified type			*/
/*  type	: const char *	  : Directory type			*/
/*  name	: const QString & : Directory name			*/
/*  (returns)	: QString	  : Path				*/

QString	locateDir
	(	const char	*type,
		const QString	&
	)
{
	/* The name is never used here. The argument exists since under	*/
	/* KDE there seems to be no way to locate an application	*/
	/* directory without naming a file that will be found in it.	*/
	return	locateFile   (type, "") ;
}

/*  setRootDir	: Set different root directory				*/
/*  _rootdir	: const QString & : New root directory name		*/
/*  (returns)	: void		  :					*/

void	setRootDir
	(	const QString	&_rootdir
	)
{
	rootdir	= _rootdir ;
	fprintf	(stderr, "setRootDir(%s)\n", (const char *)rootdir) ;
}

/*  getRootDir	: Get root directory					*/
/*  (returns)	: const QString & : Directory name			*/

const QString	&getRootDir ()
{
	fprintf	(stderr, "getRootDir(%s)\n", (const char *)rootdir) ;
	return	rootdir	;
}

#endif

/*  ------------------------------------------------------------------  */
/*  QT3/Win32								*/
/*  ------------------------------------------------------------------  */

#if		__KB_TKC && ! __KB_EMBEDDED && defined(_WIN32)

#include	<stdio.h>
#include	<stdlib.h>

#include	<qstring.h>
#include 	<qdir.h>

#include	"tk_header.h"
#include	"libcommon_exports.h"


static	QString instdir = QDir::convertSeparators(QDir::currentDirPath()) ;
static	QString rootdir = QDir::convertSeparators(QDir::currentDirPath() + "\\common") ;

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

LIBCOMMON_API	QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
//	fprintf	(stderr, "locateFile: %s: %s (with %s)\n",
//			 type,
//			 (const char *)name,
//			 (const char *)rootdir) ;

	if (qstrcmp (type, "appdata") == 0)
		return	rootdir + "\\data\\" + name ;

	if (qstrcmp (type, "doc") == 0)
		return	rootdir + "\\doc\\"  + name ;

	return	QString::null ;
}

/*  locateDir	: Locate a directory of specified type			*/
/*  type	: const char *	  : Directory type			*/
/*  name	: const QString & : Directory name			*/
/*  (returns)	: QString	  : Path				*/

LIBCOMMON_API QString	locateDir
	(	const char	*type,
		const QString	&
	)
{
	/* The name is never used here. The argument exists since under	*/
	/* KDE there seems to be no way to locate an application	*/
	/* directory without naming a file that will be found in it.	*/
	return	locateFile   (type, "") ;
}

/*  setRootDir	: Set different root directory				*/
/*  _rootdir	: const QString & : New root directory name		*/
/*  (returns)	: void		  :					*/

LIBCOMMON_API	void	setRootDir
	(	const QString	&_rootdir
	)
{
	instdir = _rootdir ;
	rootdir	= _rootdir + "\\common" ;
	fprintf	(stderr, "setRootDir(%s)\n", (const char *)rootdir) ;
}

/*  getRootDir	: Get root directory					*/
/*  (returns)	: const QString & : Directory name			*/

LIBCOMMON_API
	const QString	&getRootDir ()
{
	fprintf	(stderr, "getRootDir(%s)\n", (const char *)rootdir) ;
	return	rootdir	;
}

/*  getInstDir	: Get installation directory				*/
/*  (returns)	: const QString & : Directory name			*/

LIBCOMMON_API
	const QString	&getInstDir ()
{
	fprintf	(stderr, "getInstDir(%s)\n", (const char *)instdir) ;
	return	instdir	;
}

#endif

/*  ------------------------------------------------------------------  */
/*  Embedded								*/
/*  ------------------------------------------------------------------  */

#if	__KB_EMBEDDED

#include	<stdio.h>
#include	<qstring.h>
#include	<qfile.h>


static	QString	rootdir	= "/opt/QtPalmtop/apps/theKompany.com/tkcRekall" ;

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
//	fprintf	(stderr, "locateFile: %s: %s (with %s)\n",
//			 type,
//			 (const char *)name,
//			 (const char *)rootdir) ;

	QString	path	;

	if	(qstrcmp (type, "appdata") == 0)
	{
		path	= rootdir + "/data/"  + name ;
	}
	else if (qstrcmp (type, "doc"    ) == 0)
	{
		path	= rootdir + "/doc/"   + name ;
	}
	else	return	QString::null ;

	return	name.isEmpty ()		? path :
		QFile::exists(path)	? path : QString::null ;
}

/*  locateDir	: Locate a directory of specified type			*/
/*  type	: const char *	  : Directory type			*/
/*  name	: const QString & : Directory name			*/
/*  (returns)	: QString	  : Path				*/

QString	locateDir
	(	const char	*type,
		const QString	&
	)
{
	/* The name is never used here. The argument exists since under	*/
	/* KDE there seems to be no way to locate an application	*/
	/* directory without naming a file that will be found in it.	*/
	return	locateFile   (type, "") ;
}

/*  setRootDir	: Set different root directory				*/
/*  _rootdir	: const QString & : New root directory name		*/
/*  (returns)	: void		  :					*/

void	setRootDir
	(	const QString	&_rootdir
	)
{
	rootdir	= _rootdir ;
}

#endif
