/***************************************************************************
    file	         : kb_libloader_tkc.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


/*  This file contains the library loader code for QT builds of		*/
/*  Rekall. By preference it would be in libkbase_kde, but in order	*/
/*  that libkbase_common does not have any depend on any other Rekall	*/
/*  libraries (so that the drivers can be used outside of Rekall) we	*/
/*  have to put it here.						*/

#if		__KB_TKC

#include	"kb_libloader_tkc.h"

#ifndef		_WIN32
#include	<dlfcn.h>
#define		DLERROR()	dlerror()
#else
#define		DLERROR()	"Unknown error"
#endif

void	*KBLibrary::factory ()
{
	typedef	void	*(*IFPROC)()	;

	fprintf
	(
		stderr,
		"KBLibrary::factory: resolve [%s]\n",
		(const char *)m_name
	)	;


	IFPROC	ifproc	= (IFPROC)m_library->resolve("init_" + m_name) ;
	if (ifproc == 0)
	{
		fprintf
		(	stderr,
			"KBLibrary::factory: no interface %s [%s]\n",
			(const char *)m_name,
			DLERROR()
		)	;
		return	0 ;
	}

	return	(*ifproc)() ;

}

/*  KBLibLoader								*/
/*  self	: Instantiate the library loader			*/
/*  (returns)	: KBLibLoader *	: Loader object				*/

KBLibLoader
	*KBLibLoader::self ()
{
	static	KBLibLoader	*loader	;
	if (loader == 0) loader = new KBLibLoader ;
	return	loader	;
}

/*  KBLibLoader								*/
/*  getLibrary	: Load a library					*/
/*  libname	: const char *	: Library name				*/
/*  (returns)	: KBLibrary *	: Library object or null on error	*/

KBLibrary
	*KBLibLoader::getLibrary
	(	const char	*libname
	)
{
	QLibrary *lib	= 
#if     __KB_EMBEDDED_XXX
			new QLibrary (&libname[3], QLibrary::Immediately) ;
#else
        	//new QLibrary (&libname[3]) ;

			// Changed - Windows DLLs  now begin with the "lib" prefix
			// to make them consistent with their X-11 counterparts
			new QLibrary (&libname[0]) 
#endif
	if (lib == 0)
	{
		m_error	= DLERROR() ;
		return	0 ;
	}

	return	new KBLibrary (lib, libname) ;
}

/*  KBLibLoader								*/
/*  getGlobalLibrary							*/
/*		: Load a library with global symbol access		*/
/*  libname	: const char *	: Library name				*/
/*  (returns)	: KBLibrary *	: Library object or null on error	*/


KBLibrary
	*KBLibLoader::getGlobalLibrary
	(	const char	*libname
	)
{
	QLibrary *lib = 
#if     __KB_EMBEDDED_XXX
			new QLibrary (&libname[3], QLibrary::Immediately) ;
#else
        	//new QLibrary (&libname[3]) ;
			// Changed - Windows DLLs  now begin with the "lib" prefix
			// to make them consistent with their X-11 counterparts
			new QLibrary (&libname[0]) ;
#endif
	if (lib == 0)
	{
		m_error	= DLERROR() ;
		return	0 ;
	}

	return	new KBLibrary (lib, libname) ;
}

QString	KBLibLoader::lastErrorMessage ()
{
	return	m_error	;
}


/*  ------------------------------------------------------------------  */

KBPartFactory::KBPartFactory ()
{
}

KBPartFactory::~KBPartFactory ()
{
}

QObject	*KBPartFactory::create
	(	QObject *		,
		const char *		,
		const char *		,
		const QStringList &
	)
{
	return	0 ;
}

const char
	*KBPartFactory::ident ()
{
	return	0 ;
}


KBFactory::KBFactory ()
{
}

KBFactory::~KBFactory ()
{
}

QObject	*KBFactory::create
	(	QObject *		,
		const char *		,
		const char *		,
		const QStringList &
	)
{
	return	0 ;
}

const char
	*KBFactory::ident ()
{
	return	0 ;
}

#endif	// __KB_TKC
