/***************************************************************************
    file	         : kb_svrchooser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_SVRCHOOSER_H
#define	__KB_SVRCHOOSER_H

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"

#include	"kb_dblink.h"
#include	"kb_dbinfo.h"

#include "libapp_exports.h"


/*  KBSvrChooserDlg							*/
/*  ---------------							*/
/*  This class provies a simple server/document selection dialog, based	*/
/*  on the chooser class above.						*/

class LIBAPP_API KBSvrChooserDlg : public _KBDialog
{
	Q_OBJECT

	QLabel		m_lServer	;
	QComboBox	m_cbServer	;
	QCheckBox	m_cOver		;
	QListBox	m_lbOut		;
	QListBox	m_lbIn		;
	QPushButton	m_bAdd		;
	QPushButton	m_bAddAll	;
	QPushButton	m_bRemove	;

	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

	QVBoxLayout	*m_layMain	;
	QHBoxLayout	*m_laySelect	;
	QVBoxLayout	*m_layAddRem	;
	QHBoxLayout	*m_layButt	;

protected slots :

	void		clickOK	    ()	;
	void		clickCancel ()	;
	void		clickAdd    ()  ;
	void		clickAddAll ()	;
	void		clickRemove ()	;

	void		inHighlight ()	;
	void		outHighlight()	;

public	:

	KBSvrChooserDlg		(KBDBInfo *, const QString &, bool = false) ;

	void	getInfo		(QString &, QStringList &, bool &) ;
	void	addEntry	(const QString &) ;
}	;

#endif	// __KB_SVRCHOOSER_H
