/***************************************************************************
    file	         : kb_splash.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapp.h>
#include	<qpixmap.h>
#include	<qimage.h>
#include	<qpainter.h>

#include	"tktextmanager.h"
#include	"tkhighlight.h"

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_locator.h"
#include	"kb_build.h"

#ifndef 	_WIN32
#include	"kb_splash.moc"
#else
#include	"kb_splash.h"
#endif



/*  KBSplash								*/
/*  KBSplash	: Constructor for splash screen class			*/
/*  screen	: const char *	: Splash screen file name		*/
/*  release	: const char *	: Release text				*/
/*  showFor	: uint		: Display time in milliseconds		*/
/*  color	: QColor	: Text colour				*/
/*  (returns)	: KBSplash	:					*/

KBSplash::KBSplash
	(	const char	*screen,
		const char	*release,
		uint		showFor,
		QColor		color
	)
	:
	QLabel		(0, 0, WStyle_Customize|WStyle_StaysOnTop|WStyle_NoBorder),
	m_release	(QString("%1 [" __KB_BUILD_IDENT "]").arg(release)),
	m_color		(color)
{
#if	__KB_RUNTIME
	m_release	+= " Runtime" ;
#endif

//	fprintf
//	(	stderr,
//		"KBSplash::KBSplash: [%s]\n",
//		(cchar *)m_release
//	)	;


        QRect	dRect	= QApplication::desktop()->geometry() ;
	QString	path	= locateFile ("appdata", QString("%1.png").arg(screen)) ;
	QPixmap	pm	;
	pm.convertFromImage (QImage(path)) ;

        setFrameStyle	(QFrame::WinPanel|QFrame::Raised) ;
        setPixmap	(pm)	;
        adjustSize	()	;
        setCaption	(TR("Rekall")) ;

        move		(dRect.center() - rect().center()) ;
        show		()	;
        repaint		(false) ;

	QTimer::singleShot (showFor, this, SLOT(slotSplosh    ())) ;

#if	__KB_EMBEDDED
	/* Loading the TKTextEditor highlights takes some time on the	*/
	/* Zaurus, so do it while the splach screen is on display. The	*/
	/* delay is to give time for it to be drawn first.		*/
	QTimer::singleShot (1000,    this, SLOT(loadHighlights())) ;
#endif
}

/*  KBSplash								*/
/*  paintEvent	: Handle paint events					*/
/*  p		: QPaintEvent *	: Paint event				*/
/*  (returns)	: void		:					*/

void	KBSplash::paintEvent
	(	QPaintEvent	*p
	)
{
	QLabel::paintEvent (p) ;

	QPainter paint	(this) ;
	int	 offset	= fontMetrics().height() ;

	paint.setPen	(m_color) ;
	paint.drawText	(offset, offset * 2, m_release) ;

	QApplication::flushX () ;
}

/*  KBSplash								*/
/*  loadHighlights: Load text editor highlights				*/
/*  (returns)	  : void		:				*/

void	KBSplash::loadHighlights ()
{
//	TKTextHighlightManager::loadHighlightDict (_KBDialog::getTextManager()) ;
}

/*  KBSplash								*/
/*  slotSplosh	: Close the screen					*/
/*  (returns)	: void		:					*/

void	KBSplash::slotSplosh ()
{
	close	(true)	;
}

/*  KBSplash								*/
/*  mousePressEvent							*/
/*		: Handle mouse press					*/
/*  e		: QMouseEvent *	: Mouse event				*/
/*  (returns)	: void		:					*/

void	KBSplash::mousePressEvent
	(	QMouseEvent	*
	)
{
	close	(true)	;
}
