/***************************************************************************
    file	         : kb_quickdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_QUICKDLG_H
#define	__KB_QUICKDLG_H

#include	<qdict.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"

class	KBFileList	;
class	KBScriptList	;

class	KBQuickDlg : public _KBDialog
{
	Q_OBJECT

	QLabel			m_lType		;
	QLabel			m_lServer	;
	QLabel			m_lObject	;
	QComboBox		m_cbType	;
	QComboBox		m_cbServer	;
	QComboBox		m_cbObject	;
	QPushButton		m_bDelete	;
	QPushButton		m_bCreate	;
	QPushButton		m_bCancel	;
	QPushButton		m_bOpen		;

	QVBoxLayout		*m_layMain	;
	QGridLayout		*m_laySelect	;
	QHBoxLayout		*m_layButt	;

	KBDBInfo		*m_dbInfo	;
	QDict<KBFileList>	&m_fileDict	;
	QDict<KBScriptList>	&m_scriptDict	;


protected slots :

	void		userChange	() ;
	void		clickDelete	() ;
	void		clickCreate	() ;
	void		clickCancel	() ;
	void		clickOpen	() ;

public	:

	KBQuickDlg
	(
		KBDBInfo		*,
		QStringList		&,
		QDict<KBFileList>	&,
		QDict<KBScriptList>	&

	)	;

	void	getResults	(QString &, QString &, QString &) ;

	enum	Option
	{	Cancelled,
		Open,
		Create,
		Delete
	}	;
}	;

#endif	// __KB_QUICKDLG_H
