/***************************************************************************
    file	         : kb_dbaseviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_gui.h"
#include	"kb_dbdlg.h"
#include	"kb_viewer.h"
#include	"kbase.h"

#ifndef 	_WIN32
#include	"kb_dbaseviewer.moc"
#else
#include	"kb_dbaseviewer.h"
#endif

#include	"tk_icons.h"


static	QList<KBDBaseViewer>	dbViewers	;

#if	! __KB_RUNTIME
extern	TKActionMenu		*actDatabases	;
#endif

extern	void		setActiveWindow	(QWidget *) ;

static	GUIElement	dbvGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot			  Element name		Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"Toggle S&QL Window",	0,		ACCEL(NoAccel),	SLOT(showRawSQL       ()),"KB_showRawSQL",	0,		"Toggle SQL Window"		},
{	GTAction,	KB::GRNone,	true,	"&Dump database",	0,		ACCEL(NoAccel),	SLOT(dumpDatabase     ()),"KB_dumpDatabase",	0,		"Dump database"			},
{	GTAction,	KB::GRNone,	true,	"&Load database",	0,		ACCEL(NoAccel),	SLOT(loadDatabase     ()),"KB_loadDatabase",	0,		"Load database"			},
{	GTAction,	KB::GRNone,	true,	"&Show Objects",	0,		ACCEL(NoAccel),	SLOT(showObjects      ()),"KB_showObjects",	0,		"Show objects dialog"		},
{	GTAction,	KB::GRNone,	true,	"&Close Database",	"fileclose",	ACCEL(NoAccel),	SLOT(closeDatabase    ()),"KB_closeDatabase",	0,		"Close database"		},
{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,			  0,		 	0,		0				}
}	;

/*  KBDBaseViewer							*/
/*  findKBaseApp: Find top level window for specified location		*/
/*  location	: KBLocation &	: Location				*/
/*  (returns)	: KBaseApp *	: Top level window			*/

KBaseApp*KBDBaseViewer::findKBaseApp
	(	KBLocation	&location
	)
{
	LITER
	(	KBDBaseViewer,
		dbViewers,
		dbViewer,

		if (dbViewer->dbaseDlg->isShowing (location))
			return	dbViewer->kbaseApp ;
	)

	return	dbViewers.at(0)->kbaseApp ;
}


/*  ------------------------------------------------------------------  */

/*  KBDBaseViewer							*/
/*  KBDBaseViewer: Constructor for KBDBaseViewer class			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  app		: KBaseApp *	: Parent application widget		*/
/*  dbName	: const QString&: Database file name			*/
/*  create	: bool		: True to create a new database		*/
/*  (returns)	: KBDBaseViewer	:					*/

KBDBaseViewer::KBDBaseViewer
	(	QWidget		*parent,
		KBaseApp	*app,
		const QString	&dbName,
		bool		create
	)
	:
	KBasePart  (0, parent, WDestructiveClose|WStyle_NormalBorder),
	m_parent   (parent),
	kbaseApp   (app)
{
	setLocalGUISpec	(&dbvGUI[0]) ;

	dbaseGUI  = new KBaseGUI   (this, this, "rekallui.dbase") ;
	dbaseDlg  = new KBDBaseDlg (m_partWidget, app, dbName, create, dbaseGUI) ;

	m_topWidget = dbaseDlg ;

	QString	name	= dbaseDlg->getDBName() ;
	int	i1	= name.findRev ('/')	;
	if (i1 >= 0) name = name.mid   (i1 + 1) ;
	int	i2	= name.findRev ('.')	;
	if (i2 >= 0) name = name.left  (i2)	;

	m_topWidget->show () ;
	setGUI  (dbaseGUI)   ;

	QSize	topSize = m_topWidget->size()	;
	m_partWidget->resize	     (topSize.width(), topSize.height(), true, false) ;
	m_partWidget->setMinimumSize (topSize.width(), topSize.height()) ;
	m_partWidget->show	     () ;

	m_partWidget->setCaption(name) ;
	m_partWidget->setIcon   (getSmallIcon("rekall")) ;

	if (parent == app)
	{	app->setCaption (name) ;
		app->setIcon	(getSmallIcon("rekall")) ;
	}

	dbViewers.append (this) ;

	m_showDatabase = new TKAction
		   	 (	name,
				"database",
				0,
				this,
				SLOT(showDatabase()),
				this,
				name
		   	 )	;
#if	! __KB_RUNTIME
	actDatabases->insert (m_showDatabase) ;
#endif
}

/*  KBDBaseViewer							*/
/*  ~KBDBaseViewer: Destructor for KBDBaseViewer class			*/
/*  (returns)	  :							*/

KBDBaseViewer::~KBDBaseViewer ()
{
	ACTION	*actObjects = action ("KB_showObjects"  ) ;
	ACTION	*actClose   = action ("KB_closeDatabase") ;

	if (actObjects != 0) actObjects->unplugAll() ;
	if (actClose   != 0) actClose  ->unplugAll() ;

	objects.setAutoDelete (true) ;
	objects.clear   () ;

#if	! __KB_RUNTIME
	actDatabases->remove  (m_showDatabase) ;
#endif
	dbViewers.remove (this) ;

	if (m_partWidget)
		m_partWidget->setCaption("") ;

	if (m_parent == kbaseApp) kbaseApp->setCaption("") ;
}

/*  KBDBaseViewer							*/
/*  queryClose	: Check for close					*/
/*  (returns)	: void		:					*/

bool	KBDBaseViewer::queryClose ()
{
	return	true	;
}

/*  KBDBaseViewer							*/
/*  addObject	: Potentially add child object to this viewer		*/
/*  location	: KBLocation &	: Location being displayed		*/
/*  object	: KBObjBase *	: New obect				*/
/*  (returns)	: bool		: Success				*/

bool	KBDBaseViewer::addObject
	(	KBLocation	&location,
		KBObjBase	*object
	)
{
	if (dbaseDlg->isShowing (location))
	{
//		fprintf	(stderr, "KBDBaseViewer::add (%08lx)\n", (long)object) ;
		objects.append (object) ;

		connect	(object, SIGNAL(destroyed()), this, SLOT(removeObject())) ;

		return	true ;
	}

	return	false	;
}

/*  KBDBaseViewer							*/
/*  removeObject: Remove deceased object				*/
/*  (returns)	: void		:					*/

void	KBDBaseViewer::removeObject ()
{
	extern	bool	useMDI	;
	const	QObject *object = sender () ;

	objects.remove ((KBObjBase *)(object)) ;

	fprintf
	(	stderr,
		"KBDBaseViewer::remove [%p] useMDI=%d count=%d vis=%d\n",
		(void *)object,
		useMDI,
		objects.count(),
		kbaseApp->isVisible()
	)	;

	/* If the main application window is available, we are not in	*/
	/* MDI mode, and there are no objects left, then close the	*/
	/* application down. This means that the user can exit by	*/
	/* closing the last form (or report, ...)			*/
	if (kbaseApp->isAvailable())
		return ;

	if (useMDI || (objects.count() > 0))
		return	;

	kbaseApp->close () ;
}

/*  KBDBaseViewer							*/
/*  showDatabase: Make database viewer visible				*/
/*  (returns)	: void		:					*/

void	KBDBaseViewer::showDatabase ()
{
	extern	bool	useMDI ;

	if (useMDI)
	{	show () ;
		return	;
	}

	kbaseApp->show	     	  () ;
	kbaseApp->raise		  () ;
	kbaseApp->setActiveWindow () ;
	::setActiveWindow	  (kbaseApp) ;

	kbaseApp->setAvailable	  (true) ;
}

void	KBDBaseViewer::closeDatabase ()
{
	kbaseApp->closeDatabase (this) ;
}


/*  KBDBaseViewer							*/
/*  showObjects	: Check quick objects dialog				*/
/*  (returns)	: bool		:					*/

void	KBDBaseViewer::showObjects ()
{
	dbaseDlg->showObjects () ;
}

/*  KBDBaseViewer							*/
/*  showRawSQL	: Show raw SQL window					*/
/*  (returns)	: bool		:					*/

void	KBDBaseViewer::showRawSQL ()
{
	dbaseDlg->showRawSQL  () ;
}

/*  KBDBaseViewer							*/
/*  dumpDatabase: Dump database						*/
/*  (returns)	: bool		:					*/

void	KBDBaseViewer::dumpDatabase ()
{
#if	! __KB_RUNTIME
	dbaseDlg->dumpDatabase  () ;
#endif
}

/*  KBDBaseViewer							*/
/*  loadDatabase: Dump database						*/
/*  (returns)	: bool		:					*/

void	KBDBaseViewer::loadDatabase ()
{
#if	! __KB_RUNTIME
	dbaseDlg->loadDatabase  () ;
#endif
}

/*  KBDBaseViewer							*/
/*  autoStart	: Check for auto-start forms				*/
/*  autoLoc	: KBLocation &	: Return started location if any	*/
/*  (returns)	: bool		:					*/

bool	KBDBaseViewer::autoStart
	(	KBLocation	&autoLoc
	)
{
	return	dbaseDlg->autoStart (autoLoc) ;
}

KBDBInfo*KBDBaseViewer::getDBInfo ()
{
	return	dbaseDlg->getDBInfo () ;
}
