(************************************************************
 *
 * A part of Regexp/OCaml module.
 * 
 * (c) 2002-2003 Yutaka Oiwa. All Rights Reserved.
 *
 * This file is distributed under the terms of the Q Public
 * License version 1.0.
 *
 ************************************************************)
(* $Id: parse_regexp.mli,v 1.3 2003/03/16 19:30:05 oiwa Exp $ *)

exception Parse_error of int * int * string

type regexp_tree (* =
    Char of char
  | Seq of regexp_tree list
  | Repeat of bool * regexp_tree
  | Repeat1 of bool * regexp_tree
  | RepeatN of bool * int option * int option * regexp_tree
  | Optional of bool * regexp_tree
  | TaggedGroup of int ref * regexp_tree
  | UntaggedGroup of regexp_tree
  | Branch of regexp_tree list
  | PredefinedSet of char
  | Meta of char
  | Set of bool * set_element list
  | Empty *)
and set_element (* =
    S_Char of char
  | S_Range of char * char
  | S_PredefinedSet of char *)
(* and regexp_options = { caseless : bool; } *)
and regexp (* = regexp_options * int * regexp_tree *)

val parse_regexp : string -> regexp
type backref_kind = BR_Normal | BR_Optional | BR_List
val make_backref_table : regexp -> backref_kind array
val pcre_string_of_regexp : regexp -> string
