/**
 * File name: label.cpp
 * Project: Redkite (A small GUI toolkit)
 *
 * Copyright (C) 2019 Iurie Nistor <http://quamplex.com>
 *
 * This file is part of Redkite.
 *
 * Redkite is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "RkMain.h"
#include "RkLabel.h"
#include "RkLog.h"

/**
 * Generated with png2c
 * File name: label.png
 * Image size name: 100x94
 */
const unsigned char rk_image[] = {
0x5d, 0x77, 0x92, 0xff, 0x55, 0x72, 0x91, 0xff, 0x50, 0x70, 0x8d, 0xff,
0x4d, 0x6d, 0x8a, 0xff, 0x4b, 0x6c, 0x86, 0xff, 0x4b, 0x6d, 0x86, 0xff,
0x4b, 0x6d, 0x85, 0xff, 0x4e, 0x6c, 0x87, 0xff, 0x4f, 0x6c, 0x87, 0xff,
0x50, 0x6d, 0x88, 0xff, 0x53, 0x6f, 0x8a, 0xff, 0x56, 0x71, 0x8b, 0xff,
0x5e, 0x76, 0x8d, 0xff, 0x65, 0x78, 0x87, 0xff, 0x69, 0x77, 0x7e, 0xff,
0x67, 0x71, 0x70, 0xff, 0x65, 0x6e, 0x64, 0xff, 0x5f, 0x64, 0x5b, 0xff,
0x61, 0x61, 0x60, 0xff, 0x64, 0x63, 0x64, 0xff, 0x63, 0x64, 0x6b, 0xff,
0x6b, 0x6b, 0x6d, 0xff, 0x7b, 0x79, 0x85, 0xff, 0x7e, 0x89, 0x8c, 0xff,
0x84, 0x90, 0xa3, 0xff, 0x6c, 0x7c, 0x99, 0xff, 0x69, 0x79, 0x8b, 0xff,
0x5c, 0x5a, 0x65, 0xff, 0x5b, 0x50, 0x5b, 0xff, 0x55, 0x4f, 0x5a, 0xff,
0x4f, 0x48, 0x43, 0xff, 0x53, 0x49, 0x45, 0xff, 0x53, 0x4a, 0x44, 0xff,
0x45, 0x3e, 0x35, 0xff, 0x3a, 0x34, 0x2f, 0xff, 0x2c, 0x26, 0x23, 0xff,
0x28, 0x24, 0x21, 0xff, 0x27, 0x22, 0x2b, 0xff, 0x33, 0x2b, 0x2c, 0xff,
0x51, 0x45, 0x40, 0xff, 0x53, 0x47, 0x50, 0xff, 0x55, 0x4f, 0x50, 0xff,
0x5a, 0x55, 0x57, 0xff, 0x55, 0x53, 0x55, 0xff, 0x60, 0x63, 0x5c, 0xff,
0x5f, 0x65, 0x58, 0xff, 0x75, 0x7d, 0x78, 0xff, 0x6e, 0x7d, 0x79, 0xff,
0x56, 0x64, 0x62, 0xff, 0x56, 0x58, 0x54, 0xff, 0x57, 0x53, 0x4e, 0xff,
0x54, 0x4d, 0x4a, 0xff, 0x55, 0x49, 0x47, 0xff, 0x55, 0x48, 0x46, 0xff,
0x54, 0x48, 0x46, 0xff, 0x53, 0x48, 0x45, 0xff, 0x53, 0x47, 0x45, 0xff,
0x54, 0x47, 0x45, 0xff, 0x55, 0x47, 0x45, 0xff, 0x55, 0x47, 0x44, 0xff,
0x55, 0x46, 0x44, 0xff, 0x55, 0x46, 0x44, 0xff, 0x55, 0x46, 0x44, 0xff,
0x54, 0x45, 0x43, 0xff, 0x55, 0x46, 0x44, 0xff, 0x55, 0x47, 0x44, 0xff,
0x55, 0x48, 0x44, 0xff, 0x56, 0x48, 0x45, 0xff, 0x55, 0x47, 0x44, 0xff,
0x55, 0x47, 0x44, 0xff, 0x54, 0x49, 0x44, 0xff, 0x54, 0x48, 0x44, 0xff,
0x55, 0x49, 0x45, 0xff, 0x55, 0x49, 0x45, 0xff, 0x54, 0x48, 0x44, 0xff,
0x4e, 0x45, 0x43, 0xff, 0x65, 0x6d, 0x76, 0xff, 0x8a, 0xa9, 0xd3, 0xff,
0x7f, 0xae, 0xe6, 0xff, 0x7d, 0xb0, 0xe2, 0xff, 0x84, 0xb4, 0xe1, 0xff,
0x89, 0xb9, 0xe5, 0xff, 0x7f, 0xb4, 0xe4, 0xff, 0x7d, 0xb2, 0xdb, 0xff,
0x73, 0x99, 0xb8, 0xff, 0x97, 0xa7, 0xbf, 0xff, 0xc2, 0xc9, 0xcf, 0xff,
0xc7, 0xbe, 0xb6, 0xff, 0xb6, 0xbc, 0xc4, 0xff, 0x93, 0xac, 0xc7, 0xff,
0x96, 0x9f, 0xa7, 0xff, 0x7a, 0x72, 0x69, 0xff, 0x60, 0x4f, 0x51, 0xff,
0x54, 0x44, 0x4a, 0xff, 0x56, 0x4d, 0x48, 0xff, 0x88, 0x7f, 0x78, 0xff,
0x54, 0x4a, 0x45, 0xff, 0x54, 0x47, 0x44, 0xff, 0x54, 0x46, 0x44, 0xff,
0x55, 0x47, 0x44, 0xff, 0x5d, 0x77, 0x93, 0xff, 0x55, 0x71, 0x91, 0xff,
0x50, 0x6f, 0x8c, 0xff, 0x4d, 0x6c, 0x89, 0xff, 0x4e, 0x6d, 0x88, 0xff,
0x4e, 0x6e, 0x87, 0xff, 0x4e, 0x6e, 0x87, 0xff, 0x51, 0x6e, 0x89, 0xff,
0x52, 0x6f, 0x8a, 0xff, 0x54, 0x70, 0x8b, 0xff, 0x56, 0x72, 0x8d, 0xff,
0x5a, 0x74, 0x8d, 0xff, 0x5e, 0x79, 0x8d, 0xff, 0x64, 0x7c, 0x8a, 0xff,
0x64, 0x76, 0x80, 0xff, 0x60, 0x6f, 0x76, 0xff, 0x6f, 0x85, 0x90, 0xff,
0x9e, 0xb2, 0xcd, 0xff, 0x80, 0x93, 0xb4, 0xff, 0x69, 0x82, 0x9e, 0xff,
0x75, 0x8f, 0xb5, 0xff, 0x72, 0x95, 0xc4, 0xff, 0x82, 0xa1, 0xc8, 0xff,
0x7a, 0x9d, 0xc4, 0xff, 0x6f, 0x8a, 0xa9, 0xff, 0x67, 0x7f, 0x9e, 0xff,
0x67, 0x85, 0xa9, 0xff, 0x49, 0x5f, 0x87, 0xff, 0x32, 0x3b, 0x66, 0xff,
0x4d, 0x4d, 0x72, 0xff, 0x65, 0x63, 0x7c, 0xff, 0x69, 0x62, 0x71, 0xff,
0x50, 0x45, 0x4b, 0xff, 0x51, 0x45, 0x42, 0xff, 0x52, 0x46, 0x42, 0xff,
0x4b, 0x3f, 0x3d, 0xff, 0x3a, 0x32, 0x2f, 0xff, 0x27, 0x22, 0x23, 0xff,
0x31, 0x29, 0x27, 0xff, 0x39, 0x30, 0x2c, 0xff, 0x37, 0x32, 0x32, 0xff,
0x40, 0x39, 0x37, 0xff, 0x3f, 0x37, 0x34, 0xff, 0x3f, 0x36, 0x33, 0xff,
0x4e, 0x43, 0x40, 0xff, 0x51, 0x48, 0x43, 0xff, 0x65, 0x66, 0x64, 0xff,
0x86, 0x8b, 0x8a, 0xff, 0x97, 0x9b, 0x9b, 0xff, 0x70, 0x73, 0x71, 0xff,
0x4e, 0x4b, 0x47, 0xff, 0x52, 0x49, 0x46, 0xff, 0x56, 0x49, 0x47, 0xff,
0x54, 0x45, 0x43, 0xff, 0x52, 0x45, 0x43, 0xff, 0x51, 0x45, 0x43, 0xff,
0x52, 0x45, 0x43, 0xff, 0x53, 0x45, 0x43, 0xff, 0x53, 0x44, 0x42, 0xff,
0x54, 0x43, 0x42, 0xff, 0x54, 0x42, 0x41, 0xff, 0x54, 0x42, 0x41, 0xff,
0x54, 0x42, 0x41, 0xff, 0x56, 0x44, 0x43, 0xff, 0x56, 0x44, 0x43, 0xff,
0x55, 0x46, 0x43, 0xff, 0x55, 0x46, 0x43, 0xff, 0x55, 0x46, 0x43, 0xff,
0x54, 0x45, 0x42, 0xff, 0x54, 0x45, 0x42, 0xff, 0x53, 0x47, 0x43, 0xff,
0x53, 0x47, 0x43, 0xff, 0x53, 0x47, 0x43, 0xff, 0x54, 0x48, 0x44, 0xff,
0x54, 0x48, 0x44, 0xff, 0x54, 0x4a, 0x49, 0xff, 0x5b, 0x4b, 0x40, 0xff,
0x54, 0x54, 0x62, 0xff, 0x81, 0x90, 0xaf, 0xff, 0x8a, 0xac, 0xd6, 0xff,
0x85, 0xb8, 0xef, 0xff, 0x76, 0xbc, 0xe5, 0xff, 0x73, 0xb2, 0xe3, 0xff,
0x77, 0xb5, 0xe7, 0xff, 0x80, 0xaa, 0xcc, 0xff, 0x97, 0xa0, 0xa8, 0xff,
0xbf, 0xc6, 0xc5, 0xff, 0xbb, 0xbf, 0xb8, 0xff, 0xa2, 0xb5, 0xbe, 0xff,
0x99, 0xb3, 0xbf, 0xff, 0xa8, 0xa8, 0x9f, 0xff, 0x8a, 0x7f, 0x7b, 0xff,
0x6b, 0x5c, 0x60, 0xff, 0x61, 0x53, 0x56, 0xff, 0x63, 0x59, 0x54, 0xff,
0x70, 0x6b, 0x61, 0xff, 0x53, 0x4b, 0x44, 0xff, 0x51, 0x45, 0x42, 0xff,
0x52, 0x45, 0x45, 0xff, 0x54, 0x45, 0x44, 0xff, 0x5b, 0x77, 0x95, 0xff,
0x55, 0x71, 0x91, 0xff, 0x4f, 0x6e, 0x8a, 0xff, 0x4d, 0x6b, 0x88, 0xff,
0x4f, 0x6d, 0x88, 0xff, 0x50, 0x6f, 0x89, 0xff, 0x51, 0x6f, 0x88, 0xff,
0x52, 0x70, 0x8a, 0xff, 0x53, 0x6e, 0x88, 0xff, 0x58, 0x71, 0x8a, 0xff,
0x5b, 0x73, 0x90, 0xff, 0x5c, 0x74, 0x90, 0xff, 0x63, 0x7d, 0x97, 0xff,
0x81, 0x9b, 0xbd, 0xff, 0x92, 0xaf, 0xd3, 0xff, 0x8d, 0xaa, 0xd0, 0xff,
0x95, 0xb7, 0xdd, 0xff, 0x97, 0xb7, 0xe7, 0xff, 0x88, 0xa6, 0xd8, 0xff,
0x7c, 0x9e, 0xc3, 0xff, 0x75, 0x97, 0xbd, 0xff, 0x78, 0x96, 0xbd, 0xff,
0x71, 0x87, 0x99, 0xff, 0x79, 0x92, 0xb2, 0xff, 0x6e, 0x88, 0xa1, 0xff,
0x64, 0x7c, 0x97, 0xff, 0x5a, 0x6d, 0x88, 0xff, 0x5f, 0x83, 0xa9, 0xff,
0x48, 0x6b, 0x98, 0xff, 0x42, 0x55, 0x7c, 0xff, 0x44, 0x44, 0x69, 0xff,
0x54, 0x52, 0x7b, 0xff, 0x5d, 0x57, 0x72, 0xff, 0x5c, 0x52, 0x5f, 0xff,
0x4e, 0x43, 0x43, 0xff, 0x50, 0x44, 0x40, 0xff, 0x50, 0x43, 0x41, 0xff,
0x4b, 0x46, 0x3f, 0xff, 0x40, 0x37, 0x35, 0xff, 0x29, 0x21, 0x20, 0xff,
0x21, 0x20, 0x1c, 0xff, 0x2b, 0x26, 0x2a, 0xff, 0x2c, 0x27, 0x25, 0xff,
0x32, 0x2d, 0x26, 0xff, 0x2f, 0x27, 0x22, 0xff, 0x50, 0x48, 0x46, 0xff,
0x51, 0x4e, 0x4f, 0xff, 0x67, 0x62, 0x65, 0xff, 0x78, 0x74, 0x77, 0xff,
0x90, 0x91, 0x91, 0xff, 0xa1, 0xa3, 0xa0, 0xff, 0x8f, 0x8a, 0x89, 0xff,
0x63, 0x59, 0x57, 0xff, 0x49, 0x3d, 0x3b, 0xff, 0x4c, 0x3f, 0x3e, 0xff,
0x50, 0x44, 0x42, 0xff, 0x4f, 0x44, 0x41, 0xff, 0x53, 0x43, 0x40, 0xff,
0x52, 0x41, 0x3f, 0xff, 0x53, 0x41, 0x40, 0xff, 0x53, 0x40, 0x40, 0xff,
0x52, 0x40, 0x40, 0xff, 0x52, 0x40, 0x3f, 0xff, 0x54, 0x43, 0x42, 0xff,
0x56, 0x44, 0x43, 0xff, 0x56, 0x45, 0x43, 0xff, 0x56, 0x46, 0x43, 0xff,
0x56, 0x46, 0x43, 0xff, 0x54, 0x44, 0x41, 0xff, 0x54, 0x44, 0x41, 0xff,
0x52, 0x45, 0x41, 0xff, 0x52, 0x45, 0x42, 0xff, 0x53, 0x46, 0x43, 0xff,
0x54, 0x48, 0x45, 0xff, 0x54, 0x48, 0x45, 0xff, 0x55, 0x47, 0x44, 0xff,
0x52, 0x45, 0x41, 0xff, 0x51, 0x42, 0x3f, 0xff, 0x51, 0x3f, 0x38, 0xff,
0x62, 0x69, 0x78, 0xff, 0x70, 0x84, 0x9a, 0xff, 0x64, 0x78, 0x83, 0xff,
0x84, 0x8f, 0x9a, 0xff, 0x8d, 0x9d, 0xa4, 0xff, 0xa3, 0xa9, 0xa8, 0xff,
0xb3, 0xb9, 0xb8, 0xff, 0xa9, 0xaf, 0xae, 0xff, 0xce, 0xd0, 0xd1, 0xff,
0xb1, 0xb3, 0xbc, 0xff, 0xb3, 0xb9, 0xbe, 0xff, 0xb7, 0xb5, 0xb0, 0xff,
0x78, 0x6f, 0x74, 0xff, 0x6e, 0x64, 0x69, 0xff, 0x6b, 0x5e, 0x5b, 0xff,
0x6f, 0x65, 0x5b, 0xff, 0x64, 0x5e, 0x53, 0xff, 0x4c, 0x43, 0x3e, 0xff,
0x50, 0x44, 0x43, 0xff, 0x4f, 0x44, 0x44, 0xff, 0x51, 0x45, 0x43, 0xff,
0x58, 0x77, 0x98, 0xff, 0x52, 0x71, 0x8e, 0xff, 0x4b, 0x6e, 0x88, 0xff,
0x4a, 0x6b, 0x85, 0xff, 0x4d, 0x6c, 0x87, 0xff, 0x50, 0x6e, 0x89, 0xff,
0x53, 0x71, 0x8b, 0xff, 0x58, 0x72, 0x88, 0xff, 0x84, 0x99, 0xa7, 0xff,
0x85, 0x94, 0xa3, 0xff, 0x82, 0x94, 0xa5, 0xff, 0x7d, 0x91, 0xa5, 0xff,
0xa2, 0xbd, 0xd9, 0xff, 0x94, 0xb5, 0xdf, 0xff, 0x95, 0xb5, 0xde, 0xff,
0x8c, 0xab, 0xd3, 0xff, 0x88, 0xa5, 0xc8, 0xff, 0x85, 0xa4, 0xc8, 0xff,
0x89, 0xaa, 0xd5, 0xff, 0x82, 0xa4, 0xd0, 0xff, 0x7c, 0x9a, 0xbc, 0xff,
0x72, 0x92, 0xb6, 0xff, 0x75, 0x8d, 0xa4, 0xff, 0x71, 0x85, 0x99, 0xff,
0x6f, 0x8c, 0xac, 0xff, 0x64, 0x7b, 0x92, 0xff, 0x67, 0x7a, 0x92, 0xff,
0x63, 0x8d, 0xaf, 0xff, 0x60, 0x89, 0xb6, 0xff, 0x5b, 0x7f, 0xa3, 0xff,
0x4d, 0x55, 0x6c, 0xff, 0x56, 0x53, 0x6b, 0xff, 0x59, 0x55, 0x6a, 0xff,
0x51, 0x57, 0x72, 0xff, 0x68, 0x66, 0x72, 0xff, 0x4c, 0x3f, 0x41, 0xff,
0x50, 0x41, 0x40, 0xff, 0x4c, 0x42, 0x39, 0xff, 0x51, 0x44, 0x3f, 0xff,
0x4b, 0x3f, 0x3f, 0xff, 0x31, 0x2e, 0x2a, 0xff, 0x24, 0x24, 0x20, 0xff,
0x2c, 0x2c, 0x2a, 0xff, 0x31, 0x2e, 0x2e, 0xff, 0x33, 0x2f, 0x30, 0xff,
0x33, 0x2e, 0x30, 0xff, 0x39, 0x34, 0x35, 0xff, 0x4e, 0x4a, 0x4a, 0xff,
0x64, 0x60, 0x60, 0xff, 0x60, 0x5f, 0x5f, 0xff, 0x77, 0x78, 0x78, 0xff,
0x8e, 0x94, 0x96, 0xff, 0x92, 0x94, 0x94, 0xff, 0x8b, 0x89, 0x88, 0xff,
0x73, 0x6e, 0x6b, 0xff, 0x55, 0x51, 0x4d, 0xff, 0x4f, 0x48, 0x42, 0xff,
0x50, 0x42, 0x3e, 0xff, 0x51, 0x3f, 0x3c, 0xff, 0x52, 0x40, 0x40, 0xff,
0x52, 0x40, 0x41, 0xff, 0x4f, 0x41, 0x3f, 0xff, 0x4d, 0x41, 0x3d, 0xff,
0x54, 0x44, 0x41, 0xff, 0x59, 0x43, 0x44, 0xff, 0x56, 0x46, 0x44, 0xff,
0x55, 0x46, 0x43, 0xff, 0x55, 0x46, 0x43, 0xff, 0x54, 0x45, 0x42, 0xff,
0x52, 0x44, 0x40, 0xff, 0x52, 0x43, 0x41, 0xff, 0x54, 0x45, 0x43, 0xff,
0x53, 0x46, 0x44, 0xff, 0x54, 0x47, 0x45, 0xff, 0x53, 0x47, 0x45, 0xff,
0x54, 0x47, 0x45, 0xff, 0x51, 0x44, 0x42, 0xff, 0x4f, 0x42, 0x41, 0xff,
0x4d, 0x41, 0x3f, 0xff, 0x4d, 0x3f, 0x3c, 0xff, 0x48, 0x3e, 0x34, 0xff,
0x51, 0x4b, 0x40, 0xff, 0xa4, 0x9e, 0x98, 0xff, 0xdb, 0xdc, 0xda, 0xff,
0xd3, 0xde, 0xde, 0xff, 0xdb, 0xe2, 0xe0, 0xff, 0xd3, 0xd9, 0xda, 0xff,
0x92, 0x98, 0x97, 0xff, 0xb9, 0xb9, 0xc0, 0xff, 0x8d, 0x84, 0x90, 0xff,
0xc1, 0xba, 0xb5, 0xff, 0x60, 0x56, 0x4d, 0xff, 0x68, 0x5c, 0x55, 0xff,
0x68, 0x62, 0x56, 0xff, 0x66, 0x61, 0x4f, 0xff, 0x63, 0x5a, 0x4f, 0xff,
0x52, 0x44, 0x45, 0xff, 0x51, 0x42, 0x46, 0xff, 0x4e, 0x45, 0x43, 0xff,
0x51, 0x46, 0x43, 0xff, 0x59, 0x78, 0x9a, 0xff, 0x53, 0x72, 0x91, 0xff,
0x49, 0x6c, 0x86, 0xff, 0x49, 0x6a, 0x84, 0xff, 0x4d, 0x6b, 0x86, 0xff,
0x4f, 0x6d, 0x88, 0xff, 0x50, 0x6e, 0x8a, 0xff, 0x54, 0x70, 0x8c, 0xff,
0x5f, 0x75, 0x89, 0xff, 0x92, 0xa4, 0xaf, 0xff, 0xc4, 0xd4, 0xd9, 0xff,
0xbf, 0xce, 0xd4, 0xff, 0xa8, 0xba, 0xca, 0xff, 0x9f, 0xb9, 0xcd, 0xff,
0x9b, 0xb4, 0xc5, 0xff, 0x97, 0xae, 0xc2, 0xff, 0x92, 0xaa, 0xc4, 0xff,
0x88, 0xa3, 0xc2, 0xff, 0x86, 0xa0, 0xc5, 0xff, 0x7b, 0x98, 0xbe, 0xff,
0x81, 0x9c, 0xbe, 0xff, 0x6d, 0x89, 0xa6, 0xff, 0x77, 0x8c, 0xa1, 0xff,
0x70, 0x86, 0x9c, 0xff, 0x6a, 0x88, 0xa9, 0xff, 0x6a, 0x87, 0xa9, 0xff,
0x59, 0x71, 0x8f, 0xff, 0x6b, 0x95, 0xba, 0xff, 0x67, 0x97, 0xc2, 0xff,
0x64, 0x91, 0xb8, 0xff, 0x58, 0x72, 0x91, 0xff, 0x4e, 0x4d, 0x5b, 0xff,
0x67, 0x73, 0x85, 0xff, 0x78, 0x95, 0xba, 0xff, 0x65, 0x74, 0x90, 0xff,
0x6a, 0x61, 0x70, 0xff, 0x4b, 0x3f, 0x40, 0xff, 0x51, 0x41, 0x3a, 0xff,
0x50, 0x41, 0x39, 0xff, 0x50, 0x44, 0x42, 0xff, 0x33, 0x2c, 0x29, 0xff,
0x27, 0x21, 0x21, 0xff, 0x28, 0x23, 0x23, 0xff, 0x2b, 0x25, 0x26, 0xff,
0x2b, 0x25, 0x27, 0xff, 0x23, 0x1d, 0x20, 0xff, 0x2c, 0x27, 0x29, 0xff,
0x35, 0x30, 0x32, 0xff, 0x3e, 0x38, 0x3b, 0xff, 0x49, 0x43, 0x45, 0xff,
0x58, 0x54, 0x55, 0xff, 0x48, 0x48, 0x48, 0xff, 0x5b, 0x5b, 0x5b, 0xff,
0x6b, 0x6d, 0x6b, 0xff, 0x65, 0x69, 0x65, 0xff, 0x4a, 0x49, 0x42, 0xff,
0x7a, 0x75, 0x70, 0xff, 0x93, 0x8e, 0x8e, 0xff, 0x59, 0x50, 0x52, 0xff,
0x40, 0x34, 0x30, 0xff, 0x4a, 0x3c, 0x35, 0xff, 0x4e, 0x3f, 0x3c, 0xff,
0x4e, 0x43, 0x3f, 0xff, 0x53, 0x44, 0x40, 0xff, 0x58, 0x45, 0x42, 0xff,
0x54, 0x47, 0x43, 0xff, 0x53, 0x47, 0x43, 0xff, 0x53, 0x47, 0x43, 0xff,
0x52, 0x46, 0x42, 0xff, 0x51, 0x45, 0x40, 0xff, 0x52, 0x43, 0x41, 0xff,
0x52, 0x45, 0x43, 0xff, 0x53, 0x46, 0x44, 0xff, 0x53, 0x47, 0x45, 0xff,
0x52, 0x48, 0x45, 0xff, 0x54, 0x47, 0x45, 0xff, 0x51, 0x44, 0x42, 0xff,
0x4f, 0x42, 0x40, 0xff, 0x4e, 0x41, 0x3f, 0xff, 0x4c, 0x40, 0x3e, 0xff,
0x44, 0x37, 0x34, 0xff, 0xc0, 0xc1, 0xbd, 0xff, 0x95, 0xa8, 0xb1, 0xff,
0x7d, 0x8f, 0x9c, 0xff, 0x8d, 0x96, 0x99, 0xff, 0x82, 0x90, 0x8e, 0xff,
0x8e, 0x99, 0x9b, 0xff, 0x9d, 0xa2, 0xa1, 0xff, 0x79, 0x76, 0x77, 0xff,
0x70, 0x64, 0x68, 0xff, 0x61, 0x54, 0x4e, 0xff, 0x56, 0x50, 0x48, 0xff,
0x61, 0x5d, 0x58, 0xff, 0x5b, 0x56, 0x53, 0xff, 0x71, 0x6b, 0x62, 0xff,
0x5e, 0x57, 0x4f, 0xff, 0x50, 0x44, 0x44, 0xff, 0x51, 0x43, 0x45, 0xff,
0x4e, 0x45, 0x42, 0xff, 0x51, 0x46, 0x43, 0xff, 0x57, 0x77, 0x9a, 0xff,
0x51, 0x72, 0x92, 0xff, 0x49, 0x6c, 0x86, 0xff, 0x48, 0x69, 0x83, 0xff,
0x4c, 0x6a, 0x85, 0xff, 0x4f, 0x6d, 0x88, 0xff, 0x50, 0x70, 0x8c, 0xff,
0x4e, 0x74, 0x93, 0xff, 0x55, 0x77, 0x93, 0xff, 0x5a, 0x75, 0x8e, 0xff,
0x89, 0x9d, 0xb3, 0xff, 0xb1, 0xbf, 0xd0, 0xff, 0xbf, 0xcf, 0xdd, 0xff,
0xa4, 0xbc, 0xca, 0xff, 0xa1, 0xb8, 0xc0, 0xff, 0x9d, 0xb0, 0xba, 0xff,
0x94, 0xa8, 0xba, 0xff, 0x8d, 0xa4, 0xbb, 0xff, 0x93, 0xa9, 0xc5, 0xff,
0x7f, 0x97, 0xb7, 0xff, 0x87, 0xa3, 0xc3, 0xff, 0x77, 0x92, 0xac, 0xff,
0x71, 0x89, 0x9f, 0xff, 0x72, 0x8c, 0xa5, 0xff, 0x6d, 0x8d, 0xb0, 0xff,
0x73, 0x97, 0xbd, 0xff, 0x59, 0x7a, 0x9b, 0xff, 0x65, 0x8d, 0xb0, 0xff,
0x62, 0x97, 0xbd, 0xff, 0x6d, 0x9d, 0xc8, 0xff, 0x70, 0x98, 0xc2, 0xff,
0x5b, 0x7a, 0x95, 0xff, 0x68, 0x88, 0xaa, 0xff, 0x69, 0x93, 0xc6, 0xff,
0x65, 0x7f, 0xa7, 0xff, 0x5f, 0x68, 0x7e, 0xff, 0x5e, 0x5e, 0x6c, 0xff,
0x4b, 0x3e, 0x3f, 0xff, 0x50, 0x41, 0x3b, 0xff, 0x4b, 0x40, 0x3d, 0xff,
0x48, 0x3c, 0x39, 0xff, 0x39, 0x30, 0x2f, 0xff, 0x24, 0x1d, 0x1d, 0xff,
0x20, 0x1a, 0x1a, 0xff, 0x19, 0x14, 0x15, 0xff, 0x1d, 0x1a, 0x1b, 0xff,
0x22, 0x1f, 0x21, 0xff, 0x25, 0x21, 0x23, 0xff, 0x2a, 0x24, 0x26, 0xff,
0x32, 0x2b, 0x2e, 0xff, 0x50, 0x47, 0x47, 0xff, 0x50, 0x47, 0x45, 0xff,
0x41, 0x3a, 0x37, 0xff, 0x54, 0x50, 0x4f, 0xff, 0x54, 0x52, 0x51, 0xff,
0x4b, 0x48, 0x44, 0xff, 0x66, 0x62, 0x5f, 0xff, 0x83, 0x82, 0x86, 0xff,
0xa5, 0xa4, 0xa5, 0xff, 0xc8, 0xc3, 0xba, 0xff, 0xab, 0xa3, 0x9b, 0xff,
0x7c, 0x72, 0x6e, 0xff, 0x55, 0x4d, 0x4c, 0xff, 0x4e, 0x43, 0x41, 0xff,
0x4e, 0x41, 0x3c, 0xff, 0x54, 0x48, 0x44, 0xff, 0x53, 0x48, 0x44, 0xff,
0x53, 0x47, 0x43, 0xff, 0x54, 0x48, 0x44, 0xff, 0x50, 0x45, 0x41, 0xff,
0x51, 0x43, 0x41, 0xff, 0x52, 0x45, 0x43, 0xff, 0x53, 0x47, 0x45, 0xff,
0x52, 0x48, 0x46, 0xff, 0x52, 0x49, 0x46, 0xff, 0x53, 0x47, 0x45, 0xff,
0x51, 0x45, 0x43, 0xff, 0x4f, 0x43, 0x41, 0xff, 0x4e, 0x42, 0x40, 0xff,
0x49, 0x3d, 0x3b, 0xff, 0x77, 0x77, 0x81, 0xff, 0x73, 0x99, 0xbe, 0xff,
0x61, 0x84, 0xa2, 0xff, 0x87, 0x92, 0x97, 0xff, 0x78, 0x7c, 0x76, 0xff,
0x73, 0x7b, 0x7a, 0xff, 0x9d, 0xa1, 0xa8, 0xff, 0x88, 0x86, 0x8a, 0xff,
0x40, 0x38, 0x3a, 0xff, 0x32, 0x23, 0x27, 0xff, 0x42, 0x36, 0x39, 0xff,
0x68, 0x67, 0x67, 0xff, 0x84, 0x87, 0x8c, 0xff, 0xac, 0xad, 0xb3, 0xff,
0x88, 0x86, 0x86, 0xff, 0x53, 0x4e, 0x4a, 0xff, 0x4f, 0x45, 0x44, 0xff,
0x50, 0x44, 0x44, 0xff, 0x4f, 0x44, 0x43, 0xff, 0x51, 0x46, 0x43, 0xff,
0x55, 0x74, 0x9b, 0xff, 0x4f, 0x70, 0x93, 0xff, 0x49, 0x6c, 0x86, 0xff,
0x48, 0x69, 0x83, 0xff, 0x4b, 0x69, 0x84, 0xff, 0x4e, 0x6c, 0x87, 0xff,
0x51, 0x6f, 0x8a, 0xff, 0x54, 0x74, 0x8f, 0xff, 0x58, 0x76, 0x94, 0xff,
0x5c, 0x77, 0x95, 0xff, 0x66, 0x7a, 0x96, 0xff, 0x77, 0x86, 0x9e, 0xff,
0xa2, 0xb6, 0xd1, 0xff, 0xaa, 0xc5, 0xe4, 0xff, 0xa6, 0xbc, 0xd3, 0xff,
0x9b, 0xb1, 0xc0, 0xff, 0x9b, 0xb2, 0xc2, 0xff, 0x90, 0xa6, 0xb7, 0xff,
0x83, 0x98, 0xab, 0xff, 0x75, 0x8f, 0xa6, 0xff, 0x7a, 0x9a, 0xb6, 0xff,
0x6f, 0x90, 0xaa, 0xff, 0x79, 0x9a, 0xb5, 0xff, 0x73, 0x95, 0xb2, 0xff,
0x70, 0x94, 0xb3, 0xff, 0x6c, 0x96, 0xbb, 0xff, 0x69, 0x90, 0xb1, 0xff,
0x61, 0x87, 0xa5, 0xff, 0x5f, 0x94, 0xb3, 0xff, 0x6d, 0x99, 0xc3, 0xff,
0x72, 0x9b, 0xce, 0xff, 0x6b, 0x95, 0xbd, 0xff, 0x5a, 0x82, 0xaa, 0xff,
0x6b, 0x99, 0xcd, 0xff, 0x72, 0x92, 0xbc, 0xff, 0x6f, 0x86, 0xa3, 0xff,
0x61, 0x74, 0x9a, 0xff, 0x48, 0x42, 0x53, 0xff, 0x4c, 0x40, 0x40, 0xff,
0x49, 0x40, 0x3d, 0xff, 0x53, 0x43, 0x3f, 0xff, 0x52, 0x4b, 0x46, 0xff,
0x4d, 0x48, 0x44, 0xff, 0x28, 0x26, 0x23, 0xff, 0x33, 0x35, 0x31, 0xff,
0x32, 0x35, 0x34, 0xff, 0x31, 0x36, 0x34, 0xff, 0x24, 0x27, 0x25, 0xff,
0x25, 0x23, 0x22, 0xff, 0x28, 0x23, 0x23, 0xff, 0x2b, 0x24, 0x22, 0xff,
0x26, 0x1d, 0x17, 0xff, 0x3b, 0x33, 0x30, 0xff, 0x3b, 0x34, 0x32, 0xff,
0x36, 0x31, 0x30, 0xff, 0x3c, 0x37, 0x38, 0xff, 0x52, 0x4d, 0x4f, 0xff,
0x64, 0x60, 0x61, 0xff, 0x73, 0x70, 0x6d, 0xff, 0x9c, 0x9d, 0x96, 0xff,
0xb1, 0xaf, 0xa7, 0xff, 0xb2, 0xaf, 0xad, 0xff, 0xa8, 0xa4, 0xa7, 0xff,
0x97, 0x91, 0x94, 0xff, 0x7f, 0x78, 0x73, 0xff, 0x5c, 0x51, 0x4d, 0xff,
0x55, 0x4a, 0x46, 0xff, 0x53, 0x48, 0x44, 0xff, 0x4d, 0x42, 0x3e, 0xff,
0x4e, 0x43, 0x3f, 0xff, 0x50, 0x44, 0x42, 0xff, 0x52, 0x46, 0x44, 0xff,
0x53, 0x48, 0x46, 0xff, 0x53, 0x4a, 0x47, 0xff, 0x52, 0x4a, 0x47, 0xff,
0x54, 0x49, 0x47, 0xff, 0x51, 0x47, 0x44, 0xff, 0x4f, 0x44, 0x42, 0xff,
0x4a, 0x40, 0x3d, 0xff, 0x55, 0x4d, 0x4d, 0xff, 0x85, 0x9c, 0xc2, 0xff,
0x61, 0x91, 0xb7, 0xff, 0x75, 0x90, 0x97, 0xff, 0x73, 0x70, 0x67, 0xff,
0x70, 0x6c, 0x6d, 0xff, 0xa6, 0xad, 0xaa, 0xff, 0x94, 0x98, 0xa1, 0xff,
0x5d, 0x5c, 0x67, 0xff, 0x59, 0x55, 0x5c, 0xff, 0x64, 0x5d, 0x64, 0xff,
0x4d, 0x4b, 0x48, 0xff, 0x65, 0x64, 0x5e, 0xff, 0x4c, 0x4b, 0x48, 0xff,
0x47, 0x4a, 0x44, 0xff, 0x8a, 0x8c, 0x86, 0xff, 0x47, 0x43, 0x43, 0xff,
0x4c, 0x44, 0x41, 0xff, 0x51, 0x45, 0x44, 0xff, 0x51, 0x45, 0x45, 0xff,
0x52, 0x47, 0x45, 0xff, 0x52, 0x72, 0x9c, 0xff, 0x4e, 0x6f, 0x94, 0xff,
0x48, 0x6c, 0x87, 0xff, 0x47, 0x69, 0x83, 0xff, 0x48, 0x69, 0x86, 0xff,
0x4d, 0x6b, 0x88, 0xff, 0x50, 0x6e, 0x8c, 0xff, 0x54, 0x71, 0x94, 0xff,
0x57, 0x74, 0x98, 0xff, 0x5c, 0x78, 0x9a, 0xff, 0x65, 0x7d, 0x98, 0xff,
0x6c, 0x81, 0x9b, 0xff, 0x7f, 0x96, 0xb6, 0xff, 0x89, 0xa5, 0xc9, 0xff,
0x8f, 0xad, 0xce, 0xff, 0x7c, 0x97, 0xae, 0xff, 0x7c, 0x94, 0xa4, 0xff,
0x7d, 0x94, 0xa4, 0xff, 0x83, 0x9a, 0xa9, 0xff, 0x76, 0x8f, 0xa3, 0xff,
0x6a, 0x88, 0x9f, 0xff, 0x62, 0x85, 0xa2, 0xff, 0x67, 0x8e, 0xac, 0xff,
0x62, 0x8b, 0xa6, 0xff, 0x6f, 0x97, 0xb3, 0xff, 0x65, 0x91, 0xb3, 0xff,
0x68, 0x92, 0xb3, 0xff, 0x66, 0x8a, 0xaa, 0xff, 0x60, 0x90, 0xaf, 0xff,
0x6a, 0x91, 0xb8, 0xff, 0x67, 0x8e, 0xbf, 0xff, 0x6c, 0x8c, 0xb2, 0xff,
0x72, 0x93, 0xb8, 0xff, 0x64, 0x93, 0xba, 0xff, 0x62, 0x8b, 0xab, 0xff,
0x6f, 0x8b, 0xb2, 0xff, 0x70, 0x8d, 0xbf, 0xff, 0x56, 0x5e, 0x7a, 0xff,
0x4a, 0x46, 0x4f, 0xff, 0x4b, 0x40, 0x3a, 0xff, 0x52, 0x43, 0x41, 0xff,
0x50, 0x4a, 0x42, 0xff, 0x55, 0x53, 0x4b, 0xff, 0x52, 0x53, 0x4b, 0xff,
0x4f, 0x54, 0x4c, 0xff, 0x4d, 0x55, 0x4d, 0xff, 0x4e, 0x56, 0x50, 0xff,
0x4f, 0x55, 0x4f, 0xff, 0x4a, 0x4a, 0x45, 0xff, 0x43, 0x3f, 0x3a, 0xff,
0x33, 0x2e, 0x2a, 0xff, 0x2a, 0x26, 0x22, 0xff, 0x20, 0x1c, 0x19, 0xff,
0x28, 0x23, 0x22, 0xff, 0x22, 0x1c, 0x1d, 0xff, 0x2b, 0x26, 0x2b, 0xff,
0x35, 0x2e, 0x32, 0xff, 0x41, 0x3b, 0x3a, 0xff, 0x5f, 0x5a, 0x56, 0xff,
0x7e, 0x7e, 0x78, 0xff, 0x86, 0x85, 0x81, 0xff, 0x6c, 0x68, 0x69, 0xff,
0x69, 0x66, 0x6b, 0xff, 0x79, 0x74, 0x7a, 0xff, 0x7f, 0x79, 0x7a, 0xff,
0x98, 0x91, 0x92, 0xff, 0xa5, 0x9e, 0x9d, 0xff, 0xa3, 0x9b, 0x98, 0xff,
0x84, 0x7b, 0x75, 0xff, 0x5c, 0x52, 0x4a, 0xff, 0x4a, 0x3e, 0x39, 0xff,
0x4f, 0x43, 0x3f, 0xff, 0x53, 0x49, 0x45, 0xff, 0x55, 0x4c, 0x47, 0xff,
0x55, 0x4c, 0x47, 0xff, 0x53, 0x4b, 0x46, 0xff, 0x54, 0x4a, 0x46, 0xff,
0x4f, 0x45, 0x41, 0xff, 0x4c, 0x41, 0x3f, 0xff, 0x91, 0x8a, 0x8b, 0xff,
0x6b, 0x8c, 0xa3, 0xff, 0x6f, 0x83, 0x92, 0xff, 0x5b, 0x59, 0x59, 0xff,
0x60, 0x59, 0x50, 0xff, 0x66, 0x66, 0x5e, 0xff, 0x74, 0x7b, 0x77, 0xff,
0x71, 0x76, 0x7d, 0xff, 0x7d, 0x82, 0x8b, 0xff, 0x8c, 0x90, 0x97, 0xff,
0x9b, 0x9d, 0xa2, 0xff, 0x55, 0x56, 0x54, 0xff, 0x62, 0x60, 0x5a, 0xff,
0x7e, 0x79, 0x74, 0xff, 0x72, 0x71, 0x69, 0xff, 0x4c, 0x4e, 0x4a, 0xff,
0x5d, 0x5b, 0x5e, 0xff, 0x4f, 0x47, 0x47, 0xff, 0x53, 0x46, 0x47, 0xff,
0x52, 0x48, 0x48, 0xff, 0x52, 0x49, 0x46, 0xff, 0x53, 0x72, 0x9f, 0xff,
0x4c, 0x70, 0x97, 0xff, 0x49, 0x6d, 0x8b, 0xff, 0x46, 0x69, 0x87, 0xff,
0x49, 0x69, 0x89, 0xff, 0x4c, 0x6b, 0x8c, 0xff, 0x4f, 0x6c, 0x8e, 0xff,
0x52, 0x6f, 0x91, 0xff, 0x5a, 0x74, 0x95, 0xff, 0x61, 0x78, 0x94, 0xff,
0x67, 0x7c, 0x97, 0xff, 0x6b, 0x82, 0x99, 0xff, 0x6f, 0x85, 0x97, 0xff,
0x6e, 0x86, 0x9a, 0xff, 0x79, 0x9a, 0xb7, 0xff, 0x77, 0x96, 0xb2, 0xff,
0x71, 0x89, 0x9e, 0xff, 0x6e, 0x84, 0x9a, 0xff, 0x70, 0x88, 0x9d, 0xff,
0x72, 0x89, 0xa1, 0xff, 0x6e, 0x86, 0x9d, 0xff, 0x6a, 0x89, 0xa7, 0xff,
0x61, 0x86, 0xa3, 0xff, 0x63, 0x8d, 0xa3, 0xff, 0x66, 0x91, 0xa9, 0xff,
0x70, 0x9a, 0xb7, 0xff, 0x65, 0x8c, 0xad, 0xff, 0x65, 0x88, 0xaa, 0xff,
0x61, 0x8f, 0xad, 0xff, 0x64, 0x90, 0xaf, 0xff, 0x6d, 0x98, 0xc2, 0xff,
0x70, 0x92, 0xc1, 0xff, 0x75, 0x98, 0xc7, 0xff, 0x61, 0x86, 0xa7, 0xff,
0x62, 0x7f, 0x93, 0xff, 0x6c, 0x8c, 0xb5, 0xff, 0x74, 0x98, 0xc9, 0xff,
0x79, 0x95, 0xbc, 0xff, 0x72, 0x82, 0x9f, 0xff, 0x4d, 0x43, 0x44, 0xff,
0x4b, 0x41, 0x43, 0xff, 0x50, 0x4a, 0x45, 0xff, 0x53, 0x4f, 0x49, 0xff,
0x52, 0x51, 0x4b, 0xff, 0x4e, 0x51, 0x4a, 0xff, 0x4b, 0x50, 0x49, 0xff,
0x4e, 0x53, 0x4b, 0xff, 0x51, 0x54, 0x4d, 0xff, 0x50, 0x4d, 0x47, 0xff,
0x51, 0x47, 0x42, 0xff, 0x4d, 0x42, 0x3f, 0xff, 0x3e, 0x36, 0x36, 0xff,
0x35, 0x2e, 0x2e, 0xff, 0x37, 0x30, 0x30, 0xff, 0x35, 0x2d, 0x2d, 0xff,
0x2f, 0x27, 0x27, 0xff, 0x33, 0x2a, 0x2d, 0xff, 0x3e, 0x37, 0x37, 0xff,
0x31, 0x29, 0x29, 0xff, 0x33, 0x2c, 0x2b, 0xff, 0x4f, 0x46, 0x47, 0xff,
0x48, 0x3e, 0x40, 0xff, 0x5a, 0x50, 0x53, 0xff, 0x5c, 0x55, 0x59, 0xff,
0x69, 0x63, 0x69, 0xff, 0x73, 0x6c, 0x70, 0xff, 0x79, 0x74, 0x76, 0xff,
0x80, 0x7b, 0x7a, 0xff, 0x9c, 0x96, 0x91, 0xff, 0xa9, 0xa4, 0x9c, 0xff,
0xa7, 0xa1, 0x98, 0xff, 0x8c, 0x86, 0x7d, 0xff, 0x7d, 0x77, 0x6e, 0xff,
0x7d, 0x77, 0x6e, 0xff, 0x70, 0x6a, 0x60, 0xff, 0x63, 0x5e, 0x56, 0xff,
0x5b, 0x54, 0x4a, 0xff, 0x57, 0x4f, 0x47, 0xff, 0x4e, 0x45, 0x40, 0xff,
0x54, 0x4e, 0x4d, 0xff, 0x5f, 0x68, 0x67, 0xff, 0x47, 0x42, 0x3f, 0xff,
0x5a, 0x4d, 0x47, 0xff, 0x5f, 0x55, 0x50, 0xff, 0x65, 0x64, 0x5f, 0xff,
0x72, 0x70, 0x6f, 0xff, 0x84, 0x83, 0x82, 0xff, 0xa8, 0xa8, 0xa6, 0xff,
0xb1, 0xb4, 0xb2, 0xff, 0x9a, 0x9c, 0x99, 0xff, 0x7b, 0x7b, 0x79, 0xff,
0x76, 0x76, 0x75, 0xff, 0x6f, 0x70, 0x6e, 0xff, 0x47, 0x47, 0x45, 0xff,
0x59, 0x5b, 0x5b, 0xff, 0x61, 0x61, 0x63, 0xff, 0x52, 0x4a, 0x4c, 0xff,
0x52, 0x46, 0x47, 0xff, 0x51, 0x49, 0x48, 0xff, 0x53, 0x4b, 0x48, 0xff,
0x54, 0x72, 0xa1, 0xff, 0x4d, 0x70, 0x99, 0xff, 0x4a, 0x6c, 0x8f, 0xff,
0x48, 0x68, 0x8b, 0xff, 0x49, 0x67, 0x88, 0xff, 0x4d, 0x68, 0x89, 0xff,
0x50, 0x6b, 0x8a, 0xff, 0x54, 0x6f, 0x8a, 0xff, 0x5b, 0x73, 0x8e, 0xff,
0x62, 0x79, 0x91, 0xff, 0x68, 0x7e, 0x94, 0xff, 0x6b, 0x83, 0x95, 0xff,
0x72, 0x89, 0x99, 0xff, 0x79, 0x8b, 0x9e, 0xff, 0x6d, 0x86, 0xa2, 0xff,
0x47, 0x6d, 0x8b, 0xff, 0x44, 0x68, 0x86, 0xff, 0x56, 0x75, 0x93, 0xff,
0x66, 0x85, 0xa4, 0xff, 0x74, 0x93, 0xb0, 0xff, 0x78, 0x96, 0xb4, 0xff,
0x74, 0x95, 0xb2, 0xff, 0x74, 0x99, 0xb5, 0xff, 0x65, 0x8b, 0xa4, 0xff,
0x65, 0x8c, 0xa5, 0xff, 0x66, 0x8e, 0xa9, 0xff, 0x68, 0x90, 0xaa, 0xff,
0x6d, 0x91, 0xaf, 0xff, 0x5e, 0x8e, 0xaa, 0xff, 0x66, 0x95, 0xb5, 0xff,
0x5d, 0x8c, 0xbc, 0xff, 0x66, 0x8d, 0xc1, 0xff, 0x6f, 0x9b, 0xcb, 0xff,
0x65, 0x8c, 0xb4, 0xff, 0x73, 0x87, 0xa5, 0xff, 0x74, 0x94, 0xbd, 0xff,
0x78, 0xa3, 0xd7, 0xff, 0x70, 0x98, 0xc9, 0xff, 0x8a, 0xae, 0xe1, 0xff,
0x73, 0x82, 0x99, 0xff, 0x4a, 0x42, 0x41, 0xff, 0x4f, 0x49, 0x44, 0xff,
0x52, 0x4e, 0x49, 0xff, 0x4f, 0x4d, 0x48, 0xff, 0x4c, 0x4c, 0x46, 0xff,
0x4b, 0x4c, 0x46, 0xff, 0x4e, 0x4f, 0x49, 0xff, 0x4f, 0x50, 0x4a, 0xff,
0x4e, 0x4b, 0x46, 0xff, 0x50, 0x47, 0x43, 0xff, 0x51, 0x45, 0x42, 0xff,
0x50, 0x46, 0x42, 0xff, 0x4c, 0x42, 0x3e, 0xff, 0x4a, 0x40, 0x3c, 0xff,
0x4c, 0x42, 0x3f, 0xff, 0x4c, 0x44, 0x3f, 0xff, 0x4a, 0x44, 0x3f, 0xff,
0x3c, 0x35, 0x31, 0xff, 0x2c, 0x24, 0x23, 0xff, 0x2a, 0x22, 0x23, 0xff,
0x3a, 0x32, 0x34, 0xff, 0x36, 0x2e, 0x31, 0xff, 0x2d, 0x26, 0x29, 0xff,
0x34, 0x2e, 0x33, 0xff, 0x3c, 0x36, 0x3c, 0xff, 0x55, 0x4a, 0x4a, 0xff,
0x64, 0x58, 0x57, 0xff, 0x69, 0x60, 0x60, 0xff, 0x75, 0x6d, 0x6d, 0xff,
0x75, 0x6f, 0x70, 0xff, 0x7a, 0x74, 0x6b, 0xff, 0x8d, 0x87, 0x7e, 0xff,
0x8b, 0x85, 0x7c, 0xff, 0x89, 0x82, 0x7a, 0xff, 0x8e, 0x8a, 0x80, 0xff,
0x8b, 0x8a, 0x82, 0xff, 0x97, 0x95, 0x8b, 0xff, 0x9a, 0x96, 0x8b, 0xff,
0x8b, 0x89, 0x80, 0xff, 0x8b, 0x89, 0x84, 0xff, 0x79, 0x73, 0x6e, 0xff,
0x76, 0x71, 0x6a, 0xff, 0x92, 0x8b, 0x84, 0xff, 0xa3, 0x9c, 0x98, 0xff,
0x88, 0x82, 0x7e, 0xff, 0x71, 0x6a, 0x66, 0xff, 0x72, 0x6e, 0x6a, 0xff,
0x70, 0x6d, 0x68, 0xff, 0x69, 0x66, 0x61, 0xff, 0x69, 0x64, 0x60, 0xff,
0x6c, 0x64, 0x60, 0xff, 0x47, 0x3f, 0x3c, 0xff, 0x5f, 0x56, 0x53, 0xff,
0x70, 0x67, 0x64, 0xff, 0x67, 0x64, 0x60, 0xff, 0x55, 0x52, 0x50, 0xff,
0x8b, 0x86, 0x82, 0xff, 0x5a, 0x52, 0x4e, 0xff, 0x4f, 0x48, 0x42, 0xff,
0x54, 0x4c, 0x4b, 0xff, 0x54, 0x74, 0xa4, 0xff, 0x4e, 0x71, 0x9b, 0xff,
0x4c, 0x6d, 0x95, 0xff, 0x4b, 0x69, 0x8d, 0xff, 0x4e, 0x69, 0x88, 0xff,
0x51, 0x6a, 0x86, 0xff, 0x54, 0x6b, 0x83, 0xff, 0x59, 0x70, 0x83, 0xff,
0x5f, 0x74, 0x87, 0xff, 0x66, 0x7b, 0x8d, 0xff, 0x6a, 0x7f, 0x91, 0xff,
0x6e, 0x84, 0x94, 0xff, 0x72, 0x8a, 0x97, 0xff, 0x7e, 0x8e, 0x9e, 0xff,
0x77, 0x8c, 0xa0, 0xff, 0x45, 0x6b, 0x88, 0xff, 0x37, 0x61, 0x81, 0xff,
0x42, 0x67, 0x85, 0xff, 0x4c, 0x71, 0x8d, 0xff, 0x5d, 0x80, 0x9a, 0xff,
0x65, 0x86, 0xa1, 0xff, 0x65, 0x8d, 0xa6, 0xff, 0x66, 0x91, 0xaa, 0xff,
0x67, 0x91, 0xad, 0xff, 0x6f, 0x98, 0xb3, 0xff, 0x6d, 0x95, 0xaf, 0xff,
0x60, 0x8a, 0xa1, 0xff, 0x62, 0x86, 0xa2, 0xff, 0x63, 0x92, 0xad, 0xff,
0x6b, 0x99, 0xb9, 0xff, 0x6d, 0x9b, 0xc9, 0xff, 0x5f, 0x84, 0xa7, 0xff,
0x69, 0x81, 0xa3, 0xff, 0x63, 0x85, 0xab, 0xff, 0x61, 0x86, 0xa8, 0xff,
0x60, 0x7c, 0xa9, 0xff, 0x6c, 0x98, 0xc6, 0xff, 0x76, 0xa4, 0xd8, 0xff,
0x74, 0xa2, 0xd7, 0xff, 0x89, 0xa7, 0xcd, 0xff, 0x4f, 0x51, 0x58, 0xff,
0x4c, 0x47, 0x43, 0xff, 0x4f, 0x4a, 0x47, 0xff, 0x51, 0x4c, 0x49, 0xff,
0x4c, 0x49, 0x45, 0xff, 0x4c, 0x49, 0x45, 0xff, 0x4e, 0x4a, 0x46, 0xff,
0x4f, 0x4c, 0x48, 0xff, 0x51, 0x4c, 0x48, 0xff, 0x50, 0x48, 0x45, 0xff,
0x50, 0x44, 0x41, 0xff, 0x50, 0x45, 0x41, 0xff, 0x4c, 0x41, 0x3d, 0xff,
0x4d, 0x42, 0x3e, 0xff, 0x4e, 0x42, 0x3e, 0xff, 0x4f, 0x45, 0x3f, 0xff,
0x4e, 0x48, 0x3f, 0xff, 0x50, 0x48, 0x43, 0xff, 0x51, 0x49, 0x46, 0xff,
0x4a, 0x40, 0x3f, 0xff, 0x43, 0x3b, 0x3a, 0xff, 0x39, 0x32, 0x33, 0xff,
0x29, 0x22, 0x23, 0xff, 0x23, 0x1d, 0x20, 0xff, 0x26, 0x20, 0x23, 0xff,
0x2e, 0x28, 0x2d, 0xff, 0x37, 0x31, 0x35, 0xff, 0x4c, 0x44, 0x45, 0xff,
0x59, 0x4d, 0x4c, 0xff, 0x65, 0x57, 0x55, 0xff, 0x64, 0x5a, 0x54, 0xff,
0x6b, 0x61, 0x5b, 0xff, 0x74, 0x69, 0x64, 0xff, 0x6f, 0x65, 0x5e, 0xff,
0x6e, 0x64, 0x5e, 0xff, 0x6a, 0x65, 0x61, 0xff, 0x6f, 0x68, 0x62, 0xff,
0x77, 0x6e, 0x65, 0xff, 0x65, 0x5e, 0x56, 0xff, 0x75, 0x71, 0x6b, 0xff,
0x77, 0x6e, 0x68, 0xff, 0x6b, 0x6a, 0x61, 0xff, 0x7e, 0x81, 0x77, 0xff,
0x8b, 0x8a, 0x86, 0xff, 0x75, 0x6f, 0x6c, 0xff, 0x65, 0x5b, 0x57, 0xff,
0x69, 0x5f, 0x5b, 0xff, 0x6c, 0x64, 0x5f, 0xff, 0x6c, 0x66, 0x61, 0xff,
0x79, 0x74, 0x6f, 0xff, 0x6c, 0x65, 0x61, 0xff, 0x64, 0x5e, 0x5a, 0xff,
0x65, 0x5f, 0x5b, 0xff, 0x6b, 0x65, 0x61, 0xff, 0x6c, 0x65, 0x61, 0xff,
0x62, 0x5c, 0x57, 0xff, 0x7a, 0x77, 0x6f, 0xff, 0x8c, 0x87, 0x7f, 0xff,
0x93, 0x8c, 0x83, 0xff, 0x8b, 0x86, 0x7e, 0xff, 0x56, 0x76, 0xa6, 0xff,
0x51, 0x75, 0xa0, 0xff, 0x4f, 0x6f, 0x98, 0xff, 0x4e, 0x6b, 0x8f, 0xff,
0x52, 0x6c, 0x87, 0xff, 0x57, 0x6e, 0x83, 0xff, 0x5a, 0x6f, 0x7f, 0xff,
0x5e, 0x72, 0x7f, 0xff, 0x64, 0x77, 0x85, 0xff, 0x68, 0x7b, 0x8b, 0xff,
0x6b, 0x80, 0x90, 0xff, 0x70, 0x85, 0x92, 0xff, 0x75, 0x8a, 0x99, 0xff,
0x7d, 0x91, 0x9d, 0xff, 0x7f, 0x93, 0x9b, 0xff, 0x5b, 0x79, 0x8b, 0xff,
0x36, 0x5f, 0x7e, 0xff, 0x3f, 0x68, 0x89, 0xff, 0x54, 0x7a, 0x9a, 0xff,
0x66, 0x8b, 0xa5, 0xff, 0x6e, 0x91, 0xa9, 0xff, 0x65, 0x96, 0xae, 0xff,
0x70, 0xa3, 0xc0, 0xff, 0x72, 0xa1, 0xc2, 0xff, 0x6c, 0x9a, 0xbb, 0xff,
0x68, 0x96, 0xb1, 0xff, 0x74, 0xa0, 0xbc, 0xff, 0x6c, 0x91, 0xb0, 0xff,
0x6c, 0x98, 0xb2, 0xff, 0x67, 0x8d, 0xab, 0xff, 0x62, 0x87, 0xb0, 0xff,
0x67, 0x82, 0xa2, 0xff, 0x5b, 0x68, 0x84, 0xff, 0x5e, 0x7a, 0xa2, 0xff,
0x65, 0x8b, 0xad, 0xff, 0x5f, 0x7f, 0xa7, 0xff, 0x6d, 0x96, 0xc4, 0xff,
0x77, 0xa7, 0xdd, 0xff, 0x71, 0x98, 0xc6, 0xff, 0x73, 0x98, 0xca, 0xff,
0x82, 0x9c, 0xbf, 0xff, 0x45, 0x40, 0x3e, 0xff, 0x4d, 0x48, 0x45, 0xff,
0x50, 0x4a, 0x47, 0xff, 0x4c, 0x46, 0x43, 0xff, 0x4d, 0x46, 0x43, 0xff,
0x4f, 0x47, 0x45, 0xff, 0x4f, 0x4b, 0x47, 0xff, 0x4f, 0x4a, 0x48, 0xff,
0x51, 0x48, 0x46, 0xff, 0x51, 0x47, 0x44, 0xff, 0x50, 0x46, 0x42, 0xff,
0x4d, 0x43, 0x40, 0xff, 0x4d, 0x44, 0x41, 0xff, 0x4f, 0x45, 0x41, 0xff,
0x50, 0x47, 0x42, 0xff, 0x51, 0x48, 0x43, 0xff, 0x52, 0x4a, 0x43, 0xff,
0x51, 0x49, 0x42, 0xff, 0x50, 0x49, 0x41, 0xff, 0x4c, 0x43, 0x3e, 0xff,
0x4e, 0x44, 0x40, 0xff, 0x50, 0x46, 0x45, 0xff, 0x4a, 0x41, 0x40, 0xff,
0x39, 0x32, 0x31, 0xff, 0x28, 0x25, 0x26, 0xff, 0x2b, 0x26, 0x28, 0xff,
0x3d, 0x36, 0x38, 0xff, 0x4a, 0x3f, 0x40, 0xff, 0x4c, 0x40, 0x40, 0xff,
0x47, 0x3f, 0x3e, 0xff, 0x3f, 0x37, 0x37, 0xff, 0x43, 0x3c, 0x3c, 0xff,
0x4a, 0x42, 0x43, 0xff, 0x46, 0x3f, 0x3f, 0xff, 0x38, 0x32, 0x33, 0xff,
0x40, 0x38, 0x37, 0xff, 0x4b, 0x44, 0x3f, 0xff, 0x50, 0x4b, 0x45, 0xff,
0x57, 0x52, 0x4f, 0xff, 0x53, 0x4c, 0x4d, 0xff, 0x55, 0x4f, 0x4d, 0xff,
0x60, 0x5c, 0x54, 0xff, 0x74, 0x70, 0x6a, 0xff, 0x5b, 0x55, 0x50, 0xff,
0x55, 0x49, 0x47, 0xff, 0x58, 0x4c, 0x4a, 0xff, 0x61, 0x57, 0x55, 0xff,
0x42, 0x3b, 0x37, 0xff, 0x35, 0x2e, 0x2b, 0xff, 0x5c, 0x54, 0x53, 0xff,
0x4d, 0x46, 0x45, 0xff, 0x57, 0x50, 0x4f, 0xff, 0x5a, 0x53, 0x52, 0xff,
0x3e, 0x34, 0x31, 0xff, 0x52, 0x48, 0x44, 0xff, 0x6f, 0x6b, 0x64, 0xff,
0x75, 0x72, 0x6a, 0xff, 0x7b, 0x74, 0x6b, 0xff, 0x7b, 0x74, 0x69, 0xff,
0x57, 0x7a, 0xa8, 0xff, 0x53, 0x76, 0xa3, 0xff, 0x55, 0x73, 0x99, 0xff,
0x54, 0x6f, 0x8f, 0xff, 0x58, 0x70, 0x87, 0xff, 0x5d, 0x73, 0x81, 0xff,
0x5f, 0x74, 0x7d, 0xff, 0x64, 0x76, 0x7e, 0xff, 0x67, 0x79, 0x81, 0xff,
0x6b, 0x7e, 0x87, 0xff, 0x6d, 0x82, 0x8c, 0xff, 0x74, 0x86, 0x90, 0xff,
0x78, 0x8c, 0x98, 0xff, 0x7d, 0x92, 0x9c, 0xff, 0x84, 0x97, 0x9c, 0xff,
0x7f, 0x96, 0x9f, 0xff, 0x59, 0x7e, 0x9b, 0xff, 0x3a, 0x6e, 0x90, 0xff,
0x50, 0x86, 0xa2, 0xff, 0x55, 0x86, 0xa2, 0xff, 0x67, 0x97, 0xb4, 0xff,
0x5f, 0x95, 0xae, 0xff, 0x6b, 0x9c, 0xb9, 0xff, 0x68, 0x97, 0xb6, 0xff,
0x6f, 0x9f, 0xbf, 0xff, 0x6d, 0x9d, 0xbc, 0xff, 0x6a, 0x92, 0xb1, 0xff,
0x78, 0x9e, 0xc0, 0xff, 0x79, 0xa2, 0xc3, 0xff, 0x66, 0x87, 0xa7, 0xff,
0x61, 0x80, 0xa1, 0xff, 0x66, 0x86, 0xa8, 0xff, 0x67, 0x8b, 0xab, 0xff,
0x5e, 0x8a, 0xb3, 0xff, 0x59, 0x87, 0xac, 0xff, 0x57, 0x82, 0xa7, 0xff,
0x52, 0x77, 0xa4, 0xff, 0x66, 0xa1, 0xd8, 0xff, 0x77, 0xa0, 0xd1, 0xff,
0x5d, 0x87, 0xbf, 0xff, 0x79, 0xa7, 0xe1, 0xff, 0x54, 0x53, 0x58, 0xff,
0x50, 0x47, 0x43, 0xff, 0x4d, 0x46, 0x49, 0xff, 0x4f, 0x43, 0x44, 0xff,
0x4b, 0x43, 0x44, 0xff, 0x50, 0x47, 0x47, 0xff, 0x50, 0x49, 0x48, 0xff,
0x4f, 0x49, 0x47, 0xff, 0x51, 0x49, 0x46, 0xff, 0x51, 0x48, 0x46, 0xff,
0x51, 0x47, 0x46, 0xff, 0x4f, 0x46, 0x43, 0xff, 0x4f, 0x46, 0x43, 0xff,
0x50, 0x47, 0x44, 0xff, 0x52, 0x49, 0x44, 0xff, 0x53, 0x4a, 0x46, 0xff,
0x54, 0x4c, 0x45, 0xff, 0x52, 0x4a, 0x42, 0xff, 0x52, 0x4c, 0x42, 0xff,
0x52, 0x48, 0x41, 0xff, 0x51, 0x45, 0x41, 0xff, 0x4e, 0x45, 0x41, 0xff,
0x53, 0x4a, 0x46, 0xff, 0x58, 0x4f, 0x4a, 0xff, 0x57, 0x52, 0x4a, 0xff,
0x41, 0x3a, 0x36, 0xff, 0x4e, 0x44, 0x45, 0xff, 0x3b, 0x33, 0x36, 0xff,
0x33, 0x2f, 0x34, 0xff, 0x28, 0x26, 0x2c, 0xff, 0x27, 0x25, 0x2b, 0xff,
0x22, 0x21, 0x25, 0xff, 0x24, 0x22, 0x27, 0xff, 0x27, 0x25, 0x29, 0xff,
0x26, 0x21, 0x26, 0xff, 0x2a, 0x24, 0x28, 0xff, 0x2d, 0x28, 0x29, 0xff,
0x2f, 0x2a, 0x2c, 0xff, 0x2a, 0x26, 0x29, 0xff, 0x30, 0x29, 0x2d, 0xff,
0x33, 0x2b, 0x2c, 0xff, 0x3b, 0x31, 0x30, 0xff, 0x3c, 0x33, 0x31, 0xff,
0x39, 0x30, 0x2f, 0xff, 0x32, 0x28, 0x2a, 0xff, 0x37, 0x2f, 0x2f, 0xff,
0x2a, 0x23, 0x20, 0xff, 0x3e, 0x35, 0x31, 0xff, 0x49, 0x3e, 0x3c, 0xff,
0x38, 0x30, 0x2f, 0xff, 0x35, 0x2e, 0x2b, 0xff, 0x28, 0x1d, 0x20, 0xff,
0x20, 0x18, 0x17, 0xff, 0x3c, 0x33, 0x31, 0xff, 0x54, 0x4b, 0x49, 0xff,
0x39, 0x33, 0x30, 0xff, 0x5a, 0x56, 0x4f, 0xff, 0x70, 0x6a, 0x63, 0xff,
0x65, 0x5e, 0x57, 0xff, 0x59, 0x7b, 0xa7, 0xff, 0x56, 0x78, 0xa5, 0xff,
0x5d, 0x77, 0x9b, 0xff, 0x5e, 0x76, 0x93, 0xff, 0x62, 0x79, 0x8b, 0xff,
0x65, 0x7a, 0x85, 0xff, 0x68, 0x7a, 0x80, 0xff, 0x6a, 0x78, 0x7e, 0xff,
0x6c, 0x7b, 0x81, 0xff, 0x71, 0x82, 0x87, 0xff, 0x73, 0x85, 0x8a, 0xff,
0x77, 0x8a, 0x90, 0xff, 0x7c, 0x8f, 0x96, 0xff, 0x81, 0x93, 0x9e, 0xff,
0x85, 0x98, 0xa2, 0xff, 0x83, 0x96, 0x9c, 0xff, 0x79, 0x90, 0x9e, 0xff,
0x64, 0x8b, 0xad, 0xff, 0x58, 0x8d, 0xb3, 0xff, 0x58, 0x88, 0xa4, 0xff,
0x66, 0x90, 0xa5, 0xff, 0x5c, 0x89, 0x9e, 0xff, 0x65, 0x8b, 0xa3, 0xff,
0x65, 0x8b, 0xa1, 0xff, 0x64, 0x91, 0xa9, 0xff, 0x5e, 0x88, 0xa6, 0xff,
0x64, 0x87, 0xa1, 0xff, 0x5f, 0x89, 0xa7, 0xff, 0x65, 0x8e, 0xb2, 0xff,
0x7a, 0x9d, 0xc2, 0xff, 0x7a, 0x9d, 0xbc, 0xff, 0x6a, 0x88, 0xa2, 0xff,
0x65, 0x87, 0xa3, 0xff, 0x56, 0x87, 0xa8, 0xff, 0x56, 0x8e, 0xb4, 0xff,
0x4e, 0x82, 0xad, 0xff, 0x40, 0x78, 0xa3, 0xff, 0x5b, 0x9d, 0xd5, 0xff,
0x5d, 0x97, 0xcd, 0xff, 0x5d, 0x8f, 0xc0, 0xff, 0x64, 0x92, 0xc6, 0xff,
0x64, 0x72, 0x87, 0xff, 0x52, 0x47, 0x44, 0xff, 0x4f, 0x46, 0x49, 0xff,
0x50, 0x45, 0x46, 0xff, 0x4c, 0x44, 0x46, 0xff, 0x4f, 0x47, 0x47, 0xff,
0x51, 0x49, 0x49, 0xff, 0x52, 0x4a, 0x48, 0xff, 0x51, 0x4a, 0x47, 0xff,
0x52, 0x4b, 0x47, 0xff, 0x53, 0x49, 0x49, 0xff, 0x52, 0x49, 0x47, 0xff,
0x51, 0x48, 0x45, 0xff, 0x52, 0x4a, 0x45, 0xff, 0x54, 0x4c, 0x46, 0xff,
0x55, 0x4d, 0x46, 0xff, 0x55, 0x4d, 0x46, 0xff, 0x54, 0x4c, 0x45, 0xff,
0x53, 0x4b, 0x44, 0xff, 0x53, 0x49, 0x44, 0xff, 0x51, 0x47, 0x43, 0xff,
0x50, 0x48, 0x46, 0xff, 0x52, 0x4b, 0x47, 0xff, 0x58, 0x50, 0x48, 0xff,
0x5d, 0x57, 0x4e, 0xff, 0x54, 0x4c, 0x45, 0xff, 0x36, 0x2d, 0x2b, 0xff,
0x3c, 0x35, 0x37, 0xff, 0x24, 0x20, 0x24, 0xff, 0x1f, 0x1e, 0x22, 0xff,
0x1e, 0x1c, 0x22, 0xff, 0x1c, 0x1a, 0x20, 0xff, 0x1c, 0x19, 0x1f, 0xff,
0x1d, 0x1b, 0x21, 0xff, 0x22, 0x1b, 0x21, 0xff, 0x23, 0x1c, 0x23, 0xff,
0x24, 0x1d, 0x24, 0xff, 0x25, 0x1e, 0x25, 0xff, 0x23, 0x1b, 0x22, 0xff,
0x21, 0x1c, 0x21, 0xff, 0x22, 0x1d, 0x22, 0xff, 0x26, 0x1f, 0x24, 0xff,
0x26, 0x1f, 0x24, 0xff, 0x24, 0x19, 0x20, 0xff, 0x23, 0x1b, 0x22, 0xff,
0x22, 0x1e, 0x20, 0xff, 0x2d, 0x29, 0x28, 0xff, 0x32, 0x28, 0x26, 0xff,
0x34, 0x26, 0x27, 0xff, 0x2e, 0x25, 0x22, 0xff, 0x2a, 0x24, 0x1e, 0xff,
0x25, 0x1d, 0x1f, 0xff, 0x27, 0x21, 0x22, 0xff, 0x38, 0x35, 0x32, 0xff,
0x29, 0x23, 0x24, 0xff, 0x3e, 0x35, 0x33, 0xff, 0x32, 0x2a, 0x26, 0xff,
0x3d, 0x39, 0x34, 0xff, 0x3d, 0x37, 0x34, 0xff, 0x5c, 0x7b, 0xa1, 0xff,
0x60, 0x7e, 0xa7, 0xff, 0x64, 0x7d, 0x9f, 0xff, 0x67, 0x7f, 0x9a, 0xff,
0x6a, 0x81, 0x94, 0xff, 0x6f, 0x82, 0x8d, 0xff, 0x70, 0x82, 0x88, 0xff,
0x73, 0x7f, 0x85, 0xff, 0x75, 0x82, 0x88, 0xff, 0x76, 0x83, 0x89, 0xff,
0x78, 0x86, 0x8c, 0xff, 0x7a, 0x8b, 0x92, 0xff, 0x7e, 0x91, 0x99, 0xff,
0x83, 0x95, 0xa1, 0xff, 0x89, 0x9b, 0xa6, 0xff, 0x87, 0x9a, 0xa0, 0xff,
0x7c, 0x8d, 0x92, 0xff, 0x81, 0x9d, 0xbd, 0xff, 0x8d, 0xba, 0xf3, 0xff,
0x75, 0xa6, 0xd0, 0xff, 0x73, 0xa3, 0xc1, 0xff, 0x73, 0xa0, 0xba, 0xff,
0x71, 0x97, 0xad, 0xff, 0x6b, 0x91, 0xa6, 0xff, 0x6f, 0x9b, 0xb1, 0xff,
0x6c, 0x96, 0xaf, 0xff, 0x62, 0x8d, 0xa4, 0xff, 0x6b, 0x9b, 0xb7, 0xff,
0x6e, 0x9b, 0xbf, 0xff, 0x64, 0x8d, 0xb3, 0xff, 0x69, 0x95, 0xb9, 0xff,
0x68, 0x97, 0xb1, 0xff, 0x6b, 0x95, 0xab, 0xff, 0x62, 0x8e, 0xa3, 0xff,
0x56, 0x85, 0xa0, 0xff, 0x4f, 0x78, 0xa0, 0xff, 0x52, 0x8e, 0xb9, 0xff,
0x47, 0x94, 0xc5, 0xff, 0x41, 0x82, 0xb4, 0xff, 0x5b, 0x84, 0xb0, 0xff,
0x55, 0x86, 0xaa, 0xff, 0x76, 0x9e, 0xc5, 0xff, 0x4b, 0x45, 0x51, 0xff,
0x50, 0x47, 0x48, 0xff, 0x4d, 0x47, 0x47, 0xff, 0x50, 0x44, 0x47, 0xff,
0x50, 0x48, 0x49, 0xff, 0x53, 0x4a, 0x4b, 0xff, 0x54, 0x4c, 0x4c, 0xff,
0x54, 0x4d, 0x4b, 0xff, 0x54, 0x4d, 0x4b, 0xff, 0x53, 0x4b, 0x4b, 0xff,
0x52, 0x4b, 0x49, 0xff, 0x51, 0x4a, 0x47, 0xff, 0x53, 0x4d, 0x48, 0xff,
0x54, 0x4e, 0x48, 0xff, 0x55, 0x4f, 0x48, 0xff, 0x55, 0x4f, 0x48, 0xff,
0x55, 0x4f, 0x48, 0xff, 0x53, 0x4d, 0x46, 0xff, 0x56, 0x4d, 0x46, 0xff,
0x54, 0x4a, 0x43, 0xff, 0x56, 0x4c, 0x46, 0xff, 0x55, 0x4f, 0x48, 0xff,
0x56, 0x52, 0x4c, 0xff, 0x55, 0x49, 0x40, 0xff, 0x49, 0x42, 0x3b, 0xff,
0x26, 0x25, 0x22, 0xff, 0x27, 0x25, 0x29, 0xff, 0x15, 0x11, 0x18, 0xff,
0x1b, 0x17, 0x17, 0xff, 0x24, 0x20, 0x20, 0xff, 0x2f, 0x2c, 0x2b, 0xff,
0x31, 0x2d, 0x2d, 0xff, 0x35, 0x31, 0x31, 0xff, 0x34, 0x30, 0x30, 0xff,
0x31, 0x2c, 0x2c, 0xff, 0x2b, 0x27, 0x26, 0xff, 0x2e, 0x29, 0x2a, 0xff,
0x2b, 0x26, 0x27, 0xff, 0x28, 0x24, 0x28, 0xff, 0x28, 0x22, 0x26, 0xff,
0x27, 0x20, 0x24, 0xff, 0x28, 0x21, 0x25, 0xff, 0x28, 0x1f, 0x23, 0xff,
0x27, 0x21, 0x22, 0xff, 0x25, 0x21, 0x20, 0xff, 0x2b, 0x25, 0x23, 0xff,
0x20, 0x18, 0x18, 0xff, 0x21, 0x16, 0x17, 0xff, 0x25, 0x1b, 0x18, 0xff,
0x20, 0x18, 0x14, 0xff, 0x16, 0x10, 0x10, 0xff, 0x1d, 0x19, 0x19, 0xff,
0x2a, 0x25, 0x24, 0xff, 0x1d, 0x18, 0x16, 0xff, 0x32, 0x29, 0x26, 0xff,
0x2c, 0x24, 0x20, 0xff, 0x23, 0x1e, 0x1a, 0xff, 0x2e, 0x2a, 0x28, 0xff,
0x60, 0x7c, 0x9c, 0xff, 0x65, 0x7f, 0xa0, 0xff, 0x69, 0x83, 0xa0, 0xff,
0x6c, 0x84, 0x9c, 0xff, 0x71, 0x85, 0x97, 0xff, 0x74, 0x87, 0x93, 0xff,
0x78, 0x87, 0x8f, 0xff, 0x7b, 0x87, 0x8d, 0xff, 0x7b, 0x87, 0x8d, 0xff,
0x7a, 0x88, 0x8e, 0xff, 0x7c, 0x8b, 0x91, 0xff, 0x7e, 0x8f, 0x96, 0xff,
0x82, 0x95, 0x9d, 0xff, 0x86, 0x98, 0xa3, 0xff, 0x8c, 0x9e, 0xa8, 0xff,
0x86, 0x9a, 0xa0, 0xff, 0x81, 0x91, 0x96, 0xff, 0x70, 0x88, 0x90, 0xff,
0x9b, 0xb8, 0xcf, 0xff, 0x8b, 0xab, 0xd8, 0xff, 0x84, 0xbc, 0xec, 0xff,
0x6f, 0xa7, 0xca, 0xff, 0x79, 0xa5, 0xc4, 0xff, 0x73, 0x9f, 0xba, 0xff,
0x6c, 0x9e, 0xba, 0xff, 0x69, 0x9b, 0xb7, 0xff, 0x69, 0x97, 0xba, 0xff,
0x69, 0x9a, 0xc2, 0xff, 0x6d, 0x9d, 0xc7, 0xff, 0x68, 0x98, 0xbf, 0xff,
0x5d, 0x97, 0xb5, 0xff, 0x4c, 0x89, 0xad, 0xff, 0x58, 0x8d, 0xaa, 0xff,
0x5c, 0x8e, 0xa1, 0xff, 0x56, 0x85, 0x9c, 0xff, 0x66, 0x8c, 0xa9, 0xff,
0x5e, 0x91, 0xaa, 0xff, 0x4a, 0x8a, 0xa6, 0xff, 0x4a, 0x88, 0xaf, 0xff,
0x30, 0x4d, 0x79, 0xff, 0x50, 0x73, 0x9b, 0xff, 0x53, 0x8e, 0xc0, 0xff,
0x6f, 0x79, 0x91, 0xff, 0x50, 0x47, 0x48, 0xff, 0x4d, 0x47, 0x48, 0xff,
0x53, 0x46, 0x49, 0xff, 0x52, 0x48, 0x4a, 0xff, 0x53, 0x4b, 0x4d, 0xff,
0x56, 0x4e, 0x4e, 0xff, 0x56, 0x4e, 0x4e, 0xff, 0x56, 0x4e, 0x4e, 0xff,
0x55, 0x4f, 0x4e, 0xff, 0x54, 0x4e, 0x4c, 0xff, 0x53, 0x4d, 0x4a, 0xff,
0x53, 0x4e, 0x49, 0xff, 0x54, 0x4f, 0x49, 0xff, 0x55, 0x51, 0x49, 0xff,
0x55, 0x51, 0x49, 0xff, 0x56, 0x50, 0x49, 0xff, 0x55, 0x51, 0x49, 0xff,
0x54, 0x4c, 0x47, 0xff, 0x55, 0x4b, 0x44, 0xff, 0x56, 0x4c, 0x43, 0xff,
0x5f, 0x59, 0x53, 0xff, 0x9b, 0x9b, 0x9a, 0xff, 0x4d, 0x44, 0x42, 0xff,
0x32, 0x2d, 0x2b, 0xff, 0x22, 0x25, 0x24, 0xff, 0x1b, 0x1c, 0x1d, 0xff,
0x18, 0x16, 0x18, 0xff, 0x1c, 0x18, 0x16, 0xff, 0x52, 0x4e, 0x4a, 0xff,
0x5d, 0x59, 0x55, 0xff, 0x5e, 0x59, 0x57, 0xff, 0x60, 0x5b, 0x58, 0xff,
0x5e, 0x5b, 0x58, 0xff, 0x5b, 0x58, 0x55, 0xff, 0x59, 0x56, 0x53, 0xff,
0x58, 0x55, 0x51, 0xff, 0x57, 0x54, 0x51, 0xff, 0x54, 0x53, 0x4d, 0xff,
0x56, 0x53, 0x4e, 0xff, 0x58, 0x54, 0x4f, 0xff, 0x54, 0x50, 0x4c, 0xff,
0x6a, 0x64, 0x60, 0xff, 0x8a, 0x85, 0x7c, 0xff, 0x96, 0x91, 0x88, 0xff,
0x9b, 0x95, 0x8e, 0xff, 0x7c, 0x77, 0x74, 0xff, 0x41, 0x3e, 0x3d, 0xff,
0x5d, 0x5b, 0x5b, 0xff, 0x7c, 0x7a, 0x7b, 0xff, 0x74, 0x74, 0x6f, 0xff,
0x5c, 0x5c, 0x55, 0xff, 0x38, 0x35, 0x31, 0xff, 0x19, 0x14, 0x10, 0xff,
0x1d, 0x14, 0x11, 0xff, 0x23, 0x1a, 0x18, 0xff, 0x1c, 0x17, 0x15, 0xff,
0x24, 0x1f, 0x1f, 0xff, 0x63, 0x7c, 0x97, 0xff, 0x66, 0x7f, 0x9a, 0xff,
0x6a, 0x84, 0x9e, 0xff, 0x71, 0x88, 0x9f, 0xff, 0x76, 0x8a, 0x9b, 0xff,
0x7b, 0x8b, 0x98, 0xff, 0x7d, 0x8c, 0x96, 0xff, 0x7f, 0x8d, 0x93, 0xff,
0x7e, 0x8d, 0x93, 0xff, 0x7c, 0x8c, 0x92, 0xff, 0x7e, 0x91, 0x96, 0xff,
0x80, 0x94, 0x9a, 0xff, 0x84, 0x97, 0x9f, 0xff, 0x89, 0x9b, 0xa6, 0xff,
0x8a, 0x9c, 0xa7, 0xff, 0x85, 0x99, 0x9f, 0xff, 0x81, 0x92, 0x90, 0xff,
0x78, 0x88, 0x84, 0xff, 0x6d, 0x75, 0x76, 0xff, 0x89, 0x92, 0xa1, 0xff,
0x95, 0xb7, 0xdd, 0xff, 0x74, 0xa8, 0xcf, 0xff, 0x73, 0xa2, 0xc5, 0xff,
0x6f, 0x9d, 0xbd, 0xff, 0x6d, 0xa3, 0xc0, 0xff, 0x64, 0x9b, 0xb9, 0xff,
0x65, 0x9c, 0xb7, 0xff, 0x5f, 0x96, 0xb8, 0xff, 0x4f, 0x82, 0xa9, 0xff,
0x42, 0x79, 0x9d, 0xff, 0x40, 0x83, 0xa0, 0xff, 0x41, 0x7f, 0xa0, 0xff,
0x44, 0x85, 0xa5, 0xff, 0x3f, 0x89, 0xa8, 0xff, 0x3a, 0x8a, 0xa9, 0xff,
0x47, 0x90, 0xb1, 0xff, 0x53, 0x85, 0xa1, 0xff, 0x61, 0x7e, 0x97, 0xff,
0x52, 0x85, 0xa3, 0xff, 0x4b, 0x7b, 0xa7, 0xff, 0x3a, 0x7f, 0xa9, 0xff,
0x47, 0x88, 0xb8, 0xff, 0x5c, 0x7a, 0x9a, 0xff, 0x56, 0x4b, 0x50, 0xff,
0x50, 0x47, 0x4c, 0xff, 0x53, 0x49, 0x48, 0xff, 0x54, 0x4b, 0x4e, 0xff,
0x56, 0x4d, 0x50, 0xff, 0x58, 0x50, 0x51, 0xff, 0x58, 0x50, 0x50, 0xff,
0x57, 0x50, 0x50, 0xff, 0x55, 0x50, 0x4f, 0xff, 0x54, 0x4f, 0x4c, 0xff,
0x53, 0x4e, 0x4b, 0xff, 0x53, 0x4f, 0x4b, 0xff, 0x54, 0x51, 0x4a, 0xff,
0x55, 0x53, 0x4a, 0xff, 0x55, 0x52, 0x4a, 0xff, 0x55, 0x52, 0x4a, 0xff,
0x55, 0x52, 0x4a, 0xff, 0x53, 0x4c, 0x4a, 0xff, 0x56, 0x4b, 0x48, 0xff,
0x7b, 0x6f, 0x67, 0xff, 0x82, 0x7b, 0x78, 0xff, 0x76, 0x77, 0x7e, 0xff,
0x57, 0x5a, 0x61, 0xff, 0x23, 0x23, 0x28, 0xff, 0x20, 0x1d, 0x1f, 0xff,
0x16, 0x14, 0x12, 0xff, 0x42, 0x42, 0x3d, 0xff, 0x59, 0x57, 0x52, 0xff,
0x5a, 0x57, 0x53, 0xff, 0x5d, 0x5a, 0x56, 0xff, 0x5f, 0x5c, 0x58, 0xff,
0x60, 0x5d, 0x59, 0xff, 0x60, 0x5d, 0x59, 0xff, 0x5d, 0x5a, 0x56, 0xff,
0x5b, 0x58, 0x54, 0xff, 0x59, 0x56, 0x52, 0xff, 0x58, 0x55, 0x51, 0xff,
0x54, 0x53, 0x4c, 0xff, 0x57, 0x54, 0x4d, 0xff, 0x59, 0x55, 0x4e, 0xff,
0x57, 0x54, 0x4d, 0xff, 0x69, 0x63, 0x5c, 0xff, 0x83, 0x7f, 0x74, 0xff,
0x8f, 0x86, 0x7e, 0xff, 0x89, 0x7f, 0x7c, 0xff, 0x7d, 0x77, 0x7b, 0xff,
0x7e, 0x7d, 0x84, 0xff, 0x7d, 0x7d, 0x86, 0xff, 0x76, 0x71, 0x79, 0xff,
0x6c, 0x66, 0x5e, 0xff, 0x67, 0x5e, 0x51, 0xff, 0x59, 0x50, 0x48, 0xff,
0x50, 0x4c, 0x46, 0xff, 0x48, 0x3f, 0x3c, 0xff, 0x49, 0x40, 0x3e, 0xff,
0x45, 0x3e, 0x3f, 0xff, 0x3e, 0x38, 0x37, 0xff, 0x63, 0x7b, 0x94, 0xff,
0x68, 0x80, 0x98, 0xff, 0x6c, 0x84, 0x98, 0xff, 0x71, 0x89, 0x9b, 0xff,
0x78, 0x8c, 0x9e, 0xff, 0x7b, 0x8d, 0x9b, 0xff, 0x7d, 0x8f, 0x99, 0xff,
0x7f, 0x91, 0x98, 0xff, 0x7e, 0x91, 0x98, 0xff, 0x7e, 0x91, 0x97, 0xff,
0x80, 0x93, 0x98, 0xff, 0x83, 0x96, 0x9e, 0xff, 0x85, 0x98, 0xa2, 0xff,
0x89, 0x9d, 0xa5, 0xff, 0x87, 0x99, 0xa1, 0xff, 0x81, 0x95, 0x99, 0xff,
0x7e, 0x8d, 0x8f, 0xff, 0x74, 0x81, 0x81, 0xff, 0x6a, 0x71, 0x6c, 0xff,
0x63, 0x63, 0x63, 0xff, 0x74, 0x80, 0x9a, 0xff, 0x84, 0xa7, 0xd5, 0xff,
0x6e, 0x99, 0xc0, 0xff, 0x72, 0xa2, 0xbe, 0xff, 0x68, 0x9d, 0xb9, 0xff,
0x61, 0x94, 0xb2, 0xff, 0x51, 0x8f, 0xa5, 0xff, 0x53, 0x89, 0xa7, 0xff,
0x45, 0x85, 0xa7, 0xff, 0x37, 0x80, 0x9f, 0xff, 0x36, 0x8c, 0xa9, 0xff,
0x37, 0x8b, 0xad, 0xff, 0x39, 0x86, 0xb0, 0xff, 0x38, 0x8f, 0xba, 0xff,
0x44, 0x96, 0xc2, 0xff, 0x3b, 0x8d, 0xbd, 0xff, 0x31, 0x7b, 0x9e, 0xff,
0x3b, 0x79, 0x92, 0xff, 0x48, 0x78, 0x94, 0xff, 0x5f, 0x83, 0xa8, 0xff,
0x3e, 0x77, 0x9b, 0xff, 0x39, 0x77, 0x9f, 0xff, 0x41, 0x6a, 0x8c, 0xff,
0x4f, 0x4c, 0x56, 0xff, 0x56, 0x49, 0x4d, 0xff, 0x52, 0x48, 0x4d, 0xff,
0x54, 0x4d, 0x4d, 0xff, 0x57, 0x50, 0x52, 0xff, 0x56, 0x50, 0x51, 0xff,
0x55, 0x51, 0x53, 0xff, 0x55, 0x52, 0x51, 0xff, 0x55, 0x52, 0x4f, 0xff,
0x55, 0x51, 0x50, 0xff, 0x54, 0x4f, 0x4e, 0xff, 0x55, 0x51, 0x4c, 0xff,
0x56, 0x51, 0x4c, 0xff, 0x56, 0x53, 0x4c, 0xff, 0x58, 0x55, 0x4e, 0xff,
0x56, 0x53, 0x4b, 0xff, 0x57, 0x55, 0x4c, 0xff, 0x56, 0x51, 0x4c, 0xff,
0x7f, 0x71, 0x70, 0xff, 0x61, 0x4e, 0x50, 0xff, 0x67, 0x59, 0x5d, 0xff,
0x56, 0x52, 0x59, 0xff, 0x3b, 0x3c, 0x45, 0xff, 0x2f, 0x2d, 0x36, 0xff,
0x1e, 0x1a, 0x1d, 0xff, 0x18, 0x15, 0x11, 0xff, 0x55, 0x55, 0x4e, 0xff,
0x5a, 0x59, 0x54, 0xff, 0x5a, 0x58, 0x54, 0xff, 0x5f, 0x5d, 0x59, 0xff,
0x5e, 0x5d, 0x59, 0xff, 0x60, 0x5f, 0x5b, 0xff, 0x5f, 0x5f, 0x5b, 0xff,
0x5e, 0x5c, 0x58, 0xff, 0x5b, 0x59, 0x55, 0xff, 0x59, 0x57, 0x53, 0xff,
0x59, 0x56, 0x52, 0xff, 0x58, 0x55, 0x4f, 0xff, 0x59, 0x57, 0x51, 0xff,
0x5a, 0x58, 0x52, 0xff, 0x5a, 0x56, 0x51, 0xff, 0x66, 0x5f, 0x5a, 0xff,
0x78, 0x72, 0x6b, 0xff, 0x7a, 0x71, 0x6f, 0xff, 0x71, 0x68, 0x6b, 0xff,
0x78, 0x73, 0x7d, 0xff, 0x78, 0x78, 0x85, 0xff, 0x82, 0x83, 0x8e, 0xff,
0x6c, 0x66, 0x66, 0xff, 0x52, 0x46, 0x36, 0xff, 0x5b, 0x48, 0x36, 0xff,
0x55, 0x43, 0x39, 0xff, 0x59, 0x52, 0x4a, 0xff, 0x61, 0x5a, 0x54, 0xff,
0x5a, 0x53, 0x51, 0xff, 0x58, 0x52, 0x51, 0xff, 0x5b, 0x55, 0x53, 0xff,
0x61, 0x7a, 0x91, 0xff, 0x65, 0x7e, 0x94, 0xff, 0x6d, 0x84, 0x94, 0xff,
0x73, 0x89, 0x9b, 0xff, 0x79, 0x8d, 0x9f, 0xff, 0x7b, 0x8f, 0x9e, 0xff,
0x7e, 0x91, 0x9d, 0xff, 0x7f, 0x94, 0x9d, 0xff, 0x80, 0x93, 0x9b, 0xff,
0x80, 0x92, 0x99, 0xff, 0x80, 0x93, 0x99, 0xff, 0x84, 0x97, 0x9e, 0xff,
0x83, 0x98, 0xa1, 0xff, 0x86, 0x99, 0xa0, 0xff, 0x84, 0x97, 0x9c, 0xff,
0x7f, 0x8f, 0x93, 0xff, 0x7c, 0x88, 0x89, 0xff, 0x6f, 0x7d, 0x76, 0xff,
0x6b, 0x72, 0x65, 0xff, 0x60, 0x5d, 0x58, 0xff, 0x52, 0x53, 0x5b, 0xff,
0x6a, 0x78, 0x91, 0xff, 0x88, 0xb0, 0xe1, 0xff, 0x78, 0xb1, 0xec, 0xff,
0x6d, 0xa6, 0xcb, 0xff, 0x62, 0x9e, 0xbd, 0xff, 0x55, 0x96, 0xb4, 0xff,
0x48, 0x92, 0xb7, 0xff, 0x43, 0x9c, 0xc3, 0xff, 0x43, 0x82, 0xad, 0xff,
0x3d, 0x75, 0xa6, 0xff, 0x41, 0x91, 0xbb, 0xff, 0x35, 0x91, 0xbd, 0xff,
0x46, 0x84, 0xaf, 0xff, 0x1f, 0x3a, 0x67, 0xff, 0x3b, 0x87, 0xaf, 0xff,
0x37, 0x83, 0xae, 0xff, 0x3d, 0x91, 0xb1, 0xff, 0x37, 0x84, 0x9b, 0xff,
0x3e, 0x79, 0x90, 0xff, 0x50, 0x76, 0x90, 0xff, 0x5b, 0x82, 0xa0, 0xff,
0x47, 0x6a, 0x8c, 0xff, 0x74, 0x7e, 0x8d, 0xff, 0x54, 0x4e, 0x4e, 0xff,
0x4d, 0x47, 0x4a, 0xff, 0x56, 0x4b, 0x50, 0xff, 0x57, 0x4f, 0x51, 0xff,
0x58, 0x51, 0x4f, 0xff, 0x58, 0x53, 0x4e, 0xff, 0x58, 0x54, 0x50, 0xff,
0x58, 0x53, 0x52, 0xff, 0x57, 0x54, 0x4e, 0xff, 0x55, 0x51, 0x4b, 0xff,
0x56, 0x51, 0x4f, 0xff, 0x57, 0x54, 0x50, 0xff, 0x55, 0x52, 0x4c, 0xff,
0x5b, 0x58, 0x50, 0xff, 0x57, 0x53, 0x4b, 0xff, 0x6d, 0x68, 0x5f, 0xff,
0x8a, 0x81, 0x7b, 0xff, 0x42, 0x35, 0x36, 0xff, 0x38, 0x25, 0x2f, 0xff,
0x3b, 0x29, 0x34, 0xff, 0x30, 0x24, 0x2d, 0xff, 0x32, 0x2b, 0x31, 0xff,
0x30, 0x2a, 0x2f, 0xff, 0x56, 0x51, 0x52, 0xff, 0x57, 0x54, 0x51, 0xff,
0x5e, 0x5b, 0x57, 0xff, 0x5e, 0x5b, 0x57, 0xff, 0x5d, 0x5b, 0x57, 0xff,
0x60, 0x5e, 0x5a, 0xff, 0x60, 0x5f, 0x5b, 0xff, 0x62, 0x63, 0x5e, 0xff,
0x60, 0x61, 0x5d, 0xff, 0x5d, 0x5e, 0x5a, 0xff, 0x5d, 0x5c, 0x58, 0xff,
0x5d, 0x5a, 0x56, 0xff, 0x5c, 0x59, 0x55, 0xff, 0x5b, 0x57, 0x52, 0xff,
0x5c, 0x5a, 0x55, 0xff, 0x5b, 0x5d, 0x56, 0xff, 0x5e, 0x5a, 0x55, 0xff,
0x62, 0x5e, 0x59, 0xff, 0x74, 0x6d, 0x66, 0xff, 0x78, 0x71, 0x6f, 0xff,
0x75, 0x70, 0x73, 0xff, 0x76, 0x77, 0x7f, 0xff, 0x7e, 0x83, 0x8c, 0xff,
0x77, 0x79, 0x7d, 0xff, 0x60, 0x5c, 0x52, 0xff, 0x55, 0x48, 0x36, 0xff,
0x5e, 0x4a, 0x39, 0xff, 0x56, 0x44, 0x38, 0xff, 0x56, 0x4c, 0x44, 0xff,
0x60, 0x5a, 0x52, 0xff, 0x5d, 0x5a, 0x55, 0xff, 0x5d, 0x58, 0x54, 0xff,
0x5c, 0x58, 0x55, 0xff, 0x61, 0x78, 0x8d, 0xff, 0x63, 0x7a, 0x8f, 0xff,
0x6b, 0x81, 0x92, 0xff, 0x73, 0x88, 0x9c, 0xff, 0x79, 0x8c, 0x9f, 0xff,
0x7d, 0x91, 0xa1, 0xff, 0x81, 0x95, 0xa2, 0xff, 0x81, 0x95, 0xa0, 0xff,
0x83, 0x95, 0x9e, 0xff, 0x81, 0x93, 0x9b, 0xff, 0x82, 0x94, 0x9b, 0xff,
0x85, 0x98, 0x9f, 0xff, 0x83, 0x97, 0x9e, 0xff, 0x83, 0x95, 0x9c, 0xff,
0x80, 0x90, 0x95, 0xff, 0x7d, 0x8a, 0x8c, 0xff, 0x76, 0x84, 0x80, 0xff,
0x6c, 0x77, 0x6f, 0xff, 0x66, 0x6a, 0x62, 0xff, 0x62, 0x5e, 0x57, 0xff,
0x59, 0x55, 0x50, 0xff, 0x4c, 0x4d, 0x48, 0xff, 0x61, 0x68, 0x7c, 0xff,
0x76, 0x9c, 0xce, 0xff, 0x57, 0x9d, 0xd6, 0xff, 0x53, 0x92, 0xc2, 0xff,
0x48, 0x7c, 0xa8, 0xff, 0x44, 0x88, 0xb7, 0xff, 0x41, 0x8e, 0xbf, 0xff,
0x44, 0x81, 0xaf, 0xff, 0x3a, 0x77, 0xa6, 0xff, 0x40, 0x87, 0xad, 0xff,
0x2d, 0x7a, 0xa3, 0xff, 0x39, 0x78, 0x9e, 0xff, 0x38, 0x6a, 0x8d, 0xff,
0x33, 0x7f, 0xa2, 0xff, 0x39, 0x89, 0xa7, 0xff, 0x37, 0x7f, 0x9f, 0xff,
0x3d, 0x7c, 0xa0, 0xff, 0x3f, 0x84, 0xa9, 0xff, 0x45, 0x87, 0xaf, 0xff,
0x4b, 0x7b, 0x9d, 0xff, 0x40, 0x69, 0x90, 0xff, 0x47, 0x5c, 0x79, 0xff,
0x98, 0x9f, 0xaf, 0xff, 0x83, 0x86, 0x94, 0xff, 0x72, 0x6e, 0x75, 0xff,
0x5f, 0x5b, 0x5e, 0xff, 0x54, 0x50, 0x50, 0xff, 0x55, 0x51, 0x4d, 0xff,
0x5b, 0x55, 0x50, 0xff, 0x5b, 0x55, 0x50, 0xff, 0x59, 0x53, 0x52, 0xff,
0x55, 0x52, 0x4e, 0xff, 0x55, 0x56, 0x4c, 0xff, 0x53, 0x55, 0x4a, 0xff,
0x5b, 0x59, 0x51, 0xff, 0x66, 0x61, 0x5a, 0xff, 0x79, 0x70, 0x6b, 0xff,
0x77, 0x6b, 0x66, 0xff, 0x64, 0x58, 0x54, 0xff, 0x4f, 0x44, 0x46, 0xff,
0x30, 0x24, 0x2f, 0xff, 0x2d, 0x23, 0x2f, 0xff, 0x28, 0x1c, 0x27, 0xff,
0x2d, 0x29, 0x29, 0xff, 0x5d, 0x5b, 0x5a, 0xff, 0x5e, 0x5c, 0x59, 0xff,
0x60, 0x5f, 0x5a, 0xff, 0x5d, 0x5c, 0x56, 0xff, 0x5f, 0x5f, 0x5c, 0xff,
0x5e, 0x5e, 0x5c, 0xff, 0x60, 0x62, 0x5f, 0xff, 0x61, 0x64, 0x61, 0xff,
0x62, 0x66, 0x64, 0xff, 0x62, 0x65, 0x62, 0xff, 0x61, 0x62, 0x5f, 0xff,
0x5f, 0x5f, 0x5d, 0xff, 0x5f, 0x5d, 0x5b, 0xff, 0x5f, 0x5c, 0x59, 0xff,
0x5d, 0x5d, 0x57, 0xff, 0x5d, 0x5f, 0x59, 0xff, 0x5d, 0x61, 0x5b, 0xff,
0x60, 0x62, 0x5b, 0xff, 0x60, 0x5e, 0x59, 0xff, 0x72, 0x69, 0x62, 0xff,
0x72, 0x6d, 0x69, 0xff, 0x73, 0x72, 0x72, 0xff, 0x7a, 0x81, 0x84, 0xff,
0x77, 0x80, 0x82, 0xff, 0x62, 0x61, 0x5d, 0xff, 0x4b, 0x44, 0x3a, 0xff,
0x4a, 0x3b, 0x30, 0xff, 0x4c, 0x39, 0x2f, 0xff, 0x46, 0x35, 0x2c, 0xff,
0x4d, 0x44, 0x3a, 0xff, 0x60, 0x5c, 0x53, 0xff, 0x60, 0x5f, 0x59, 0xff,
0x5d, 0x5d, 0x59, 0xff, 0x5c, 0x5d, 0x59, 0xff, 0x64, 0x79, 0x8b, 0xff,
0x64, 0x7a, 0x8d, 0xff, 0x67, 0x7d, 0x90, 0xff, 0x6f, 0x84, 0x99, 0xff,
0x78, 0x8a, 0xa0, 0xff, 0x7d, 0x91, 0xa2, 0xff, 0x80, 0x93, 0xa2, 0xff,
0x81, 0x95, 0xa1, 0xff, 0x83, 0x95, 0xa0, 0xff, 0x82, 0x93, 0x9d, 0xff,
0x83, 0x94, 0x9d, 0xff, 0x83, 0x94, 0x9c, 0xff, 0x82, 0x93, 0x9a, 0xff,
0x82, 0x92, 0x98, 0xff, 0x80, 0x8d, 0x90, 0xff, 0x7b, 0x87, 0x89, 0xff,
0x76, 0x80, 0x7d, 0xff, 0x6c, 0x70, 0x6f, 0xff, 0x66, 0x64, 0x63, 0xff,
0x5e, 0x5b, 0x57, 0xff, 0x5b, 0x56, 0x50, 0xff, 0x55, 0x53, 0x49, 0xff,
0x53, 0x4f, 0x4d, 0xff, 0x4b, 0x52, 0x59, 0xff, 0x56, 0x71, 0x82, 0xff,
0x4e, 0x6b, 0x90, 0xff, 0x41, 0x75, 0xb4, 0xff, 0x47, 0x81, 0xc7, 0xff,
0x47, 0x88, 0xc6, 0xff, 0x43, 0x84, 0xb8, 0xff, 0x67, 0x90, 0xc5, 0xff,
0x58, 0x99, 0xc5, 0xff, 0x43, 0x94, 0xbf, 0xff, 0x2d, 0x82, 0xab, 0xff,
0x2d, 0x81, 0xa7, 0xff, 0x40, 0x85, 0xb1, 0xff, 0x43, 0x80, 0xae, 0xff,
0x49, 0x83, 0xb4, 0xff, 0x43, 0x76, 0xac, 0xff, 0x4b, 0x82, 0xb8, 0xff,
0x40, 0x75, 0xa7, 0xff, 0x4f, 0x69, 0x7e, 0xff, 0x5c, 0x6a, 0x78, 0xff,
0x58, 0x5a, 0x61, 0xff, 0x57, 0x5a, 0x61, 0xff, 0x5f, 0x67, 0x73, 0xff,
0x62, 0x6f, 0x7e, 0xff, 0x8f, 0x97, 0xa7, 0xff, 0xa9, 0xa9, 0xbc, 0xff,
0x8f, 0x8a, 0x9f, 0xff, 0x63, 0x5c, 0x6e, 0xff, 0x58, 0x53, 0x57, 0xff,
0x56, 0x55, 0x50, 0xff, 0x5b, 0x5a, 0x52, 0xff, 0x54, 0x51, 0x4f, 0xff,
0x69, 0x66, 0x61, 0xff, 0x95, 0x90, 0x8a, 0xff, 0x75, 0x6f, 0x6b, 0xff,
0x60, 0x58, 0x57, 0xff, 0x56, 0x4d, 0x4e, 0xff, 0x3e, 0x35, 0x37, 0xff,
0x32, 0x2b, 0x31, 0xff, 0x26, 0x20, 0x2b, 0xff, 0x22, 0x1e, 0x27, 0xff,
0x3a, 0x35, 0x39, 0xff, 0x5c, 0x5f, 0x5b, 0xff, 0x5f, 0x63, 0x5d, 0xff,
0x61, 0x64, 0x60, 0xff, 0x61, 0x65, 0x5f, 0xff, 0x61, 0x65, 0x5f, 0xff,
0x60, 0x64, 0x62, 0xff, 0x5f, 0x63, 0x61, 0xff, 0x62, 0x68, 0x65, 0xff,
0x63, 0x6a, 0x68, 0xff, 0x64, 0x6c, 0x69, 0xff, 0x63, 0x6a, 0x68, 0xff,
0x62, 0x68, 0x65, 0xff, 0x5f, 0x62, 0x61, 0xff, 0x5e, 0x62, 0x60, 0xff,
0x5e, 0x60, 0x5e, 0xff, 0x5d, 0x61, 0x5c, 0xff, 0x5e, 0x64, 0x5f, 0xff,
0x61, 0x67, 0x62, 0xff, 0x5f, 0x66, 0x61, 0xff, 0x5d, 0x5f, 0x5a, 0xff,
0x64, 0x5d, 0x56, 0xff, 0x63, 0x5d, 0x58, 0xff, 0x77, 0x73, 0x71, 0xff,
0x80, 0x84, 0x83, 0xff, 0x74, 0x7a, 0x77, 0xff, 0x5a, 0x58, 0x4e, 0xff,
0x3f, 0x37, 0x2e, 0xff, 0x38, 0x2a, 0x21, 0xff, 0x35, 0x26, 0x1f, 0xff,
0x35, 0x28, 0x1f, 0xff, 0x47, 0x40, 0x34, 0xff, 0x5d, 0x5c, 0x52, 0xff,
0x61, 0x67, 0x5d, 0xff, 0x5e, 0x64, 0x5e, 0xff, 0x60, 0x66, 0x60, 0xff,
0x66, 0x79, 0x8a, 0xff, 0x66, 0x7a, 0x8c, 0xff, 0x67, 0x7d, 0x91, 0xff,
0x6c, 0x81, 0x97, 0xff, 0x75, 0x88, 0x9d, 0xff, 0x7b, 0x8e, 0xa0, 0xff,
0x7e, 0x91, 0x9f, 0xff, 0x80, 0x93, 0xa0, 0xff, 0x82, 0x94, 0xa0, 0xff,
0x82, 0x92, 0x9e, 0xff, 0x80, 0x90, 0x9a, 0xff, 0x7e, 0x8f, 0x98, 0xff,
0x80, 0x8f, 0x96, 0xff, 0x80, 0x8d, 0x91, 0xff, 0x7b, 0x88, 0x8a, 0xff,
0x78, 0x82, 0x83, 0xff, 0x73, 0x7a, 0x77, 0xff, 0x6f, 0x6d, 0x68, 0xff,
0x66, 0x67, 0x5e, 0xff, 0x58, 0x5f, 0x56, 0xff, 0x59, 0x57, 0x54, 0xff,
0x58, 0x54, 0x4e, 0xff, 0x4f, 0x4f, 0x4f, 0xff, 0x57, 0x51, 0x51, 0xff,
0x5b, 0x51, 0x49, 0xff, 0x54, 0x58, 0x5a, 0xff, 0x52, 0x64, 0x7c, 0xff,
0x52, 0x73, 0x93, 0xff, 0x59, 0x6f, 0x90, 0xff, 0x49, 0x57, 0x74, 0xff,
0x69, 0x69, 0x89, 0xff, 0x4f, 0x70, 0x9f, 0xff, 0x5c, 0x99, 0xc5, 0xff,
0x44, 0x74, 0x95, 0xff, 0x46, 0x6c, 0x82, 0xff, 0x42, 0x5f, 0x74, 0xff,
0x51, 0x5b, 0x66, 0xff, 0x49, 0x5b, 0x69, 0xff, 0x4f, 0x60, 0x6d, 0xff,
0x55, 0x5e, 0x69, 0xff, 0x5b, 0x59, 0x5d, 0xff, 0x57, 0x53, 0x52, 0xff,
0x5a, 0x51, 0x4c, 0xff, 0x59, 0x51, 0x4e, 0xff, 0x52, 0x4e, 0x4b, 0xff,
0x53, 0x51, 0x49, 0xff, 0x5b, 0x5a, 0x53, 0xff, 0x61, 0x60, 0x63, 0xff,
0x5d, 0x5f, 0x6e, 0xff, 0x6c, 0x70, 0x88, 0xff, 0x79, 0x7b, 0x9b, 0xff,
0x7e, 0x7a, 0xa3, 0xff, 0x85, 0x7f, 0xa1, 0xff, 0x82, 0x7d, 0x8c, 0xff,
0x81, 0x7f, 0x78, 0xff, 0x5f, 0x59, 0x4f, 0xff, 0x57, 0x4c, 0x4d, 0xff,
0x49, 0x41, 0x43, 0xff, 0x39, 0x34, 0x39, 0xff, 0x2d, 0x2b, 0x33, 0xff,
0x25, 0x25, 0x2d, 0xff, 0x23, 0x20, 0x2a, 0xff, 0x26, 0x1e, 0x29, 0xff,
0x50, 0x4e, 0x4f, 0xff, 0x5b, 0x64, 0x5a, 0xff, 0x5c, 0x66, 0x5f, 0xff,
0x5e, 0x68, 0x62, 0xff, 0x60, 0x69, 0x65, 0xff, 0x61, 0x6b, 0x67, 0xff,
0x62, 0x6a, 0x68, 0xff, 0x65, 0x6a, 0x69, 0xff, 0x64, 0x6a, 0x69, 0xff,
0x66, 0x6e, 0x6d, 0xff, 0x67, 0x70, 0x6f, 0xff, 0x67, 0x72, 0x70, 0xff,
0x65, 0x70, 0x6f, 0xff, 0x64, 0x6f, 0x6d, 0xff, 0x60, 0x69, 0x68, 0xff,
0x60, 0x67, 0x66, 0xff, 0x60, 0x67, 0x65, 0xff, 0x61, 0x67, 0x63, 0xff,
0x61, 0x6b, 0x66, 0xff, 0x61, 0x6b, 0x66, 0xff, 0x64, 0x6c, 0x68, 0xff,
0x5a, 0x5e, 0x59, 0xff, 0x55, 0x53, 0x4b, 0xff, 0x5d, 0x56, 0x50, 0xff,
0x78, 0x72, 0x6d, 0xff, 0x7a, 0x74, 0x70, 0xff, 0x5e, 0x5c, 0x56, 0xff,
0x4e, 0x4c, 0x42, 0xff, 0x42, 0x3c, 0x35, 0xff, 0x3a, 0x30, 0x28, 0xff,
0x33, 0x2c, 0x21, 0xff, 0x35, 0x2d, 0x20, 0xff, 0x45, 0x3e, 0x31, 0xff,
0x5b, 0x5b, 0x4f, 0xff, 0x62, 0x6b, 0x60, 0xff, 0x63, 0x6e, 0x65, 0xff,
0x62, 0x6a, 0x64, 0xff, 0x65, 0x78, 0x8a, 0xff, 0x66, 0x7a, 0x8d, 0xff,
0x69, 0x7d, 0x93, 0xff, 0x6d, 0x82, 0x98, 0xff, 0x72, 0x87, 0x9d, 0xff,
0x76, 0x8b, 0x9e, 0xff, 0x79, 0x8e, 0x9f, 0xff, 0x7f, 0x92, 0xa0, 0xff,
0x80, 0x92, 0x9f, 0xff, 0x81, 0x91, 0x9d, 0xff, 0x7e, 0x8e, 0x96, 0xff,
0x7d, 0x8b, 0x93, 0xff, 0x80, 0x8a, 0x90, 0xff, 0x7d, 0x88, 0x8c, 0xff,
0x7c, 0x84, 0x87, 0xff, 0x77, 0x80, 0x80, 0xff, 0x73, 0x79, 0x76, 0xff,
0x6d, 0x6f, 0x69, 0xff, 0x67, 0x6a, 0x60, 0xff, 0x5e, 0x62, 0x57, 0xff,
0x5c, 0x5b, 0x52, 0xff, 0x59, 0x56, 0x50, 0xff, 0x5c, 0x56, 0x50, 0xff,
0x5c, 0x55, 0x51, 0xff, 0x59, 0x55, 0x55, 0xff, 0x57, 0x58, 0x51, 0xff,
0x5c, 0x55, 0x4c, 0xff, 0x58, 0x55, 0x50, 0xff, 0x5a, 0x50, 0x4d, 0xff,
0x58, 0x51, 0x4d, 0xff, 0x54, 0x55, 0x51, 0xff, 0x54, 0x52, 0x57, 0xff,
0x4f, 0x52, 0x57, 0xff, 0x56, 0x53, 0x52, 0xff, 0x56, 0x56, 0x4d, 0xff,
0x5c, 0x58, 0x4e, 0xff, 0x59, 0x57, 0x4b, 0xff, 0x5d, 0x5a, 0x52, 0xff,
0x59, 0x55, 0x50, 0xff, 0x5b, 0x58, 0x53, 0xff, 0x59, 0x56, 0x51, 0xff,
0x59, 0x5a, 0x55, 0xff, 0x59, 0x58, 0x55, 0xff, 0x57, 0x55, 0x56, 0xff,
0x59, 0x55, 0x55, 0xff, 0x5b, 0x55, 0x53, 0xff, 0x58, 0x59, 0x56, 0xff,
0x59, 0x5b, 0x57, 0xff, 0x60, 0x5f, 0x5a, 0xff, 0x5f, 0x5e, 0x58, 0xff,
0x60, 0x62, 0x60, 0xff, 0x64, 0x69, 0x6d, 0xff, 0x65, 0x62, 0x78, 0xff,
0x6d, 0x65, 0x78, 0xff, 0x5e, 0x57, 0x53, 0xff, 0x41, 0x39, 0x3a, 0xff,
0x38, 0x32, 0x38, 0xff, 0x37, 0x36, 0x40, 0xff, 0x32, 0x31, 0x3d, 0xff,
0x22, 0x1d, 0x29, 0xff, 0x22, 0x20, 0x2b, 0xff, 0x21, 0x1e, 0x28, 0xff,
0x45, 0x40, 0x46, 0xff, 0x60, 0x62, 0x61, 0xff, 0x5f, 0x68, 0x61, 0xff,
0x5f, 0x6c, 0x67, 0xff, 0x61, 0x6e, 0x6a, 0xff, 0x65, 0x70, 0x6d, 0xff,
0x66, 0x70, 0x6d, 0xff, 0x67, 0x71, 0x6e, 0xff, 0x66, 0x71, 0x6f, 0xff,
0x66, 0x71, 0x70, 0xff, 0x67, 0x73, 0x72, 0xff, 0x69, 0x75, 0x74, 0xff,
0x6a, 0x75, 0x76, 0xff, 0x67, 0x75, 0x73, 0xff, 0x66, 0x73, 0x71, 0xff,
0x63, 0x70, 0x6e, 0xff, 0x61, 0x6e, 0x6b, 0xff, 0x60, 0x6b, 0x69, 0xff,
0x61, 0x6c, 0x6a, 0xff, 0x62, 0x6e, 0x6c, 0xff, 0x62, 0x6e, 0x6c, 0xff,
0x66, 0x71, 0x6f, 0xff, 0x52, 0x5b, 0x57, 0xff, 0x46, 0x44, 0x3b, 0xff,
0x5d, 0x54, 0x4d, 0xff, 0x71, 0x69, 0x65, 0xff, 0x64, 0x5e, 0x5d, 0xff,
0x52, 0x4d, 0x4c, 0xff, 0x50, 0x4d, 0x45, 0xff, 0x50, 0x4c, 0x49, 0xff,
0x4d, 0x4a, 0x48, 0xff, 0x42, 0x45, 0x3a, 0xff, 0x3f, 0x40, 0x34, 0xff,
0x42, 0x3f, 0x33, 0xff, 0x4f, 0x4f, 0x41, 0xff, 0x62, 0x69, 0x5c, 0xff,
0x66, 0x72, 0x6b, 0xff, 0x62, 0x70, 0x6c, 0xff, 0x64, 0x76, 0x87, 0xff,
0x66, 0x79, 0x8d, 0xff, 0x69, 0x7b, 0x91, 0xff, 0x6e, 0x81, 0x97, 0xff,
0x72, 0x87, 0x9c, 0xff, 0x73, 0x8b, 0x9f, 0xff, 0x77, 0x8e, 0xa0, 0xff,
0x7f, 0x93, 0xa2, 0xff, 0x80, 0x92, 0xa0, 0xff, 0x7f, 0x8f, 0x9b, 0xff,
0x7d, 0x8c, 0x94, 0xff, 0x7b, 0x88, 0x8f, 0xff, 0x7b, 0x85, 0x8c, 0xff,
0x7a, 0x84, 0x88, 0xff, 0x79, 0x81, 0x83, 0xff, 0x77, 0x7f, 0x7e, 0xff,
0x72, 0x79, 0x77, 0xff, 0x6e, 0x71, 0x6e, 0xff, 0x69, 0x6c, 0x66, 0xff,
0x66, 0x66, 0x5e, 0xff, 0x60, 0x5f, 0x55, 0xff, 0x5a, 0x58, 0x51, 0xff,
0x59, 0x57, 0x52, 0xff, 0x59, 0x57, 0x52, 0xff, 0x5b, 0x59, 0x53, 0xff,
0x5c, 0x5a, 0x55, 0xff, 0x5c, 0x5a, 0x55, 0xff, 0x5c, 0x5a, 0x55, 0xff,
0x5b, 0x59, 0x54, 0xff, 0x59, 0x57, 0x51, 0xff, 0x5a, 0x58, 0x53, 0xff,
0x5b, 0x5c, 0x54, 0xff, 0x5a, 0x5b, 0x54, 0xff, 0x5a, 0x5c, 0x54, 0xff,
0x5b, 0x5d, 0x55, 0xff, 0x5b, 0x5d, 0x55, 0xff, 0x5b, 0x5c, 0x52, 0xff,
0x5b, 0x5c, 0x53, 0xff, 0x5b, 0x5c, 0x55, 0xff, 0x5c, 0x5c, 0x56, 0xff,
0x5e, 0x5d, 0x59, 0xff, 0x5c, 0x5e, 0x57, 0xff, 0x5d, 0x5d, 0x59, 0xff,
0x5f, 0x5d, 0x58, 0xff, 0x5d, 0x5b, 0x58, 0xff, 0x5e, 0x5a, 0x59, 0xff,
0x5e, 0x5c, 0x5b, 0xff, 0x5f, 0x5f, 0x5e, 0xff, 0x60, 0x61, 0x60, 0xff,
0x5f, 0x62, 0x60, 0xff, 0x60, 0x64, 0x63, 0xff, 0x5f, 0x66, 0x5e, 0xff,
0x5e, 0x63, 0x5f, 0xff, 0x5b, 0x5a, 0x59, 0xff, 0x3b, 0x34, 0x32, 0xff,
0x34, 0x2b, 0x37, 0xff, 0x27, 0x1f, 0x2a, 0xff, 0x19, 0x1b, 0x24, 0xff,
0x22, 0x20, 0x2b, 0xff, 0x2c, 0x20, 0x30, 0xff, 0x22, 0x19, 0x27, 0xff,
0x34, 0x32, 0x37, 0xff, 0x67, 0x71, 0x6a, 0xff, 0x5d, 0x6a, 0x62, 0xff,
0x61, 0x6d, 0x69, 0xff, 0x62, 0x70, 0x6e, 0xff, 0x64, 0x72, 0x72, 0xff,
0x67, 0x74, 0x72, 0xff, 0x69, 0x75, 0x74, 0xff, 0x6a, 0x76, 0x75, 0xff,
0x68, 0x76, 0x74, 0xff, 0x69, 0x77, 0x76, 0xff, 0x69, 0x78, 0x78, 0xff,
0x6a, 0x78, 0x7b, 0xff, 0x6c, 0x7a, 0x7c, 0xff, 0x6b, 0x78, 0x7a, 0xff,
0x68, 0x77, 0x77, 0xff, 0x66, 0x74, 0x74, 0xff, 0x64, 0x72, 0x73, 0xff,
0x62, 0x70, 0x6f, 0xff, 0x62, 0x71, 0x70, 0xff, 0x64, 0x73, 0x71, 0xff,
0x67, 0x76, 0x74, 0xff, 0x67, 0x76, 0x73, 0xff, 0x52, 0x61, 0x5d, 0xff,
0x47, 0x47, 0x40, 0xff, 0x55, 0x4c, 0x45, 0xff, 0x67, 0x62, 0x5d, 0xff,
0x69, 0x66, 0x67, 0xff, 0x69, 0x63, 0x67, 0xff, 0x6f, 0x6a, 0x6f, 0xff,
0x75, 0x70, 0x7a, 0xff, 0x6b, 0x6c, 0x74, 0xff, 0x61, 0x68, 0x6b, 0xff,
0x60, 0x64, 0x63, 0xff, 0x55, 0x58, 0x50, 0xff, 0x4f, 0x51, 0x45, 0xff,
0x5d, 0x65, 0x5a, 0xff, 0x6a, 0x77, 0x75, 0xff, 0x65, 0x73, 0x71, 0xff,
0x65, 0x76, 0x86, 0xff, 0x66, 0x78, 0x89, 0xff, 0x69, 0x7a, 0x8e, 0xff,
0x6e, 0x82, 0x94, 0xff, 0x72, 0x87, 0x9b, 0xff, 0x75, 0x8a, 0x9f, 0xff,
0x78, 0x8d, 0xa1, 0xff, 0x7f, 0x91, 0xa2, 0xff, 0x7f, 0x91, 0xa0, 0xff,
0x7d, 0x8d, 0x9a, 0xff, 0x7b, 0x89, 0x93, 0xff, 0x7a, 0x86, 0x8f, 0xff,
0x7c, 0x86, 0x8e, 0xff, 0x7a, 0x84, 0x89, 0xff, 0x7a, 0x83, 0x86, 0xff,
0x77, 0x80, 0x81, 0xff, 0x74, 0x7b, 0x7b, 0xff, 0x6f, 0x75, 0x73, 0xff,
0x6c, 0x70, 0x6c, 0xff, 0x68, 0x6a, 0x64, 0xff, 0x63, 0x64, 0x5b, 0xff,
0x5c, 0x5d, 0x57, 0xff, 0x5a, 0x5c, 0x56, 0xff, 0x5b, 0x5d, 0x57, 0xff,
0x5c, 0x5d, 0x57, 0xff, 0x5d, 0x5e, 0x58, 0xff, 0x5d, 0x5f, 0x59, 0xff,
0x5d, 0x5f, 0x59, 0xff, 0x5d, 0x5f, 0x59, 0xff, 0x5d, 0x5f, 0x59, 0xff,
0x5e, 0x60, 0x5a, 0xff, 0x5e, 0x62, 0x59, 0xff, 0x5d, 0x62, 0x59, 0xff,
0x5c, 0x61, 0x58, 0xff, 0x5c, 0x61, 0x58, 0xff, 0x5d, 0x62, 0x59, 0xff,
0x5c, 0x61, 0x58, 0xff, 0x5c, 0x61, 0x5a, 0xff, 0x5d, 0x60, 0x5b, 0xff,
0x5d, 0x61, 0x5c, 0xff, 0x5f, 0x62, 0x5e, 0xff, 0x5e, 0x64, 0x5e, 0xff,
0x60, 0x64, 0x5f, 0xff, 0x60, 0x61, 0x5f, 0xff, 0x61, 0x61, 0x60, 0xff,
0x5f, 0x5f, 0x5f, 0xff, 0x60, 0x62, 0x60, 0xff, 0x60, 0x64, 0x61, 0xff,
0x60, 0x64, 0x62, 0xff, 0x62, 0x67, 0x65, 0xff, 0x61, 0x68, 0x66, 0xff,
0x63, 0x6c, 0x65, 0xff, 0x61, 0x6a, 0x61, 0xff, 0x59, 0x5c, 0x5f, 0xff,
0x33, 0x2b, 0x3d, 0xff, 0x2c, 0x20, 0x36, 0xff, 0x20, 0x12, 0x1f, 0xff,
0x46, 0x46, 0x4a, 0xff, 0x67, 0x65, 0x6c, 0xff, 0x2f, 0x23, 0x34, 0xff,
0x2b, 0x1c, 0x2e, 0xff, 0x73, 0x6f, 0x75, 0xff, 0x5d, 0x69, 0x63, 0xff,
0x61, 0x71, 0x6b, 0xff, 0x67, 0x71, 0x75, 0xff, 0x67, 0x75, 0x79, 0xff,
0x67, 0x76, 0x78, 0xff, 0x6a, 0x7b, 0x7c, 0xff, 0x68, 0x7a, 0x7c, 0xff,
0x6a, 0x7c, 0x7d, 0xff, 0x6a, 0x7c, 0x7d, 0xff, 0x6b, 0x7d, 0x7f, 0xff,
0x6b, 0x7c, 0x80, 0xff, 0x6c, 0x7c, 0x82, 0xff, 0x6c, 0x7d, 0x83, 0xff,
0x6c, 0x7c, 0x81, 0xff, 0x6a, 0x7a, 0x7f, 0xff, 0x68, 0x78, 0x7d, 0xff,
0x66, 0x77, 0x7b, 0xff, 0x63, 0x74, 0x7a, 0xff, 0x65, 0x76, 0x79, 0xff,
0x66, 0x77, 0x7a, 0xff, 0x68, 0x79, 0x7d, 0xff, 0x6a, 0x7c, 0x7f, 0xff,
0x65, 0x74, 0x78, 0xff, 0x57, 0x5f, 0x5b, 0xff, 0x56, 0x53, 0x4b, 0xff,
0x67, 0x65, 0x5e, 0xff, 0x71, 0x70, 0x6f, 0xff, 0x77, 0x70, 0x79, 0xff,
0x76, 0x74, 0x81, 0xff, 0x7a, 0x7a, 0x89, 0xff, 0x78, 0x7e, 0x8b, 0xff,
0x7b, 0x84, 0x90, 0xff, 0x83, 0x8b, 0x92, 0xff, 0x86, 0x8c, 0x8b, 0xff,
0x6f, 0x75, 0x71, 0xff, 0x64, 0x6d, 0x68, 0xff, 0x68, 0x78, 0x77, 0xff,
0x6a, 0x79, 0x78, 0xff, 0x66, 0x77, 0x83, 0xff, 0x67, 0x78, 0x88, 0xff,
0x6b, 0x7d, 0x8d, 0xff, 0x6f, 0x81, 0x92, 0xff, 0x72, 0x86, 0x97, 0xff,
0x74, 0x87, 0x9c, 0xff, 0x75, 0x8a, 0xa0, 0xff, 0x7c, 0x8f, 0xa0, 0xff,
0x7c, 0x8d, 0x9e, 0xff, 0x7c, 0x8c, 0x99, 0xff, 0x7b, 0x88, 0x95, 0xff,
0x79, 0x86, 0x90, 0xff, 0x7b, 0x86, 0x8e, 0xff, 0x79, 0x83, 0x8b, 0xff,
0x77, 0x82, 0x86, 0xff, 0x77, 0x80, 0x83, 0xff, 0x74, 0x7e, 0x7f, 0xff,
0x73, 0x7a, 0x79, 0xff, 0x6e, 0x74, 0x72, 0xff, 0x6a, 0x6e, 0x6a, 0xff,
0x65, 0x68, 0x62, 0xff, 0x5f, 0x62, 0x5c, 0xff, 0x5c, 0x5f, 0x59, 0xff,
0x5e, 0x61, 0x5b, 0xff, 0x5e, 0x61, 0x5b, 0xff, 0x5e, 0x61, 0x5b, 0xff,
0x5c, 0x61, 0x5b, 0xff, 0x5d, 0x63, 0x5c, 0xff, 0x5e, 0x63, 0x5d, 0xff,
0x5e, 0x63, 0x5d, 0xff, 0x60, 0x66, 0x5f, 0xff, 0x60, 0x68, 0x63, 0xff,
0x5e, 0x67, 0x61, 0xff, 0x5d, 0x66, 0x60, 0xff, 0x5d, 0x66, 0x60, 0xff,
0x5f, 0x67, 0x61, 0xff, 0x5e, 0x67, 0x5f, 0xff, 0x5e, 0x66, 0x60, 0xff,
0x5f, 0x66, 0x61, 0xff, 0x61, 0x67, 0x63, 0xff, 0x61, 0x68, 0x65, 0xff,
0x61, 0x69, 0x64, 0xff, 0x61, 0x69, 0x65, 0xff, 0x65, 0x6a, 0x69, 0xff,
0x62, 0x65, 0x65, 0xff, 0x61, 0x65, 0x64, 0xff, 0x64, 0x69, 0x65, 0xff,
0x67, 0x6c, 0x69, 0xff, 0x68, 0x6f, 0x6b, 0xff, 0x65, 0x6d, 0x69, 0xff,
0x64, 0x6d, 0x6b, 0xff, 0x63, 0x6d, 0x6d, 0xff, 0x63, 0x70, 0x6a, 0xff,
0x4c, 0x52, 0x5f, 0xff, 0x26, 0x23, 0x42, 0xff, 0x26, 0x20, 0x35, 0xff,
0x2f, 0x27, 0x32, 0xff, 0x66, 0x6c, 0x6f, 0xff, 0x67, 0x6d, 0x71, 0xff,
0x4a, 0x48, 0x55, 0xff, 0x6a, 0x70, 0x78, 0xff, 0x67, 0x73, 0x72, 0xff,
0x65, 0x77, 0x73, 0xff, 0x63, 0x77, 0x74, 0xff, 0x63, 0x77, 0x76, 0xff,
0x68, 0x77, 0x7b, 0xff, 0x6c, 0x7c, 0x7f, 0xff, 0x6b, 0x7d, 0x80, 0xff,
0x69, 0x7e, 0x81, 0xff, 0x6a, 0x80, 0x81, 0xff, 0x6b, 0x7f, 0x84, 0xff,
0x6d, 0x80, 0x86, 0xff, 0x6d, 0x80, 0x87, 0xff, 0x6c, 0x7f, 0x87, 0xff,
0x6c, 0x7f, 0x86, 0xff, 0x6c, 0x7e, 0x87, 0xff, 0x6a, 0x7c, 0x86, 0xff,
0x69, 0x7b, 0x85, 0xff, 0x67, 0x79, 0x82, 0xff, 0x66, 0x78, 0x82, 0xff,
0x66, 0x79, 0x80, 0xff, 0x67, 0x79, 0x82, 0xff, 0x69, 0x7c, 0x83, 0xff,
0x6a, 0x7d, 0x85, 0xff, 0x6b, 0x7e, 0x85, 0xff, 0x62, 0x6f, 0x71, 0xff,
0x5e, 0x62, 0x5a, 0xff, 0x6e, 0x6f, 0x64, 0xff, 0x77, 0x74, 0x74, 0xff,
0x79, 0x72, 0x7b, 0xff, 0x74, 0x74, 0x7e, 0xff, 0x73, 0x76, 0x7d, 0xff,
0x73, 0x7a, 0x7f, 0xff, 0x7d, 0x86, 0x8e, 0xff, 0x8d, 0x98, 0xa0, 0xff,
0x9d, 0xa7, 0xab, 0xff, 0x95, 0x9b, 0x9a, 0xff, 0x75, 0x7e, 0x7b, 0xff,
0x6b, 0x79, 0x7b, 0xff, 0x6e, 0x7c, 0x7e, 0xff, 0x6a, 0x7a, 0x87, 0xff,
0x6b, 0x7c, 0x89, 0xff, 0x6e, 0x7f, 0x8c, 0xff, 0x6e, 0x81, 0x90, 0xff,
0x71, 0x82, 0x95, 0xff, 0x72, 0x84, 0x9b, 0xff, 0x75, 0x88, 0x9e, 0xff,
0x7b, 0x8c, 0x9f, 0xff, 0x7a, 0x8c, 0x9c, 0xff, 0x78, 0x87, 0x97, 0xff,
0x79, 0x87, 0x93, 0xff, 0x79, 0x87, 0x92, 0xff, 0x7a, 0x85, 0x8f, 0xff,
0x78, 0x84, 0x8b, 0xff, 0x79, 0x83, 0x89, 0xff, 0x76, 0x82, 0x84, 0xff,
0x77, 0x80, 0x83, 0xff, 0x73, 0x7c, 0x7e, 0xff, 0x70, 0x77, 0x76, 0xff,
0x6d, 0x73, 0x71, 0xff, 0x68, 0x6d, 0x68, 0xff, 0x62, 0x68, 0x61, 0xff,
0x5e, 0x65, 0x5e, 0xff, 0x61, 0x67, 0x60, 0xff, 0x61, 0x67, 0x60, 0xff,
0x61, 0x67, 0x60, 0xff, 0x5f, 0x67, 0x60, 0xff, 0x5f, 0x69, 0x61, 0xff,
0x61, 0x69, 0x62, 0xff, 0x62, 0x6b, 0x63, 0xff, 0x64, 0x6d, 0x66, 0xff,
0x62, 0x6d, 0x6a, 0xff, 0x63, 0x6e, 0x6c, 0xff, 0x65, 0x70, 0x6d, 0xff,
0x64, 0x6f, 0x6b, 0xff, 0x61, 0x6c, 0x69, 0xff, 0x63, 0x6d, 0x65, 0xff,
0x63, 0x6d, 0x66, 0xff, 0x64, 0x6d, 0x69, 0xff, 0x66, 0x6e, 0x6b, 0xff,
0x66, 0x6f, 0x6d, 0xff, 0x66, 0x71, 0x6e, 0xff, 0x67, 0x71, 0x6d, 0xff,
0x65, 0x6e, 0x6b, 0xff, 0x63, 0x6a, 0x68, 0xff, 0x60, 0x65, 0x65, 0xff,
0x63, 0x67, 0x6b, 0xff, 0x61, 0x66, 0x6a, 0xff, 0x67, 0x6d, 0x71, 0xff,
0x60, 0x69, 0x6d, 0xff, 0x65, 0x6f, 0x71, 0xff, 0x64, 0x70, 0x73, 0xff,
0x63, 0x72, 0x72, 0xff, 0x57, 0x5e, 0x74, 0xff, 0x29, 0x28, 0x4b, 0xff,
0x1e, 0x24, 0x2d, 0xff, 0x5a, 0x5f, 0x63, 0xff, 0x61, 0x73, 0x78, 0xff,
0x65, 0x78, 0x7e, 0xff, 0x6e, 0x7c, 0x82, 0xff, 0x60, 0x75, 0x78, 0xff,
0x65, 0x73, 0x7b, 0xff, 0x6d, 0x6d, 0x7e, 0xff, 0x7c, 0x7f, 0x8e, 0xff,
0x67, 0x74, 0x7c, 0xff, 0x7b, 0x85, 0x92, 0xff, 0x79, 0x83, 0x91, 0xff,
0x6a, 0x78, 0x86, 0xff, 0x6f, 0x80, 0x8d, 0xff, 0x6d, 0x81, 0x8e, 0xff,
0x6e, 0x84, 0x8b, 0xff, 0x6f, 0x84, 0x8c, 0xff, 0x70, 0x84, 0x8e, 0xff,
0x6f, 0x83, 0x8e, 0xff, 0x6f, 0x83, 0x8e, 0xff, 0x6e, 0x81, 0x8f, 0xff,
0x6e, 0x80, 0x8e, 0xff, 0x6b, 0x7e, 0x8c, 0xff, 0x6a, 0x7d, 0x8b, 0xff,
0x69, 0x7c, 0x89, 0xff, 0x69, 0x7c, 0x87, 0xff, 0x6a, 0x7e, 0x89, 0xff,
0x6c, 0x7f, 0x8b, 0xff, 0x6d, 0x81, 0x8c, 0xff, 0x6e, 0x82, 0x8d, 0xff,
0x6d, 0x80, 0x84, 0xff, 0x6d, 0x77, 0x6e, 0xff, 0x70, 0x74, 0x68, 0xff,
0x72, 0x6f, 0x6e, 0xff, 0x75, 0x6d, 0x77, 0xff, 0x75, 0x70, 0x76, 0xff,
0x72, 0x73, 0x74, 0xff, 0x71, 0x75, 0x76, 0xff, 0x6d, 0x72, 0x77, 0xff,
0x80, 0x89, 0x92, 0xff, 0x9e, 0xa8, 0xae, 0xff, 0xa7, 0xad, 0xac, 0xff,
0x8c, 0x94, 0x92, 0xff, 0x76, 0x82, 0x82, 0xff, 0x72, 0x80, 0x82, 0xff,
0x6f, 0x80, 0x89, 0xff, 0x6e, 0x7f, 0x89, 0xff, 0x6d, 0x7f, 0x8b, 0xff,
0x6f, 0x81, 0x8f, 0xff, 0x70, 0x81, 0x92, 0xff, 0x70, 0x84, 0x97, 0xff,
0x72, 0x86, 0x9a, 0xff, 0x76, 0x89, 0x9f, 0xff, 0x78, 0x88, 0x9b, 0xff,
0x79, 0x87, 0x98, 0xff, 0x7a, 0x87, 0x95, 0xff, 0x79, 0x86, 0x92, 0xff,
0x76, 0x84, 0x8f, 0xff, 0x76, 0x83, 0x8c, 0xff, 0x77, 0x83, 0x89, 0xff,
0x77, 0x82, 0x87, 0xff, 0x75, 0x81, 0x85, 0xff, 0x72, 0x7e, 0x82, 0xff,
0x6f, 0x7a, 0x7c, 0xff, 0x6e, 0x76, 0x75, 0xff, 0x6a, 0x70, 0x6e, 0xff,
0x63, 0x6c, 0x69, 0xff, 0x60, 0x69, 0x66, 0xff, 0x63, 0x6b, 0x66, 0xff,
0x63, 0x6a, 0x66, 0xff, 0x64, 0x6b, 0x65, 0xff, 0x60, 0x6d, 0x67, 0xff,
0x60, 0x6d, 0x68, 0xff, 0x61, 0x6e, 0x69, 0xff, 0x61, 0x6e, 0x6a, 0xff,
0x63, 0x70, 0x6b, 0xff, 0x65, 0x72, 0x70, 0xff, 0x67, 0x74, 0x73, 0xff,
0x68, 0x75, 0x74, 0xff, 0x69, 0x75, 0x73, 0xff, 0x68, 0x73, 0x6f, 0xff,
0x65, 0x70, 0x70, 0xff, 0x61, 0x6e, 0x6c, 0xff, 0x63, 0x70, 0x6b, 0xff,
0x66, 0x71, 0x71, 0xff, 0x6a, 0x72, 0x76, 0xff, 0x74, 0x79, 0x7e, 0xff,
0x8a, 0x8b, 0x99, 0xff, 0xa3, 0x9e, 0xb7, 0xff, 0xa6, 0x9d, 0xbb, 0xff,
0xbc, 0xaf, 0xd6, 0xff, 0xc0, 0xb6, 0xd6, 0xff, 0xbd, 0xb2, 0xd4, 0xff,
0xbf, 0xb3, 0xd3, 0xff, 0xb0, 0xa7, 0xc0, 0xff, 0xaa, 0xa2, 0xb5, 0xff,
0xab, 0xa4, 0xb9, 0xff, 0xa2, 0x9d, 0xb5, 0xff, 0x94, 0x8c, 0xae, 0xff,
0x66, 0x59, 0x80, 0xff, 0x62, 0x5e, 0x77, 0xff, 0x7b, 0x7d, 0x93, 0xff,
0x73, 0x78, 0x8f, 0xff, 0x6c, 0x72, 0x89, 0xff, 0x6e, 0x72, 0x89, 0xff,
0x72, 0x73, 0x92, 0xff, 0x7b, 0x73, 0x9d, 0xff, 0xa3, 0x94, 0xc3, 0xff,
0xb2, 0xa3, 0xcc, 0xff, 0xa6, 0x99, 0xbe, 0xff, 0xa4, 0x9c, 0xc0, 0xff,
0xaf, 0xa6, 0xc6, 0xff, 0xbd, 0xb5, 0xcf, 0xff, 0x94, 0x9a, 0xa6, 0xff,
0x73, 0x83, 0x90, 0xff, 0x74, 0x83, 0x93, 0xff, 0x73, 0x84, 0x93, 0xff,
0x6f, 0x84, 0x91, 0xff, 0x74, 0x88, 0x93, 0xff, 0x73, 0x84, 0x95, 0xff,
0x71, 0x85, 0x94, 0xff, 0x6f, 0x84, 0x93, 0xff, 0x6d, 0x82, 0x91, 0xff,
0x6f, 0x82, 0x91, 0xff, 0x6f, 0x7f, 0x8f, 0xff, 0x6a, 0x81, 0x8f, 0xff,
0x6e, 0x81, 0x8d, 0xff, 0x70, 0x83, 0x8e, 0xff, 0x71, 0x83, 0x92, 0xff,
0x70, 0x83, 0x96, 0xff, 0x6a, 0x81, 0x88, 0xff, 0x6d, 0x73, 0x6a, 0xff,
0x6c, 0x6b, 0x5e, 0xff, 0x69, 0x65, 0x64, 0xff, 0x6a, 0x65, 0x6a, 0xff,
0x68, 0x67, 0x66, 0xff, 0x6a, 0x68, 0x62, 0xff, 0x65, 0x64, 0x5e, 0xff,
0x65, 0x67, 0x67, 0xff, 0x7b, 0x84, 0x8a, 0xff, 0x90, 0x9e, 0xa5, 0xff,
0x90, 0x98, 0x9a, 0xff, 0x85, 0x8b, 0x86, 0xff, 0x7c, 0x89, 0x84, 0xff,
0x76, 0x85, 0x84, 0xff, 0x72, 0x83, 0x8c, 0xff, 0x71, 0x82, 0x8b, 0xff,
0x6f, 0x80, 0x8c, 0xff, 0x6f, 0x80, 0x8d, 0xff, 0x6f, 0x80, 0x90, 0xff,
0x6f, 0x81, 0x93, 0xff, 0x71, 0x83, 0x96, 0xff, 0x72, 0x85, 0x9b, 0xff,
0x77, 0x87, 0x9a, 0xff, 0x78, 0x86, 0x98, 0xff, 0x79, 0x85, 0x94, 0xff,
0x78, 0x85, 0x92, 0xff, 0x74, 0x84, 0x90, 0xff, 0x74, 0x83, 0x8e, 0xff,
0x76, 0x83, 0x8c, 0xff, 0x76, 0x82, 0x89, 0xff, 0x74, 0x82, 0x89, 0xff,
0x71, 0x80, 0x86, 0xff, 0x70, 0x7c, 0x82, 0xff, 0x6d, 0x79, 0x7b, 0xff,
0x6d, 0x75, 0x76, 0xff, 0x69, 0x74, 0x73, 0xff, 0x65, 0x71, 0x70, 0xff,
0x68, 0x71, 0x6f, 0xff, 0x67, 0x71, 0x6e, 0xff, 0x69, 0x71, 0x6d, 0xff,
0x65, 0x72, 0x6e, 0xff, 0x65, 0x73, 0x6f, 0xff, 0x66, 0x74, 0x70, 0xff,
0x66, 0x74, 0x70, 0xff, 0x68, 0x76, 0x73, 0xff, 0x6a, 0x77, 0x78, 0xff,
0x6a, 0x79, 0x7b, 0xff, 0x6b, 0x7c, 0x7e, 0xff, 0x69, 0x7c, 0x7d, 0xff,
0x6b, 0x7c, 0x7a, 0xff, 0x71, 0x7a, 0x7f, 0xff, 0x88, 0x8b, 0x99, 0xff,
0x9e, 0x9e, 0xb6, 0xff, 0xb2, 0xaf, 0xca, 0xff, 0xc4, 0xc0, 0xd9, 0xff,
0xce, 0xc6, 0xe0, 0xff, 0xcb, 0xc1, 0xe2, 0xff, 0xcc, 0xbc, 0xe3, 0xff,
0xc4, 0xb3, 0xda, 0xff, 0xb6, 0xa1, 0xd7, 0xff, 0xb3, 0x9d, 0xdb, 0xff,
0xaf, 0x98, 0xd6, 0xff, 0xb5, 0x9c, 0xdb, 0xff, 0xac, 0x94, 0xcd, 0xff,
0x94, 0x7c, 0xb7, 0xff, 0x83, 0x66, 0xaf, 0xff, 0x95, 0x7d, 0xc1, 0xff,
0xaf, 0x99, 0xda, 0xff, 0xb1, 0x99, 0xd1, 0xff, 0xbe, 0xaa, 0xd7, 0xff,
0xd3, 0xc0, 0xe9, 0xff, 0xc7, 0xb2, 0xe2, 0xff, 0xc8, 0xb0, 0xe6, 0xff,
0xbf, 0xa6, 0xe0, 0xff, 0xb0, 0x9b, 0xd2, 0xff, 0xb4, 0xa1, 0xdb, 0xff,
0xa4, 0x92, 0xd1, 0xff, 0x93, 0x84, 0xc2, 0xff, 0x94, 0x84, 0xc8, 0xff,
0x89, 0x71, 0xb6, 0xff, 0xa2, 0x88, 0xc2, 0xff, 0xb5, 0x98, 0xc7, 0xff,
0xc2, 0xae, 0xcc, 0xff, 0xd6, 0xc8, 0xeb, 0xff, 0xce, 0xca, 0xd8, 0xff,
0xb7, 0xb6, 0xc4, 0xff, 0xad, 0xb2, 0xc1, 0xff, 0x76, 0x84, 0x95, 0xff,
0x73, 0x86, 0x9c, 0xff, 0x72, 0x88, 0x98, 0xff, 0x6f, 0x87, 0x96, 0xff,
0x6d, 0x85, 0x94, 0xff, 0x6f, 0x83, 0x92, 0xff, 0x71, 0x81, 0x91, 0xff,
0x6f, 0x82, 0x93, 0xff, 0x70, 0x83, 0x90, 0xff, 0x70, 0x85, 0x91, 0xff,
0x70, 0x85, 0x95, 0xff, 0x70, 0x85, 0x97, 0xff, 0x6d, 0x81, 0x85, 0xff,
0x60, 0x63, 0x56, 0xff, 0x56, 0x52, 0x43, 0xff, 0x5b, 0x56, 0x51, 0xff,
0x60, 0x5c, 0x5c, 0xff, 0x57, 0x55, 0x51, 0xff, 0x4f, 0x4d, 0x44, 0xff,
0x51, 0x50, 0x4a, 0xff, 0x67, 0x69, 0x69, 0xff, 0x7d, 0x85, 0x8b, 0xff,
0x89, 0x98, 0xa1, 0xff, 0x82, 0x91, 0x93, 0xff, 0x72, 0x7a, 0x72, 0xff,
0x81, 0x87, 0x7d, 0xff, 0x7d, 0x89, 0x88, 0xff, 0x75, 0x87, 0x8e, 0xff,
0x74, 0x85, 0x8e, 0xff, 0x73, 0x83, 0x8b, 0xff, 0x70, 0x80, 0x8b, 0xff,
0x6f, 0x7f, 0x8c, 0xff, 0x6f, 0x80, 0x90, 0xff, 0x70, 0x80, 0x92, 0xff,
0x71, 0x82, 0x95, 0xff, 0x77, 0x86, 0x97, 0xff, 0x76, 0x85, 0x96, 0xff,
0x77, 0x85, 0x94, 0xff, 0x76, 0x85, 0x93, 0xff, 0x74, 0x84, 0x91, 0xff,
0x74, 0x83, 0x91, 0xff, 0x73, 0x83, 0x90, 0xff, 0x74, 0x83, 0x8f, 0xff,
0x73, 0x82, 0x8f, 0xff, 0x70, 0x81, 0x8b, 0xff, 0x6f, 0x7f, 0x87, 0xff,
0x6e, 0x7b, 0x82, 0xff, 0x6f, 0x7a, 0x7f, 0xff, 0x6c, 0x7a, 0x7d, 0xff,
0x6a, 0x78, 0x7a, 0xff, 0x6b, 0x78, 0x79, 0xff, 0x6b, 0x77, 0x77, 0xff,
0x6c, 0x77, 0x76, 0xff, 0x69, 0x77, 0x75, 0xff, 0x69, 0x77, 0x75, 0xff,
0x6b, 0x79, 0x76, 0xff, 0x6b, 0x79, 0x77, 0xff, 0x6d, 0x7b, 0x79, 0xff,
0x6a, 0x7d, 0x80, 0xff, 0x72, 0x81, 0x84, 0xff, 0x6e, 0x78, 0x81, 0xff,
0x84, 0x8b, 0x9a, 0xff, 0xa8, 0xac, 0xc0, 0xff, 0xb6, 0xae, 0xd5, 0xff,
0xb8, 0xad, 0xd9, 0xff, 0xb6, 0xaa, 0xd5, 0xff, 0xc6, 0xb8, 0xe2, 0xff,
0xbd, 0xb0, 0xd9, 0xff, 0xb1, 0xa1, 0xda, 0xff, 0xaa, 0x99, 0xd5, 0xff,
0xb0, 0x9e, 0xd6, 0xff, 0xba, 0xac, 0xdc, 0xff, 0xb9, 0xa7, 0xe1, 0xff,
0xae, 0x97, 0xdb, 0xff, 0xaa, 0x93, 0xd5, 0xff, 0xad, 0x95, 0xd7, 0xff,
0xb2, 0x99, 0xd9, 0xff, 0xb7, 0x9d, 0xdd, 0xff, 0xb2, 0x98, 0xdd, 0xff,
0xaa, 0x92, 0xdb, 0xff, 0x9e, 0x85, 0xd1, 0xff, 0xa8, 0x8e, 0xd7, 0xff,
0x9a, 0x7e, 0xc3, 0xff, 0xa8, 0x8d, 0xcf, 0xff, 0xaa, 0x90, 0xd0, 0xff,
0xa4, 0x8b, 0xc9, 0xff, 0xa5, 0x8c, 0xc9, 0xff, 0xa9, 0x90, 0xce, 0xff,
0xa7, 0x8d, 0xd1, 0xff, 0x93, 0x7a, 0xc0, 0xff, 0x91, 0x79, 0xc0, 0xff,
0x8d, 0x73, 0xc3, 0xff, 0x84, 0x72, 0xcb, 0xff, 0x80, 0x6d, 0xbb, 0xff,
0xa4, 0x8b, 0xcd, 0xff, 0xbc, 0xa3, 0xd5, 0xff, 0x9d, 0x7e, 0xbc, 0xff,
0xba, 0xa3, 0xcb, 0xff, 0xd5, 0xc0, 0xdb, 0xff, 0xd3, 0xc2, 0xd7, 0xff,
0xb6, 0xb4, 0xc4, 0xff, 0x84, 0x92, 0x9b, 0xff, 0x70, 0x83, 0x90, 0xff,
0x71, 0x86, 0x93, 0xff, 0x70, 0x86, 0x92, 0xff, 0x70, 0x85, 0x92, 0xff,
0x73, 0x83, 0x91, 0xff, 0x74, 0x83, 0x93, 0xff, 0x70, 0x84, 0x92, 0xff,
0x6d, 0x85, 0x91, 0xff, 0x70, 0x87, 0x93, 0xff, 0x72, 0x88, 0x92, 0xff,
0x6b, 0x76, 0x71, 0xff, 0x56, 0x54, 0x46, 0xff, 0x45, 0x3f, 0x34, 0xff,
0x48, 0x44, 0x3c, 0xff, 0x55, 0x4f, 0x48, 0xff, 0x5b, 0x58, 0x50, 0xff,
0x5f, 0x5c, 0x57, 0xff, 0x5e, 0x5d, 0x5c, 0xff, 0x6e, 0x71, 0x73, 0xff,
0x75, 0x7c, 0x83, 0xff, 0x81, 0x8f, 0x99, 0xff, 0x7e, 0x91, 0x92, 0xff,
0x77, 0x80, 0x76, 0xff, 0x91, 0x8f, 0x85, 0xff, 0x8b, 0x90, 0x89, 0xff,
0x79, 0x8c, 0x91, 0xff, 0x78, 0x8a, 0x91, 0xff, 0x77, 0x86, 0x8c, 0xff,
0x74, 0x81, 0x8a, 0xff, 0x71, 0x80, 0x8c, 0xff, 0x70, 0x80, 0x8d, 0xff,
0x70, 0x80, 0x8d, 0xff, 0x70, 0x7f, 0x8f, 0xff, 0x73, 0x83, 0x93, 0xff,
0x73, 0x83, 0x93, 0xff, 0x74, 0x84, 0x94, 0xff, 0x75, 0x85, 0x94, 0xff,
0x75, 0x85, 0x93, 0xff, 0x75, 0x84, 0x95, 0xff, 0x73, 0x83, 0x94, 0xff,
0x73, 0x84, 0x96, 0xff, 0x72, 0x84, 0x95, 0xff, 0x70, 0x82, 0x91, 0xff,
0x6f, 0x81, 0x8e, 0xff, 0x6f, 0x7d, 0x89, 0xff, 0x6f, 0x7d, 0x86, 0xff,
0x6c, 0x7d, 0x84, 0xff, 0x6b, 0x7c, 0x82, 0xff, 0x6b, 0x7b, 0x7f, 0xff,
0x6e, 0x7c, 0x7f, 0xff, 0x6c, 0x7a, 0x7d, 0xff, 0x6e, 0x7c, 0x7b, 0xff,
0x6e, 0x7c, 0x7b, 0xff, 0x6e, 0x7c, 0x7b, 0xff, 0x6d, 0x7b, 0x7b, 0xff,
0x6f, 0x7d, 0x7b, 0xff, 0x6d, 0x7e, 0x82, 0xff, 0x7d, 0x85, 0x8d, 0xff,
0xb5, 0xae, 0xc2, 0xff, 0xce, 0xbf, 0xe6, 0xff, 0xb6, 0xa3, 0xd8, 0xff,
0xa6, 0x98, 0xd2, 0xff, 0xbe, 0xb0, 0xe5, 0xff, 0xbf, 0xaf, 0xe6, 0xff,
0xab, 0x98, 0xd7, 0xff, 0xaa, 0x95, 0xdc, 0xff, 0xa9, 0x95, 0xe2, 0xff,
0xa8, 0x96, 0xe1, 0xff, 0xad, 0x9d, 0xe6, 0xff, 0xaf, 0xa5, 0xe2, 0xff,
0xa8, 0x98, 0xe0, 0xff, 0xa8, 0x92, 0xd9, 0xff, 0xae, 0x98, 0xdc, 0xff,
0xac, 0x95, 0xd9, 0xff, 0xa6, 0x8c, 0xd3, 0xff, 0xb2, 0x99, 0xdf, 0xff,
0xad, 0x94, 0xda, 0xff, 0xab, 0x93, 0xdd, 0xff, 0xa3, 0x8b, 0xd7, 0xff,
0x8e, 0x72, 0xbd, 0xff, 0xa4, 0x88, 0xd1, 0xff, 0xb3, 0x97, 0xde, 0xff,
0x9e, 0x82, 0xc8, 0xff, 0xad, 0x92, 0xd6, 0xff, 0xb1, 0x97, 0xd8, 0xff,
0xa9, 0x91, 0xdb, 0xff, 0x9e, 0x82, 0xd0, 0xff, 0xae, 0x92, 0xd8, 0xff,
0xae, 0x91, 0xd1, 0xff, 0x9d, 0x7b, 0xc3, 0xff, 0x87, 0x70, 0xc7, 0xff,
0x94, 0x80, 0xd4, 0xff, 0x98, 0x7f, 0xd1, 0xff, 0xa6, 0x8c, 0xd1, 0xff,
0xaf, 0x8d, 0xda, 0xff, 0xa9, 0x92, 0xc4, 0xff, 0xb5, 0x9f, 0xc1, 0xff,
0xce, 0xb7, 0xd7, 0xff, 0xc1, 0xad, 0xcf, 0xff, 0xcb, 0xc1, 0xd7, 0xff,
0xbd, 0xbc, 0xcb, 0xff, 0x96, 0x9c, 0xab, 0xff, 0x76, 0x85, 0x92, 0xff,
0x73, 0x85, 0x92, 0xff, 0x72, 0x85, 0x92, 0xff, 0x74, 0x84, 0x8f, 0xff,
0x71, 0x85, 0x91, 0xff, 0x72, 0x88, 0x93, 0xff, 0x78, 0x8b, 0x90, 0xff,
0x6a, 0x79, 0x79, 0xff, 0x58, 0x5b, 0x4f, 0xff, 0x48, 0x40, 0x34, 0xff,
0x37, 0x2e, 0x27, 0xff, 0x37, 0x31, 0x2a, 0xff, 0x4b, 0x44, 0x38, 0xff,
0x5d, 0x55, 0x4e, 0xff, 0x60, 0x5f, 0x5d, 0xff, 0x63, 0x67, 0x69, 0xff,
0x67, 0x6a, 0x6e, 0xff, 0x6f, 0x75, 0x79, 0xff, 0x76, 0x82, 0x88, 0xff,
0x68, 0x75, 0x76, 0xff, 0x78, 0x7c, 0x72, 0xff, 0x91, 0x8e, 0x86, 0xff,
0x90, 0x8f, 0x86, 0xff, 0x7a, 0x8d, 0x92, 0xff, 0x7a, 0x8b, 0x91, 0xff,
0x7a, 0x86, 0x8b, 0xff, 0x75, 0x81, 0x89, 0xff, 0x73, 0x7f, 0x89, 0xff,
0x71, 0x7f, 0x8b, 0xff, 0x71, 0x7e, 0x8b, 0xff, 0x6c, 0x7c, 0x89, 0xff,
0x71, 0x81, 0x8d, 0xff, 0x72, 0x82, 0x92, 0xff, 0x72, 0x84, 0x93, 0xff,
0x74, 0x84, 0x94, 0xff, 0x75, 0x84, 0x94, 0xff, 0x73, 0x84, 0x96, 0xff,
0x72, 0x83, 0x97, 0xff, 0x71, 0x85, 0x9a, 0xff, 0x71, 0x85, 0x9a, 0xff,
0x6f, 0x84, 0x96, 0xff, 0x70, 0x82, 0x93, 0xff, 0x71, 0x80, 0x8f, 0xff,
0x70, 0x80, 0x8d, 0xff, 0x6f, 0x82, 0x8a, 0xff, 0x6e, 0x80, 0x88, 0xff,
0x6e, 0x80, 0x87, 0xff, 0x6e, 0x7e, 0x84, 0xff, 0x6e, 0x7e, 0x83, 0xff,
0x6e, 0x7e, 0x7e, 0xff, 0x6e, 0x7e, 0x7d, 0xff, 0x6e, 0x7e, 0x7d, 0xff,
0x6e, 0x7e, 0x7d, 0xff, 0x6f, 0x7f, 0x7e, 0xff, 0x89, 0x8f, 0x93, 0xff,
0xd8, 0xd5, 0xde, 0xff, 0xda, 0xcc, 0xe9, 0xff, 0xb2, 0xa1, 0xdb, 0xff,
0xa3, 0x95, 0xe3, 0xff, 0xac, 0x9f, 0xe4, 0xff, 0xa3, 0x93, 0xdd, 0xff,
0xa0, 0x8d, 0xdb, 0xff, 0xa7, 0x92, 0xe2, 0xff, 0xa0, 0x8b, 0xd9, 0xff,
0xa5, 0x91, 0xd5, 0xff, 0xab, 0x97, 0xe0, 0xff, 0xab, 0x98, 0xe2, 0xff,
0xac, 0x9e, 0xe3, 0xff, 0x9d, 0x8c, 0xdc, 0xff, 0xa3, 0x8b, 0xda, 0xff,
0xa0, 0x89, 0xd3, 0xff, 0xa5, 0x8c, 0xd6, 0xff, 0x9e, 0x82, 0xd3, 0xff,
0x9f, 0x80, 0xd5, 0xff, 0xa4, 0x87, 0xdc, 0xff, 0x95, 0x7a, 0xd1, 0xff,
0x9a, 0x80, 0xd6, 0xff, 0xad, 0x92, 0xe2, 0xff, 0x99, 0x7d, 0xcb, 0xff,
0xaa, 0x8e, 0xdd, 0xff, 0x9d, 0x80, 0xd2, 0xff, 0x79, 0x5a, 0xb0, 0xff,
0x9b, 0x7c, 0xd4, 0xff, 0x81, 0x61, 0xbd, 0xff, 0x96, 0x77, 0xd1, 0xff,
0xa7, 0x8d, 0xdd, 0xff, 0x9f, 0x87, 0xd0, 0xff, 0x99, 0x80, 0xd2, 0xff,
0x7a, 0x5e, 0xaf, 0xff, 0x84, 0x68, 0xc0, 0xff, 0x88, 0x6c, 0xce, 0xff,
0x8c, 0x72, 0xc9, 0xff, 0x9e, 0x82, 0xd9, 0xff, 0xa3, 0x83, 0xc9, 0xff,
0xac, 0x97, 0xc3, 0xff, 0xaf, 0x9b, 0xc4, 0xff, 0xb1, 0x9e, 0xc9, 0xff,
0xc2, 0xb1, 0xcd, 0xff, 0xcf, 0xba, 0xcb, 0xff, 0xc6, 0xbb, 0xcb, 0xff,
0x8b, 0x90, 0x9d, 0xff, 0x74, 0x83, 0x8f, 0xff, 0x6f, 0x85, 0x8e, 0xff,
0x72, 0x86, 0x8a, 0xff, 0x74, 0x8b, 0x92, 0xff, 0x82, 0x97, 0x9d, 0xff,
0x7e, 0x8a, 0x8a, 0xff, 0x67, 0x6a, 0x64, 0xff, 0x4b, 0x46, 0x39, 0xff,
0x38, 0x2c, 0x25, 0xff, 0x31, 0x24, 0x23, 0xff, 0x31, 0x2a, 0x24, 0xff,
0x45, 0x3d, 0x2e, 0xff, 0x4f, 0x46, 0x3d, 0xff, 0x52, 0x51, 0x4f, 0xff,
0x60, 0x63, 0x69, 0xff, 0x6a, 0x6e, 0x73, 0xff, 0x6d, 0x74, 0x75, 0xff,
0x6d, 0x78, 0x76, 0xff, 0x64, 0x69, 0x66, 0xff, 0x76, 0x74, 0x6e, 0xff,
0x88, 0x89, 0x87, 0xff, 0x88, 0x89, 0x85, 0xff, 0x7b, 0x8c, 0x91, 0xff,
0x79, 0x8a, 0x91, 0xff, 0x79, 0x88, 0x8e, 0xff, 0x76, 0x81, 0x85, 0xff,
0x75, 0x7f, 0x83, 0xff, 0x74, 0x7d, 0x82, 0xff, 0x71, 0x7c, 0x82, 0xff,
0x6e, 0x7a, 0x86, 0xff, 0x6f, 0x7c, 0x89, 0xff, 0x6f, 0x7e, 0x8d, 0xff,
0x71, 0x81, 0x92, 0xff, 0x71, 0x84, 0x94, 0xff, 0x72, 0x84, 0x94, 0xff,
0x70, 0x84, 0x96, 0xff, 0x6e, 0x85, 0x9a, 0xff, 0x6e, 0x86, 0x9c, 0xff,
0x6f, 0x86, 0x9b, 0xff, 0x70, 0x85, 0x98, 0xff, 0x6f, 0x84, 0x95, 0xff,
0x6f, 0x82, 0x93, 0xff, 0x70, 0x83, 0x92, 0xff, 0x70, 0x84, 0x90, 0xff,
0x6f, 0x83, 0x8e, 0xff, 0x6f, 0x83, 0x8c, 0xff, 0x6f, 0x81, 0x89, 0xff,
0x6e, 0x81, 0x86, 0xff, 0x6f, 0x7f, 0x84, 0xff, 0x6b, 0x7f, 0x7a, 0xff,
0x6b, 0x7d, 0x79, 0xff, 0x72, 0x7d, 0x82, 0xff, 0x7a, 0x81, 0x85, 0xff,
0xcd, 0xcd, 0xd4, 0xff, 0xd8, 0xcd, 0xe9, 0xff, 0xbd, 0xad, 0xe7, 0xff,
0x9f, 0x92, 0xdb, 0xff, 0xa5, 0x97, 0xdf, 0xff, 0x9b, 0x88, 0xdd, 0xff,
0x9d, 0x86, 0xdd, 0xff, 0x98, 0x7f, 0xdc, 0xff, 0x9e, 0x89, 0xdc, 0xff,
0xa6, 0x9a, 0xd8, 0xff, 0xbc, 0xab, 0xde, 0xff, 0xb9, 0xa5, 0xe5, 0xff,
0xa5, 0x8d, 0xdd, 0xff, 0xa7, 0x93, 0xdf, 0xff, 0xa0, 0x8a, 0xdc, 0xff,
0x9b, 0x87, 0xd9, 0xff, 0xa3, 0x8c, 0xe1, 0xff, 0x98, 0x7d, 0xd4, 0xff,
0x9f, 0x7e, 0xd9, 0xff, 0xa4, 0x86, 0xde, 0xff, 0xb2, 0x98, 0xe9, 0xff,
0xa4, 0x86, 0xe0, 0xff, 0x9b, 0x7c, 0xdb, 0xff, 0xa5, 0x8e, 0xde, 0xff,
0x94, 0x7a, 0xca, 0xff, 0xa4, 0x86, 0xde, 0xff, 0x9b, 0x7d, 0xda, 0xff,
0x8d, 0x69, 0xc7, 0xff, 0x8c, 0x6c, 0xc7, 0xff, 0x9a, 0x7a, 0xd4, 0xff,
0x8f, 0x6e, 0xcd, 0xff, 0x8f, 0x70, 0xd1, 0xff, 0x8a, 0x70, 0xcb, 0xff,
0x99, 0x83, 0xd6, 0xff, 0xa6, 0x8d, 0xd6, 0xff, 0x98, 0x7f, 0xcc, 0xff,
0x98, 0x80, 0xcc, 0xff, 0x99, 0x7e, 0xce, 0xff, 0x92, 0x73, 0xc6, 0xff,
0x98, 0x7c, 0xc8, 0xff, 0xa0, 0x86, 0xc8, 0xff, 0xb2, 0x9e, 0xcd, 0xff,
0xab, 0x96, 0xc3, 0xff, 0xa8, 0x94, 0xba, 0xff, 0xbe, 0xa9, 0xc4, 0xff,
0xc4, 0xb3, 0xc4, 0xff, 0xba, 0xb2, 0xc2, 0xff, 0x86, 0x8d, 0x9a, 0xff,
0x70, 0x87, 0x89, 0xff, 0x6e, 0x87, 0x8a, 0xff, 0x7c, 0x8e, 0x92, 0xff,
0x85, 0x8c, 0x95, 0xff, 0x79, 0x75, 0x78, 0xff, 0x5b, 0x53, 0x4a, 0xff,
0x43, 0x39, 0x2c, 0xff, 0x2d, 0x21, 0x1b, 0xff, 0x26, 0x1a, 0x17, 0xff,
0x2d, 0x25, 0x1b, 0xff, 0x3b, 0x34, 0x26, 0xff, 0x4c, 0x44, 0x39, 0xff,
0x4c, 0x48, 0x46, 0xff, 0x61, 0x68, 0x6b, 0xff, 0x6e, 0x77, 0x7c, 0xff,
0x60, 0x66, 0x66, 0xff, 0x64, 0x6a, 0x68, 0xff, 0x6b, 0x6f, 0x72, 0xff,
0x7c, 0x7f, 0x7f, 0xff, 0x8c, 0x8f, 0x8b, 0xff, 0x92, 0x93, 0x8e, 0xff,
0x7b, 0x8c, 0x92, 0xff, 0x78, 0x8a, 0x91, 0xff, 0x79, 0x88, 0x8e, 0xff,
0x76, 0x82, 0x85, 0xff, 0x75, 0x7e, 0x81, 0xff, 0x72, 0x7b, 0x7f, 0xff,
0x6f, 0x78, 0x7f, 0xff, 0x6e, 0x77, 0x81, 0xff, 0x6c, 0x78, 0x84, 0xff,
0x6e, 0x7c, 0x8a, 0xff, 0x6f, 0x7e, 0x8f, 0xff, 0x71, 0x81, 0x92, 0xff,
0x70, 0x82, 0x94, 0xff, 0x6f, 0x83, 0x96, 0xff, 0x6f, 0x84, 0x9a, 0xff,
0x6f, 0x86, 0x9d, 0xff, 0x6f, 0x87, 0x9c, 0xff, 0x70, 0x87, 0x9a, 0xff,
0x70, 0x86, 0x98, 0xff, 0x72, 0x87, 0x97, 0xff, 0x73, 0x86, 0x97, 0xff,
0x72, 0x86, 0x95, 0xff, 0x71, 0x86, 0x93, 0xff, 0x71, 0x85, 0x91, 0xff,
0x71, 0x84, 0x8d, 0xff, 0x71, 0x84, 0x8b, 0xff, 0x70, 0x7f, 0x88, 0xff,
0x73, 0x81, 0x85, 0xff, 0x72, 0x80, 0x7d, 0xff, 0x78, 0x7f, 0x80, 0xff,
0xc5, 0xc5, 0xd2, 0xff, 0xaa, 0x9d, 0xcd, 0xff, 0xba, 0xa7, 0xde, 0xff,
0xa4, 0x94, 0xd6, 0xff, 0xa7, 0x9a, 0xe5, 0xff, 0xa0, 0x8f, 0xd8, 0xff,
0x9c, 0x8a, 0xdd, 0xff, 0x98, 0x83, 0xd8, 0xff, 0xa0, 0x8a, 0xdb, 0xff,
0xac, 0x9d, 0xe4, 0xff, 0xb3, 0xa6, 0xeb, 0xff, 0xa6, 0x90, 0xdd, 0xff,
0xa1, 0x8a, 0xda, 0xff, 0x9c, 0x83, 0xdb, 0xff, 0x9b, 0x82, 0xd6, 0xff,
0xa2, 0x89, 0xe1, 0xff, 0xb2, 0x9e, 0xf1, 0xff, 0x93, 0x7b, 0xd0, 0xff,
0xa5, 0x89, 0xe3, 0xff, 0x9d, 0x7e, 0xda, 0xff, 0x93, 0x75, 0xd2, 0xff,
0x9c, 0x80, 0xde, 0xff, 0x9f, 0x7e, 0xde, 0xff, 0x8b, 0x6c, 0xca, 0xff,
0x9c, 0x83, 0xd9, 0xff, 0x8f, 0x75, 0xc7, 0xff, 0x8e, 0x70, 0xc7, 0xff,
0x94, 0x74, 0xd5, 0xff, 0x89, 0x61, 0xc7, 0xff, 0x92, 0x70, 0xd2, 0xff,
0x9c, 0x7c, 0xda, 0xff, 0x95, 0x76, 0xd4, 0xff, 0xa0, 0x83, 0xdf, 0xff,
0xa2, 0x86, 0xe4, 0xff, 0x8f, 0x74, 0xd2, 0xff, 0xad, 0x90, 0xe6, 0xff,
0x91, 0x78, 0xc9, 0xff, 0x9e, 0x8a, 0xd0, 0xff, 0x8b, 0x6f, 0xc1, 0xff,
0x8a, 0x67, 0xc4, 0xff, 0x92, 0x73, 0xcf, 0xff, 0x99, 0x7e, 0xc7, 0xff,
0x90, 0x77, 0xb7, 0xff, 0xa2, 0x8e, 0xba, 0xff, 0xae, 0x97, 0xc2, 0xff,
0xa7, 0x93, 0xb9, 0xff, 0xb8, 0xa4, 0xc0, 0xff, 0xc0, 0xaf, 0xca, 0xff,
0xb9, 0xb3, 0xca, 0xff, 0x78, 0x80, 0x8b, 0xff, 0x75, 0x87, 0x84, 0xff,
0x78, 0x84, 0x7e, 0xff, 0x71, 0x71, 0x70, 0xff, 0x5c, 0x54, 0x51, 0xff,
0x49, 0x3e, 0x34, 0xff, 0x35, 0x29, 0x21, 0xff, 0x22, 0x16, 0x11, 0xff,
0x27, 0x1d, 0x17, 0xff, 0x37, 0x33, 0x25, 0xff, 0x3c, 0x38, 0x27, 0xff,
0x44, 0x3d, 0x2b, 0xff, 0x4d, 0x49, 0x3e, 0xff, 0x58, 0x5c, 0x57, 0xff,
0x67, 0x6d, 0x6b, 0xff, 0x63, 0x66, 0x64, 0xff, 0x6a, 0x6c, 0x6c, 0xff,
0x71, 0x75, 0x77, 0xff, 0x80, 0x83, 0x84, 0xff, 0x91, 0x91, 0x8e, 0xff,
0x99, 0x98, 0x93, 0xff, 0x7a, 0x8c, 0x93, 0xff, 0x78, 0x8a, 0x92, 0xff,
0x79, 0x87, 0x8e, 0xff, 0x76, 0x82, 0x85, 0xff, 0x73, 0x7c, 0x7f, 0xff,
0x71, 0x7a, 0x7d, 0xff, 0x6e, 0x77, 0x7b, 0xff, 0x6d, 0x76, 0x7e, 0xff,
0x6c, 0x76, 0x7e, 0xff, 0x6d, 0x79, 0x85, 0xff, 0x6f, 0x7d, 0x8b, 0xff,
0x70, 0x7f, 0x90, 0xff, 0x6f, 0x80, 0x92, 0xff, 0x70, 0x82, 0x96, 0xff,
0x70, 0x84, 0x9b, 0xff, 0x6f, 0x85, 0x9e, 0xff, 0x6f, 0x86, 0x9e, 0xff,
0x70, 0x88, 0x9c, 0xff, 0x71, 0x88, 0x9b, 0xff, 0x73, 0x89, 0x9a, 0xff,
0x74, 0x89, 0x9a, 0xff, 0x74, 0x89, 0x9a, 0xff, 0x73, 0x89, 0x98, 0xff,
0x74, 0x88, 0x96, 0xff, 0x73, 0x87, 0x92, 0xff, 0x73, 0x87, 0x8f, 0xff,
0x75, 0x86, 0x84, 0xff, 0x6f, 0x7b, 0x7c, 0xff, 0xa7, 0xad, 0xb1, 0xff,
0xb6, 0xb0, 0xcc, 0xff, 0x9c, 0x89, 0xcf, 0xff, 0xa9, 0x9b, 0xd9, 0xff,
0xb7, 0xa5, 0xe5, 0xff, 0x9e, 0x8c, 0xd5, 0xff, 0x9e, 0x91, 0xdd, 0xff,
0xa0, 0x92, 0xd7, 0xff, 0xa4, 0x98, 0xdd, 0xff, 0xa8, 0x99, 0xe0, 0xff,
0xa8, 0x9b, 0xd7, 0xff, 0xaf, 0xa5, 0xe0, 0xff, 0xa0, 0x92, 0xde, 0xff,
0x9d, 0x84, 0xe1, 0xff, 0x98, 0x81, 0xdb, 0xff, 0x94, 0x79, 0xd9, 0xff,
0x92, 0x77, 0xd6, 0xff, 0xa2, 0x83, 0xea, 0xff, 0x9e, 0x84, 0xe0, 0xff,
0x9e, 0x84, 0xe1, 0xff, 0x9e, 0x82, 0xe2, 0xff, 0x9e, 0x7e, 0xe3, 0xff,
0x9a, 0x79, 0xe3, 0xff, 0x89, 0x67, 0xda, 0xff, 0x95, 0x72, 0xdc, 0xff,
0x95, 0x77, 0xd0, 0xff, 0xa1, 0x87, 0xd8, 0xff, 0x96, 0x77, 0xd1, 0xff,
0x9c, 0x7a, 0xdf, 0xff, 0x94, 0x72, 0xda, 0xff, 0x86, 0x60, 0xc2, 0xff,
0xa1, 0x82, 0xdc, 0xff, 0x87, 0x69, 0xc8, 0xff, 0x8e, 0x6d, 0xd3, 0xff,
0x8f, 0x6d, 0xda, 0xff, 0x81, 0x5d, 0xcd, 0xff, 0x7c, 0x5b, 0xc8, 0xff,
0x82, 0x5f, 0xcd, 0xff, 0x81, 0x63, 0xc8, 0xff, 0x8e, 0x79, 0xc8, 0xff,
0x90, 0x75, 0xcd, 0xff, 0x88, 0x65, 0xc9, 0xff, 0x7f, 0x5c, 0xc8, 0xff,
0x86, 0x6a, 0xbd, 0xff, 0x8a, 0x6a, 0xc1, 0xff, 0xbd, 0xa6, 0xdb, 0xff,
0x95, 0x7d, 0xb3, 0xff, 0xa7, 0x92, 0xc3, 0xff, 0xab, 0x94, 0xc1, 0xff,
0xa1, 0x8a, 0xb2, 0xff, 0xa2, 0x8f, 0xb0, 0xff, 0xb0, 0xa2, 0xbd, 0xff,
0x6e, 0x73, 0x71, 0xff, 0x5f, 0x63, 0x56, 0xff, 0x56, 0x53, 0x47, 0xff,
0x4f, 0x46, 0x3c, 0xff, 0x41, 0x35, 0x2a, 0xff, 0x2b, 0x20, 0x19, 0xff,
0x24, 0x1c, 0x14, 0xff, 0x44, 0x42, 0x35, 0xff, 0x60, 0x62, 0x51, 0xff,
0x57, 0x59, 0x47, 0xff, 0x46, 0x43, 0x32, 0xff, 0x44, 0x3d, 0x2e, 0xff,
0x51, 0x4f, 0x48, 0xff, 0x6a, 0x6a, 0x69, 0xff, 0x74, 0x74, 0x78, 0xff,
0x72, 0x76, 0x7d, 0xff, 0x77, 0x7c, 0x82, 0xff, 0x87, 0x8b, 0x8f, 0xff,
0x95, 0x98, 0x9b, 0xff, 0x9e, 0x9d, 0x9c, 0xff, 0x78, 0x8b, 0x93, 0xff,
0x77, 0x8a, 0x92, 0xff, 0x77, 0x86, 0x8d, 0xff, 0x75, 0x81, 0x84, 0xff,
0x73, 0x7c, 0x7f, 0xff, 0x6f, 0x78, 0x7c, 0xff, 0x6d, 0x75, 0x79, 0xff,
0x6e, 0x75, 0x7a, 0xff, 0x6b, 0x74, 0x7c, 0xff, 0x6c, 0x76, 0x7f, 0xff,
0x6f, 0x7b, 0x86, 0xff, 0x6e, 0x7b, 0x89, 0xff, 0x6d, 0x7d, 0x8d, 0xff,
0x6f, 0x80, 0x92, 0xff, 0x70, 0x83, 0x98, 0xff, 0x71, 0x85, 0x9c, 0xff,
0x70, 0x87, 0x9d, 0xff, 0x70, 0x88, 0x9d, 0xff, 0x72, 0x8a, 0x9f, 0xff,
0x74, 0x8b, 0x9e, 0xff, 0x73, 0x89, 0x9b, 0xff, 0x73, 0x89, 0x9c, 0xff,
0x73, 0x89, 0x9a, 0xff, 0x73, 0x88, 0x98, 0xff, 0x72, 0x88, 0x95, 0xff,
0x73, 0x87, 0x92, 0xff, 0x74, 0x84, 0x8e, 0xff, 0x97, 0x9c, 0xb3, 0xff,
0xa9, 0xa0, 0xc7, 0xff, 0xbd, 0xaa, 0xe9, 0xff, 0x96, 0x7e, 0xd4, 0xff,
0xa9, 0x9f, 0xdd, 0xff, 0xaa, 0x99, 0xdb, 0xff, 0x99, 0x87, 0xd6, 0xff,
0x93, 0x84, 0xd5, 0xff, 0xa8, 0x98, 0xde, 0xff, 0xa3, 0x99, 0xde, 0xff,
0x9c, 0x8e, 0xd8, 0xff, 0xa5, 0x94, 0xdf, 0xff, 0xa0, 0x8f, 0xe2, 0xff,
0x96, 0x82, 0xe3, 0xff, 0x9a, 0x89, 0xe1, 0xff, 0x98, 0x85, 0xdd, 0xff,
0x9e, 0x86, 0xe5, 0xff, 0x91, 0x76, 0xd4, 0xff, 0x89, 0x6b, 0xd0, 0xff,
0x90, 0x73, 0xd5, 0xff, 0x8a, 0x6c, 0xd1, 0xff, 0x90, 0x72, 0xd8, 0xff,
0x8d, 0x6d, 0xd8, 0xff, 0x92, 0x76, 0xda, 0xff, 0x90, 0x77, 0xd6, 0xff,
0x93, 0x73, 0xdb, 0xff, 0x90, 0x6e, 0xcf, 0xff, 0x87, 0x66, 0xc6, 0xff,
0x85, 0x64, 0xc4, 0xff, 0x87, 0x67, 0xc3, 0xff, 0x76, 0x55, 0xb9, 0xff,
0x85, 0x5d, 0xc4, 0xff, 0x8c, 0x6a, 0xcc, 0xff, 0x8a, 0x70, 0xca, 0xff,
0x82, 0x66, 0xc8, 0xff, 0x7d, 0x5b, 0xca, 0xff, 0x88, 0x66, 0xd2, 0xff,
0x8a, 0x69, 0xca, 0xff, 0x89, 0x67, 0xcf, 0xff, 0x81, 0x61, 0xc7, 0xff,
0x81, 0x69, 0xbb, 0xff, 0x8e, 0x72, 0xc8, 0xff, 0x86, 0x64, 0xc0, 0xff,
0x84, 0x64, 0xc6, 0xff, 0x8c, 0x71, 0xc5, 0xff, 0x8a, 0x6d, 0xc0, 0xff,
0xa8, 0x91, 0xc8, 0xff, 0x9f, 0x89, 0xbb, 0xff, 0x8c, 0x75, 0xa9, 0xff,
0x9b, 0x83, 0xb9, 0xff, 0xa9, 0x92, 0xbf, 0xff, 0xa8, 0x91, 0xb7, 0xff,
0xa3, 0x8b, 0xb3, 0xff, 0x91, 0x87, 0x95, 0xff, 0x4d, 0x48, 0x3f, 0xff,
0x51, 0x4b, 0x3a, 0xff, 0x48, 0x3e, 0x31, 0xff, 0x38, 0x2d, 0x22, 0xff,
0x29, 0x21, 0x15, 0xff, 0x3f, 0x3c, 0x2d, 0xff, 0x64, 0x67, 0x57, 0xff,
0x7b, 0x83, 0x75, 0xff, 0x72, 0x79, 0x6d, 0xff, 0x5d, 0x5e, 0x51, 0xff,
0x46, 0x3e, 0x30, 0xff, 0x52, 0x4c, 0x45, 0xff, 0x73, 0x6e, 0x71, 0xff,
0x7f, 0x7d, 0x88, 0xff, 0x7d, 0x83, 0x8b, 0xff, 0x7a, 0x83, 0x86, 0xff,
0x87, 0x8f, 0x91, 0xff, 0xa3, 0xa6, 0xaa, 0xff, 0xaa, 0xaa, 0xa9, 0xff,
0x76, 0x89, 0x91, 0xff, 0x74, 0x87, 0x8f, 0xff, 0x75, 0x84, 0x8a, 0xff,
0x72, 0x7e, 0x82, 0xff, 0x71, 0x7a, 0x7d, 0xff, 0x6e, 0x77, 0x7b, 0xff,
0x6b, 0x74, 0x78, 0xff, 0x6d, 0x73, 0x77, 0xff, 0x6c, 0x73, 0x79, 0xff,
0x6b, 0x74, 0x7d, 0xff, 0x6b, 0x76, 0x7f, 0xff, 0x69, 0x75, 0x81, 0xff,
0x69, 0x79, 0x86, 0xff, 0x6a, 0x7c, 0x8b, 0xff, 0x6d, 0x82, 0x92, 0xff,
0x70, 0x86, 0x99, 0xff, 0x72, 0x88, 0x9d, 0xff, 0x71, 0x89, 0x9f, 0xff,
0x73, 0x8b, 0x9f, 0xff, 0x73, 0x8c, 0xa0, 0xff, 0x74, 0x8b, 0x9d, 0xff,
0x74, 0x8a, 0x9f, 0xff, 0x74, 0x89, 0x9d, 0xff, 0x73, 0x8a, 0x9a, 0xff,
0x73, 0x88, 0x98, 0xff, 0x73, 0x88, 0x94, 0xff, 0x73, 0x88, 0x8c, 0xff,
0x81, 0x82, 0xa4, 0xff, 0x91, 0x79, 0xcc, 0xff, 0x7b, 0x61, 0xbc, 0xff,
0xac, 0xa0, 0xdd, 0xff, 0xa4, 0x94, 0xeb, 0xff, 0x9a, 0x86, 0xd7, 0xff,
0x98, 0x86, 0xd8, 0xff, 0x8f, 0x7d, 0xd4, 0xff, 0x98, 0x80, 0xd6, 0xff,
0xa6, 0x9b, 0xe1, 0xff, 0x9c, 0x91, 0xd7, 0xff, 0x99, 0x84, 0xdf, 0xff,
0x8b, 0x71, 0xe0, 0xff, 0x8c, 0x74, 0xe4, 0xff, 0x8c, 0x77, 0xe1, 0xff,
0xa2, 0x88, 0xf7, 0xff, 0x8e, 0x70, 0xe3, 0xff, 0x96, 0x79, 0xdd, 0xff,
0x89, 0x6d, 0xcd, 0xff, 0x95, 0x77, 0xd5, 0xff, 0x9d, 0x7f, 0xe0, 0xff,
0x84, 0x67, 0xca, 0xff, 0x8c, 0x6f, 0xd4, 0xff, 0x9a, 0x83, 0xe0, 0xff,
0x98, 0x80, 0xe0, 0xff, 0x88, 0x66, 0xd4, 0xff, 0x8e, 0x6e, 0xcc, 0xff,
0x96, 0x78, 0xcb, 0xff, 0x91, 0x70, 0xcb, 0xff, 0x8e, 0x6f, 0xcd, 0xff,
0x74, 0x53, 0xb6, 0xff, 0x86, 0x61, 0xc4, 0xff, 0x84, 0x64, 0xc0, 0xff,
0x83, 0x66, 0xc8, 0xff, 0x9f, 0x81, 0xe7, 0xff, 0x89, 0x6b, 0xd1, 0xff,
0x87, 0x66, 0xca, 0xff, 0x88, 0x67, 0xc6, 0xff, 0x89, 0x64, 0xcc, 0xff,
0x81, 0x5f, 0xc5, 0xff, 0x8a, 0x6e, 0xc3, 0xff, 0x7e, 0x60, 0xb2, 0xff,
0x8b, 0x6c, 0xbb, 0xff, 0x90, 0x74, 0xd0, 0xff, 0x9d, 0x80, 0xdf, 0xff,
0x80, 0x61, 0xb8, 0xff, 0x9d, 0x7f, 0xcd, 0xff, 0x98, 0x7e, 0xbc, 0xff,
0xa8, 0x8e, 0xc4, 0xff, 0x86, 0x6d, 0xa6, 0xff, 0xb2, 0x9d, 0xcb, 0xff,
0x9f, 0x8b, 0xb0, 0xff, 0xab, 0x94, 0xbd, 0xff, 0xac, 0x97, 0xb9, 0xff,
0x8d, 0x81, 0x85, 0xff, 0x55, 0x4d, 0x40, 0xff, 0x44, 0x3b, 0x2e, 0xff,
0x36, 0x2d, 0x21, 0xff, 0x42, 0x3d, 0x2b, 0xff, 0x64, 0x65, 0x50, 0xff,
0x7e, 0x84, 0x72, 0xff, 0x7d, 0x86, 0x7c, 0xff, 0x7b, 0x87, 0x7f, 0xff,
0x76, 0x7e, 0x6e, 0xff, 0x5f, 0x5b, 0x49, 0xff, 0x55, 0x50, 0x44, 0xff,
0x72, 0x6d, 0x6f, 0xff, 0x7c, 0x77, 0x7d, 0xff, 0x66, 0x68, 0x67, 0xff,
0x4a, 0x4f, 0x48, 0xff, 0x65, 0x6a, 0x61, 0xff, 0x9f, 0x9e, 0x9a, 0xff,
0xac, 0xab, 0xa9, 0xff, 0x70, 0x85, 0x8d, 0xff, 0x70, 0x84, 0x8c, 0xff,
0x72, 0x80, 0x86, 0xff, 0x71, 0x7d, 0x82, 0xff, 0x6e, 0x79, 0x7d, 0xff,
0x6f, 0x77, 0x7a, 0xff, 0x6d, 0x74, 0x77, 0xff, 0x6c, 0x72, 0x77, 0xff,
0x6a, 0x71, 0x77, 0xff, 0x69, 0x71, 0x79, 0xff, 0x68, 0x72, 0x7a, 0xff,
0x69, 0x74, 0x7c, 0xff, 0x6a, 0x76, 0x82, 0xff, 0x6b, 0x7a, 0x88, 0xff,
0x6d, 0x7f, 0x90, 0xff, 0x6f, 0x84, 0x99, 0xff, 0x72, 0x88, 0x9c, 0xff,
0x72, 0x89, 0x9e, 0xff, 0x73, 0x8b, 0xa2, 0xff, 0x72, 0x8a, 0xa1, 0xff,
0x74, 0x8b, 0x9f, 0xff, 0x72, 0x8a, 0x9e, 0xff, 0x76, 0x8a, 0x9a, 0xff,
0x79, 0x88, 0x98, 0xff, 0x73, 0x86, 0x99, 0xff, 0x74, 0x87, 0x94, 0xff,
0x75, 0x7f, 0x8b, 0xff, 0xb9, 0xb6, 0xca, 0xff, 0xaa, 0x94, 0xd3, 0xff,
0xaf, 0x9e, 0xdd, 0xff, 0xa0, 0x91, 0xd3, 0xff, 0xa0, 0x8a, 0xde, 0xff,
0x96, 0x81, 0xd0, 0xff, 0x91, 0x7c, 0xcf, 0xff, 0x97, 0x82, 0xdf, 0xff,
0x93, 0x83, 0xde, 0xff, 0xa6, 0x98, 0xdc, 0xff, 0xa6, 0x99, 0xda, 0xff,
0x91, 0x7d, 0xd8, 0xff, 0x8e, 0x76, 0xe0, 0xff, 0x89, 0x70, 0xe0, 0xff,
0x86, 0x67, 0xe6, 0xff, 0x76, 0x58, 0xd4, 0xff, 0x84, 0x69, 0xd8, 0xff,
0x80, 0x5f, 0xd9, 0xff, 0x89, 0x6d, 0xd4, 0xff, 0x84, 0x5f, 0xe2, 0xff,
0x7b, 0x53, 0xd6, 0xff, 0x90, 0x73, 0xda, 0xff, 0x8d, 0x71, 0xd7, 0xff,
0x98, 0x7d, 0xe3, 0xff, 0x8d, 0x6f, 0xd7, 0xff, 0x8c, 0x6e, 0xd6, 0xff,
0x91, 0x74, 0xd6, 0xff, 0x91, 0x76, 0xd2, 0xff, 0x92, 0x72, 0xdb, 0xff,
0x89, 0x68, 0xc7, 0xff, 0x8f, 0x69, 0xca, 0xff, 0x7c, 0x56, 0xb7, 0xff,
0x82, 0x62, 0xbf, 0xff, 0x73, 0x5a, 0xbd, 0xff, 0x8d, 0x74, 0xd4, 0xff,
0x88, 0x69, 0xd1, 0xff, 0x84, 0x65, 0xc9, 0xff, 0x7c, 0x5f, 0xc1, 0xff,
0x80, 0x5d, 0xca, 0xff, 0x76, 0x59, 0xae, 0xff, 0x85, 0x61, 0xca, 0xff,
0x83, 0x5d, 0xc7, 0xff, 0x7a, 0x57, 0xb3, 0xff, 0x6b, 0x40, 0xbb, 0xff,
0x78, 0x4f, 0xc2, 0xff, 0x78, 0x53, 0xb9, 0xff, 0x77, 0x4f, 0xbe, 0xff,
0x94, 0x72, 0xce, 0xff, 0x85, 0x63, 0xb0, 0xff, 0xa0, 0x81, 0xc3, 0xff,
0x74, 0x57, 0x9e, 0xff, 0x85, 0x6c, 0xaa, 0xff, 0xa8, 0x97, 0xbb, 0xff,
0xa8, 0x95, 0xc1, 0xff, 0xa6, 0x95, 0xad, 0xff, 0x57, 0x4a, 0x4e, 0xff,
0x3d, 0x36, 0x25, 0xff, 0x47, 0x41, 0x33, 0xff, 0x67, 0x66, 0x56, 0xff,
0x7b, 0x7f, 0x70, 0xff, 0x81, 0x8b, 0x7b, 0xff, 0x7f, 0x88, 0x7b, 0xff,
0x7f, 0x87, 0x7b, 0xff, 0x81, 0x86, 0x7a, 0xff, 0x72, 0x72, 0x64, 0xff,
0x5e, 0x5c, 0x4e, 0xff, 0x62, 0x5d, 0x54, 0xff, 0x53, 0x4e, 0x43, 0xff,
0x3b, 0x36, 0x28, 0xff, 0x3b, 0x30, 0x26, 0xff, 0x4d, 0x44, 0x3c, 0xff,
0x6f, 0x6d, 0x67, 0xff, 0x84, 0x87, 0x81, 0xff, 0x6f, 0x83, 0x8b, 0xff,
0x6f, 0x82, 0x89, 0xff, 0x6f, 0x7d, 0x84, 0xff, 0x6e, 0x7a, 0x80, 0xff,
0x6b, 0x77, 0x7b, 0xff, 0x6d, 0x74, 0x78, 0xff, 0x6b, 0x72, 0x75, 0xff,
0x6b, 0x71, 0x76, 0xff, 0x69, 0x70, 0x76, 0xff, 0x68, 0x70, 0x77, 0xff,
0x67, 0x71, 0x79, 0xff, 0x68, 0x71, 0x7b, 0xff, 0x69, 0x75, 0x7f, 0xff,
0x6a, 0x79, 0x86, 0xff, 0x6d, 0x7e, 0x8f, 0xff, 0x70, 0x83, 0x96, 0xff,
0x71, 0x87, 0x9c, 0xff, 0x71, 0x89, 0x9f, 0xff, 0x71, 0x8b, 0xa4, 0xff,
0x70, 0x8a, 0xa2, 0xff, 0x73, 0x8a, 0xa0, 0xff, 0x72, 0x8b, 0xa0, 0xff,
0x76, 0x8a, 0x9e, 0xff, 0x78, 0x89, 0x9a, 0xff, 0x73, 0x88, 0x96, 0xff,
0x74, 0x86, 0x93, 0xff, 0x80, 0x83, 0x9c, 0xff, 0xa1, 0x8f, 0xca, 0xff,
0xb0, 0x9a, 0xdc, 0xff, 0xb3, 0xa4, 0xe2, 0xff, 0x92, 0x7d, 0xc9, 0xff,
0x9b, 0x82, 0xd1, 0xff, 0x92, 0x7a, 0xc8, 0xff, 0x98, 0x7f, 0xd7, 0xff,
0x8b, 0x70, 0xd5, 0xff, 0x8f, 0x76, 0xdb, 0xff, 0x98, 0x85, 0xdb, 0xff,
0x94, 0x84, 0xd1, 0xff, 0x93, 0x80, 0xdc, 0xff, 0x96, 0x83, 0xe3, 0xff,
0x8f, 0x7a, 0xe1, 0xff, 0x89, 0x6c, 0xde, 0xff, 0x8e, 0x6f, 0xdd, 0xff,
0x94, 0x78, 0xde, 0xff, 0x7e, 0x5b, 0xd2, 0xff, 0x8b, 0x6c, 0xd5, 0xff,
0x71, 0x4e, 0xc6, 0xff, 0x85, 0x62, 0xd3, 0xff, 0x91, 0x75, 0xd0, 0xff,
0x87, 0x69, 0xcf, 0xff, 0x8a, 0x6a, 0xd9, 0xff, 0x8d, 0x6d, 0xd8, 0xff,
0x88, 0x6b, 0xcf, 0xff, 0x81, 0x63, 0xcb, 0xff, 0x67, 0x46, 0xb5, 0xff,
0x70, 0x4c, 0xc5, 0xff, 0x83, 0x5f, 0xc7, 0xff, 0x6f, 0x48, 0xab, 0xff,
0x81, 0x5c, 0xbd, 0xff, 0x8a, 0x6c, 0xc7, 0xff, 0x8c, 0x6e, 0xd2, 0xff,
0x86, 0x69, 0xcb, 0xff, 0x7e, 0x5d, 0xbc, 0xff, 0x8f, 0x73, 0xc2, 0xff,
0x80, 0x63, 0xb9, 0xff, 0x7b, 0x58, 0xbd, 0xff, 0x8b, 0x6c, 0xc8, 0xff,
0x7b, 0x50, 0xd1, 0xff, 0x5d, 0x30, 0xb0, 0xff, 0x7e, 0x58, 0xbc, 0xff,
0x72, 0x52, 0xab, 0xff, 0x79, 0x58, 0xb3, 0xff, 0x84, 0x62, 0xc1, 0xff,
0x84, 0x63, 0xbd, 0xff, 0x6f, 0x4c, 0xad, 0xff, 0x7f, 0x5f, 0xac, 0xff,
0x80, 0x5d, 0xb2, 0xff, 0x7b, 0x58, 0xad, 0xff, 0x8b, 0x6e, 0xb2, 0xff,
0xa5, 0x90, 0xbd, 0xff, 0x9a, 0x86, 0xb1, 0xff, 0xa7, 0x91, 0xba, 0xff,
0x60, 0x4f, 0x60, 0xff, 0x41, 0x3b, 0x2c, 0xff, 0x67, 0x63, 0x55, 0xff,
0x86, 0x86, 0x76, 0xff, 0x86, 0x8b, 0x7c, 0xff, 0x83, 0x8c, 0x7d, 0xff,
0x83, 0x8b, 0x7e, 0xff, 0x82, 0x89, 0x7d, 0xff, 0x86, 0x8a, 0x7e, 0xff,
0x83, 0x84, 0x76, 0xff, 0x68, 0x67, 0x59, 0xff, 0x4f, 0x49, 0x3e, 0xff,
0x37, 0x2d, 0x25, 0xff, 0x39, 0x2a, 0x25, 0xff, 0x3e, 0x2b, 0x26, 0xff,
0x47, 0x3b, 0x33, 0xff, 0x4d, 0x4a, 0x40, 0xff, 0x5c, 0x60, 0x5a, 0xff,
0x6e, 0x81, 0x88, 0xff, 0x6d, 0x7f, 0x86, 0xff, 0x6d, 0x7b, 0x81, 0xff,
0x6d, 0x79, 0x7e, 0xff, 0x6a, 0x75, 0x79, 0xff, 0x6b, 0x73, 0x76, 0xff,
0x6a, 0x71, 0x74, 0xff, 0x6a, 0x70, 0x75, 0xff, 0x68, 0x6f, 0x75, 0xff,
0x67, 0x6f, 0x76, 0xff, 0x66, 0x6f, 0x78, 0xff, 0x66, 0x70, 0x79, 0xff,
0x69, 0x74, 0x7d, 0xff, 0x6a, 0x78, 0x84, 0xff, 0x6d, 0x7e, 0x8e, 0xff,
0x70, 0x83, 0x95, 0xff, 0x71, 0x87, 0x9a, 0xff, 0x71, 0x88, 0x9f, 0xff,
0x71, 0x8a, 0xa4, 0xff, 0x71, 0x8a, 0xa4, 0xff, 0x73, 0x8b, 0xa1, 0xff,
0x74, 0x8b, 0xa1, 0xff, 0x76, 0x8a, 0x9f, 0xff, 0x76, 0x8b, 0x9b, 0xff,
0x76, 0x8c, 0x98, 0xff, 0x7b, 0x87, 0x9b, 0xff, 0xa3, 0x9a, 0xc7, 0xff,
0x9b, 0x82, 0xcd, 0xff, 0x94, 0x7f, 0xc2, 0xff, 0xa3, 0x8a, 0xe7, 0xff,
0x84, 0x66, 0xc1, 0xff, 0x95, 0x7d, 0xc7, 0xff, 0x9b, 0x87, 0xd3, 0xff,
0x9c, 0x87, 0xe3, 0xff, 0x93, 0x7b, 0xe4, 0xff, 0x87, 0x6d, 0xd5, 0xff,
0x89, 0x71, 0xd7, 0xff, 0x95, 0x81, 0xdf, 0xff, 0x8c, 0x78, 0xd9, 0xff,
0x93, 0x81, 0xdd, 0xff, 0x82, 0x6e, 0xd1, 0xff, 0x7b, 0x60, 0xd3, 0xff,
0x63, 0x3e, 0xce, 0xff, 0x66, 0x3b, 0xda, 0xff, 0x6c, 0x46, 0xd5, 0xff,
0x8c, 0x6f, 0xdd, 0xff, 0x7e, 0x5c, 0xcf, 0xff, 0x7d, 0x59, 0xc8, 0xff,
0x8c, 0x6b, 0xcd, 0xff, 0x8b, 0x6f, 0xcd, 0xff, 0x88, 0x6b, 0xcf, 0xff,
0x87, 0x6b, 0xcb, 0xff, 0x8c, 0x6f, 0xd3, 0xff, 0x79, 0x5c, 0xbf, 0xff,
0x89, 0x6e, 0xcb, 0xff, 0x86, 0x68, 0xcf, 0xff, 0x8f, 0x6c, 0xd2, 0xff,
0x81, 0x5b, 0xbb, 0xff, 0x7a, 0x53, 0xb7, 0xff, 0x7e, 0x5d, 0xc4, 0xff,
0x87, 0x6d, 0xcb, 0xff, 0x93, 0x7b, 0xd3, 0xff, 0x87, 0x6c, 0xc2, 0xff,
0x87, 0x6f, 0xba, 0xff, 0x8a, 0x6e, 0xca, 0xff, 0x81, 0x65, 0xbb, 0xff,
0x7e, 0x58, 0xc7, 0xff, 0x6a, 0x40, 0xbb, 0xff, 0x7f, 0x5f, 0xb9, 0xff,
0x7f, 0x5a, 0xba, 0xff, 0x7b, 0x56, 0xbd, 0xff, 0x95, 0x76, 0xcd, 0xff,
0x6c, 0x48, 0xad, 0xff, 0x70, 0x4c, 0xb2, 0xff, 0x83, 0x63, 0xbd, 0xff,
0x86, 0x66, 0xb7, 0xff, 0x5f, 0x3c, 0x93, 0xff, 0x7c, 0x5e, 0xa5, 0xff,
0x83, 0x69, 0xa2, 0xff, 0x8e, 0x73, 0xab, 0xff, 0x9c, 0x89, 0xb2, 0xff,
0xa0, 0x88, 0xb5, 0xff, 0x96, 0x83, 0x9d, 0xff, 0x52, 0x4e, 0x42, 0xff,
0x7d, 0x7f, 0x6d, 0xff, 0x8b, 0x8d, 0x7d, 0xff, 0x86, 0x8c, 0x7d, 0xff,
0x86, 0x8d, 0x7e, 0xff, 0x87, 0x8c, 0x80, 0xff, 0x88, 0x8c, 0x7f, 0xff,
0x88, 0x8d, 0x7f, 0xff, 0x89, 0x8b, 0x7b, 0xff, 0x73, 0x73, 0x63, 0xff,
0x4b, 0x46, 0x39, 0xff, 0x2f, 0x26, 0x1c, 0xff, 0x2d, 0x23, 0x1a, 0xff,
0x34, 0x29, 0x25, 0xff, 0x4e, 0x49, 0x47, 0xff, 0x67, 0x67, 0x68, 0xff,
0x73, 0x79, 0x7e, 0xff, 0x6e, 0x7f, 0x88, 0xff, 0x6e, 0x7d, 0x84, 0xff,
0x6c, 0x7a, 0x80, 0xff, 0x6d, 0x79, 0x7e, 0xff, 0x6a, 0x75, 0x79, 0xff,
0x6b, 0x73, 0x77, 0xff, 0x6b, 0x72, 0x75, 0xff, 0x6b, 0x71, 0x76, 0xff,
0x69, 0x70, 0x76, 0xff, 0x67, 0x6f, 0x76, 0xff, 0x65, 0x6e, 0x77, 0xff,
0x66, 0x6f, 0x77, 0xff, 0x69, 0x74, 0x7c, 0xff, 0x6b, 0x78, 0x83, 0xff,
0x6d, 0x7d, 0x8b, 0xff, 0x70, 0x82, 0x93, 0xff, 0x72, 0x87, 0x99, 0xff,
0x72, 0x88, 0x9c, 0xff, 0x73, 0x8a, 0xa0, 0xff, 0x74, 0x8b, 0xa1, 0xff,
0x76, 0x8b, 0xa0, 0xff, 0x78, 0x8e, 0x9d, 0xff, 0x79, 0x8b, 0x9e, 0xff,
0x78, 0x8c, 0x9b, 0xff, 0x75, 0x87, 0x92, 0xff, 0x98, 0x96, 0xb7, 0xff,
0x9e, 0x8f, 0xc1, 0xff, 0xa9, 0x96, 0xcc, 0xff, 0xa5, 0x98, 0xcb, 0xff,
0x7a, 0x61, 0xbb, 0xff, 0x9d, 0x7f, 0xce, 0xff, 0x91, 0x77, 0xca, 0xff,
0x93, 0x7e, 0xd7, 0xff, 0x77, 0x63, 0xcb, 0xff, 0x84, 0x6c, 0xdc, 0xff,
0x88, 0x6d, 0xd8, 0xff, 0x84, 0x68, 0xd1, 0xff, 0x8a, 0x6f, 0xd7, 0xff,
0x8a, 0x71, 0xd9, 0xff, 0x7f, 0x69, 0xca, 0xff, 0x85, 0x6c, 0xdb, 0xff,
0x87, 0x69, 0xd0, 0xff, 0x7d, 0x5b, 0xcf, 0xff, 0x71, 0x49, 0xc9, 0xff,
0x7a, 0x54, 0xcc, 0xff, 0x87, 0x65, 0xd0, 0xff, 0x7b, 0x5b, 0xc9, 0xff,
0x7a, 0x58, 0xc7, 0xff, 0x77, 0x54, 0xc5, 0xff, 0x86, 0x69, 0xce, 0xff,
0x84, 0x67, 0xcc, 0xff, 0x8c, 0x70, 0xd3, 0xff, 0x87, 0x67, 0xd4, 0xff,
0x79, 0x59, 0xc4, 0xff, 0x82, 0x68, 0xc0, 0xff, 0x8b, 0x71, 0xcb, 0xff,
0x83, 0x62, 0xc2, 0xff, 0x79, 0x55, 0xaf, 0xff, 0x7b, 0x54, 0xba, 0xff,
0x7e, 0x58, 0xc8, 0xff, 0x7e, 0x66, 0xca, 0xff, 0x90, 0x7a, 0xd4, 0xff,
0x6c, 0x4e, 0xb4, 0xff, 0x8d, 0x6b, 0xdf, 0xff, 0x80, 0x5b, 0xd9, 0xff,
0x71, 0x4f, 0xb9, 0xff, 0x86, 0x65, 0xc8, 0xff, 0x7b, 0x5b, 0xb7, 0xff,
0x73, 0x53, 0xa9, 0xff, 0x80, 0x60, 0xb1, 0xff, 0x72, 0x50, 0xae, 0xff,
0x88, 0x5b, 0xd8, 0xff, 0x77, 0x53, 0xb9, 0xff, 0x7c, 0x5b, 0xb5, 0xff,
0x7d, 0x5c, 0xb5, 0xff, 0x75, 0x57, 0xac, 0xff, 0x80, 0x62, 0xaf, 0xff,
0x89, 0x6f, 0xa6, 0xff, 0x8a, 0x70, 0xa3, 0xff, 0x87, 0x67, 0xa7, 0xff,
0x9f, 0x86, 0xb9, 0xff, 0x9c, 0x85, 0xb0, 0xff, 0xa7, 0x93, 0xb4, 0xff,
0x87, 0x82, 0x81, 0xff, 0x8c, 0x90, 0x7d, 0xff, 0x8c, 0x92, 0x81, 0xff,
0x89, 0x90, 0x81, 0xff, 0x89, 0x90, 0x81, 0xff, 0x8c, 0x8f, 0x83, 0xff,
0x8c, 0x8f, 0x83, 0xff, 0x8c, 0x91, 0x82, 0xff, 0x8e, 0x90, 0x7f, 0xff,
0x7e, 0x7e, 0x6c, 0xff, 0x4e, 0x48, 0x3b, 0xff, 0x37, 0x30, 0x23, 0xff,
0x31, 0x2e, 0x22, 0xff, 0x45, 0x45, 0x40, 0xff, 0x69, 0x6e, 0x71, 0xff,
0x75, 0x7c, 0x85, 0xff, 0x82, 0x88, 0x94, 0xff, 0x6d, 0x7e, 0x86, 0xff,
0x6e, 0x7c, 0x82, 0xff, 0x6d, 0x7b, 0x80, 0xff, 0x6d, 0x79, 0x7e, 0xff,
0x6b, 0x76, 0x7a, 0xff, 0x6d, 0x75, 0x78, 0xff, 0x6b, 0x72, 0x76, 0xff,
0x6c, 0x72, 0x77, 0xff, 0x6a, 0x71, 0x77, 0xff, 0x67, 0x6f, 0x76, 0xff,
0x65, 0x6e, 0x76, 0xff, 0x66, 0x6f, 0x77, 0xff, 0x6a, 0x74, 0x7c, 0xff,
0x6c, 0x78, 0x82, 0xff, 0x6c, 0x7c, 0x8a, 0xff, 0x6f, 0x81, 0x91, 0xff,
0x73, 0x86, 0x96, 0xff, 0x74, 0x88, 0x99, 0xff, 0x74, 0x8a, 0x9c, 0xff,
0x76, 0x8b, 0x9d, 0xff, 0x78, 0x8b, 0x9c, 0xff, 0x7a, 0x8d, 0x96, 0xff,
0x7a, 0x8a, 0x99, 0xff, 0x76, 0x8a, 0x97, 0xff, 0x82, 0x8f, 0x9f, 0xff,
0x9f, 0x92, 0xc0, 0xff, 0xac, 0x95, 0xd4, 0xff, 0xae, 0x98, 0xd9, 0xff,
0x92, 0x81, 0xc0, 0xff, 0x8c, 0x79, 0xc0, 0xff, 0x9b, 0x7f, 0xc8, 0xff,
0x92, 0x73, 0xc4, 0xff, 0x9c, 0x85, 0xd8, 0xff, 0x7f, 0x6b, 0xca, 0xff,
0x9a, 0x82, 0xe7, 0xff, 0x87, 0x6d, 0xc7, 0xff, 0x83, 0x67, 0xcc, 0xff,
0x88, 0x69, 0xd4, 0xff, 0x81, 0x63, 0xd0, 0xff, 0x8b, 0x6f, 0xd9, 0xff,
0x75, 0x54, 0xcf, 0xff, 0x7a, 0x5c, 0xca, 0xff, 0x79, 0x5c, 0xc7, 0xff,
0x84, 0x63, 0xd6, 0xff, 0x77, 0x56, 0xc6, 0xff, 0x7d, 0x5a, 0xcf, 0xff,
0x7c, 0x5a, 0xd3, 0xff, 0x85, 0x67, 0xd3, 0xff, 0x89, 0x6b, 0xd5, 0xff,
0x90, 0x76, 0xd5, 0xff, 0x82, 0x67, 0xcb, 0xff, 0x7b, 0x5e, 0xc0, 0xff,
0x7f, 0x61, 0xc7, 0xff, 0x86, 0x67, 0xcf, 0xff, 0x7c, 0x5f, 0xbf, 0xff,
0x79, 0x5b, 0xc0, 0xff, 0x76, 0x53, 0xb9, 0xff, 0x75, 0x50, 0xac, 0xff,
0x6d, 0x47, 0xaa, 0xff, 0x7a, 0x57, 0xc1, 0xff, 0x86, 0x69, 0xcf, 0xff,
0x79, 0x5f, 0xba, 0xff, 0x7d, 0x5a, 0xc5, 0xff, 0x60, 0x32, 0xb6, 0xff,
0x60, 0x38, 0xb5, 0xff, 0x78, 0x57, 0xb8, 0xff, 0x7b, 0x58, 0xbf, 0xff,
0x7f, 0x5f, 0xbc, 0xff, 0x7e, 0x5d, 0xb7, 0xff, 0x6e, 0x4a, 0xa6, 0xff,
0x69, 0x46, 0xa8, 0xff, 0x57, 0x27, 0xaf, 0xff, 0x81, 0x5a, 0xc5, 0xff,
0x76, 0x4e, 0xc1, 0xff, 0x81, 0x5e, 0xbd, 0xff, 0x85, 0x68, 0xbe, 0xff,
0x83, 0x66, 0xb2, 0xff, 0x83, 0x66, 0xa6, 0xff, 0x8a, 0x6c, 0xa7, 0xff,
0x80, 0x61, 0x9d, 0xff, 0x8a, 0x6c, 0xac, 0xff, 0x97, 0x81, 0xab, 0xff,
0x9a, 0x85, 0xb0, 0xff, 0x8f, 0x86, 0x97, 0xff, 0x92, 0x98, 0x8a, 0xff,
0x92, 0x98, 0x87, 0xff, 0x8f, 0x95, 0x87, 0xff, 0x8e, 0x95, 0x86, 0xff,
0x91, 0x94, 0x88, 0xff, 0x92, 0x94, 0x87, 0xff, 0x91, 0x96, 0x87, 0xff,
0x92, 0x95, 0x83, 0xff, 0x85, 0x84, 0x73, 0xff, 0x4c, 0x47, 0x3a, 0xff,
0x43, 0x3b, 0x33, 0xff, 0x54, 0x4d, 0x4a, 0xff, 0x63, 0x65, 0x63, 0xff,
0x76, 0x7d, 0x7f, 0xff, 0x71, 0x7a, 0x7f, 0xff, 0x74, 0x7c, 0x7f, 0xff,
0x6f, 0x7e, 0x84, 0xff, 0x6e, 0x7c, 0x81, 0xff, 0x6f, 0x7c, 0x7f, 0xff,
0x6f, 0x7a, 0x7e, 0xff, 0x6c, 0x76, 0x7d, 0xff, 0x6e, 0x76, 0x7d, 0xff,
0x6d, 0x76, 0x7c, 0xff, 0x69, 0x74, 0x78, 0xff, 0x69, 0x73, 0x78, 0xff,
0x69, 0x72, 0x76, 0xff, 0x68, 0x6e, 0x73, 0xff, 0x69, 0x70, 0x75, 0xff,
0x6a, 0x75, 0x79, 0xff, 0x6c, 0x79, 0x80, 0xff, 0x6e, 0x7d, 0x87, 0xff,
0x70, 0x81, 0x8f, 0xff, 0x71, 0x84, 0x95, 0xff, 0x73, 0x86, 0x98, 0xff,
0x77, 0x89, 0x99, 0xff, 0x78, 0x89, 0x99, 0xff, 0x78, 0x88, 0x97, 0xff,
0x77, 0x88, 0x96, 0xff, 0x72, 0x8b, 0x91, 0xff, 0x75, 0x8a, 0x92, 0xff,
0x94, 0x91, 0xb1, 0xff, 0xa0, 0x8e, 0xc3, 0xff, 0x92, 0x7e, 0xb9, 0xff,
0x96, 0x80, 0xc0, 0xff, 0x8d, 0x6f, 0xcb, 0xff, 0x98, 0x7f, 0xcc, 0xff,
0x96, 0x7c, 0xc7, 0xff, 0x8e, 0x72, 0xc7, 0xff, 0x9c, 0x82, 0xd7, 0xff,
0x8b, 0x6e, 0xcb, 0xff, 0x84, 0x63, 0xd2, 0xff, 0x83, 0x67, 0xc8, 0xff,
0x80, 0x69, 0xc7, 0xff, 0x96, 0x81, 0xe6, 0xff, 0x82, 0x6c, 0xd7, 0xff,
0x7c, 0x63, 0xd0, 0xff, 0x75, 0x5a, 0xc8, 0xff, 0x89, 0x71, 0xd6, 0xff,
0x79, 0x57, 0xcb, 0xff, 0x80, 0x5e, 0xd1, 0xff, 0x72, 0x51, 0xc5, 0xff,
0x86, 0x62, 0xdc, 0xff, 0x79, 0x5c, 0xcc, 0xff, 0x80, 0x6c, 0xd2, 0xff,
0x7c, 0x59, 0xd0, 0xff, 0x74, 0x4b, 0xc7, 0xff, 0x7e, 0x61, 0xc5, 0xff,
0x88, 0x67, 0xd8, 0xff, 0x74, 0x58, 0xbf, 0xff, 0x6f, 0x4e, 0xbb, 0xff,
0x7f, 0x5c, 0xba, 0xff, 0x7d, 0x56, 0xbe, 0xff, 0x71, 0x4c, 0xb4, 0xff,
0x72, 0x4b, 0xb3, 0xff, 0x79, 0x53, 0xba, 0xff, 0x8f, 0x6f, 0xd6, 0xff,
0x74, 0x56, 0xbe, 0xff, 0x7e, 0x61, 0xc1, 0xff, 0x84, 0x66, 0xc5, 0xff,
0x77, 0x56, 0xbc, 0xff, 0x7b, 0x5b, 0xba, 0xff, 0x82, 0x5f, 0xc9, 0xff,
0x82, 0x5d, 0xbf, 0xff, 0x77, 0x53, 0xaf, 0xff, 0x74, 0x4e, 0xad, 0xff,
0x73, 0x4f, 0xae, 0xff, 0x6c, 0x4b, 0xaa, 0xff, 0x67, 0x3b, 0xb4, 0xff,
0x6c, 0x41, 0xb9, 0xff, 0x71, 0x4c, 0xad, 0xff, 0x7b, 0x57, 0xb4, 0xff,
0x6e, 0x49, 0xaf, 0xff, 0x73, 0x54, 0xa2, 0xff, 0x79, 0x5b, 0x9e, 0xff,
0x79, 0x59, 0x9d, 0xff, 0x77, 0x57, 0x97, 0xff, 0xa2, 0x8b, 0xbd, 0xff,
0x96, 0x82, 0xb0, 0xff, 0xa0, 0x85, 0xb8, 0xff, 0x92, 0x82, 0xa0, 0xff,
0x97, 0x9e, 0x8d, 0xff, 0x96, 0x9a, 0x8d, 0xff, 0x96, 0x9a, 0x8e, 0xff,
0x94, 0x98, 0x8c, 0xff, 0x94, 0x98, 0x8c, 0xff, 0x95, 0x98, 0x8c, 0xff,
0x98, 0x9b, 0x8c, 0xff, 0x96, 0x9b, 0x8c, 0xff, 0x8d, 0x8f, 0x81, 0xff,
0x57, 0x56, 0x48, 0xff, 0x50, 0x4c, 0x45, 0xff, 0x6a, 0x65, 0x66, 0xff,
0x6c, 0x68, 0x68, 0xff, 0x5c, 0x59, 0x56, 0xff, 0x5d, 0x5b, 0x51, 0xff,
0x66, 0x66, 0x59, 0xff, 0x6f, 0x7e, 0x84, 0xff, 0x6e, 0x7c, 0x82, 0xff,
0x70, 0x7b, 0x7f, 0xff, 0x6f, 0x7a, 0x7e, 0xff, 0x6f, 0x79, 0x7f, 0xff,
0x6f, 0x78, 0x80, 0xff, 0x6e, 0x78, 0x80, 0xff, 0x6c, 0x77, 0x7c, 0xff,
0x69, 0x75, 0x79, 0xff, 0x68, 0x71, 0x76, 0xff, 0x67, 0x6e, 0x74, 0xff,
0x67, 0x70, 0x75, 0xff, 0x68, 0x72, 0x79, 0xff, 0x6b, 0x77, 0x7f, 0xff,
0x6e, 0x7c, 0x85, 0xff, 0x70, 0x80, 0x8c, 0xff, 0x72, 0x83, 0x90, 0xff,
0x74, 0x85, 0x92, 0xff, 0x76, 0x87, 0x94, 0xff, 0x76, 0x88, 0x94, 0xff,
0x75, 0x87, 0x93, 0xff, 0x73, 0x83, 0x8f, 0xff, 0x73, 0x86, 0x8f, 0xff,
0x7a, 0x85, 0x97, 0xff, 0x9b, 0x90, 0xb5, 0xff, 0xa7, 0x93, 0xbd, 0xff,
0xaa, 0x9b, 0xc6, 0xff, 0x8c, 0x73, 0xbd, 0xff, 0x84, 0x6b, 0xb4, 0xff,
0x91, 0x79, 0xc0, 0xff, 0x8e, 0x71, 0xc6, 0xff, 0x83, 0x64, 0xc7, 0xff,
0x6a, 0x43, 0xc3, 0xff, 0x70, 0x50, 0xbe, 0xff, 0x7d, 0x60, 0xc6, 0xff,
0x7e, 0x5f, 0xce, 0xff, 0x84, 0x6a, 0xc9, 0xff, 0x86, 0x6d, 0xd0, 0xff,
0x80, 0x67, 0xcf, 0xff, 0x85, 0x6a, 0xd2, 0xff, 0x79, 0x5d, 0xc3, 0xff,
0x71, 0x58, 0xbb, 0xff, 0x77, 0x5a, 0xbe, 0xff, 0x89, 0x6a, 0xcd, 0xff,
0x7d, 0x5c, 0xc9, 0xff, 0x71, 0x4d, 0xc7, 0xff, 0x74, 0x53, 0xce, 0xff,
0x79, 0x61, 0xcf, 0xff, 0x6a, 0x4b, 0xbf, 0xff, 0x65, 0x40, 0xb9, 0xff,
0x76, 0x5a, 0xc0, 0xff, 0x7e, 0x5e, 0xcc, 0xff, 0x78, 0x5c, 0xc3, 0xff,
0x82, 0x62, 0xce, 0xff, 0x84, 0x63, 0xc3, 0xff, 0x72, 0x4e, 0xae, 0xff,
0x78, 0x56, 0xb4, 0xff, 0x71, 0x4c, 0xad, 0xff, 0x74, 0x4f, 0xb4, 0xff,
0x75, 0x54, 0xbb, 0xff, 0x81, 0x63, 0xc8, 0xff, 0x7d, 0x5d, 0xc2, 0xff,
0x79, 0x59, 0xbc, 0xff, 0x7b, 0x5b, 0xba, 0xff, 0x7d, 0x5c, 0xbc, 0xff,
0x82, 0x5f, 0xc5, 0xff, 0x7b, 0x58, 0xb5, 0xff, 0x84, 0x5f, 0xba, 0xff,
0x6d, 0x47, 0xa7, 0xff, 0x74, 0x50, 0xad, 0xff, 0x70, 0x4c, 0xae, 0xff,
0x78, 0x4d, 0xc3, 0xff, 0x5e, 0x35, 0xa9, 0xff, 0x7d, 0x59, 0xbb, 0xff,
0x75, 0x53, 0xb1, 0xff, 0x6d, 0x4a, 0xac, 0xff, 0x8f, 0x6a, 0xcb, 0xff,
0x79, 0x55, 0xa9, 0xff, 0x7c, 0x5c, 0xa1, 0xff, 0x6a, 0x49, 0x8c, 0xff,
0x7a, 0x56, 0xa8, 0xff, 0x7d, 0x62, 0xa3, 0xff, 0x9c, 0x7f, 0xb7, 0xff,
0x8e, 0x7a, 0xa0, 0xff, 0x9c, 0x9d, 0x98, 0xff, 0x9b, 0x9f, 0x93, 0xff,
0x9b, 0x9f, 0x93, 0xff, 0x9a, 0x9e, 0x92, 0xff, 0x9a, 0x9e, 0x92, 0xff,
0x9b, 0x9e, 0x92, 0xff, 0x9c, 0xa0, 0x91, 0xff, 0x9a, 0xa0, 0x91, 0xff,
0x96, 0x9a, 0x8b, 0xff, 0x74, 0x73, 0x65, 0xff, 0x5b, 0x58, 0x4d, 0xff,
0x73, 0x6d, 0x66, 0xff, 0x6b, 0x65, 0x5f, 0xff, 0x4b, 0x46, 0x3d, 0xff,
0x49, 0x46, 0x3a, 0xff, 0x59, 0x59, 0x4c, 0xff, 0x71, 0x7f, 0x85, 0xff,
0x6f, 0x7b, 0x81, 0xff, 0x70, 0x7a, 0x80, 0xff, 0x6f, 0x79, 0x80, 0xff,
0x6f, 0x7b, 0x82, 0xff, 0x6f, 0x7b, 0x83, 0xff, 0x6f, 0x7c, 0x83, 0xff,
0x70, 0x7c, 0x82, 0xff, 0x6c, 0x77, 0x7e, 0xff, 0x69, 0x73, 0x7a, 0xff,
0x65, 0x6f, 0x76, 0xff, 0x66, 0x6f, 0x76, 0xff, 0x68, 0x73, 0x7a, 0xff,
0x6d, 0x78, 0x7f, 0xff, 0x70, 0x7c, 0x85, 0xff, 0x72, 0x80, 0x88, 0xff,
0x74, 0x83, 0x8a, 0xff, 0x75, 0x84, 0x8c, 0xff, 0x76, 0x87, 0x8e, 0xff,
0x76, 0x87, 0x90, 0xff, 0x75, 0x87, 0x92, 0xff, 0x71, 0x83, 0x92, 0xff,
0x75, 0x88, 0x93, 0xff, 0x7e, 0x88, 0x9a, 0xff, 0x8d, 0x80, 0xac, 0xff,
0x9a, 0x85, 0xc2, 0xff, 0x77, 0x5b, 0xad, 0xff, 0x8c, 0x73, 0xbc, 0xff,
0x93, 0x78, 0xc7, 0xff, 0x84, 0x6a, 0xb7, 0xff, 0x87, 0x6a, 0xbe, 0xff,
0x81, 0x66, 0xc0, 0xff, 0x8a, 0x70, 0xcb, 0xff, 0x83, 0x68, 0xc4, 0xff,
0x7a, 0x5b, 0xc6, 0xff, 0x80, 0x67, 0xc3, 0xff, 0x78, 0x5b, 0xbc, 0xff,
0x7c, 0x60, 0xc6, 0xff, 0x79, 0x5d, 0xc9, 0xff, 0x76, 0x56, 0xc5, 0xff,
0x73, 0x51, 0xbf, 0xff, 0x6d, 0x52, 0xb1, 0xff, 0x76, 0x58, 0xb8, 0xff,
0x60, 0x3c, 0xa3, 0xff, 0x7a, 0x57, 0xc4, 0xff, 0x73, 0x4f, 0xbd, 0xff,
0x7e, 0x58, 0xca, 0xff, 0x7a, 0x56, 0xc8, 0xff, 0x85, 0x68, 0xca, 0xff,
0x83, 0x5f, 0xce, 0xff, 0x6d, 0x45, 0xbc, 0xff, 0x7a, 0x59, 0xc8, 0xff,
0x63, 0x43, 0xb3, 0xff, 0x7a, 0x58, 0xc6, 0xff, 0x79, 0x56, 0xc0, 0xff,
0x7e, 0x5a, 0xbf, 0xff, 0x6e, 0x4a, 0xae, 0xff, 0x66, 0x3e, 0xa8, 0xff,
0x7b, 0x52, 0xc2, 0xff, 0x6f, 0x48, 0xbe, 0xff, 0x77, 0x57, 0xbf, 0xff,
0x78, 0x56, 0xc2, 0xff, 0x78, 0x54, 0xc0, 0xff, 0x77, 0x56, 0xb5, 0xff,
0x6d, 0x48, 0xaf, 0xff, 0x68, 0x41, 0xb4, 0xff, 0x6a, 0x41, 0xae, 0xff,
0x78, 0x4e, 0xb6, 0xff, 0x72, 0x4a, 0xae, 0xff, 0x6e, 0x4c, 0xa5, 0xff,
0x70, 0x4a, 0xab, 0xff, 0x69, 0x3f, 0xab, 0xff, 0x70, 0x48, 0xb5, 0xff,
0x6e, 0x4b, 0xae, 0xff, 0x76, 0x57, 0xb3, 0xff, 0x7e, 0x5d, 0xb8, 0xff,
0x62, 0x3a, 0xa2, 0xff, 0x78, 0x53, 0xad, 0xff, 0x73, 0x54, 0x96, 0xff,
0x83, 0x64, 0xa2, 0xff, 0x6c, 0x48, 0x96, 0xff, 0x79, 0x5e, 0x9b, 0xff,
0x88, 0x6d, 0x9f, 0xff, 0x8b, 0x73, 0x9e, 0xff, 0x9c, 0x97, 0xa4, 0xff,
0x9f, 0xa3, 0x98, 0xff, 0x9f, 0xa3, 0x97, 0xff, 0x9e, 0xa2, 0x96, 0xff,
0x9e, 0xa2, 0x96, 0xff, 0x9f, 0xa3, 0x96, 0xff, 0x9e, 0xa3, 0x94, 0xff,
0x9d, 0xa3, 0x94, 0xff, 0x9c, 0xa2, 0x93, 0xff, 0x8b, 0x8b, 0x7d, 0xff,
0x62, 0x60, 0x53, 0xff, 0x61, 0x5c, 0x53, 0xff, 0x60, 0x59, 0x54, 0xff,
0x52, 0x4b, 0x48, 0xff, 0x4d, 0x45, 0x41, 0xff, 0x5a, 0x59, 0x57, 0xff,
0x74, 0x81, 0x87, 0xff, 0x72, 0x7d, 0x84, 0xff, 0x73, 0x7b, 0x82, 0xff,
0x71, 0x7c, 0x83, 0xff, 0x71, 0x7d, 0x85, 0xff, 0x6e, 0x7e, 0x87, 0xff,
0x6f, 0x80, 0x88, 0xff, 0x73, 0x81, 0x88, 0xff, 0x71, 0x7c, 0x83, 0xff,
0x6c, 0x78, 0x7f, 0xff, 0x67, 0x71, 0x79, 0xff, 0x66, 0x70, 0x78, 0xff,
0x69, 0x74, 0x7c, 0xff, 0x6e, 0x79, 0x80, 0xff, 0x72, 0x7d, 0x84, 0xff,
0x74, 0x80, 0x85, 0xff, 0x75, 0x82, 0x86, 0xff, 0x77, 0x84, 0x88, 0xff,
0x78, 0x85, 0x8d, 0xff, 0x77, 0x87, 0x91, 0xff, 0x78, 0x8a, 0x96, 0xff,
0x75, 0x89, 0x9b, 0xff, 0x79, 0x8d, 0x9b, 0xff, 0x7b, 0x80, 0x96, 0xff,
0x97, 0x87, 0xbb, 0xff, 0x85, 0x6c, 0xba, 0xff, 0x87, 0x6d, 0xba, 0xff,
0xa2, 0x94, 0xbf, 0xff, 0x79, 0x60, 0xab, 0xff, 0x8b, 0x6f, 0xc1, 0xff,
0x84, 0x68, 0xbb, 0xff, 0x82, 0x62, 0xbd, 0xff, 0x78, 0x52, 0xc4, 0xff,
0x78, 0x58, 0xbd, 0xff, 0x74, 0x55, 0xb7, 0xff, 0x7b, 0x5b, 0xc5, 0xff,
0x73, 0x58, 0xb5, 0xff, 0x77, 0x5d, 0xbd, 0xff, 0x89, 0x6f, 0xd3, 0xff,
0x6b, 0x50, 0xb3, 0xff, 0x77, 0x5a, 0xbe, 0xff, 0x6f, 0x52, 0xb3, 0xff,
0x79, 0x60, 0xa9, 0xff, 0x7a, 0x5f, 0xa8, 0xff, 0x70, 0x4d, 0xb0, 0xff,
0x72, 0x4d, 0xc1, 0xff, 0x70, 0x50, 0xbd, 0xff, 0x6f, 0x4c, 0xbd, 0xff,
0x55, 0x32, 0xba, 0xff, 0x53, 0x31, 0xb3, 0xff, 0x75, 0x55, 0xbc, 0xff,
0x79, 0x56, 0xc3, 0xff, 0x70, 0x4c, 0xc2, 0xff, 0x6c, 0x4d, 0xb8, 0xff,
0x67, 0x43, 0xb3, 0xff, 0x7b, 0x57, 0xbd, 0xff, 0x6b, 0x46, 0xab, 0xff,
0x87, 0x5f, 0xc8, 0xff, 0x64, 0x3d, 0xa9, 0xff, 0x6b, 0x47, 0xb5, 0xff,
0x74, 0x53, 0xba, 0xff, 0x6d, 0x4a, 0xb1, 0xff, 0x6e, 0x4c, 0xaf, 0xff,
0x72, 0x4f, 0xb1, 0xff, 0x75, 0x50, 0xb2, 0xff, 0x85, 0x5f, 0xcd, 0xff,
0x68, 0x3f, 0xab, 0xff, 0x68, 0x3e, 0xa8, 0xff, 0x62, 0x3a, 0x9e, 0xff,
0x64, 0x43, 0x99, 0xff, 0x6b, 0x42, 0xa5, 0xff, 0x5e, 0x36, 0x9c, 0xff,
0x6e, 0x46, 0xaf, 0xff, 0x7d, 0x5b, 0xc0, 0xff, 0x67, 0x4a, 0xa9, 0xff,
0x78, 0x5b, 0xaa, 0xff, 0x95, 0x7c, 0xbb, 0xff, 0xae, 0x95, 0xca, 0xff,
0x72, 0x54, 0x93, 0xff, 0x61, 0x3d, 0x8b, 0xff, 0x81, 0x61, 0xa1, 0xff,
0x91, 0x75, 0xb1, 0xff, 0x84, 0x66, 0x9b, 0xff, 0x7a, 0x60, 0x93, 0xff,
0x8c, 0x80, 0x9a, 0xff, 0xa4, 0xa8, 0x9d, 0xff, 0xa2, 0xa6, 0x9a, 0xff,
0xa3, 0xa7, 0x9b, 0xff, 0xa3, 0xa7, 0x9b, 0xff, 0xa2, 0xa7, 0x9a, 0xff,
0xa1, 0xa7, 0x98, 0xff, 0x9f, 0xa7, 0x98, 0xff, 0xa0, 0xa7, 0x98, 0xff,
0x9a, 0x9e, 0x8f, 0xff, 0x6f, 0x6e, 0x61, 0xff, 0x4f, 0x4b, 0x43, 0xff,
0x4f, 0x48, 0x48, 0xff, 0x55, 0x4c, 0x50, 0xff, 0x60, 0x57, 0x5c, 0xff,
0x6e, 0x6b, 0x76, 0xff, 0x78, 0x84, 0x8a, 0xff, 0x76, 0x80, 0x87, 0xff,
0x77, 0x7f, 0x86, 0xff, 0x75, 0x7f, 0x87, 0xff, 0x73, 0x81, 0x89, 0xff,
0x71, 0x81, 0x8b, 0xff, 0x71, 0x82, 0x8b, 0xff, 0x73, 0x81, 0x89, 0xff,
0x70, 0x7d, 0x85, 0xff, 0x6f, 0x7b, 0x83, 0xff, 0x6a, 0x74, 0x7d, 0xff,
0x68, 0x73, 0x7c, 0xff, 0x6a, 0x75, 0x7e, 0xff, 0x6e, 0x7a, 0x81, 0xff,
0x71, 0x7c, 0x82, 0xff, 0x74, 0x7f, 0x83, 0xff, 0x77, 0x80, 0x84, 0xff,
0x78, 0x82, 0x87, 0xff, 0x78, 0x84, 0x8c, 0xff, 0x78, 0x88, 0x93, 0xff,
0x7b, 0x8b, 0x9a, 0xff, 0x7d, 0x8e, 0xa0, 0xff, 0x7c, 0x89, 0x9b, 0xff,
0x8b, 0x86, 0xa7, 0xff, 0x98, 0x82, 0xb9, 0xff, 0x7e, 0x66, 0xa8, 0xff,
0x80, 0x67, 0xaf, 0xff, 0x6e, 0x54, 0xa0, 0xff, 0x81, 0x67, 0xb5, 0xff,
0x81, 0x65, 0xb8, 0xff, 0x84, 0x68, 0xba, 0xff, 0x7c, 0x59, 0xb8, 0xff,
0x63, 0x3a, 0xac, 0xff, 0x79, 0x54, 0xba, 0xff, 0x7b, 0x5b, 0xb9, 0xff,
0x7f, 0x5f, 0xc1, 0xff, 0x7e, 0x64, 0xc1, 0xff, 0x77, 0x5e, 0xc0, 0xff,
0x7e, 0x64, 0xca, 0xff, 0x76, 0x5a, 0xc2, 0xff, 0x7b, 0x5c, 0xc7, 0xff,
0x6e, 0x4f, 0xb1, 0xff, 0x76, 0x5a, 0xa6, 0xff, 0x70, 0x4f, 0xa2, 0xff,
0x72, 0x4d, 0xb5, 0xff, 0x68, 0x43, 0xb2, 0xff, 0x6f, 0x48, 0xb5, 0xff,
0x85, 0x62, 0xc3, 0xff, 0x70, 0x55, 0xb7, 0xff, 0x83, 0x67, 0xcd, 0xff,
0x6c, 0x49, 0xab, 0xff, 0x70, 0x4e, 0xb2, 0xff, 0x6a, 0x47, 0xb7, 0xff,
0x8b, 0x6f, 0xce, 0xff, 0x75, 0x54, 0xbc, 0xff, 0x68, 0x46, 0xa7, 0xff,
0x73, 0x4e, 0xb3, 0xff, 0x6a, 0x42, 0xa9, 0xff, 0x6e, 0x47, 0xae, 0xff,
0x6e, 0x4c, 0xb4, 0xff, 0x7f, 0x5d, 0xc3, 0xff, 0x79, 0x59, 0xb7, 0xff,
0x70, 0x4e, 0xaa, 0xff, 0x6a, 0x47, 0xa9, 0xff, 0x6b, 0x46, 0xa5, 0xff,
0x6b, 0x4a, 0xa8, 0xff, 0x72, 0x4e, 0xae, 0xff, 0x65, 0x3d, 0xa3, 0xff,
0x6e, 0x46, 0xac, 0xff, 0x67, 0x43, 0xa1, 0xff, 0x68, 0x3e, 0xa2, 0xff,
0x6c, 0x45, 0xa6, 0xff, 0x6e, 0x48, 0xb0, 0xff, 0x5a, 0x38, 0x9e, 0xff,
0x77, 0x59, 0xb8, 0xff, 0x56, 0x2f, 0x9c, 0xff, 0x71, 0x4b, 0xaf, 0xff,
0x77, 0x4f, 0xb0, 0xff, 0x6c, 0x47, 0x9e, 0xff, 0x6d, 0x4b, 0x92, 0xff,
0x6a, 0x47, 0x8e, 0xff, 0x8f, 0x6d, 0xb7, 0xff, 0x78, 0x55, 0x96, 0xff,
0x77, 0x59, 0x95, 0xff, 0x83, 0x74, 0x95, 0xff, 0xa9, 0xad, 0xa1, 0xff,
0xa7, 0xab, 0x9f, 0xff, 0xa6, 0xaa, 0x9f, 0xff, 0xa6, 0xaa, 0x9e, 0xff,
0xa6, 0xaa, 0x9d, 0xff, 0xa4, 0xaa, 0x9b, 0xff, 0xa3, 0xaa, 0x9b, 0xff,
0xa2, 0xa8, 0x99, 0xff, 0xa7, 0xab, 0x9b, 0xff, 0x80, 0x81, 0x70, 0xff,
0x4c, 0x4c, 0x3e, 0xff, 0x50, 0x4c, 0x48, 0xff, 0x5c, 0x56, 0x59, 0xff,
0x6c, 0x65, 0x6c, 0xff, 0x75, 0x75, 0x81, 0xff, 0x79, 0x86, 0x8c, 0xff,
0x77, 0x83, 0x87, 0xff, 0x75, 0x81, 0x85, 0xff, 0x76, 0x83, 0x88, 0xff,
0x76, 0x83, 0x8b, 0xff, 0x74, 0x81, 0x8c, 0xff, 0x72, 0x80, 0x8c, 0xff,
0x71, 0x80, 0x89, 0xff, 0x70, 0x7f, 0x88, 0xff, 0x6e, 0x7d, 0x86, 0xff,
0x6a, 0x79, 0x82, 0xff, 0x68, 0x76, 0x7f, 0xff, 0x6b, 0x77, 0x81, 0xff,
0x70, 0x7a, 0x83, 0xff, 0x70, 0x7c, 0x82, 0xff, 0x74, 0x7f, 0x83, 0xff,
0x75, 0x80, 0x85, 0xff, 0x78, 0x83, 0x8a, 0xff, 0x79, 0x87, 0x8d, 0xff,
0x79, 0x8a, 0x93, 0xff, 0x7c, 0x8c, 0x9d, 0xff, 0x79, 0x8f, 0xa4, 0xff,
0x81, 0x8a, 0x9c, 0xff, 0x85, 0x7a, 0xa3, 0xff, 0x87, 0x75, 0xad, 0xff,
0x7d, 0x69, 0xa6, 0xff, 0x85, 0x6b, 0xb0, 0xff, 0x74, 0x5a, 0x9f, 0xff,
0x7f, 0x64, 0xac, 0xff, 0x84, 0x67, 0xb7, 0xff, 0x79, 0x58, 0xb4, 0xff,
0x74, 0x56, 0xb9, 0xff, 0x7a, 0x59, 0xbc, 0xff, 0x78, 0x51, 0xc2, 0xff,
0x6c, 0x45, 0xb7, 0xff, 0x7b, 0x5f, 0xbd, 0xff, 0x7d, 0x64, 0xbe, 0xff,
0x7a, 0x5f, 0xbf, 0xff, 0x72, 0x56, 0xb4, 0xff, 0x78, 0x5c, 0xbc, 0xff,
0x7c, 0x5d, 0xc8, 0xff, 0x78, 0x52, 0xb9, 0xff, 0x72, 0x52, 0x9e, 0xff,
0x6e, 0x4d, 0xa0, 0xff, 0x77, 0x58, 0xbf, 0xff, 0x71, 0x56, 0xbd, 0xff,
0x6c, 0x46, 0xb8, 0xff, 0x58, 0x2d, 0xae, 0xff, 0x72, 0x4d, 0xbd, 0xff,
0x6a, 0x47, 0xae, 0xff, 0x6b, 0x46, 0xaf, 0xff, 0x6a, 0x41, 0xae, 0xff,
0x72, 0x4c, 0xb7, 0xff, 0x84, 0x62, 0xc3, 0xff, 0x7f, 0x57, 0xc1, 0xff,
0x68, 0x42, 0xa9, 0xff, 0x73, 0x4d, 0xae, 0xff, 0x6f, 0x48, 0xac, 0xff,
0x68, 0x42, 0xa0, 0xff, 0x66, 0x41, 0xa1, 0xff, 0x6d, 0x4a, 0xae, 0xff,
0x6a, 0x48, 0xad, 0xff, 0x66, 0x43, 0xa8, 0xff, 0x77, 0x52, 0xb7, 0xff,
0x58, 0x2e, 0x9e, 0xff, 0x62, 0x3a, 0xa4, 0xff, 0x6a, 0x42, 0xab, 0xff,
0x67, 0x41, 0xa4, 0xff, 0x6e, 0x4c, 0xa5, 0xff, 0x6e, 0x4b, 0xa6, 0xff,
0x68, 0x41, 0xa5, 0xff, 0x6b, 0x46, 0xac, 0xff, 0x57, 0x2f, 0xa6, 0xff,
0x63, 0x3d, 0xa7, 0xff, 0x69, 0x41, 0xa6, 0xff, 0x70, 0x4a, 0xaa, 0xff,
0x55, 0x2b, 0x98, 0xff, 0x58, 0x31, 0x98, 0xff, 0x69, 0x48, 0x99, 0xff,
0x69, 0x48, 0x8a, 0xff, 0x71, 0x4e, 0x99, 0xff, 0x6f, 0x4c, 0x94, 0xff,
0x78, 0x59, 0x95, 0xff, 0x7a, 0x5c, 0x98, 0xff, 0x76, 0x5f, 0x88, 0xff,
0xac, 0xaf, 0xa2, 0xff, 0xac, 0xae, 0xa0, 0xff, 0xab, 0xaa, 0xa5, 0xff,
0xa9, 0xac, 0x9e, 0xff, 0xa9, 0xac, 0x9d, 0xff, 0xaa, 0xad, 0x9e, 0xff,
0xa8, 0xab, 0x9c, 0xff, 0xa8, 0xab, 0x9c, 0xff, 0xa9, 0xac, 0x9d, 0xff,
0x7f, 0x82, 0x6f, 0xff, 0x44, 0x42, 0x2f, 0xff, 0x4c, 0x42, 0x3f, 0xff,
0x64, 0x5b, 0x61, 0xff, 0x70, 0x69, 0x73, 0xff, 0x7c, 0x7d, 0x87, 0xff,
0x7c, 0x89, 0x8e, 0xff, 0x79, 0x85, 0x8a, 0xff, 0x77, 0x83, 0x86, 0xff,
0x78, 0x84, 0x89, 0xff, 0x79, 0x85, 0x8c, 0xff, 0x76, 0x83, 0x8c, 0xff,
0x74, 0x82, 0x8c, 0xff, 0x71, 0x80, 0x89, 0xff, 0x70, 0x7f, 0x88, 0xff,
0x6c, 0x7b, 0x84, 0xff, 0x6c, 0x7b, 0x84, 0xff, 0x6c, 0x7a, 0x83, 0xff,
0x6d, 0x79, 0x83, 0xff, 0x72, 0x7d, 0x85, 0xff, 0x72, 0x7e, 0x83, 0xff,
0x76, 0x81, 0x85, 0xff, 0x77, 0x82, 0x86, 0xff, 0x7a, 0x85, 0x89, 0xff,
0x7b, 0x88, 0x8d, 0xff, 0x7b, 0x8d, 0x96, 0xff, 0x7f, 0x90, 0x9f, 0xff,
0x7e, 0x95, 0xa4, 0xff, 0x74, 0x7e, 0x8c, 0xff, 0x90, 0x86, 0xac, 0xff,
0x7c, 0x6b, 0x9f, 0xff, 0x98, 0x85, 0xbd, 0xff, 0x87, 0x6f, 0xae, 0xff,
0x78, 0x5d, 0xa4, 0xff, 0x79, 0x5c, 0xaa, 0xff, 0x82, 0x63, 0xb6, 0xff,
0x74, 0x56, 0xaa, 0xff, 0x71, 0x52, 0xb2, 0xff, 0x70, 0x4e, 0xb8, 0xff,
0x6c, 0x46, 0xba, 0xff, 0x6b, 0x4a, 0xb2, 0xff, 0x85, 0x6c, 0xbc, 0xff,
0x84, 0x6a, 0xb7, 0xff, 0x87, 0x6c, 0xb9, 0xff, 0x76, 0x58, 0xb1, 0xff,
0x6c, 0x4b, 0xad, 0xff, 0x76, 0x55, 0xb5, 0xff, 0x69, 0x47, 0xa7, 0xff,
0x6a, 0x4c, 0x9f, 0xff, 0x6b, 0x4a, 0xa9, 0xff, 0x71, 0x51, 0xbc, 0xff,
0x63, 0x46, 0xae, 0xff, 0x71, 0x4c, 0xbb, 0xff, 0x78, 0x51, 0xc5, 0xff,
0x72, 0x4f, 0xb6, 0xff, 0x66, 0x43, 0xaa, 0xff, 0x68, 0x43, 0xae, 0xff,
0x69, 0x46, 0xa8, 0xff, 0x5f, 0x42, 0x9c, 0xff, 0x6a, 0x4b, 0xad, 0xff,
0x67, 0x41, 0xae, 0xff, 0x68, 0x43, 0xa8, 0xff, 0x6d, 0x48, 0xab, 0xff,
0x63, 0x39, 0xa1, 0xff, 0x5b, 0x33, 0x94, 0xff, 0x67, 0x41, 0xa5, 0xff,
0x62, 0x3f, 0xa2, 0xff, 0x62, 0x42, 0x9f, 0xff, 0x69, 0x46, 0xa8, 0xff,
0x77, 0x4f, 0xba, 0xff, 0x65, 0x3e, 0xa3, 0xff, 0x5d, 0x38, 0x96, 0xff,
0x63, 0x3c, 0x9e, 0xff, 0x62, 0x3d, 0x9a, 0xff, 0x65, 0x42, 0x97, 0xff,
0x68, 0x45, 0x9b, 0xff, 0x5f, 0x3b, 0x96, 0xff, 0x63, 0x3c, 0xa5, 0xff,
0x63, 0x3c, 0xab, 0xff, 0x6f, 0x4c, 0xa9, 0xff, 0x56, 0x2f, 0x93, 0xff,
0x62, 0x3c, 0x9a, 0xff, 0x6f, 0x4c, 0xa8, 0xff, 0x61, 0x40, 0x95, 0xff,
0x6a, 0x49, 0x93, 0xff, 0x6f, 0x4f, 0x8f, 0xff, 0x63, 0x40, 0x89, 0xff,
0x6e, 0x4c, 0x91, 0xff, 0x8d, 0x6f, 0xab, 0xff, 0x6c, 0x4d, 0x8b, 0xff,
0x79, 0x62, 0x8d, 0xff, 0xad, 0xae, 0xa4, 0xff, 0xae, 0xb0, 0xa2, 0xff,
0xae, 0xaf, 0xa5, 0xff, 0xac, 0xaf, 0xa0, 0xff, 0xac, 0xaf, 0xa0, 0xff,
0xab, 0xae, 0x9f, 0xff, 0xaa, 0xad, 0x9e, 0xff, 0xab, 0xae, 0x9f, 0xff,
0xac, 0xaf, 0xa0, 0xff, 0x86, 0x88, 0x77, 0xff, 0x46, 0x44, 0x34, 0xff,
0x4d, 0x47, 0x40, 0xff, 0x6b, 0x63, 0x65, 0xff, 0x72, 0x6c, 0x72, 0xff,
0x76, 0x76, 0x7d, 0xff, 0x7f, 0x8b, 0x8e, 0xff, 0x7d, 0x88, 0x8a, 0xff,
0x7a, 0x86, 0x87, 0xff, 0x7a, 0x86, 0x89, 0xff, 0x7a, 0x86, 0x8c, 0xff,
0x77, 0x83, 0x8b, 0xff, 0x74, 0x81, 0x8a, 0xff, 0x71, 0x80, 0x89, 0xff,
0x6f, 0x7e, 0x87, 0xff, 0x6d, 0x7c, 0x85, 0xff, 0x6c, 0x7b, 0x84, 0xff,
0x6e, 0x7c, 0x85, 0xff, 0x6f, 0x7b, 0x85, 0xff, 0x73, 0x7d, 0x86, 0xff,
0x72, 0x7e, 0x84, 0xff, 0x75, 0x80, 0x84, 0xff, 0x77, 0x82, 0x85, 0xff,
0x7b, 0x86, 0x8a, 0xff, 0x7d, 0x8b, 0x8e, 0xff, 0x7d, 0x8e, 0x96, 0xff,
0x81, 0x92, 0x9f, 0xff, 0x81, 0x97, 0xa3, 0xff, 0x78, 0x81, 0x90, 0xff,
0x7f, 0x6f, 0x9f, 0xff, 0x7b, 0x62, 0xaa, 0xff, 0x81, 0x65, 0xb2, 0xff,
0x7c, 0x65, 0x9e, 0xff, 0x84, 0x6a, 0xaa, 0xff, 0x73, 0x54, 0xa4, 0xff,
0x77, 0x54, 0xae, 0xff, 0x77, 0x54, 0xb0, 0xff, 0x6e, 0x4d, 0xaa, 0xff,
0x6f, 0x4c, 0xba, 0xff, 0x6f, 0x4c, 0xbf, 0xff, 0x7d, 0x60, 0xbe, 0xff,
0x8b, 0x71, 0xb9, 0xff, 0x84, 0x68, 0xae, 0xff, 0x8e, 0x73, 0xb9, 0xff,
0x70, 0x4f, 0xa7, 0xff, 0x65, 0x3f, 0xa0, 0xff, 0x62, 0x41, 0x99, 0xff,
0x67, 0x48, 0xa2, 0xff, 0x66, 0x48, 0xa2, 0xff, 0x61, 0x41, 0xa3, 0xff,
0x62, 0x41, 0xaa, 0xff, 0x65, 0x42, 0xad, 0xff, 0x59, 0x2f, 0xa6, 0xff,
0x59, 0x2e, 0xa9, 0xff, 0x65, 0x3d, 0xb0, 0xff, 0x68, 0x44, 0xa9, 0xff,
0x67, 0x44, 0xa7, 0xff, 0x62, 0x40, 0xa5, 0xff, 0x68, 0x48, 0xb0, 0xff,
0x72, 0x4f, 0xc3, 0xff, 0x6d, 0x47, 0xb7, 0xff, 0x6b, 0x47, 0xa8, 0xff,
0x5e, 0x39, 0x99, 0xff, 0x61, 0x38, 0x98, 0xff, 0x63, 0x3f, 0x93, 0xff,
0x6c, 0x4b, 0x9d, 0xff, 0x6b, 0x48, 0xa7, 0xff, 0x5d, 0x3b, 0x98, 0xff,
0x61, 0x3c, 0x9f, 0xff, 0x5f, 0x35, 0xa2, 0xff, 0x66, 0x40, 0xa0, 0xff,
0x63, 0x3d, 0x9b, 0xff, 0x66, 0x3f, 0xa0, 0xff, 0x60, 0x3a, 0x98, 0xff,
0x59, 0x36, 0x8d, 0xff, 0x56, 0x32, 0x8c, 0xff, 0x64, 0x3f, 0x95, 0xff,
0x54, 0x2b, 0x95, 0xff, 0x6b, 0x46, 0xab, 0xff, 0x6d, 0x49, 0xa4, 0xff,
0x60, 0x38, 0x9b, 0xff, 0x5d, 0x34, 0x96, 0xff, 0x63, 0x41, 0x95, 0xff,
0x62, 0x42, 0x91, 0xff, 0x64, 0x41, 0x8f, 0xff, 0x63, 0x3f, 0x83, 0xff,
0x62, 0x41, 0x85, 0xff, 0x75, 0x54, 0x97, 0xff, 0x75, 0x57, 0x91, 0xff,
0x6b, 0x4c, 0x8a, 0xff, 0x77, 0x5f, 0x8c, 0xff, 0xab, 0xab, 0xa5, 0xff,
0xaf, 0xb2, 0xa3, 0xff, 0xae, 0xaf, 0xa4, 0xff, 0xad, 0xb0, 0xa0, 0xff,
0xad, 0xaf, 0xa2, 0xff, 0xac, 0xaf, 0xa0, 0xff, 0xac, 0xaf, 0xa0, 0xff,
0xac, 0xaf, 0xa0, 0xff, 0xab, 0xae, 0x9f, 0xff, 0xa3, 0xa5, 0x95, 0xff,
0x78, 0x78, 0x68, 0xff, 0x58, 0x54, 0x4a, 0xff, 0x71, 0x6c, 0x6a, 0xff,
0x7c, 0x79, 0x7d, 0xff, 0x7e, 0x7c, 0x82, 0xff, 0x82, 0x8e, 0x91, 0xff,
0x81, 0x8a, 0x8c, 0xff, 0x7e, 0x88, 0x88, 0xff, 0x7d, 0x87, 0x8a, 0xff,
0x7a, 0x85, 0x8a, 0xff, 0x78, 0x83, 0x8a, 0xff, 0x74, 0x80, 0x88, 0xff,
0x6f, 0x7e, 0x87, 0xff, 0x6c, 0x7b, 0x84, 0xff, 0x6c, 0x7b, 0x84, 0xff,
0x6a, 0x79, 0x82, 0xff, 0x6d, 0x7b, 0x85, 0xff, 0x6f, 0x7b, 0x85, 0xff,
0x73, 0x7d, 0x86, 0xff, 0x72, 0x7e, 0x84, 0xff, 0x75, 0x80, 0x84, 0xff,
0x76, 0x82, 0x84, 0xff, 0x7b, 0x87, 0x89, 0xff, 0x7e, 0x8d, 0x8e, 0xff,
0x7f, 0x91, 0x97, 0xff, 0x83, 0x95, 0xa1, 0xff, 0x83, 0x99, 0xa4, 0xff,
0x7e, 0x85, 0x96, 0xff, 0x8b, 0x77, 0xac, 0xff, 0x6d, 0x51, 0x9c, 0xff,
0x6d, 0x50, 0x9e, 0xff, 0x75, 0x59, 0x9e, 0xff, 0x6e, 0x52, 0x97, 0xff,
0x69, 0x4a, 0x95, 0xff, 0x74, 0x54, 0xa7, 0xff, 0x74, 0x52, 0xa9, 0xff,
0x71, 0x4e, 0xa8, 0xff, 0x60, 0x3e, 0xa9, 0xff, 0x6c, 0x4f, 0xb7, 0xff,
0x7b, 0x62, 0xb7, 0xff, 0x7a, 0x5b, 0xa9, 0xff, 0x7b, 0x5f, 0xa5, 0xff,
0x71, 0x52, 0xa2, 0xff, 0x68, 0x45, 0x9f, 0xff, 0x6a, 0x47, 0xa1, 0xff,
0x65, 0x42, 0x9a, 0xff, 0x66, 0x42, 0xa2, 0xff, 0x68, 0x48, 0xa5, 0xff,
0x59, 0x3b, 0x97, 0xff, 0x65, 0x41, 0xa1, 0xff, 0x5f, 0x36, 0x9c, 0xff,
0x5a, 0x32, 0x9f, 0xff, 0x5e, 0x35, 0xa8, 0xff, 0x60, 0x34, 0xaa, 0xff,
0x5f, 0x38, 0xa0, 0xff, 0x6b, 0x46, 0xa9, 0xff, 0x66, 0x3c, 0xb1, 0xff,
0x6c, 0x45, 0xb8, 0xff, 0x6e, 0x49, 0xb7, 0xff, 0x6a, 0x42, 0xac, 0xff,
0x59, 0x33, 0x92, 0xff, 0x6b, 0x45, 0xa1, 0xff, 0x67, 0x3c, 0x9c, 0xff,
0x60, 0x39, 0x92, 0xff, 0x60, 0x3b, 0x95, 0xff, 0x5c, 0x38, 0x98, 0xff,
0x67, 0x43, 0xa0, 0xff, 0x60, 0x3c, 0x98, 0xff, 0x5b, 0x35, 0x93, 0xff,
0x5e, 0x38, 0x95, 0xff, 0x4a, 0x24, 0x7e, 0xff, 0x65, 0x3e, 0x9d, 0xff,
0x5a, 0x32, 0x90, 0xff, 0x58, 0x32, 0x8a, 0xff, 0x5d, 0x36, 0x91, 0xff,
0x5a, 0x32, 0x8e, 0xff, 0x5a, 0x31, 0x99, 0xff, 0x5c, 0x39, 0x96, 0xff,
0x57, 0x30, 0x92, 0xff, 0x5f, 0x35, 0x97, 0xff, 0x64, 0x3b, 0x99, 0xff,
0x5f, 0x3e, 0x8d, 0xff, 0x5d, 0x3b, 0x8d, 0xff, 0x6a, 0x44, 0x95, 0xff,
0x64, 0x40, 0x82, 0xff, 0x6e, 0x4e, 0x8f, 0xff, 0x73, 0x53, 0x94, 0xff,
0x73, 0x55, 0x8f, 0xff, 0x67, 0x49, 0x87, 0xff, 0x7a, 0x61, 0x91, 0xff,
0xaa, 0xa9, 0xa7, 0xff, 0xaf, 0xb2, 0xa2, 0xff, 0xae, 0xb1, 0xa3, 0xff,
0xae, 0xb2, 0xa0, 0xff, 0xae, 0xb1, 0xa3, 0xff, 0xad, 0xb0, 0xa1, 0xff,
0xad, 0xb0, 0xa1, 0xff, 0xac, 0xaf, 0xa0, 0xff, 0xab, 0xae, 0x9f, 0xff,
0xac, 0xae, 0xa0, 0xff, 0xa1, 0xa1, 0x93, 0xff, 0x71, 0x6f, 0x64, 0xff,
0x73, 0x71, 0x6a, 0xff, 0x7e, 0x7d, 0x7e, 0xff, 0x82, 0x80, 0x86, 0xff,
0x85, 0x8f, 0x93, 0xff, 0x83, 0x8d, 0x8e, 0xff, 0x81, 0x8b, 0x8b, 0xff,
0x7d, 0x87, 0x8a, 0xff, 0x7a, 0x86, 0x89, 0xff, 0x78, 0x83, 0x89, 0xff,
0x74, 0x80, 0x87, 0xff, 0x6d, 0x7c, 0x85, 0xff, 0x6b, 0x7a, 0x83, 0xff,
0x6a, 0x79, 0x82, 0xff, 0x69, 0x78, 0x81, 0xff, 0x6b, 0x79, 0x83, 0xff,
0x70, 0x7b, 0x84, 0xff, 0x73, 0x7d, 0x86, 0xff, 0x73, 0x7e, 0x83, 0xff,
0x75, 0x7f, 0x83, 0xff, 0x76, 0x81, 0x83, 0xff, 0x7a, 0x87, 0x89, 0xff,
0x7e, 0x8d, 0x8f, 0xff, 0x81, 0x93, 0x99, 0xff, 0x86, 0x98, 0xa2, 0xff,
0x86, 0x9b, 0xa5, 0xff, 0x86, 0x8c, 0xa1, 0xff, 0x8a, 0x76, 0xa7, 0xff,
0x7a, 0x63, 0x9c, 0xff, 0x72, 0x59, 0x93, 0xff, 0x75, 0x58, 0x9e, 0xff,
0x71, 0x55, 0x9a, 0xff, 0x68, 0x4b, 0x90, 0xff, 0x70, 0x51, 0x9d, 0xff,
0x6e, 0x4b, 0xa1, 0xff, 0x65, 0x43, 0x9b, 0xff, 0x74, 0x52, 0xbd, 0xff,
0x65, 0x48, 0xae, 0xff, 0x7a, 0x60, 0xb3, 0xff, 0x71, 0x50, 0xa3, 0xff,
0x71, 0x53, 0x9e, 0xff, 0x74, 0x51, 0xaa, 0xff, 0x65, 0x41, 0x9c, 0xff,
0x5b, 0x3a, 0x8f, 0xff, 0x5f, 0x3c, 0x97, 0xff, 0x5e, 0x36, 0x9d, 0xff,
0x59, 0x38, 0x95, 0xff, 0x5a, 0x3c, 0x90, 0xff, 0x5c, 0x38, 0x93, 0xff,
0x5f, 0x33, 0x9b, 0xff, 0x57, 0x2e, 0x99, 0xff, 0x5a, 0x32, 0x9b, 0xff,
0x6d, 0x42, 0xb5, 0xff, 0x60, 0x34, 0xaa, 0xff, 0x61, 0x37, 0xa9, 0xff,
0x62, 0x39, 0xa8, 0xff, 0x69, 0x46, 0xaa, 0xff, 0x78, 0x57, 0xb3, 0xff,
0x5f, 0x39, 0x99, 0xff, 0x5e, 0x37, 0x94, 0xff, 0x68, 0x42, 0x97, 0xff,
0x58, 0x2f, 0x89, 0xff, 0x59, 0x31, 0x8a, 0xff, 0x60, 0x3a, 0x97, 0xff,
0x5d, 0x38, 0x9b, 0xff, 0x61, 0x3c, 0x9b, 0xff, 0x5f, 0x3b, 0x93, 0xff,
0x5d, 0x3a, 0x93, 0xff, 0x54, 0x2c, 0x8a, 0xff, 0x5b, 0x36, 0x8d, 0xff,
0x65, 0x3f, 0x98, 0xff, 0x5b, 0x35, 0x8c, 0xff, 0x57, 0x34, 0x86, 0xff,
0x4e, 0x2b, 0x80, 0xff, 0x5b, 0x32, 0x90, 0xff, 0x60, 0x38, 0x9c, 0xff,
0x59, 0x34, 0x93, 0xff, 0x5c, 0x34, 0x9a, 0xff, 0x5c, 0x35, 0x91, 0xff,
0x60, 0x3a, 0x91, 0xff, 0x60, 0x3f, 0x8c, 0xff, 0x57, 0x34, 0x88, 0xff,
0x5b, 0x35, 0x87, 0xff, 0x5f, 0x3e, 0x7b, 0xff, 0x60, 0x40, 0x7f, 0xff,
0x6b, 0x4b, 0x8b, 0xff, 0x6a, 0x4c, 0x86, 0xff, 0x65, 0x46, 0x83, 0xff,
0x6e, 0x55, 0x85, 0xff, 0xab, 0xa9, 0xa9, 0xff, 0xaf, 0xb2, 0xa3, 0xff,
0xaf, 0xb2, 0xa3, 0xff, 0xaf, 0xb2, 0xa2, 0xff, 0xaf, 0xb1, 0xa3, 0xff,
0xae, 0xb1, 0xa2, 0xff, 0xae, 0xb1, 0xa2, 0xff, 0xad, 0xb0, 0xa1, 0xff,
0xad, 0xb0, 0xa1, 0xff, 0xac, 0xaf, 0xa1, 0xff, 0xab, 0xac, 0x9e, 0xff,
0x87, 0x87, 0x78, 0xff, 0x59, 0x58, 0x4f, 0xff, 0x5a, 0x59, 0x57, 0xff,
0x73, 0x71, 0x75, 0xff, 0x85, 0x91, 0x97, 0xff, 0x83, 0x8e, 0x93, 0xff,
0x80, 0x8d, 0x8e, 0xff, 0x7c, 0x89, 0x8b, 0xff, 0x7a, 0x86, 0x89, 0xff,
0x77, 0x83, 0x88, 0xff, 0x73, 0x80, 0x85, 0xff, 0x6e, 0x7a, 0x84, 0xff,
0x6a, 0x78, 0x81, 0xff, 0x68, 0x75, 0x7e, 0xff, 0x66, 0x73, 0x7d, 0xff,
0x6a, 0x76, 0x7f, 0xff, 0x70, 0x7b, 0x83, 0xff, 0x72, 0x7c, 0x84, 0xff,
0x72, 0x7d, 0x80, 0xff, 0x75, 0x7e, 0x81, 0xff, 0x75, 0x81, 0x80, 0xff,
0x7a, 0x87, 0x89, 0xff, 0x81, 0x90, 0x92, 0xff, 0x82, 0x93, 0x99, 0xff,
0x87, 0x99, 0xa0, 0xff, 0x86, 0x9b, 0xa3, 0xff, 0x7d, 0x87, 0xa5, 0xff,
0x82, 0x64, 0x9a, 0xff, 0x6f, 0x57, 0x8d, 0xff, 0x6e, 0x50, 0x8d, 0xff,
0x68, 0x4e, 0x89, 0xff, 0x74, 0x59, 0x98, 0xff, 0x6b, 0x50, 0x8e, 0xff,
0x71, 0x53, 0x9a, 0xff, 0x6d, 0x4b, 0xa2, 0xff, 0x5f, 0x3f, 0x97, 0xff,
0x6d, 0x45, 0xba, 0xff, 0x60, 0x3d, 0xa8, 0xff, 0x6d, 0x50, 0x9f, 0xff,
0x78, 0x59, 0xa6, 0xff, 0x6e, 0x4b, 0x99, 0xff, 0x71, 0x53, 0x9b, 0xff,
0x64, 0x41, 0x97, 0xff, 0x5c, 0x3a, 0x91, 0xff, 0x63, 0x3f, 0x9a, 0xff,
0x63, 0x3d, 0xa1, 0xff, 0x57, 0x35, 0x8e, 0xff, 0x51, 0x2f, 0x85, 0xff,
0x5d, 0x3a, 0x98, 0xff, 0x54, 0x2f, 0x95, 0xff, 0x61, 0x3a, 0xa0, 0xff,
0x5e, 0x37, 0x9b, 0xff, 0x62, 0x37, 0xa8, 0xff, 0x58, 0x2c, 0xa2, 0xff,
0x4f, 0x25, 0x9b, 0xff, 0x5c, 0x39, 0xa7, 0xff, 0x56, 0x2e, 0xa0, 0xff,
0x54, 0x27, 0x9c, 0xff, 0x6e, 0x46, 0xa4, 0xff, 0x56, 0x31, 0x83, 0xff,
0x5b, 0x33, 0x86, 0xff, 0x55, 0x2d, 0x7e, 0xff, 0x6e, 0x49, 0x9d, 0xff,
0x62, 0x40, 0x97, 0xff, 0x50, 0x30, 0x94, 0xff, 0x54, 0x33, 0x8a, 0xff,
0x61, 0x40, 0x91, 0xff, 0x59, 0x33, 0x97, 0xff, 0x59, 0x32, 0x8d, 0xff,
0x56, 0x32, 0x8a, 0xff, 0x50, 0x29, 0x85, 0xff, 0x4e, 0x27, 0x7e, 0xff,
0x5d, 0x3c, 0x8a, 0xff, 0x57, 0x39, 0x89, 0xff, 0x50, 0x2c, 0x84, 0xff,
0x4e, 0x26, 0x85, 0xff, 0x52, 0x2b, 0x8d, 0xff, 0x58, 0x33, 0x90, 0xff,
0x5a, 0x3a, 0x8f, 0xff, 0x64, 0x41, 0x92, 0xff, 0x5b, 0x3a, 0x8c, 0xff,
0x63, 0x42, 0x95, 0xff, 0x59, 0x36, 0x84, 0xff, 0x64, 0x41, 0x84, 0xff,
0x60, 0x40, 0x82, 0xff, 0x66, 0x48, 0x86, 0xff, 0x6d, 0x50, 0x89, 0xff,
0x66, 0x49, 0x80, 0xff, 0x76, 0x5f, 0x8a, 0xff, 0xac, 0xaa, 0xa7, 0xff,
0xb2, 0xb5, 0xa8, 0xff, 0xb0, 0xb2, 0xa6, 0xff, 0xaf, 0xb2, 0xa3, 0xff,
0xae, 0xb2, 0xa1, 0xff, 0xae, 0xb1, 0xa2, 0xff, 0xae, 0xb1, 0xa2, 0xff,
0xae, 0xb1, 0xa2, 0xff, 0xad, 0xb0, 0xa1, 0xff, 0xac, 0xaf, 0xa0, 0xff,
0xac, 0xaf, 0x9e, 0xff, 0x88, 0x89, 0x79, 0xff, 0x50, 0x50, 0x43, 0xff,
0x4d, 0x4a, 0x42, 0xff, 0x60, 0x5b, 0x5a, 0xff, 0x85, 0x91, 0x98, 0xff,
0x83, 0x90, 0x96, 0xff, 0x81, 0x8d, 0x90, 0xff, 0x7d, 0x89, 0x8e, 0xff,
0x7a, 0x86, 0x8b, 0xff, 0x77, 0x82, 0x89, 0xff, 0x73, 0x7e, 0x86, 0xff,
0x6c, 0x78, 0x82, 0xff, 0x68, 0x74, 0x7e, 0xff, 0x65, 0x71, 0x7b, 0xff,
0x63, 0x6f, 0x79, 0xff, 0x67, 0x73, 0x7c, 0xff, 0x6e, 0x77, 0x7f, 0xff,
0x70, 0x7a, 0x80, 0xff, 0x70, 0x79, 0x7d, 0xff, 0x76, 0x7f, 0x7f, 0xff,
0x76, 0x81, 0x81, 0xff, 0x7b, 0x87, 0x87, 0xff, 0x81, 0x8f, 0x91, 0xff,
0x85, 0x95, 0x9a, 0xff, 0x8a, 0x9b, 0xa1, 0xff, 0x80, 0x95, 0x9d, 0xff,
0x7c, 0x87, 0xa1, 0xff, 0x85, 0x6b, 0x9b, 0xff, 0x70, 0x5b, 0x91, 0xff,
0x78, 0x5b, 0x95, 0xff, 0x71, 0x56, 0x96, 0xff, 0x6d, 0x51, 0x93, 0xff,
0x69, 0x4b, 0x90, 0xff, 0x66, 0x48, 0x90, 0xff, 0x6c, 0x49, 0xa1, 0xff,
0x65, 0x41, 0x9f, 0xff, 0x62, 0x3d, 0xa8, 0xff, 0x64, 0x44, 0xa3, 0xff,
0x74, 0x58, 0x9e, 0xff, 0x72, 0x55, 0x9b, 0xff, 0x67, 0x47, 0x8d, 0xff,
0x72, 0x52, 0x97, 0xff, 0x5c, 0x39, 0x8e, 0xff, 0x58, 0x34, 0x8f, 0xff,
0x5b, 0x37, 0x95, 0xff, 0x56, 0x33, 0x8e, 0xff, 0x57, 0x34, 0x8f, 0xff,
0x57, 0x34, 0x8f, 0xff, 0x52, 0x30, 0x88, 0xff, 0x51, 0x2f, 0x87, 0xff,
0x55, 0x2d, 0x95, 0xff, 0x4e, 0x25, 0x94, 0xff, 0x55, 0x2d, 0x95, 0xff,
0x5c, 0x35, 0x9e, 0xff, 0x59, 0x30, 0xa0, 0xff, 0x48, 0x20, 0x96, 0xff,
0x60, 0x38, 0xa5, 0xff, 0x5b, 0x32, 0x9b, 0xff, 0x51, 0x28, 0x89, 0xff,
0x4f, 0x2c, 0x7c, 0xff, 0x4e, 0x28, 0x7e, 0xff, 0x52, 0x2a, 0x7a, 0xff,
0x4b, 0x26, 0x78, 0xff, 0x5f, 0x3b, 0x93, 0xff, 0x61, 0x41, 0x9b, 0xff,
0x60, 0x3b, 0x97, 0xff, 0x57, 0x32, 0x8c, 0xff, 0x51, 0x2f, 0x8b, 0xff,
0x5f, 0x38, 0x95, 0xff, 0x56, 0x30, 0x87, 0xff, 0x5d, 0x34, 0x8f, 0xff,
0x53, 0x2b, 0x81, 0xff, 0x4a, 0x27, 0x75, 0xff, 0x54, 0x34, 0x86, 0xff,
0x56, 0x2d, 0x8d, 0xff, 0x57, 0x2f, 0x8d, 0xff, 0x4c, 0x27, 0x83, 0xff,
0x55, 0x31, 0x8c, 0xff, 0x55, 0x32, 0x8d, 0xff, 0x58, 0x36, 0x83, 0xff,
0x59, 0x3a, 0x85, 0xff, 0x5b, 0x3c, 0x89, 0xff, 0x57, 0x36, 0x80, 0xff,
0x53, 0x32, 0x70, 0xff, 0x56, 0x38, 0x78, 0xff, 0x67, 0x48, 0x85, 0xff,
0x70, 0x53, 0x8a, 0xff, 0x62, 0x47, 0x79, 0xff, 0x6f, 0x59, 0x7f, 0xff,
0xae, 0xaf, 0xa8, 0xff, 0xb2, 0xb5, 0xa6, 0xff, 0xb1, 0xb3, 0xa7, 0xff,
0xb0, 0xb3, 0xa6, 0xff, 0xaf, 0xb2, 0xa2, 0xff, 0xb0, 0xb3, 0xa4, 0xff,
0xb0, 0xb3, 0xa4, 0xff, 0xae, 0xb1, 0xa2, 0xff, 0xad, 0xb0, 0xa1, 0xff,
0xac, 0xaf, 0xa0, 0xff, 0xae, 0xb1, 0xa1, 0xff, 0x90, 0x92, 0x82, 0xff,
0x53, 0x53, 0x45, 0xff, 0x4a, 0x47, 0x3f, 0xff, 0x5c, 0x57, 0x56, 0xff,
0x82, 0x91, 0x9a, 0xff, 0x80, 0x90, 0x99, 0xff, 0x81, 0x8e, 0x94, 0xff,
0x7c, 0x89, 0x8f, 0xff, 0x79, 0x85, 0x8d, 0xff, 0x75, 0x81, 0x8a, 0xff,
0x71, 0x7d, 0x87, 0xff, 0x6d, 0x78, 0x82, 0xff, 0x68, 0x72, 0x7c, 0xff,
0x64, 0x6e, 0x78, 0xff, 0x62, 0x6d, 0x77, 0xff, 0x66, 0x70, 0x79, 0xff,
0x6a, 0x74, 0x7b, 0xff, 0x6f, 0x78, 0x7c, 0xff, 0x72, 0x7a, 0x7c, 0xff,
0x76, 0x7e, 0x7e, 0xff, 0x78, 0x82, 0x80, 0xff, 0x7c, 0x88, 0x88, 0xff,
0x83, 0x90, 0x91, 0xff, 0x89, 0x97, 0x9a, 0xff, 0x8d, 0x9d, 0xa3, 0xff,
0x81, 0x94, 0xa3, 0xff, 0x75, 0x81, 0x9e, 0xff, 0x71, 0x57, 0x8b, 0xff,
0x6f, 0x56, 0x95, 0xff, 0x7a, 0x5e, 0x9d, 0xff, 0x6c, 0x51, 0x91, 0xff,
0x6c, 0x4e, 0x95, 0xff, 0x6a, 0x4c, 0x94, 0xff, 0x69, 0x4a, 0x94, 0xff,
0x66, 0x45, 0x97, 0xff, 0x64, 0x40, 0x9e, 0xff, 0x60, 0x3c, 0xa0, 0xff,
0x68, 0x48, 0xa0, 0xff, 0x70, 0x53, 0x9a, 0xff, 0x6d, 0x4f, 0x93, 0xff,
0x6e, 0x4d, 0x90, 0xff, 0x71, 0x51, 0x93, 0xff, 0x59, 0x34, 0x88, 0xff,
0x5b, 0x37, 0x90, 0xff, 0x56, 0x32, 0x8f, 0xff, 0x55, 0x30, 0x8e, 0xff,
0x58, 0x31, 0x95, 0xff, 0x54, 0x2d, 0x90, 0xff, 0x4f, 0x2b, 0x84, 0xff,
0x4c, 0x2b, 0x7d, 0xff, 0x5b, 0x38, 0x93, 0xff, 0x4f, 0x27, 0x91, 0xff,
0x62, 0x3a, 0xa3, 0xff, 0x4f, 0x26, 0x91, 0xff, 0x48, 0x1f, 0x8d, 0xff,
0x6c, 0x41, 0xb2, 0xff, 0x52, 0x2a, 0x92, 0xff, 0x61, 0x3b, 0x9a, 0xff,
0x4b, 0x24, 0x84, 0xff, 0x52, 0x30, 0x85, 0xff, 0x5a, 0x35, 0x8d, 0xff,
0x4b, 0x27, 0x74, 0xff, 0x55, 0x2f, 0x7d, 0xff, 0x5b, 0x35, 0x8c, 0xff,
0x51, 0x2f, 0x83, 0xff, 0x59, 0x32, 0x8c, 0xff, 0x5a, 0x33, 0x90, 0xff,
0x5f, 0x3f, 0x97, 0xff, 0x4c, 0x26, 0x82, 0xff, 0x53, 0x2e, 0x82, 0xff,
0x50, 0x28, 0x7e, 0xff, 0x48, 0x1f, 0x74, 0xff, 0x4e, 0x2b, 0x79, 0xff,
0x4d, 0x2c, 0x7e, 0xff, 0x4c, 0x25, 0x82, 0xff, 0x53, 0x2d, 0x87, 0xff,
0x5d, 0x3a, 0x90, 0xff, 0x4f, 0x2c, 0x84, 0xff, 0x47, 0x25, 0x7e, 0xff,
0x53, 0x30, 0x7f, 0xff, 0x4a, 0x2a, 0x76, 0xff, 0x55, 0x36, 0x85, 0xff,
0x58, 0x37, 0x82, 0xff, 0x54, 0x33, 0x72, 0xff, 0x5b, 0x3c, 0x7b, 0xff,
0x5d, 0x3e, 0x79, 0xff, 0x75, 0x5a, 0x8d, 0xff, 0x65, 0x4c, 0x78, 0xff,
0x6f, 0x5c, 0x7c, 0xff, 0xb3, 0xb4, 0xaa, 0xff, 0xb2, 0xb6, 0xa6, 0xff,
0xb2, 0xb5, 0xa6, 0xff, 0xb0, 0xb2, 0xa6, 0xff, 0xb0, 0xb3, 0xa4, 0xff,
0xb0, 0xb3, 0xa4, 0xff, 0xb0, 0xb3, 0xa4, 0xff, 0xae, 0xb1, 0xa2, 0xff,
0xad, 0xb0, 0xa1, 0xff, 0xad, 0xb0, 0xa1, 0xff, 0xac, 0xaf, 0x9f, 0xff,
0x92, 0x94, 0x83, 0xff, 0x4e, 0x4e, 0x41, 0xff, 0x43, 0x40, 0x38, 0xff,
0x5c, 0x57, 0x56, 0xff, 0x80, 0x90, 0x9c, 0xff, 0x7f, 0x8f, 0x99, 0xff,
0x7f, 0x8c, 0x94, 0xff, 0x7a, 0x87, 0x90, 0xff, 0x77, 0x83, 0x8d, 0xff,
0x73, 0x7f, 0x8a, 0xff, 0x70, 0x7b, 0x87, 0xff, 0x6c, 0x76, 0x80, 0xff,
0x67, 0x70, 0x7a, 0xff, 0x61, 0x6a, 0x74, 0xff, 0x60, 0x6a, 0x74, 0xff,
0x62, 0x6c, 0x75, 0xff, 0x68, 0x70, 0x76, 0xff, 0x6c, 0x74, 0x77, 0xff,
0x71, 0x79, 0x79, 0xff, 0x77, 0x7e, 0x7d, 0xff, 0x7a, 0x83, 0x81, 0xff,
0x7e, 0x89, 0x87, 0xff, 0x85, 0x90, 0x90, 0xff, 0x8b, 0x99, 0x9b, 0xff,
0x8f, 0x9e, 0xa3, 0xff, 0x7e, 0x91, 0xa3, 0xff, 0x78, 0x85, 0xa0, 0xff,
0x74, 0x5a, 0x8e, 0xff, 0x68, 0x51, 0x94, 0xff, 0x65, 0x49, 0x89, 0xff,
0x68, 0x4d, 0x8b, 0xff, 0x66, 0x49, 0x8f, 0xff, 0x61, 0x43, 0x8b, 0xff,
0x59, 0x3b, 0x82, 0xff, 0x5b, 0x3c, 0x88, 0xff, 0x59, 0x36, 0x8d, 0xff,
0x5e, 0x39, 0x9b, 0xff, 0x5e, 0x3a, 0x9c, 0xff, 0x60, 0x3d, 0x93, 0xff,
0x68, 0x45, 0x8e, 0xff, 0x66, 0x44, 0x89, 0xff, 0x63, 0x44, 0x84, 0xff,
0x61, 0x3d, 0x8e, 0xff, 0x56, 0x32, 0x85, 0xff, 0x46, 0x22, 0x78, 0xff,
0x54, 0x2e, 0x8f, 0xff, 0x52, 0x2b, 0x8d, 0xff, 0x52, 0x2c, 0x8b, 0xff,
0x57, 0x34, 0x8b, 0xff, 0x65, 0x43, 0x96, 0xff, 0x4d, 0x29, 0x88, 0xff,
0x47, 0x20, 0x86, 0xff, 0x49, 0x21, 0x8b, 0xff, 0x45, 0x20, 0x83, 0xff,
0x50, 0x2b, 0x8b, 0xff, 0x57, 0x2e, 0x95, 0xff, 0x4b, 0x20, 0x89, 0xff,
0x45, 0x1f, 0x80, 0xff, 0x4f, 0x27, 0x8d, 0xff, 0x55, 0x2f, 0x93, 0xff,
0x4b, 0x26, 0x82, 0xff, 0x4b, 0x28, 0x73, 0xff, 0x56, 0x2f, 0x7c, 0xff,
0x55, 0x2e, 0x85, 0xff, 0x4e, 0x2c, 0x7c, 0xff, 0x58, 0x30, 0x84, 0xff,
0x5b, 0x33, 0x8d, 0xff, 0x54, 0x32, 0x8d, 0xff, 0x51, 0x2d, 0x88, 0xff,
0x52, 0x2d, 0x7e, 0xff, 0x4e, 0x26, 0x79, 0xff, 0x46, 0x1e, 0x71, 0xff,
0x43, 0x1d, 0x6d, 0xff, 0x49, 0x25, 0x79, 0xff, 0x59, 0x34, 0x88, 0xff,
0x4b, 0x26, 0x7c, 0xff, 0x51, 0x2e, 0x85, 0xff, 0x55, 0x34, 0x86, 0xff,
0x53, 0x35, 0x83, 0xff, 0x5e, 0x3d, 0x88, 0xff, 0x50, 0x31, 0x7d, 0xff,
0x5c, 0x3d, 0x8a, 0xff, 0x4b, 0x2a, 0x72, 0xff, 0x53, 0x32, 0x70, 0xff,
0x56, 0x38, 0x75, 0xff, 0x66, 0x48, 0x80, 0xff, 0x6e, 0x55, 0x82, 0xff,
0x62, 0x4b, 0x72, 0xff, 0x72, 0x60, 0x7b, 0xff, 0xb7, 0xb8, 0xab, 0xff,
0xb3, 0xb7, 0xa3, 0xff, 0xb3, 0xb6, 0xa7, 0xff, 0xb1, 0xb3, 0xa8, 0xff,
0xb1, 0xb4, 0xa5, 0xff, 0xb0, 0xb3, 0xa4, 0xff, 0xb0, 0xb3, 0xa4, 0xff,
0xaf, 0xb2, 0xa3, 0xff, 0xae, 0xb1, 0xa2, 0xff, 0xae, 0xb1, 0xa2, 0xff,
0xac, 0xaf, 0x9f, 0xff, 0xa1, 0xa2, 0x92, 0xff, 0x56, 0x56, 0x49, 0xff,
0x45, 0x42, 0x3a, 0xff, 0x5e, 0x59, 0x57, 0xff, 0x7f, 0x91, 0x9d, 0xff,
0x7e, 0x8f, 0x9b, 0xff, 0x7d, 0x8c, 0x94, 0xff, 0x78, 0x87, 0x90, 0xff,
0x75, 0x83, 0x8d, 0xff, 0x71, 0x7e, 0x8a, 0xff, 0x6d, 0x79, 0x86, 0xff,
0x6a, 0x73, 0x7e, 0xff, 0x64, 0x6d, 0x77, 0xff, 0x61, 0x68, 0x73, 0xff,
0x5f, 0x66, 0x70, 0xff, 0x62, 0x68, 0x70, 0xff, 0x64, 0x6a, 0x6e, 0xff,
0x68, 0x6e, 0x71, 0xff, 0x6b, 0x72, 0x72, 0xff, 0x73, 0x7a, 0x79, 0xff,
0x7a, 0x81, 0x7f, 0xff, 0x80, 0x89, 0x88, 0xff, 0x87, 0x92, 0x8f, 0xff,
0x8c, 0x9a, 0x99, 0xff, 0x92, 0x9f, 0xa1, 0xff, 0x83, 0x97, 0xa3, 0xff,
0x73, 0x82, 0x9a, 0xff, 0x74, 0x61, 0x91, 0xff, 0x61, 0x47, 0x86, 0xff,
0x5e, 0x44, 0x80, 0xff, 0x63, 0x49, 0x84, 0xff, 0x6e, 0x4f, 0x94, 0xff,
0x5b, 0x3d, 0x87, 0xff, 0x54, 0x35, 0x7e, 0xff, 0x55, 0x35, 0x7d, 0xff,
0x55, 0x33, 0x83, 0xff, 0x5f, 0x3a, 0x99, 0xff, 0x56, 0x2f, 0x99, 0xff,
0x58, 0x32, 0x93, 0xff, 0x65, 0x40, 0x8d, 0xff, 0x60, 0x3c, 0x82, 0xff,
0x66, 0x46, 0x87, 0xff, 0x5c, 0x38, 0x88, 0xff, 0x4f, 0x2e, 0x7c, 0xff,
0x48, 0x24, 0x76, 0xff, 0x4d, 0x27, 0x84, 0xff, 0x54, 0x2f, 0x88, 0xff,
0x4f, 0x2d, 0x81, 0xff, 0x4b, 0x28, 0x7a, 0xff, 0x45, 0x23, 0x76, 0xff,
0x49, 0x27, 0x7d, 0xff, 0x58, 0x34, 0x8f, 0xff, 0x44, 0x1d, 0x85, 0xff,
0x4a, 0x23, 0x88, 0xff, 0x47, 0x22, 0x7f, 0xff, 0x46, 0x21, 0x7b, 0xff,
0x49, 0x20, 0x84, 0xff, 0x5a, 0x35, 0x94, 0xff, 0x53, 0x2d, 0x8b, 0xff,
0x47, 0x20, 0x83, 0xff, 0x5b, 0x34, 0x8d, 0xff, 0x49, 0x25, 0x71, 0xff,
0x51, 0x2c, 0x77, 0xff, 0x5b, 0x33, 0x86, 0xff, 0x51, 0x2d, 0x7b, 0xff,
0x4e, 0x26, 0x77, 0xff, 0x56, 0x2e, 0x84, 0xff, 0x4d, 0x28, 0x84, 0xff,
0x48, 0x25, 0x7c, 0xff, 0x4c, 0x27, 0x79, 0xff, 0x4b, 0x24, 0x75, 0xff,
0x40, 0x19, 0x6a, 0xff, 0x42, 0x1e, 0x6c, 0xff, 0x53, 0x2f, 0x80, 0xff,
0x50, 0x2f, 0x7b, 0xff, 0x52, 0x2e, 0x7f, 0xff, 0x51, 0x2f, 0x83, 0xff,
0x50, 0x2f, 0x7f, 0xff, 0x56, 0x38, 0x81, 0xff, 0x57, 0x39, 0x83, 0xff,
0x4b, 0x2d, 0x75, 0xff, 0x53, 0x36, 0x7c, 0xff, 0x4d, 0x2e, 0x6f, 0xff,
0x4e, 0x30, 0x6a, 0xff, 0x58, 0x39, 0x76, 0xff, 0x60, 0x43, 0x79, 0xff,
0x61, 0x47, 0x75, 0xff, 0x5e, 0x48, 0x6f, 0xff, 0x7d, 0x6f, 0x83, 0xff,
0xb9, 0xba, 0xab, 0xff, 0xb4, 0xb7, 0xa5, 0xff, 0xb4, 0xb6, 0xa7, 0xff,
0xb4, 0xb5, 0xa8, 0xff, 0xb2, 0xb4, 0xa6, 0xff, 0xb1, 0xb3, 0xa5, 0xff,
0xb1, 0xb3, 0xa5, 0xff, 0xb1, 0xb3, 0xa5, 0xff, 0xb1, 0xb2, 0xa4, 0xff,
0xaf, 0xb1, 0xa2, 0xff, 0xae, 0xb1, 0xa1, 0xff, 0xad, 0xaf, 0x9f, 0xff,
0x78, 0x79, 0x6b, 0xff, 0x42, 0x3f, 0x36, 0xff, 0x5d, 0x57, 0x52, 0xff,
0x80, 0x93, 0xa2, 0xff, 0x7e, 0x91, 0x9c, 0xff, 0x7c, 0x8d, 0x98, 0xff,
0x76, 0x87, 0x92, 0xff, 0x74, 0x82, 0x8d, 0xff, 0x71, 0x7d, 0x87, 0xff,
0x6c, 0x77, 0x82, 0xff, 0x69, 0x73, 0x7e, 0xff, 0x63, 0x6a, 0x75, 0xff,
0x60, 0x66, 0x6f, 0xff, 0x5f, 0x61, 0x6b, 0xff, 0x60, 0x62, 0x69, 0xff,
0x60, 0x63, 0x67, 0xff, 0x63, 0x67, 0x68, 0xff, 0x67, 0x6d, 0x6c, 0xff,
0x6e, 0x76, 0x75, 0xff, 0x78, 0x7e, 0x7e, 0xff, 0x82, 0x89, 0x87, 0xff,
0x89, 0x93, 0x8d, 0xff, 0x8d, 0x98, 0x94, 0xff, 0x95, 0xa0, 0x9e, 0xff,
0x87, 0x9a, 0x9c, 0xff, 0x74, 0x84, 0x9c, 0xff, 0x69, 0x5b, 0x8b, 0xff,
0x6d, 0x51, 0x8b, 0xff, 0x61, 0x48, 0x82, 0xff, 0x65, 0x48, 0x80, 0xff,
0x6b, 0x4d, 0x8e, 0xff, 0x5e, 0x40, 0x8b, 0xff, 0x57, 0x35, 0x81, 0xff,
0x4e, 0x2c, 0x73, 0xff, 0x53, 0x30, 0x80, 0xff, 0x50, 0x2d, 0x85, 0xff,
0x55, 0x32, 0x97, 0xff, 0x58, 0x32, 0x93, 0xff, 0x59, 0x33, 0x7f, 0xff,
0x61, 0x3e, 0x81, 0xff, 0x5b, 0x3b, 0x7c, 0xff, 0x55, 0x30, 0x83, 0xff,
0x4d, 0x2d, 0x7d, 0xff, 0x49, 0x29, 0x7c, 0xff, 0x46, 0x22, 0x79, 0xff,
0x4a, 0x26, 0x7b, 0xff, 0x4e, 0x2a, 0x7c, 0xff, 0x4a, 0x27, 0x7a, 0xff,
0x45, 0x20, 0x77, 0xff, 0x4a, 0x24, 0x7f, 0xff, 0x4a, 0x23, 0x7f, 0xff,
0x4d, 0x26, 0x82, 0xff, 0x52, 0x2a, 0x89, 0xff, 0x45, 0x1d, 0x7b, 0xff,
0x51, 0x29, 0x89, 0xff, 0x50, 0x25, 0x8d, 0xff, 0x48, 0x1e, 0x85, 0xff,
0x53, 0x2c, 0x8c, 0xff, 0x55, 0x2c, 0x86, 0xff, 0x52, 0x27, 0x7b, 0xff,
0x48, 0x22, 0x6e, 0xff, 0x4d, 0x2a, 0x77, 0xff, 0x4f, 0x2c, 0x77, 0xff,
0x57, 0x32, 0x81, 0xff, 0x53, 0x2e, 0x7f, 0xff, 0x4d, 0x27, 0x7b, 0xff,
0x4a, 0x23, 0x78, 0xff, 0x4c, 0x24, 0x7c, 0xff, 0x50, 0x28, 0x7e, 0xff,
0x49, 0x23, 0x74, 0xff, 0x43, 0x20, 0x6c, 0xff, 0x3c, 0x19, 0x64, 0xff,
0x54, 0x30, 0x7c, 0xff, 0x48, 0x27, 0x72, 0xff, 0x4d, 0x2c, 0x77, 0xff,
0x4f, 0x2d, 0x79, 0xff, 0x4b, 0x28, 0x76, 0xff, 0x50, 0x2d, 0x7c, 0xff,
0x4c, 0x2d, 0x7c, 0xff, 0x4d, 0x2e, 0x78, 0xff, 0x4f, 0x32, 0x73, 0xff,
0x48, 0x2c, 0x68, 0xff, 0x4d, 0x2f, 0x6b, 0xff, 0x54, 0x34, 0x71, 0xff,
0x59, 0x3b, 0x6f, 0xff, 0x62, 0x47, 0x76, 0xff, 0x57, 0x44, 0x6c, 0xff,
0x95, 0x90, 0x98, 0xff, 0xb8, 0xb8, 0xaa, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb4, 0xb4, 0xa6, 0xff, 0xb4, 0xb4, 0xa6, 0xff, 0xb3, 0xb3, 0xa5, 0xff,
0xb2, 0xb2, 0xa4, 0xff, 0xb0, 0xb1, 0xa3, 0xff, 0xae, 0xb1, 0xa2, 0xff,
0xae, 0xb1, 0xa2, 0xff, 0x9e, 0x9e, 0x90, 0xff, 0x5e, 0x5b, 0x4c, 0xff,
0x5b, 0x54, 0x4b, 0xff, 0x81, 0x97, 0xa9, 0xff, 0x7c, 0x90, 0xa1, 0xff,
0x7a, 0x8c, 0x9a, 0xff, 0x76, 0x86, 0x93, 0xff, 0x72, 0x80, 0x8d, 0xff,
0x6f, 0x7b, 0x85, 0xff, 0x6c, 0x76, 0x80, 0xff, 0x66, 0x6e, 0x78, 0xff,
0x61, 0x67, 0x70, 0xff, 0x5c, 0x60, 0x68, 0xff, 0x59, 0x5c, 0x63, 0xff,
0x5b, 0x5c, 0x61, 0xff, 0x5a, 0x5c, 0x60, 0xff, 0x5c, 0x5f, 0x61, 0xff,
0x64, 0x69, 0x68, 0xff, 0x6d, 0x72, 0x71, 0xff, 0x75, 0x7b, 0x7b, 0xff,
0x80, 0x86, 0x85, 0xff, 0x86, 0x90, 0x8a, 0xff, 0x8c, 0x97, 0x93, 0xff,
0x93, 0x9e, 0x9d, 0xff, 0x8d, 0x9b, 0x9f, 0xff, 0x71, 0x82, 0x92, 0xff,
0x6c, 0x61, 0x8a, 0xff, 0x5f, 0x46, 0x7e, 0xff, 0x5d, 0x44, 0x7e, 0xff,
0x62, 0x48, 0x7a, 0xff, 0x5a, 0x41, 0x7a, 0xff, 0x62, 0x46, 0x8a, 0xff,
0x4a, 0x2d, 0x75, 0xff, 0x4a, 0x28, 0x73, 0xff, 0x4b, 0x29, 0x79, 0xff,
0x56, 0x35, 0x89, 0xff, 0x4e, 0x2b, 0x87, 0xff, 0x6b, 0x46, 0x9d, 0xff,
0x66, 0x42, 0x8b, 0xff, 0x5f, 0x3b, 0x7e, 0xff, 0x59, 0x38, 0x75, 0xff,
0x56, 0x33, 0x80, 0xff, 0x48, 0x26, 0x77, 0xff, 0x55, 0x32, 0x87, 0xff,
0x45, 0x1e, 0x77, 0xff, 0x42, 0x1e, 0x73, 0xff, 0x47, 0x23, 0x75, 0xff,
0x3f, 0x1b, 0x6f, 0xff, 0x4a, 0x24, 0x7b, 0xff, 0x51, 0x2a, 0x86, 0xff,
0x3f, 0x17, 0x74, 0xff, 0x46, 0x1e, 0x7d, 0xff, 0x4a, 0x21, 0x82, 0xff,
0x3e, 0x15, 0x76, 0xff, 0x45, 0x1c, 0x7d, 0xff, 0x40, 0x16, 0x7d, 0xff,
0x4b, 0x20, 0x87, 0xff, 0x45, 0x1c, 0x7f, 0xff, 0x46, 0x1c, 0x78, 0xff,
0x40, 0x17, 0x69, 0xff, 0x41, 0x1b, 0x67, 0xff, 0x52, 0x2d, 0x7e, 0xff,
0x42, 0x1c, 0x6e, 0xff, 0x4f, 0x2b, 0x76, 0xff, 0x5a, 0x37, 0x81, 0xff,
0x4b, 0x28, 0x73, 0xff, 0x4b, 0x27, 0x72, 0xff, 0x4e, 0x2a, 0x76, 0xff,
0x48, 0x22, 0x74, 0xff, 0x43, 0x1e, 0x6c, 0xff, 0x43, 0x20, 0x6a, 0xff,
0x4a, 0x27, 0x70, 0xff, 0x48, 0x25, 0x6f, 0xff, 0x48, 0x27, 0x71, 0xff,
0x4f, 0x2e, 0x78, 0xff, 0x52, 0x31, 0x7c, 0xff, 0x4e, 0x2d, 0x77, 0xff,
0x4d, 0x2c, 0x76, 0xff, 0x46, 0x27, 0x71, 0xff, 0x4a, 0x2b, 0x70, 0xff,
0x4a, 0x2d, 0x6b, 0xff, 0x55, 0x38, 0x74, 0xff, 0x52, 0x34, 0x6f, 0xff,
0x52, 0x34, 0x6d, 0xff, 0x64, 0x47, 0x79, 0xff, 0x5e, 0x44, 0x70, 0xff,
0x51, 0x40, 0x62, 0xff, 0xad, 0xaa, 0xac, 0xff, 0xb8, 0xb8, 0xaa, 0xff,
0xb6, 0xb6, 0xa8, 0xff, 0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb3, 0xb3, 0xa5, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb1, 0xb1, 0xa3, 0xff,
0xb1, 0xb2, 0xa4, 0xff, 0xae, 0xb2, 0xa3, 0xff, 0xa5, 0xa4, 0x96, 0xff,
0x69, 0x63, 0x56, 0xff, 0x4e, 0x48, 0x3c, 0xff, 0x7e, 0x97, 0xaf, 0xff,
0x7a, 0x92, 0xa9, 0xff, 0x78, 0x8d, 0x9e, 0xff, 0x73, 0x85, 0x94, 0xff,
0x71, 0x81, 0x8d, 0xff, 0x6f, 0x7a, 0x84, 0xff, 0x69, 0x73, 0x7c, 0xff,
0x66, 0x6c, 0x73, 0xff, 0x5f, 0x63, 0x6a, 0xff, 0x5b, 0x5e, 0x63, 0xff,
0x58, 0x59, 0x5e, 0xff, 0x59, 0x59, 0x5d, 0xff, 0x59, 0x59, 0x5d, 0xff,
0x5c, 0x5e, 0x5f, 0xff, 0x61, 0x66, 0x65, 0xff, 0x69, 0x6f, 0x6e, 0xff,
0x74, 0x7a, 0x7a, 0xff, 0x7e, 0x84, 0x83, 0xff, 0x86, 0x90, 0x8a, 0xff,
0x89, 0x95, 0x90, 0xff, 0x94, 0x9e, 0x9d, 0xff, 0x87, 0x91, 0x96, 0xff,
0x64, 0x72, 0x7b, 0xff, 0x6a, 0x64, 0x83, 0xff, 0x60, 0x48, 0x7f, 0xff,
0x64, 0x49, 0x83, 0xff, 0x5e, 0x43, 0x7b, 0xff, 0x54, 0x3b, 0x77, 0xff,
0x6b, 0x50, 0x94, 0xff, 0x4b, 0x2d, 0x79, 0xff, 0x47, 0x25, 0x75, 0xff,
0x43, 0x23, 0x75, 0xff, 0x52, 0x33, 0x7f, 0xff, 0x4e, 0x2c, 0x7b, 0xff,
0x5d, 0x3b, 0x89, 0xff, 0x69, 0x4a, 0x8e, 0xff, 0x5d, 0x3d, 0x74, 0xff,
0x56, 0x3a, 0x6a, 0xff, 0x5b, 0x3b, 0x7b, 0xff, 0x58, 0x39, 0x80, 0xff,
0x47, 0x26, 0x77, 0xff, 0x45, 0x1e, 0x72, 0xff, 0x3f, 0x1a, 0x6a, 0xff,
0x49, 0x25, 0x73, 0xff, 0x4a, 0x25, 0x76, 0xff, 0x48, 0x22, 0x75, 0xff,
0x49, 0x22, 0x7a, 0xff, 0x43, 0x1b, 0x74, 0xff, 0x47, 0x20, 0x79, 0xff,
0x41, 0x17, 0x73, 0xff, 0x47, 0x1f, 0x79, 0xff, 0x37, 0x10, 0x69, 0xff,
0x4b, 0x24, 0x7d, 0xff, 0x48, 0x20, 0x7a, 0xff, 0x49, 0x21, 0x7a, 0xff,
0x45, 0x1d, 0x72, 0xff, 0x44, 0x1d, 0x69, 0xff, 0x42, 0x1c, 0x67, 0xff,
0x4d, 0x27, 0x7a, 0xff, 0x43, 0x1c, 0x72, 0xff, 0x48, 0x24, 0x72, 0xff,
0x42, 0x1e, 0x6a, 0xff, 0x4b, 0x27, 0x73, 0xff, 0x52, 0x2e, 0x7a, 0xff,
0x49, 0x25, 0x70, 0xff, 0x41, 0x1d, 0x6a, 0xff, 0x3c, 0x18, 0x64, 0xff,
0x42, 0x20, 0x67, 0xff, 0x44, 0x22, 0x68, 0xff, 0x47, 0x25, 0x6c, 0xff,
0x42, 0x21, 0x6b, 0xff, 0x55, 0x34, 0x7c, 0xff, 0x49, 0x2a, 0x70, 0xff,
0x4b, 0x2c, 0x70, 0xff, 0x51, 0x31, 0x74, 0xff, 0x4a, 0x2b, 0x6e, 0xff,
0x4f, 0x33, 0x71, 0xff, 0x49, 0x2c, 0x66, 0xff, 0x4b, 0x2d, 0x65, 0xff,
0x4f, 0x30, 0x69, 0xff, 0x55, 0x39, 0x6c, 0xff, 0x5c, 0x3f, 0x6f, 0xff,
0x54, 0x3b, 0x66, 0xff, 0x5c, 0x4c, 0x68, 0xff, 0xba, 0xba, 0xb2, 0xff,
0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff,
0xb6, 0xb6, 0xa8, 0xff, 0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb5, 0xb5, 0xa7, 0xff, 0xb4, 0xb4, 0xa6, 0xff, 0xb3, 0xb3, 0xa5, 0xff,
0xb1, 0xb1, 0xa3, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb0, 0xb1, 0xa3, 0xff,
0x95, 0x93, 0x85, 0xff, 0x54, 0x4c, 0x40, 0xff, 0x3d, 0x36, 0x2a, 0xff,
0x7d, 0x98, 0xb6, 0xff, 0x7a, 0x94, 0xae, 0xff, 0x77, 0x8f, 0xa3, 0xff,
0x73, 0x87, 0x98, 0xff, 0x71, 0x82, 0x8f, 0xff, 0x70, 0x7b, 0x84, 0xff,
0x6c, 0x74, 0x7b, 0xff, 0x67, 0x6c, 0x71, 0xff, 0x5e, 0x62, 0x66, 0xff,
0x5a, 0x5b, 0x5f, 0xff, 0x57, 0x56, 0x59, 0xff, 0x58, 0x56, 0x59, 0xff,
0x56, 0x55, 0x59, 0xff, 0x5a, 0x5b, 0x5c, 0xff, 0x5f, 0x61, 0x61, 0xff,
0x66, 0x6b, 0x6a, 0xff, 0x71, 0x76, 0x76, 0xff, 0x79, 0x80, 0x7f, 0xff,
0x82, 0x8c, 0x86, 0xff, 0x88, 0x94, 0x8f, 0xff, 0x8e, 0x98, 0x97, 0xff,
0x7b, 0x81, 0x86, 0xff, 0x54, 0x62, 0x65, 0xff, 0x63, 0x5f, 0x76, 0xff,
0x59, 0x43, 0x79, 0xff, 0x5e, 0x42, 0x7d, 0xff, 0x5e, 0x43, 0x7f, 0xff,
0x52, 0x38, 0x75, 0xff, 0x51, 0x3a, 0x79, 0xff, 0x4d, 0x32, 0x76, 0xff,
0x47, 0x27, 0x73, 0xff, 0x42, 0x24, 0x77, 0xff, 0x52, 0x35, 0x7c, 0xff,
0x54, 0x33, 0x76, 0xff, 0x5e, 0x3f, 0x83, 0xff, 0x59, 0x3e, 0x7e, 0xff,
0x5a, 0x38, 0x6d, 0xff, 0x59, 0x3d, 0x68, 0xff, 0x50, 0x31, 0x6b, 0xff,
0x4d, 0x2d, 0x71, 0xff, 0x3f, 0x1c, 0x6d, 0xff, 0x47, 0x21, 0x71, 0xff,
0x44, 0x21, 0x6b, 0xff, 0x4a, 0x28, 0x70, 0xff, 0x48, 0x26, 0x70, 0xff,
0x4e, 0x2a, 0x75, 0xff, 0x43, 0x1f, 0x6d, 0xff, 0x4c, 0x28, 0x77, 0xff,
0x45, 0x20, 0x6f, 0xff, 0x42, 0x1c, 0x6e, 0xff, 0x46, 0x1f, 0x73, 0xff,
0x44, 0x1d, 0x72, 0xff, 0x48, 0x22, 0x74, 0xff, 0x44, 0x1e, 0x70, 0xff,
0x48, 0x21, 0x76, 0xff, 0x41, 0x1a, 0x69, 0xff, 0x3d, 0x19, 0x5d, 0xff,
0x40, 0x1d, 0x62, 0xff, 0x47, 0x22, 0x72, 0xff, 0x47, 0x20, 0x76, 0xff,
0x45, 0x21, 0x70, 0xff, 0x4a, 0x26, 0x72, 0xff, 0x43, 0x20, 0x6b, 0xff,
0x45, 0x22, 0x6b, 0xff, 0x47, 0x26, 0x6c, 0xff, 0x43, 0x1f, 0x6b, 0xff,
0x3e, 0x1b, 0x65, 0xff, 0x45, 0x23, 0x69, 0xff, 0x49, 0x28, 0x6c, 0xff,
0x41, 0x1f, 0x64, 0xff, 0x4c, 0x2c, 0x74, 0xff, 0x45, 0x26, 0x6b, 0xff,
0x52, 0x33, 0x76, 0xff, 0x46, 0x28, 0x67, 0xff, 0x4e, 0x32, 0x6f, 0xff,
0x49, 0x2c, 0x6b, 0xff, 0x55, 0x38, 0x72, 0xff, 0x4a, 0x2e, 0x64, 0xff,
0x4d, 0x2e, 0x65, 0xff, 0x52, 0x33, 0x6b, 0xff, 0x50, 0x35, 0x64, 0xff,
0x5c, 0x40, 0x6e, 0xff, 0x50, 0x37, 0x60, 0xff, 0x72, 0x65, 0x7a, 0xff,
0xb8, 0xba, 0xab, 0xff, 0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff,
0xb7, 0xb7, 0xa9, 0xff, 0xb6, 0xb6, 0xa8, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb5, 0xb5, 0xa7, 0xff, 0xb4, 0xb4, 0xa6, 0xff, 0xb4, 0xb4, 0xa6, 0xff,
0xb3, 0xb3, 0xa5, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb1, 0xa3, 0xff,
0xa8, 0xa8, 0x9a, 0xff, 0x79, 0x77, 0x69, 0xff, 0x45, 0x3d, 0x30, 0xff,
0x38, 0x30, 0x25, 0xff, 0x7e, 0x9c, 0xbc, 0xff, 0x7a, 0x97, 0xb4, 0xff,
0x77, 0x91, 0xa6, 0xff, 0x72, 0x89, 0x9b, 0xff, 0x72, 0x83, 0x92, 0xff,
0x6f, 0x7b, 0x86, 0xff, 0x69, 0x73, 0x7c, 0xff, 0x64, 0x6a, 0x70, 0xff,
0x5f, 0x61, 0x65, 0xff, 0x5a, 0x5a, 0x5c, 0xff, 0x58, 0x55, 0x57, 0xff,
0x55, 0x53, 0x55, 0xff, 0x54, 0x53, 0x56, 0xff, 0x56, 0x57, 0x58, 0xff,
0x5b, 0x5e, 0x5f, 0xff, 0x62, 0x67, 0x69, 0xff, 0x6e, 0x73, 0x74, 0xff,
0x77, 0x7d, 0x7c, 0xff, 0x80, 0x89, 0x86, 0xff, 0x89, 0x94, 0x91, 0xff,
0x7f, 0x8a, 0x88, 0xff, 0x68, 0x70, 0x72, 0xff, 0x54, 0x65, 0x64, 0xff,
0x66, 0x69, 0x7c, 0xff, 0x5a, 0x45, 0x78, 0xff, 0x54, 0x3b, 0x73, 0xff,
0x55, 0x3c, 0x74, 0xff, 0x57, 0x3e, 0x77, 0xff, 0x4f, 0x38, 0x72, 0xff,
0x53, 0x39, 0x78, 0xff, 0x42, 0x25, 0x6a, 0xff, 0x43, 0x26, 0x72, 0xff,
0x48, 0x2b, 0x6e, 0xff, 0x56, 0x36, 0x75, 0xff, 0x5e, 0x3f, 0x7d, 0xff,
0x59, 0x3c, 0x7c, 0xff, 0x51, 0x31, 0x6a, 0xff, 0x4f, 0x32, 0x61, 0xff,
0x51, 0x31, 0x6a, 0xff, 0x47, 0x25, 0x6c, 0xff, 0x41, 0x1e, 0x6e, 0xff,
0x3e, 0x1d, 0x68, 0xff, 0x39, 0x18, 0x60, 0xff, 0x43, 0x21, 0x68, 0xff,
0x44, 0x22, 0x67, 0xff, 0x43, 0x21, 0x69, 0xff, 0x4e, 0x2b, 0x71, 0xff,
0x40, 0x1e, 0x62, 0xff, 0x40, 0x1c, 0x65, 0xff, 0x41, 0x1e, 0x67, 0xff,
0x3d, 0x1a, 0x62, 0xff, 0x3c, 0x17, 0x68, 0xff, 0x3c, 0x16, 0x69, 0xff,
0x3e, 0x18, 0x6d, 0xff, 0x3f, 0x1b, 0x6e, 0xff, 0x44, 0x1f, 0x6a, 0xff,
0x38, 0x15, 0x57, 0xff, 0x3c, 0x19, 0x5f, 0xff, 0x43, 0x1f, 0x6d, 0xff,
0x40, 0x1c, 0x6c, 0xff, 0x49, 0x26, 0x70, 0xff, 0x45, 0x23, 0x6b, 0xff,
0x41, 0x1e, 0x66, 0xff, 0x45, 0x24, 0x69, 0xff, 0x53, 0x33, 0x74, 0xff,
0x40, 0x1d, 0x67, 0xff, 0x3e, 0x1b, 0x64, 0xff, 0x43, 0x24, 0x62, 0xff,
0x4a, 0x2a, 0x6b, 0xff, 0x51, 0x30, 0x72, 0xff, 0x4b, 0x2c, 0x71, 0xff,
0x4c, 0x2d, 0x70, 0xff, 0x44, 0x27, 0x67, 0xff, 0x48, 0x2b, 0x69, 0xff,
0x53, 0x36, 0x73, 0xff, 0x41, 0x23, 0x60, 0xff, 0x46, 0x28, 0x61, 0xff,
0x41, 0x24, 0x5a, 0xff, 0x47, 0x29, 0x5f, 0xff, 0x50, 0x32, 0x69, 0xff,
0x51, 0x36, 0x64, 0xff, 0x57, 0x3e, 0x68, 0xff, 0x4a, 0x36, 0x5b, 0xff,
0x8d, 0x84, 0x8d, 0xff, 0xb9, 0xb9, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff,
0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb6, 0xb5, 0xa7, 0xff, 0xb5, 0xb4, 0xa6, 0xff, 0xb4, 0xb5, 0xa6, 0xff,
0xb4, 0xb5, 0xa6, 0xff, 0xb2, 0xb5, 0xa4, 0xff, 0xb1, 0xb1, 0xa3, 0xff,
0xac, 0xaa, 0x9d, 0xff, 0x8e, 0x8b, 0x80, 0xff, 0x57, 0x51, 0x47, 0xff,
0x3c, 0x33, 0x29, 0xff, 0x31, 0x2b, 0x22, 0xff, 0x7f, 0x9e, 0xc1, 0xff,
0x7b, 0x99, 0xb9, 0xff, 0x78, 0x93, 0xac, 0xff, 0x72, 0x8a, 0xa0, 0xff,
0x72, 0x84, 0x95, 0xff, 0x6e, 0x7c, 0x88, 0xff, 0x67, 0x73, 0x7d, 0xff,
0x62, 0x6a, 0x71, 0xff, 0x5e, 0x62, 0x64, 0xff, 0x5b, 0x5a, 0x5b, 0xff,
0x58, 0x56, 0x56, 0xff, 0x53, 0x53, 0x54, 0xff, 0x53, 0x53, 0x54, 0xff,
0x54, 0x56, 0x57, 0xff, 0x57, 0x5b, 0x5f, 0xff, 0x5d, 0x63, 0x67, 0xff,
0x6b, 0x71, 0x73, 0xff, 0x77, 0x7e, 0x7d, 0xff, 0x81, 0x89, 0x88, 0xff,
0x86, 0x90, 0x8f, 0xff, 0x7d, 0x88, 0x86, 0xff, 0x75, 0x82, 0x80, 0xff,
0x71, 0x84, 0x83, 0xff, 0x85, 0x8e, 0x9a, 0xff, 0x58, 0x4b, 0x70, 0xff,
0x53, 0x3d, 0x72, 0xff, 0x57, 0x3f, 0x76, 0xff, 0x54, 0x3c, 0x72, 0xff,
0x52, 0x39, 0x72, 0xff, 0x4e, 0x33, 0x72, 0xff, 0x4c, 0x2e, 0x74, 0xff,
0x41, 0x25, 0x6a, 0xff, 0x54, 0x37, 0x78, 0xff, 0x4d, 0x2e, 0x6b, 0xff,
0x4f, 0x31, 0x6d, 0xff, 0x54, 0x39, 0x75, 0xff, 0x52, 0x35, 0x70, 0xff,
0x4c, 0x31, 0x64, 0xff, 0x4f, 0x2f, 0x68, 0xff, 0x49, 0x27, 0x6d, 0xff,
0x42, 0x21, 0x6c, 0xff, 0x46, 0x28, 0x71, 0xff, 0x44, 0x23, 0x6b, 0xff,
0x3c, 0x1a, 0x61, 0xff, 0x40, 0x1f, 0x61, 0xff, 0x3f, 0x1e, 0x61, 0xff,
0x47, 0x23, 0x69, 0xff, 0x41, 0x1d, 0x62, 0xff, 0x3a, 0x16, 0x5d, 0xff,
0x41, 0x1c, 0x64, 0xff, 0x42, 0x1f, 0x64, 0xff, 0x3d, 0x19, 0x65, 0xff,
0x3b, 0x14, 0x69, 0xff, 0x40, 0x1a, 0x72, 0xff, 0x47, 0x25, 0x78, 0xff,
0x41, 0x20, 0x67, 0xff, 0x37, 0x13, 0x59, 0xff, 0x41, 0x1d, 0x68, 0xff,
0x41, 0x1e, 0x6a, 0xff, 0x4a, 0x29, 0x74, 0xff, 0x49, 0x28, 0x6c, 0xff,
0x3f, 0x1f, 0x61, 0xff, 0x40, 0x1e, 0x66, 0xff, 0x3e, 0x1c, 0x64, 0xff,
0x43, 0x20, 0x67, 0xff, 0x39, 0x16, 0x5f, 0xff, 0x41, 0x1f, 0x67, 0xff,
0x3d, 0x20, 0x5a, 0xff, 0x49, 0x2b, 0x68, 0xff, 0x48, 0x28, 0x68, 0xff,
0x42, 0x24, 0x65, 0xff, 0x48, 0x2b, 0x6b, 0xff, 0x54, 0x37, 0x76, 0xff,
0x45, 0x28, 0x67, 0xff, 0x41, 0x25, 0x61, 0xff, 0x3d, 0x1f, 0x5a, 0xff,
0x44, 0x27, 0x60, 0xff, 0x41, 0x25, 0x5c, 0xff, 0x4d, 0x32, 0x65, 0xff,
0x4e, 0x33, 0x65, 0xff, 0x54, 0x3a, 0x68, 0xff, 0x4e, 0x3c, 0x61, 0xff,
0x42, 0x35, 0x4f, 0xff, 0xb6, 0xb4, 0xac, 0xff, 0xb6, 0xb4, 0xa9, 0xff,
0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb5, 0xb5, 0xa7, 0xff, 0xb4, 0xb4, 0xa6, 0xff, 0xb5, 0xb4, 0xa7, 0xff,
0xb4, 0xb5, 0xa6, 0xff, 0xb1, 0xb2, 0xa2, 0xff, 0xa9, 0xab, 0x9a, 0xff,
0xa1, 0xa1, 0x90, 0xff, 0x8f, 0x8b, 0x7e, 0xff, 0x61, 0x5a, 0x53, 0xff,
0x41, 0x38, 0x35, 0xff, 0x2f, 0x26, 0x23, 0xff, 0x21, 0x1d, 0x16, 0xff,
0x7d, 0x9f, 0xc6, 0xff, 0x7a, 0x9a, 0xbf, 0xff, 0x79, 0x94, 0xb2, 0xff,
0x75, 0x8b, 0xa6, 0xff, 0x72, 0x84, 0x99, 0xff, 0x6d, 0x7c, 0x8b, 0xff,
0x69, 0x74, 0x7f, 0xff, 0x64, 0x6a, 0x70, 0xff, 0x5f, 0x62, 0x63, 0xff,
0x5d, 0x5b, 0x59, 0xff, 0x58, 0x56, 0x56, 0xff, 0x54, 0x53, 0x53, 0xff,
0x53, 0x53, 0x53, 0xff, 0x54, 0x56, 0x57, 0xff, 0x58, 0x5d, 0x5e, 0xff,
0x5e, 0x65, 0x68, 0xff, 0x6b, 0x72, 0x73, 0xff, 0x76, 0x7e, 0x7d, 0xff,
0x80, 0x89, 0x88, 0xff, 0x85, 0x90, 0x8e, 0xff, 0x86, 0x92, 0x90, 0xff,
0x8a, 0x95, 0x97, 0xff, 0x91, 0x9f, 0x9f, 0xff, 0x99, 0xa2, 0xa4, 0xff,
0x69, 0x63, 0x79, 0xff, 0x52, 0x3c, 0x6f, 0xff, 0x53, 0x3a, 0x72, 0xff,
0x50, 0x38, 0x6f, 0xff, 0x4c, 0x33, 0x6b, 0xff, 0x4e, 0x34, 0x70, 0xff,
0x3f, 0x23, 0x64, 0xff, 0x39, 0x1e, 0x61, 0xff, 0x3e, 0x21, 0x60, 0xff,
0x4c, 0x2e, 0x68, 0xff, 0x4a, 0x2c, 0x65, 0xff, 0x4e, 0x32, 0x6d, 0xff,
0x46, 0x2a, 0x66, 0xff, 0x53, 0x36, 0x6d, 0xff, 0x40, 0x1e, 0x5c, 0xff,
0x3f, 0x1d, 0x64, 0xff, 0x41, 0x20, 0x69, 0xff, 0x3f, 0x22, 0x65, 0xff,
0x3b, 0x1c, 0x60, 0xff, 0x3d, 0x1c, 0x60, 0xff, 0x3c, 0x1b, 0x5e, 0xff,
0x45, 0x24, 0x67, 0xff, 0x3c, 0x17, 0x5f, 0xff, 0x3f, 0x19, 0x64, 0xff,
0x48, 0x25, 0x69, 0xff, 0x42, 0x1e, 0x62, 0xff, 0x44, 0x1f, 0x6a, 0xff,
0x3d, 0x19, 0x65, 0xff, 0x3c, 0x17, 0x67, 0xff, 0x3d, 0x19, 0x6b, 0xff,
0x3c, 0x1d, 0x6a, 0xff, 0x3d, 0x1b, 0x62, 0xff, 0x37, 0x13, 0x59, 0xff,
0x3d, 0x19, 0x64, 0xff, 0x36, 0x12, 0x60, 0xff, 0x41, 0x21, 0x6b, 0xff,
0x40, 0x20, 0x62, 0xff, 0x40, 0x1f, 0x60, 0xff, 0x46, 0x24, 0x6a, 0xff,
0x44, 0x22, 0x69, 0xff, 0x3f, 0x1d, 0x63, 0xff, 0x39, 0x17, 0x5e, 0xff,
0x3f, 0x1d, 0x65, 0xff, 0x40, 0x23, 0x5d, 0xff, 0x3d, 0x1d, 0x5c, 0xff,
0x43, 0x22, 0x64, 0xff, 0x44, 0x27, 0x67, 0xff, 0x4b, 0x2f, 0x6d, 0xff,
0x48, 0x2c, 0x69, 0xff, 0x44, 0x28, 0x63, 0xff, 0x4b, 0x2f, 0x6a, 0xff,
0x3f, 0x22, 0x5a, 0xff, 0x3e, 0x21, 0x58, 0xff, 0x46, 0x2b, 0x5e, 0xff,
0x4a, 0x2f, 0x61, 0xff, 0x52, 0x38, 0x66, 0xff, 0x53, 0x3c, 0x64, 0xff,
0x44, 0x32, 0x57, 0xff, 0x72, 0x6c, 0x77, 0xff, 0xbd, 0xbd, 0xae, 0xff,
0xb8, 0xb6, 0xad, 0xff, 0xb7, 0xb7, 0xa9, 0xff, 0xb7, 0xb7, 0xa9, 0xff,
0xb6, 0xb6, 0xa8, 0xff, 0xb6, 0xb5, 0xa7, 0xff, 0xb3, 0xb5, 0xa6, 0xff,
0xb2, 0xb6, 0xa6, 0xff, 0xaa, 0xab, 0x9d, 0xff, 0x96, 0x94, 0x85, 0xff,
0x87, 0x80, 0x73, 0xff, 0x7c, 0x75, 0x6a, 0xff, 0x61, 0x5b, 0x54, 0xff,
0x41, 0x3a, 0x37, 0xff, 0x2d, 0x27, 0x26, 0xff, 0x25, 0x1f, 0x1d, 0xff,
0x17, 0x17, 0x13, 0xff, 0x7c, 0x9f, 0xc9, 0xff, 0x7b, 0x9c, 0xc1, 0xff,
0x7a, 0x95, 0xb7, 0xff, 0x75, 0x8c, 0xa9, 0xff, 0x73, 0x87, 0x9c, 0xff,
0x6e, 0x7e, 0x8c, 0xff, 0x67, 0x73, 0x7d, 0xff, 0x66, 0x6d, 0x70, 0xff,
0x5f, 0x62, 0x60, 0xff, 0x5c, 0x5a, 0x56, 0xff, 0x5a, 0x57, 0x53, 0xff,
0x55, 0x53, 0x51, 0xff, 0x53, 0x53, 0x52, 0xff, 0x56, 0x58, 0x58, 0xff,
0x58, 0x5c, 0x5d, 0xff, 0x60, 0x68, 0x68, 0xff, 0x6b, 0x74, 0x74, 0xff,
0x77, 0x80, 0x80, 0xff, 0x80, 0x8a, 0x8a, 0xff, 0x87, 0x92, 0x92, 0xff,
0x8b, 0x97, 0x97, 0xff, 0x95, 0x9f, 0xa2, 0xff, 0x9c, 0xa3, 0xa5, 0xff,
0xa0, 0xa8, 0xa4, 0xff, 0x85, 0x88, 0x8d, 0xff, 0x51, 0x40, 0x68, 0xff,
0x51, 0x39, 0x6f, 0xff, 0x4c, 0x35, 0x6a, 0xff, 0x4c, 0x34, 0x69, 0xff,
0x4a, 0x31, 0x69, 0xff, 0x49, 0x2f, 0x6b, 0xff, 0x3a, 0x21, 0x61, 0xff,
0x48, 0x2c, 0x69, 0xff, 0x43, 0x26, 0x5e, 0xff, 0x3f, 0x22, 0x59, 0xff,
0x4d, 0x32, 0x6a, 0xff, 0x40, 0x24, 0x5e, 0xff, 0x3f, 0x22, 0x5a, 0xff,
0x43, 0x21, 0x60, 0xff, 0x40, 0x1f, 0x62, 0xff, 0x3f, 0x20, 0x62, 0xff,
0x3c, 0x22, 0x60, 0xff, 0x3a, 0x1d, 0x5d, 0xff, 0x3a, 0x1a, 0x5b, 0xff,
0x39, 0x19, 0x5a, 0xff, 0x44, 0x24, 0x66, 0xff, 0x48, 0x26, 0x67, 0xff,
0x3a, 0x16, 0x5c, 0xff, 0x45, 0x23, 0x62, 0xff, 0x48, 0x27, 0x65, 0xff,
0x37, 0x14, 0x5b, 0xff, 0x38, 0x15, 0x5f, 0xff, 0x3f, 0x1b, 0x66, 0xff,
0x3f, 0x1e, 0x68, 0xff, 0x39, 0x1b, 0x62, 0xff, 0x37, 0x16, 0x5a, 0xff,
0x33, 0x10, 0x54, 0xff, 0x3b, 0x18, 0x60, 0xff, 0x37, 0x14, 0x5f, 0xff,
0x36, 0x15, 0x60, 0xff, 0x3d, 0x1b, 0x63, 0xff, 0x3d, 0x1a, 0x63, 0xff,
0x3b, 0x19, 0x60, 0xff, 0x38, 0x18, 0x59, 0xff, 0x3d, 0x1f, 0x59, 0xff,
0x39, 0x19, 0x5a, 0xff, 0x36, 0x16, 0x58, 0xff, 0x44, 0x27, 0x5f, 0xff,
0x3f, 0x20, 0x5e, 0xff, 0x46, 0x25, 0x68, 0xff, 0x3d, 0x21, 0x5d, 0xff,
0x41, 0x25, 0x61, 0xff, 0x45, 0x29, 0x64, 0xff, 0x44, 0x29, 0x62, 0xff,
0x45, 0x2b, 0x62, 0xff, 0x3e, 0x22, 0x57, 0xff, 0x3b, 0x1f, 0x51, 0xff,
0x41, 0x27, 0x56, 0xff, 0x46, 0x2d, 0x59, 0xff, 0x4e, 0x34, 0x5f, 0xff,
0x4c, 0x39, 0x5c, 0xff, 0x4a, 0x3d, 0x59, 0xff, 0xa7, 0xa7, 0xa1, 0xff,
0xb5, 0xb7, 0xa8, 0xff, 0xb6, 0xb5, 0xac, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb6, 0xb6, 0xa8, 0xff, 0xb5, 0xb5, 0xa7, 0xff, 0xb5, 0xb5, 0xa7, 0xff,
0xb4, 0xb4, 0xa6, 0xff, 0xaa, 0xac, 0x9c, 0xff, 0x8e, 0x8d, 0x7e, 0xff,
0x69, 0x62, 0x57, 0xff, 0x56, 0x4b, 0x43, 0xff, 0x4f, 0x44, 0x41, 0xff,
0x42, 0x3a, 0x3c, 0xff, 0x32, 0x2c, 0x2e, 0xff, 0x25, 0x23, 0x1f, 0xff,
0x1b, 0x1d, 0x13, 0xff, 0x14, 0x17, 0x12, 0xff, 0x7e, 0x9f, 0xca, 0xff,
0x7c, 0x9c, 0xc1, 0xff, 0x7a, 0x96, 0xb8, 0xff, 0x74, 0x8e, 0xaa, 0xff,
0x73, 0x88, 0x9b, 0xff, 0x6e, 0x80, 0x8a, 0xff, 0x68, 0x77, 0x7b, 0xff,
0x66, 0x6d, 0x6d, 0xff, 0x5f, 0x61, 0x5e, 0xff, 0x5d, 0x5a, 0x55, 0xff,
0x5a, 0x57, 0x52, 0xff, 0x55, 0x54, 0x50, 0xff, 0x54, 0x55, 0x53, 0xff,
0x56, 0x58, 0x58, 0xff, 0x5b, 0x60, 0x5f, 0xff, 0x63, 0x6a, 0x6a, 0xff,
0x6c, 0x75, 0x77, 0xff, 0x77, 0x80, 0x82, 0xff, 0x80, 0x8b, 0x8d, 0xff,
0x88, 0x94, 0x96, 0xff, 0x8c, 0x99, 0x9a, 0xff, 0x96, 0xa2, 0x9e, 0xff,
0x9f, 0xa3, 0xa4, 0xff, 0xa3, 0xa8, 0xa4, 0xff, 0xa5, 0xaf, 0xab, 0xff,
0x57, 0x4a, 0x67, 0xff, 0x50, 0x3a, 0x6b, 0xff, 0x4c, 0x36, 0x67, 0xff,
0x4c, 0x37, 0x64, 0xff, 0x4c, 0x36, 0x65, 0xff, 0x43, 0x2c, 0x60, 0xff,
0x3a, 0x22, 0x5f, 0xff, 0x4c, 0x31, 0x6b, 0xff, 0x49, 0x2c, 0x63, 0xff,
0x44, 0x28, 0x5d, 0xff, 0x46, 0x2c, 0x61, 0xff, 0x3f, 0x23, 0x5b, 0xff,
0x39, 0x1c, 0x53, 0xff, 0x3e, 0x1d, 0x5b, 0xff, 0x40, 0x20, 0x61, 0xff,
0x42, 0x27, 0x60, 0xff, 0x36, 0x1d, 0x57, 0xff, 0x37, 0x1b, 0x58, 0xff,
0x37, 0x18, 0x57, 0xff, 0x3b, 0x1b, 0x5c, 0xff, 0x3b, 0x1a, 0x5d, 0xff,
0x3d, 0x1b, 0x5c, 0xff, 0x3f, 0x1d, 0x5c, 0xff, 0x3f, 0x1c, 0x5f, 0xff,
0x3b, 0x19, 0x5b, 0xff, 0x3f, 0x1c, 0x60, 0xff, 0x39, 0x16, 0x60, 0xff,
0x3b, 0x19, 0x5f, 0xff, 0x3a, 0x1b, 0x5e, 0xff, 0x37, 0x1a, 0x5d, 0xff,
0x38, 0x19, 0x59, 0xff, 0x38, 0x16, 0x54, 0xff, 0x39, 0x19, 0x5c, 0xff,
0x3b, 0x1a, 0x60, 0xff, 0x3b, 0x1b, 0x5f, 0xff, 0x3e, 0x1d, 0x63, 0xff,
0x39, 0x17, 0x5e, 0xff, 0x35, 0x14, 0x59, 0xff, 0x3a, 0x1a, 0x5b, 0xff,
0x3f, 0x21, 0x5b, 0xff, 0x3a, 0x1d, 0x57, 0xff, 0x3d, 0x1e, 0x5a, 0xff,
0x4d, 0x32, 0x64, 0xff, 0x44, 0x25, 0x61, 0xff, 0x42, 0x23, 0x62, 0xff,
0x42, 0x26, 0x61, 0xff, 0x44, 0x29, 0x62, 0xff, 0x41, 0x26, 0x5f, 0xff,
0x3e, 0x24, 0x5b, 0xff, 0x43, 0x29, 0x5f, 0xff, 0x3f, 0x25, 0x55, 0xff,
0x3b, 0x21, 0x4e, 0xff, 0x42, 0x2a, 0x55, 0xff, 0x47, 0x2f, 0x59, 0xff,
0x4d, 0x35, 0x5d, 0xff, 0x45, 0x33, 0x54, 0xff, 0x67, 0x5f, 0x6d, 0xff,
0xb3, 0xb7, 0xa7, 0xff, 0xb4, 0xb6, 0xab, 0xff, 0xb6, 0xb7, 0xa8, 0xff,
0xb6, 0xb6, 0xa8, 0xff, 0xb6, 0xb6, 0xa8, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb4, 0xb4, 0xa6, 0xff, 0xa5, 0xa4, 0x95, 0xff, 0x83, 0x7d, 0x6e, 0xff,
0x57, 0x4f, 0x42, 0xff, 0x39, 0x30, 0x28, 0xff, 0x32, 0x28, 0x21, 0xff,
0x30, 0x28, 0x22, 0xff, 0x3a, 0x35, 0x2f, 0xff, 0x2d, 0x29, 0x26, 0xff,
0x20, 0x1f, 0x1e, 0xff, 0x16, 0x19, 0x15, 0xff, 0x15, 0x19, 0x14, 0xff,
0x7e, 0x9f, 0xc8, 0xff, 0x7c, 0x9c, 0xc0, 0xff, 0x7b, 0x97, 0xb5, 0xff,
0x77, 0x8f, 0xa9, 0xff, 0x74, 0x8a, 0x99, 0xff, 0x6f, 0x80, 0x89, 0xff,
0x69, 0x76, 0x7a, 0xff, 0x66, 0x6b, 0x69, 0xff, 0x61, 0x62, 0x5c, 0xff,
0x5e, 0x5c, 0x53, 0xff, 0x5a, 0x56, 0x4f, 0xff, 0x57, 0x54, 0x50, 0xff,
0x55, 0x56, 0x54, 0xff, 0x59, 0x5b, 0x5a, 0xff, 0x5c, 0x62, 0x61, 0xff,
0x65, 0x6d, 0x6c, 0xff, 0x6d, 0x76, 0x77, 0xff, 0x76, 0x80, 0x84, 0xff,
0x80, 0x8c, 0x8e, 0xff, 0x87, 0x95, 0x95, 0xff, 0x8e, 0x9b, 0x9b, 0xff,
0x96, 0xa2, 0x9b, 0xff, 0x9e, 0xa3, 0xa4, 0xff, 0xa2, 0xa7, 0xa5, 0xff,
0xa8, 0xaf, 0xa8, 0xff, 0x7d, 0x76, 0x88, 0xff, 0x50, 0x3b, 0x6a, 0xff,
0x4a, 0x36, 0x61, 0xff, 0x4a, 0x37, 0x5f, 0xff, 0x46, 0x30, 0x5d, 0xff,
0x45, 0x2e, 0x5e, 0xff, 0x3c, 0x24, 0x5c, 0xff, 0x38, 0x20, 0x57, 0xff,
0x42, 0x28, 0x5e, 0xff, 0x3b, 0x22, 0x54, 0xff, 0x45, 0x2d, 0x5d, 0xff,
0x3d, 0x22, 0x57, 0xff, 0x34, 0x18, 0x4e, 0xff, 0x34, 0x15, 0x4e, 0xff,
0x3f, 0x22, 0x5d, 0xff, 0x3b, 0x20, 0x57, 0xff, 0x3e, 0x22, 0x5c, 0xff,
0x3d, 0x21, 0x5d, 0xff, 0x36, 0x19, 0x58, 0xff, 0x36, 0x17, 0x58, 0xff,
0x38, 0x17, 0x5b, 0xff, 0x3a, 0x19, 0x5a, 0xff, 0x3f, 0x1d, 0x5e, 0xff,
0x39, 0x15, 0x5d, 0xff, 0x38, 0x15, 0x5c, 0xff, 0x38, 0x18, 0x5b, 0xff,
0x35, 0x15, 0x5a, 0xff, 0x33, 0x13, 0x57, 0xff, 0x36, 0x17, 0x59, 0xff,
0x37, 0x19, 0x5b, 0xff, 0x34, 0x15, 0x54, 0xff, 0x38, 0x19, 0x54, 0xff,
0x37, 0x18, 0x58, 0xff, 0x3b, 0x1b, 0x5d, 0xff, 0x3b, 0x1b, 0x5e, 0xff,
0x37, 0x19, 0x57, 0xff, 0x36, 0x18, 0x57, 0xff, 0x34, 0x15, 0x56, 0xff,
0x33, 0x15, 0x55, 0xff, 0x3d, 0x1f, 0x5d, 0xff, 0x3d, 0x1f, 0x59, 0xff,
0x3a, 0x1f, 0x55, 0xff, 0x44, 0x2a, 0x5d, 0xff, 0x36, 0x1b, 0x55, 0xff,
0x3f, 0x23, 0x5c, 0xff, 0x40, 0x25, 0x5b, 0xff, 0x50, 0x36, 0x6c, 0xff,
0x41, 0x27, 0x5c, 0xff, 0x36, 0x1c, 0x51, 0xff, 0x37, 0x1d, 0x50, 0xff,
0x38, 0x1f, 0x4b, 0xff, 0x3b, 0x21, 0x4f, 0xff, 0x42, 0x29, 0x56, 0xff,
0x46, 0x2f, 0x57, 0xff, 0x50, 0x3a, 0x5c, 0xff, 0x43, 0x33, 0x53, 0xff,
0xae, 0xaa, 0xa9, 0xff, 0xb5, 0xb8, 0xa6, 0xff, 0xb5, 0xb6, 0xaa, 0xff,
0xb6, 0xb6, 0xa9, 0xff, 0xb5, 0xb5, 0xaa, 0xff, 0xb6, 0xb7, 0xa8, 0xff,
0xb2, 0xb3, 0xa2, 0xff, 0xa3, 0xa1, 0x92, 0xff, 0x80, 0x7a, 0x6d, 0xff,
0x4c, 0x43, 0x38, 0xff, 0x34, 0x2b, 0x23, 0xff, 0x28, 0x21, 0x16, 0xff,
0x3a, 0x36, 0x27, 0xff, 0x65, 0x64, 0x50, 0xff, 0x6e, 0x6b, 0x5a, 0xff,
0x3b, 0x3a, 0x2d, 0xff, 0x1e, 0x1e, 0x19, 0xff, 0x11, 0x16, 0x17, 0xff,
0x12, 0x17, 0x14, 0xff, 0x80, 0xa0, 0xc6, 0xff, 0x7d, 0x9d, 0xbf, 0xff,
0x7c, 0x98, 0xb2, 0xff, 0x79, 0x91, 0xa5, 0xff, 0x77, 0x89, 0x97, 0xff,
0x73, 0x80, 0x87, 0xff, 0x6b, 0x75, 0x78, 0xff, 0x67, 0x6c, 0x67, 0xff,
0x62, 0x63, 0x5b, 0xff, 0x5f, 0x5d, 0x53, 0xff, 0x5a, 0x57, 0x4e, 0xff,
0x57, 0x54, 0x50, 0xff, 0x55, 0x56, 0x53, 0xff, 0x5a, 0x5d, 0x5b, 0xff,
0x5d, 0x62, 0x61, 0xff, 0x65, 0x6d, 0x6d, 0xff, 0x6d, 0x75, 0x77, 0xff,
0x76, 0x7f, 0x82, 0xff, 0x7e, 0x8b, 0x8d, 0xff, 0x86, 0x94, 0x93, 0xff,
0x90, 0x9a, 0x9a, 0xff, 0x96, 0xa0, 0x9b, 0xff, 0x9d, 0xa4, 0xa4, 0xff,
0xa1, 0xa7, 0xa3, 0xff, 0xa4, 0xab, 0x9e, 0xff, 0xa1, 0x9f, 0xa5, 0xff,
0x52, 0x41, 0x66, 0xff, 0x4a, 0x37, 0x5f, 0xff, 0x49, 0x36, 0x5d, 0xff,
0x45, 0x2f, 0x59, 0xff, 0x4e, 0x35, 0x67, 0xff, 0x3a, 0x24, 0x57, 0xff,
0x3d, 0x26, 0x5b, 0xff, 0x42, 0x2b, 0x5f, 0xff, 0x3c, 0x24, 0x54, 0xff,
0x39, 0x22, 0x4e, 0xff, 0x40, 0x25, 0x58, 0xff, 0x32, 0x16, 0x4c, 0xff,
0x34, 0x18, 0x4f, 0xff, 0x3a, 0x1f, 0x55, 0xff, 0x3d, 0x21, 0x59, 0xff,
0x3c, 0x20, 0x59, 0xff, 0x34, 0x1a, 0x54, 0xff, 0x34, 0x1a, 0x57, 0xff,
0x36, 0x19, 0x59, 0xff, 0x38, 0x19, 0x58, 0xff, 0x38, 0x1a, 0x56, 0xff,
0x35, 0x16, 0x56, 0xff, 0x35, 0x14, 0x57, 0xff, 0x33, 0x13, 0x56, 0xff,
0x31, 0x13, 0x52, 0xff, 0x34, 0x17, 0x55, 0xff, 0x35, 0x18, 0x54, 0xff,
0x35, 0x18, 0x56, 0xff, 0x33, 0x16, 0x53, 0xff, 0x36, 0x18, 0x55, 0xff,
0x36, 0x17, 0x54, 0xff, 0x37, 0x18, 0x56, 0xff, 0x38, 0x19, 0x58, 0xff,
0x3a, 0x1a, 0x5a, 0xff, 0x32, 0x16, 0x52, 0xff, 0x30, 0x14, 0x50, 0xff,
0x37, 0x1a, 0x59, 0xff, 0x32, 0x16, 0x53, 0xff, 0x32, 0x16, 0x51, 0xff,
0x35, 0x17, 0x52, 0xff, 0x3e, 0x24, 0x56, 0xff, 0x3e, 0x23, 0x59, 0xff,
0x44, 0x2a, 0x64, 0xff, 0x3f, 0x27, 0x5c, 0xff, 0x3c, 0x22, 0x56, 0xff,
0x3e, 0x25, 0x58, 0xff, 0x3a, 0x22, 0x53, 0xff, 0x3b, 0x23, 0x52, 0xff,
0x38, 0x21, 0x4f, 0xff, 0x3b, 0x23, 0x4c, 0xff, 0x3b, 0x23, 0x4e, 0xff,
0x42, 0x28, 0x54, 0xff, 0x49, 0x31, 0x57, 0xff, 0x45, 0x31, 0x52, 0xff,
0x58, 0x4a, 0x65, 0xff, 0xc0, 0xbf, 0xb5, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb6, 0xb7, 0xa8, 0xff, 0xb6, 0xb5, 0xab, 0xff, 0xb2, 0xb6, 0xa9, 0xff,
0xb4, 0xb6, 0xa7, 0xff, 0xa3, 0xa1, 0x92, 0xff, 0x74, 0x70, 0x62, 0xff,
0x48, 0x40, 0x35, 0xff, 0x32, 0x29, 0x22, 0xff, 0x2c, 0x26, 0x18, 0xff,
0x54, 0x51, 0x3e, 0xff, 0x86, 0x86, 0x71, 0xff, 0xa6, 0xa5, 0x91, 0xff,
0xa9, 0xa8, 0x94, 0xff, 0x65, 0x62, 0x52, 0xff, 0x24, 0x24, 0x18, 0xff,
0x19, 0x1b, 0x16, 0xff, 0x17, 0x19, 0x14, 0xff, 0x84, 0xa1, 0xc2, 0xff,
0x81, 0x9d, 0xbb, 0xff, 0x7f, 0x99, 0xaf, 0xff, 0x7c, 0x91, 0xa3, 0xff,
0x79, 0x8a, 0x94, 0xff, 0x75, 0x80, 0x84, 0xff, 0x6e, 0x76, 0x76, 0xff,
0x69, 0x6c, 0x66, 0xff, 0x63, 0x63, 0x5a, 0xff, 0x5f, 0x5d, 0x52, 0xff,
0x59, 0x57, 0x4d, 0xff, 0x56, 0x56, 0x4f, 0xff, 0x55, 0x56, 0x52, 0xff,
0x5a, 0x5d, 0x5a, 0xff, 0x5d, 0x62, 0x60, 0xff, 0x64, 0x6c, 0x6b, 0xff,
0x6d, 0x74, 0x75, 0xff, 0x76, 0x7f, 0x81, 0xff, 0x7e, 0x8b, 0x8a, 0xff,
0x86, 0x93, 0x92, 0xff, 0x90, 0x9a, 0x98, 0xff, 0x97, 0x9e, 0x9d, 0xff,
0x9d, 0xa4, 0xa4, 0xff, 0xa1, 0xa9, 0xa1, 0xff, 0xa7, 0xaf, 0x9e, 0xff,
0xab, 0xae, 0xa5, 0xff, 0x68, 0x5f, 0x6e, 0xff, 0x49, 0x38, 0x5e, 0xff,
0x4a, 0x37, 0x61, 0xff, 0x43, 0x31, 0x53, 0xff, 0x46, 0x2f, 0x5e, 0xff,
0x42, 0x2e, 0x5c, 0xff, 0x35, 0x1f, 0x4f, 0xff, 0x3b, 0x25, 0x56, 0xff,
0x3d, 0x25, 0x55, 0xff, 0x37, 0x20, 0x4c, 0xff, 0x38, 0x20, 0x51, 0xff,
0x35, 0x1c, 0x4e, 0xff, 0x30, 0x16, 0x4a, 0xff, 0x35, 0x1b, 0x50, 0xff,
0x3d, 0x23, 0x59, 0xff, 0x3d, 0x23, 0x58, 0xff, 0x34, 0x1c, 0x53, 0xff,
0x30, 0x18, 0x51, 0xff, 0x31, 0x16, 0x52, 0xff, 0x34, 0x17, 0x52, 0xff,
0x36, 0x1c, 0x54, 0xff, 0x32, 0x16, 0x52, 0xff, 0x32, 0x16, 0x52, 0xff,
0x35, 0x19, 0x53, 0xff, 0x35, 0x1b, 0x53, 0xff, 0x32, 0x18, 0x50, 0xff,
0x3a, 0x21, 0x59, 0xff, 0x34, 0x1a, 0x53, 0xff, 0x2e, 0x15, 0x4d, 0xff,
0x2f, 0x13, 0x4f, 0xff, 0x34, 0x15, 0x54, 0xff, 0x33, 0x15, 0x51, 0xff,
0x3c, 0x20, 0x58, 0xff, 0x39, 0x1c, 0x54, 0xff, 0x36, 0x1b, 0x51, 0xff,
0x34, 0x19, 0x52, 0xff, 0x31, 0x15, 0x52, 0xff, 0x33, 0x17, 0x52, 0xff,
0x38, 0x1d, 0x56, 0xff, 0x38, 0x1c, 0x52, 0xff, 0x3a, 0x21, 0x52, 0xff,
0x3c, 0x23, 0x55, 0xff, 0x3d, 0x26, 0x59, 0xff, 0x39, 0x23, 0x54, 0xff,
0x3d, 0x25, 0x55, 0xff, 0x3b, 0x23, 0x51, 0xff, 0x3f, 0x28, 0x55, 0xff,
0x3a, 0x23, 0x4f, 0xff, 0x35, 0x1e, 0x49, 0xff, 0x3d, 0x26, 0x4e, 0xff,
0x3b, 0x24, 0x4b, 0xff, 0x45, 0x2f, 0x53, 0xff, 0x4a, 0x35, 0x57, 0xff,
0x60, 0x4c, 0x6b, 0xff, 0x63, 0x58, 0x6d, 0xff, 0xbe, 0xbd, 0xb2, 0xff,
0xb7, 0xb7, 0xa9, 0xff, 0xb6, 0xb7, 0xa7, 0xff, 0xb5, 0xb6, 0xa9, 0xff,
0xb1, 0xb3, 0xa0, 0xff, 0x9a, 0x99, 0x89, 0xff, 0x6c, 0x69, 0x5d, 0xff,
0x41, 0x3a, 0x31, 0xff, 0x2d, 0x27, 0x1c, 0xff, 0x36, 0x32, 0x22, 0xff,
0x64, 0x63, 0x4d, 0xff, 0x92, 0x93, 0x7d, 0xff, 0xaf, 0xaf, 0x9e, 0xff,
0xb4, 0xb6, 0xa6, 0xff, 0xaf, 0xb2, 0x9e, 0xff, 0x7a, 0x79, 0x66, 0xff,
0x2c, 0x27, 0x17, 0xff, 0x22, 0x1d, 0x12, 0xff, 0x1e, 0x1a, 0x0e, 0xff,
0x85, 0xa0, 0xbc, 0xff, 0x83, 0x9d, 0xb5, 0xff, 0x81, 0x99, 0xab, 0xff,
0x7e, 0x91, 0x9f, 0xff, 0x7c, 0x8a, 0x91, 0xff, 0x77, 0x80, 0x81, 0xff,
0x70, 0x75, 0x73, 0xff, 0x6c, 0x6d, 0x66, 0xff, 0x64, 0x64, 0x5a, 0xff,
0x60, 0x5f, 0x54, 0xff, 0x59, 0x5a, 0x4f, 0xff, 0x57, 0x59, 0x51, 0xff,
0x58, 0x5a, 0x55, 0xff, 0x5b, 0x5f, 0x5a, 0xff, 0x5e, 0x64, 0x61, 0xff,
0x63, 0x6c, 0x69, 0xff, 0x6d, 0x74, 0x73, 0xff, 0x78, 0x80, 0x80, 0xff,
0x7e, 0x8b, 0x8a, 0xff, 0x87, 0x94, 0x91, 0xff, 0x93, 0x9b, 0x99, 0xff,
0x99, 0xa1, 0x9f, 0xff, 0x9d, 0xa5, 0xa1, 0xff, 0xa2, 0xa9, 0xa2, 0xff,
0xa4, 0xab, 0x9d, 0xff, 0xa9, 0xae, 0x9f, 0xff, 0xa7, 0xa7, 0xa4, 0xff,
0x4e, 0x43, 0x5c, 0xff, 0x45, 0x33, 0x5a, 0xff, 0x46, 0x36, 0x57, 0xff,
0x40, 0x2e, 0x55, 0xff, 0x40, 0x2e, 0x56, 0xff, 0x3d, 0x28, 0x54, 0xff,
0x36, 0x21, 0x4f, 0xff, 0x43, 0x2b, 0x5a, 0xff, 0x35, 0x1e, 0x4a, 0xff,
0x34, 0x1e, 0x4d, 0xff, 0x39, 0x23, 0x51, 0xff, 0x31, 0x1a, 0x4b, 0xff,
0x2f, 0x17, 0x49, 0xff, 0x34, 0x1d, 0x4f, 0xff, 0x35, 0x1d, 0x4e, 0xff,
0x2f, 0x19, 0x4d, 0xff, 0x30, 0x1b, 0x50, 0xff, 0x2d, 0x16, 0x4e, 0xff,
0x32, 0x17, 0x50, 0xff, 0x31, 0x18, 0x4e, 0xff, 0x39, 0x1f, 0x57, 0xff,
0x2e, 0x14, 0x4c, 0xff, 0x30, 0x18, 0x4c, 0xff, 0x2d, 0x15, 0x49, 0xff,
0x36, 0x1d, 0x56, 0xff, 0x31, 0x18, 0x51, 0xff, 0x34, 0x1b, 0x54, 0xff,
0x2e, 0x15, 0x4e, 0xff, 0x38, 0x1e, 0x57, 0xff, 0x36, 0x1a, 0x54, 0xff,
0x37, 0x1d, 0x54, 0xff, 0x32, 0x18, 0x4e, 0xff, 0x2e, 0x14, 0x49, 0xff,
0x37, 0x1d, 0x52, 0xff, 0x32, 0x18, 0x4e, 0xff, 0x30, 0x15, 0x4e, 0xff,
0x34, 0x18, 0x51, 0xff, 0x35, 0x1b, 0x51, 0xff, 0x35, 0x1b, 0x49, 0xff,
0x3b, 0x22, 0x53, 0xff, 0x3c, 0x24, 0x53, 0xff, 0x38, 0x24, 0x50, 0xff,
0x3d, 0x28, 0x56, 0xff, 0x3b, 0x24, 0x4f, 0xff, 0x39, 0x23, 0x4f, 0xff,
0x39, 0x23, 0x4c, 0xff, 0x32, 0x1d, 0x44, 0xff, 0x33, 0x1e, 0x45, 0xff,
0x3a, 0x25, 0x4c, 0xff, 0x3d, 0x2a, 0x4b, 0xff, 0x43, 0x31, 0x4e, 0xff,
0x54, 0x42, 0x60, 0xff, 0x67, 0x57, 0x73, 0xff, 0x5c, 0x53, 0x61, 0xff,
0xbd, 0xbe, 0xb0, 0xff, 0xb6, 0xb6, 0xa8, 0xff, 0xb6, 0xb7, 0xa7, 0xff,
0xb2, 0xb2, 0xa2, 0xff, 0x99, 0x98, 0x85, 0xff, 0x67, 0x63, 0x57, 0xff,
0x39, 0x33, 0x2b, 0xff, 0x27, 0x23, 0x19, 0xff, 0x42, 0x3f, 0x2e, 0xff,
0x77, 0x78, 0x61, 0xff, 0x9f, 0x9f, 0x90, 0xff, 0xae, 0xae, 0xa1, 0xff,
0xb3, 0xb5, 0xa4, 0xff, 0xaf, 0xb4, 0xa2, 0xff, 0xae, 0xb1, 0xa1, 0xff,
0x90, 0x8e, 0x7c, 0xff, 0x5f, 0x5b, 0x48, 0xff, 0x50, 0x4c, 0x3b, 0xff,
0x48, 0x46, 0x32, 0xff, 0x86, 0x9e, 0xb4, 0xff, 0x82, 0x9a, 0xae, 0xff,
0x82, 0x97, 0xa7, 0xff, 0x7f, 0x8f, 0x9b, 0xff, 0x7d, 0x89, 0x8e, 0xff,
0x79, 0x7f, 0x7e, 0xff, 0x70, 0x74, 0x6f, 0xff, 0x6d, 0x6e, 0x65, 0xff,
0x68, 0x67, 0x5c, 0xff, 0x62, 0x62, 0x54, 0xff, 0x59, 0x5d, 0x51, 0xff,
0x57, 0x5c, 0x52, 0xff, 0x5b, 0x5d, 0x57, 0xff, 0x5d, 0x61, 0x5b, 0xff,
0x60, 0x67, 0x62, 0xff, 0x65, 0x6e, 0x6b, 0xff, 0x6f, 0x75, 0x75, 0xff,
0x79, 0x81, 0x80, 0xff, 0x82, 0x8d, 0x8b, 0xff, 0x88, 0x93, 0x90, 0xff,
0x94, 0x9c, 0x99, 0xff, 0x99, 0xa3, 0x9d, 0xff, 0x9d, 0xa7, 0x9e, 0xff,
0xa2, 0xa9, 0xa2, 0xff, 0xa4, 0xa9, 0xa2, 0xff, 0xa9, 0xad, 0xa0, 0xff,
0xac, 0xaf, 0xa2, 0xff, 0x74, 0x6e, 0x76, 0xff, 0x46, 0x38, 0x57, 0xff,
0x46, 0x35, 0x5a, 0xff, 0x41, 0x33, 0x4f, 0xff, 0x3f, 0x2e, 0x51, 0xff,
0x44, 0x31, 0x59, 0xff, 0x33, 0x1e, 0x4b, 0xff, 0x3c, 0x25, 0x52, 0xff,
0x3c, 0x25, 0x51, 0xff, 0x31, 0x1d, 0x48, 0xff, 0x30, 0x1b, 0x48, 0xff,
0x30, 0x1a, 0x49, 0xff, 0x35, 0x1f, 0x4f, 0xff, 0x30, 0x1a, 0x4a, 0xff,
0x32, 0x1d, 0x4a, 0xff, 0x31, 0x1d, 0x4c, 0xff, 0x29, 0x17, 0x48, 0xff,
0x2f, 0x17, 0x4c, 0xff, 0x2e, 0x15, 0x4c, 0xff, 0x2a, 0x11, 0x49, 0xff,
0x2b, 0x12, 0x4b, 0xff, 0x2d, 0x15, 0x4c, 0xff, 0x2d, 0x17, 0x49, 0xff,
0x33, 0x1e, 0x4e, 0xff, 0x2f, 0x18, 0x4b, 0xff, 0x31, 0x1c, 0x4f, 0xff,
0x36, 0x20, 0x53, 0xff, 0x31, 0x1b, 0x4e, 0xff, 0x31, 0x1b, 0x4c, 0xff,
0x37, 0x1f, 0x51, 0xff, 0x3a, 0x21, 0x54, 0xff, 0x30, 0x17, 0x4c, 0xff,
0x30, 0x17, 0x4d, 0xff, 0x31, 0x17, 0x4b, 0xff, 0x31, 0x17, 0x4d, 0xff,
0x32, 0x16, 0x4e, 0xff, 0x32, 0x18, 0x4f, 0xff, 0x37, 0x1d, 0x52, 0xff,
0x3b, 0x22, 0x4c, 0xff, 0x3d, 0x24, 0x53, 0xff, 0x3a, 0x23, 0x50, 0xff,
0x37, 0x24, 0x4a, 0xff, 0x37, 0x23, 0x4e, 0xff, 0x38, 0x23, 0x4b, 0xff,
0x37, 0x21, 0x49, 0xff, 0x36, 0x21, 0x48, 0xff, 0x35, 0x20, 0x45, 0xff,
0x37, 0x23, 0x46, 0xff, 0x39, 0x25, 0x4a, 0xff, 0x42, 0x31, 0x4f, 0xff,
0x5b, 0x4b, 0x64, 0xff, 0x7f, 0x6f, 0x89, 0xff, 0x43, 0x32, 0x50, 0xff,
0x8b, 0x84, 0x8d, 0xff, 0xb9, 0xba, 0xaa, 0xff, 0xb6, 0xb6, 0xa9, 0xff,
0xaf, 0xb0, 0x9f, 0xff, 0x97, 0x97, 0x87, 0xff, 0x69, 0x63, 0x54, 0xff,
0x39, 0x31, 0x2b, 0xff, 0x2b, 0x25, 0x1d, 0xff, 0x4a, 0x48, 0x38, 0xff,
0x7f, 0x7f, 0x6b, 0xff, 0xa9, 0xa8, 0x9a, 0xff, 0xb2, 0xb3, 0xa4, 0xff,
0xb1, 0xb5, 0xa5, 0xff, 0xaf, 0xb5, 0xa3, 0xff, 0xaf, 0xb3, 0xa6, 0xff,
0xb1, 0xb2, 0xa8, 0xff, 0xaf, 0xaf, 0x9f, 0xff, 0xa6, 0xa7, 0x94, 0xff,
0xa0, 0xa1, 0x8d, 0xff, 0x9b, 0x9e, 0x8a, 0xff, 0x87, 0x9c, 0xad, 0xff,
0x85, 0x98, 0xa8, 0xff, 0x84, 0x96, 0xa2, 0xff, 0x7f, 0x8e, 0x96, 0xff,
0x7c, 0x88, 0x87, 0xff, 0x78, 0x7e, 0x78, 0xff, 0x72, 0x75, 0x6c, 0xff,
0x6f, 0x6f, 0x63, 0xff, 0x6a, 0x69, 0x5e, 0xff, 0x64, 0x64, 0x58, 0xff,
0x5c, 0x5f, 0x54, 0xff, 0x59, 0x5e, 0x55, 0xff, 0x5c, 0x5f, 0x5a, 0xff,
0x60, 0x65, 0x5f, 0xff, 0x64, 0x69, 0x66, 0xff, 0x6a, 0x71, 0x6e, 0xff,
0x70, 0x79, 0x78, 0xff, 0x79, 0x82, 0x80, 0xff, 0x81, 0x8c, 0x8a, 0xff,
0x89, 0x93, 0x91, 0xff, 0x90, 0x9a, 0x98, 0xff, 0x99, 0xa1, 0x9c, 0xff,
0x9e, 0xa7, 0x9e, 0xff, 0xa4, 0xaa, 0xa2, 0xff, 0xa4, 0xa9, 0xa1, 0xff,
0xa8, 0xac, 0xa2, 0xff, 0xaa, 0xae, 0xa3, 0xff, 0xa9, 0xa9, 0xa3, 0xff,
0x4d, 0x46, 0x55, 0xff, 0x45, 0x35, 0x57, 0xff, 0x3e, 0x30, 0x4e, 0xff,
0x39, 0x2c, 0x50, 0xff, 0x3a, 0x2b, 0x4f, 0xff, 0x3c, 0x2a, 0x4e, 0xff,
0x31, 0x1b, 0x44, 0xff, 0x3c, 0x25, 0x51, 0xff, 0x34, 0x20, 0x4c, 0xff,
0x32, 0x1e, 0x4a, 0xff, 0x2e, 0x17, 0x4a, 0xff, 0x2b, 0x13, 0x49, 0xff,
0x2e, 0x18, 0x49, 0xff, 0x30, 0x1c, 0x48, 0xff, 0x32, 0x1e, 0x4a, 0xff,
0x30, 0x1b, 0x49, 0xff, 0x31, 0x1c, 0x4c, 0xff, 0x30, 0x19, 0x4b, 0xff,
0x2e, 0x17, 0x4b, 0xff, 0x2e, 0x18, 0x4c, 0xff, 0x29, 0x13, 0x46, 0xff,
0x2d, 0x17, 0x48, 0xff, 0x30, 0x1c, 0x4b, 0xff, 0x2e, 0x1b, 0x49, 0xff,
0x30, 0x1c, 0x4b, 0xff, 0x2f, 0x1b, 0x49, 0xff, 0x2e, 0x1a, 0x49, 0xff,
0x2f, 0x1b, 0x4a, 0xff, 0x30, 0x1b, 0x4b, 0xff, 0x2a, 0x15, 0x44, 0xff,
0x2d, 0x17, 0x48, 0xff, 0x2c, 0x17, 0x49, 0xff, 0x2f, 0x18, 0x49, 0xff,
0x2c, 0x14, 0x47, 0xff, 0x31, 0x1a, 0x4e, 0xff, 0x32, 0x1b, 0x4e, 0xff,
0x2d, 0x16, 0x45, 0xff, 0x36, 0x22, 0x4b, 0xff, 0x37, 0x22, 0x4e, 0xff,
0x36, 0x21, 0x4b, 0xff, 0x36, 0x23, 0x49, 0xff, 0x34, 0x21, 0x49, 0xff,
0x35, 0x20, 0x48, 0xff, 0x36, 0x23, 0x45, 0xff, 0x33, 0x21, 0x40, 0xff,
0x3b, 0x28, 0x48, 0xff, 0x39, 0x25, 0x48, 0xff, 0x3f, 0x30, 0x4d, 0xff,
0x41, 0x33, 0x4d, 0xff, 0x53, 0x49, 0x56, 0xff, 0xa5, 0x9e, 0xa1, 0xff,
0xa3, 0x9e, 0x9f, 0xff, 0xba, 0xba, 0xb6, 0xff, 0xb7, 0xb9, 0xab, 0xff,
0xb1, 0xb1, 0xa2, 0xff, 0x95, 0x93, 0x84, 0xff, 0x68, 0x62, 0x56, 0xff,
0x39, 0x32, 0x2c, 0xff, 0x29, 0x24, 0x19, 0xff, 0x4c, 0x4b, 0x39, 0xff,
0x86, 0x86, 0x73, 0xff, 0xaa, 0xaa, 0x9a, 0xff, 0xb2, 0xb2, 0xa6, 0xff,
0xb2, 0xb3, 0xa3, 0xff, 0xb1, 0xb3, 0xa2, 0xff, 0xb0, 0xb2, 0xa4, 0xff,
0xb2, 0xb3, 0xa5, 0xff, 0xb2, 0xb3, 0xa6, 0xff, 0xb1, 0xb2, 0xa3, 0xff,
0xb1, 0xb3, 0xa1, 0xff, 0xb0, 0xb2, 0xa1, 0xff, 0xb1, 0xb2, 0xa2, 0xff,
0x89, 0x9a, 0xa8, 0xff, 0x86, 0x97, 0xa3, 0xff, 0x84, 0x94, 0x9c, 0xff,
0x81, 0x8c, 0x90, 0xff, 0x7d, 0x86, 0x82, 0xff, 0x78, 0x7f, 0x74, 0xff,
0x72, 0x75, 0x69, 0xff, 0x6f, 0x70, 0x61, 0xff, 0x6a, 0x69, 0x5e, 0xff,
0x65, 0x64, 0x5a, 0xff, 0x5e, 0x62, 0x57, 0xff, 0x5d, 0x62, 0x59, 0xff,
0x5e, 0x62, 0x5c, 0xff, 0x62, 0x68, 0x63, 0xff, 0x67, 0x6c, 0x69, 0xff,
0x6e, 0x75, 0x72, 0xff, 0x74, 0x7c, 0x7a, 0xff, 0x7a, 0x84, 0x81, 0xff,
0x83, 0x8d, 0x8a, 0xff, 0x8a, 0x94, 0x92, 0xff, 0x91, 0x9b, 0x99, 0xff,
0x9a, 0xa1, 0x9c, 0xff, 0x9f, 0xa7, 0x9e, 0xff, 0xa5, 0xaa, 0xa1, 0xff,
0xa4, 0xab, 0xa0, 0xff, 0xa8, 0xac, 0xa1, 0xff, 0xa9, 0xac, 0xa3, 0xff,
0xae, 0xb1, 0xa5, 0xff, 0x93, 0x90, 0x91, 0xff, 0x49, 0x3c, 0x55, 0xff,
0x3d, 0x2d, 0x4f, 0xff, 0x38, 0x2c, 0x4c, 0xff, 0x39, 0x2d, 0x4a, 0xff,
0x3b, 0x2d, 0x49, 0xff, 0x38, 0x28, 0x47, 0xff, 0x39, 0x25, 0x4a, 0xff,
0x36, 0x23, 0x4a, 0xff, 0x36, 0x23, 0x4d, 0xff, 0x38, 0x22, 0x55, 0xff,
0x30, 0x17, 0x51, 0xff, 0x25, 0x0e, 0x42, 0xff, 0x33, 0x20, 0x48, 0xff,
0x2e, 0x1b, 0x45, 0xff, 0x32, 0x1f, 0x49, 0xff, 0x2e, 0x1a, 0x46, 0xff,
0x2b, 0x17, 0x43, 0xff, 0x33, 0x1f, 0x4d, 0xff, 0x2a, 0x16, 0x44, 0xff,
0x29, 0x15, 0x43, 0xff, 0x2c, 0x18, 0x46, 0xff, 0x2d, 0x19, 0x46, 0xff,
0x2d, 0x19, 0x45, 0xff, 0x2d, 0x19, 0x46, 0xff, 0x30, 0x1d, 0x4a, 0xff,
0x37, 0x22, 0x4f, 0xff, 0x31, 0x1d, 0x4b, 0xff, 0x2d, 0x1a, 0x47, 0xff,
0x2f, 0x1d, 0x46, 0xff, 0x2d, 0x1a, 0x45, 0xff, 0x34, 0x20, 0x4d, 0xff,
0x2a, 0x15, 0x44, 0xff, 0x2e, 0x19, 0x49, 0xff, 0x38, 0x23, 0x54, 0xff,
0x35, 0x21, 0x4f, 0xff, 0x31, 0x1e, 0x48, 0xff, 0x2f, 0x1c, 0x45, 0xff,
0x36, 0x23, 0x4c, 0xff, 0x33, 0x21, 0x48, 0xff, 0x32, 0x20, 0x46, 0xff,
0x37, 0x25, 0x4a, 0xff, 0x34, 0x21, 0x48, 0xff, 0x30, 0x1e, 0x41, 0xff,
0x31, 0x22, 0x3e, 0xff, 0x38, 0x29, 0x45, 0xff, 0x3a, 0x2a, 0x4a, 0xff,
0x38, 0x2b, 0x48, 0xff, 0x3c, 0x32, 0x47, 0xff, 0x8d, 0x89, 0x8b, 0xff,
0xb6, 0xb7, 0xa8, 0xff, 0xb5, 0xb8, 0xa8, 0xff, 0xb6, 0xba, 0xad, 0xff,
0xb0, 0xb1, 0xa5, 0xff, 0x97, 0x95, 0x89, 0xff, 0x61, 0x5b, 0x53, 0xff,
0x34, 0x2c, 0x25, 0xff, 0x2c, 0x28, 0x1f, 0xff, 0x4e, 0x4c, 0x3a, 0xff,
0x87, 0x89, 0x73, 0xff, 0xab, 0xac, 0x99, 0xff, 0xb2, 0xb2, 0xa4, 0xff,
0xb3, 0xb3, 0xa5, 0xff, 0xb3, 0xb3, 0xa5, 0xff, 0xb2, 0xb2, 0xa4, 0xff,
0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb2, 0xa3, 0xff, 0xb1, 0xb2, 0xa2, 0xff,
0xb1, 0xb2, 0xa2, 0xff, 0xb1, 0xb2, 0xa2, 0xff, 0xb1, 0xb2, 0xa2, 0xff,
0xb0, 0xb1, 0xa1, 0xff, 0x8b, 0x99, 0xa1, 0xff, 0x89, 0x97, 0x9c, 0xff,
0x86, 0x92, 0x94, 0xff, 0x80, 0x8a, 0x88, 0xff, 0x7d, 0x85, 0x7d, 0xff,
0x78, 0x7d, 0x72, 0xff, 0x72, 0x76, 0x68, 0xff, 0x70, 0x70, 0x62, 0xff,
0x6b, 0x6a, 0x5e, 0xff, 0x65, 0x64, 0x5a, 0xff, 0x61, 0x64, 0x5a, 0xff,
0x61, 0x66, 0x5d, 0xff, 0x61, 0x65, 0x5f, 0xff, 0x65, 0x6b, 0x65, 0xff,
0x69, 0x6f, 0x6a, 0xff, 0x71, 0x78, 0x75, 0xff, 0x76, 0x7e, 0x7b, 0xff,
0x7d, 0x85, 0x82, 0xff, 0x84, 0x8d, 0x8a, 0xff, 0x8d, 0x96, 0x93, 0xff,
0x94, 0x9c, 0x99, 0xff, 0x9a, 0xa1, 0x9c, 0xff, 0x9f, 0xa7, 0x9f, 0xff,
0xa5, 0xaa, 0xa1, 0xff, 0xa4, 0xaa, 0x9f, 0xff, 0xa8, 0xac, 0xa1, 0xff,
0xa9, 0xad, 0xa1, 0xff, 0xaa, 0xad, 0x9e, 0xff, 0xad, 0xaf, 0xa4, 0xff,
0x6e, 0x67, 0x71, 0xff, 0x3f, 0x31, 0x4e, 0xff, 0x3c, 0x30, 0x4b, 0xff,
0x3a, 0x2e, 0x49, 0xff, 0x37, 0x2b, 0x46, 0xff, 0x3a, 0x2c, 0x49, 0xff,
0x35, 0x26, 0x45, 0xff, 0x36, 0x28, 0x47, 0xff, 0x2f, 0x1f, 0x41, 0xff,
0x38, 0x24, 0x53, 0xff, 0x47, 0x30, 0x66, 0xff, 0x2c, 0x17, 0x49, 0xff,
0x2b, 0x1a, 0x3f, 0xff, 0x2c, 0x1b, 0x42, 0xff, 0x2e, 0x1d, 0x43, 0xff,
0x2c, 0x1a, 0x43, 0xff, 0x2a, 0x19, 0x41, 0xff, 0x2a, 0x19, 0x43, 0xff,
0x26, 0x15, 0x3f, 0xff, 0x27, 0x16, 0x40, 0xff, 0x29, 0x17, 0x41, 0xff,
0x2a, 0x19, 0x43, 0xff, 0x27, 0x17, 0x3e, 0xff, 0x30, 0x20, 0x47, 0xff,
0x2e, 0x1e, 0x45, 0xff, 0x2c, 0x1c, 0x42, 0xff, 0x2d, 0x1d, 0x44, 0xff,
0x2c, 0x1c, 0x42, 0xff, 0x29, 0x1b, 0x3d, 0xff, 0x25, 0x16, 0x39, 0xff,
0x2b, 0x1c, 0x42, 0xff, 0x2b, 0x19, 0x41, 0xff, 0x2b, 0x18, 0x42, 0xff,
0x33, 0x20, 0x4c, 0xff, 0x32, 0x1f, 0x49, 0xff, 0x30, 0x1f, 0x45, 0xff,
0x31, 0x20, 0x45, 0xff, 0x31, 0x20, 0x45, 0xff, 0x35, 0x24, 0x47, 0xff,
0x31, 0x20, 0x42, 0xff, 0x39, 0x2a, 0x4a, 0xff, 0x33, 0x22, 0x46, 0xff,
0x2f, 0x1e, 0x40, 0xff, 0x34, 0x25, 0x42, 0xff, 0x33, 0x24, 0x40, 0xff,
0x37, 0x29, 0x44, 0xff, 0x38, 0x2c, 0x45, 0xff, 0x56, 0x50, 0x5c, 0xff,
0x9c, 0x9d, 0x92, 0xff, 0xb8, 0xbc, 0xa8, 0xff, 0xb4, 0xb7, 0xa8, 0xff,
0xb2, 0xb4, 0xa3, 0xff, 0x98, 0x96, 0x8a, 0xff, 0x65, 0x5f, 0x58, 0xff,
0x37, 0x30, 0x2c, 0xff, 0x2f, 0x26, 0x20, 0xff, 0x50, 0x4f, 0x3c, 0xff,
0x8a, 0x8c, 0x76, 0xff, 0xae, 0xb0, 0x9b, 0xff, 0xb4, 0xb5, 0xa5, 0xff,
0xb5, 0xb5, 0xa9, 0xff, 0xb3, 0xb3, 0xa5, 0xff, 0xb3, 0xb3, 0xa5, 0xff,
0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb1, 0xb1, 0xa3, 0xff,
0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb1, 0xb2, 0xa2, 0xff,
0xb1, 0xb2, 0xa2, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0x8d, 0x98, 0x98, 0xff,
0x8c, 0x95, 0x93, 0xff, 0x89, 0x91, 0x8b, 0xff, 0x82, 0x89, 0x81, 0xff,
0x7d, 0x82, 0x77, 0xff, 0x7a, 0x7e, 0x6f, 0xff, 0x76, 0x79, 0x69, 0xff,
0x71, 0x72, 0x64, 0xff, 0x6c, 0x6b, 0x60, 0xff, 0x69, 0x68, 0x5e, 0xff,
0x64, 0x67, 0x5c, 0xff, 0x63, 0x69, 0x5f, 0xff, 0x68, 0x6d, 0x63, 0xff,
0x6c, 0x72, 0x6b, 0xff, 0x71, 0x78, 0x71, 0xff, 0x74, 0x7b, 0x76, 0xff,
0x77, 0x7e, 0x79, 0xff, 0x7d, 0x84, 0x7f, 0xff, 0x84, 0x8a, 0x86, 0xff,
0x8b, 0x91, 0x8d, 0xff, 0x91, 0x97, 0x93, 0xff, 0x98, 0x9f, 0x98, 0xff,
0x9b, 0xa3, 0x9b, 0xff, 0xa1, 0xa6, 0x9d, 0xff, 0xa1, 0xa7, 0x9c, 0xff,
0xa6, 0xaa, 0x9f, 0xff, 0xa8, 0xac, 0xa0, 0xff, 0xaa, 0xad, 0x9f, 0xff,
0xad, 0xb0, 0xa1, 0xff, 0xb3, 0xb1, 0xa9, 0xff, 0x59, 0x51, 0x5d, 0xff,
0x3f, 0x33, 0x4b, 0xff, 0x35, 0x29, 0x45, 0xff, 0x3b, 0x2f, 0x4d, 0xff,
0x3a, 0x2f, 0x4d, 0xff, 0x31, 0x28, 0x43, 0xff, 0x30, 0x26, 0x40, 0xff,
0x32, 0x28, 0x44, 0xff, 0x29, 0x1b, 0x41, 0xff, 0x31, 0x22, 0x4c, 0xff,
0x27, 0x1a, 0x3f, 0xff, 0x24, 0x18, 0x39, 0xff, 0x29, 0x1d, 0x3d, 0xff,
0x29, 0x1d, 0x3f, 0xff, 0x29, 0x1d, 0x40, 0xff, 0x29, 0x1b, 0x40, 0xff,
0x2b, 0x1c, 0x40, 0xff, 0x26, 0x19, 0x3c, 0xff, 0x29, 0x1b, 0x3f, 0xff,
0x26, 0x18, 0x3c, 0xff, 0x29, 0x1b, 0x3e, 0xff, 0x29, 0x1b, 0x3d, 0xff,
0x29, 0x1c, 0x3d, 0xff, 0x2d, 0x1f, 0x41, 0xff, 0x2d, 0x20, 0x41, 0xff,
0x2b, 0x1d, 0x3f, 0xff, 0x2b, 0x1e, 0x3e, 0xff, 0x26, 0x1a, 0x38, 0xff,
0x26, 0x1a, 0x38, 0xff, 0x2d, 0x21, 0x41, 0xff, 0x2a, 0x1c, 0x3e, 0xff,
0x2c, 0x1c, 0x41, 0xff, 0x30, 0x20, 0x46, 0xff, 0x2f, 0x1f, 0x43, 0xff,
0x36, 0x28, 0x47, 0xff, 0x32, 0x24, 0x45, 0xff, 0x32, 0x24, 0x44, 0xff,
0x32, 0x25, 0x44, 0xff, 0x33, 0x26, 0x44, 0xff, 0x30, 0x23, 0x40, 0xff,
0x2c, 0x1d, 0x3c, 0xff, 0x33, 0x24, 0x44, 0xff, 0x34, 0x26, 0x43, 0xff,
0x35, 0x29, 0x3e, 0xff, 0x3c, 0x32, 0x41, 0xff, 0x5b, 0x56, 0x5e, 0xff,
0x9a, 0x98, 0x98, 0xff, 0xa9, 0xab, 0x9d, 0xff, 0xb6, 0xba, 0xa6, 0xff,
0xb5, 0xb6, 0xa9, 0xff, 0xa3, 0xa2, 0x8f, 0xff, 0x6d, 0x69, 0x5d, 0xff,
0x38, 0x32, 0x2d, 0xff, 0x2b, 0x25, 0x1d, 0xff, 0x51, 0x4d, 0x41, 0xff,
0x88, 0x8a, 0x74, 0xff, 0xad, 0xae, 0x9a, 0xff, 0xb5, 0xb7, 0xa5, 0xff,
0xb3, 0xb5, 0xa6, 0xff, 0xb2, 0xb4, 0xa6, 0xff, 0xb3, 0xb3, 0xa5, 0xff,
0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb2, 0xa4, 0xff,
0xb1, 0xb2, 0xa3, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff,
0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff,
0x8d, 0x94, 0x8f, 0xff, 0x8b, 0x91, 0x8b, 0xff, 0x87, 0x8c, 0x82, 0xff,
0x82, 0x87, 0x7c, 0xff, 0x7f, 0x83, 0x75, 0xff, 0x7b, 0x7e, 0x6d, 0xff,
0x77, 0x7a, 0x68, 0xff, 0x74, 0x74, 0x66, 0xff, 0x6f, 0x6e, 0x62, 0xff,
0x6a, 0x6a, 0x60, 0xff, 0x66, 0x69, 0x5e, 0xff, 0x65, 0x6b, 0x61, 0xff,
0x6b, 0x70, 0x67, 0xff, 0x73, 0x7b, 0x71, 0xff, 0x76, 0x7d, 0x77, 0xff,
0x70, 0x77, 0x71, 0xff, 0x70, 0x76, 0x71, 0xff, 0x78, 0x7c, 0x77, 0xff,
0x7e, 0x83, 0x7e, 0xff, 0x86, 0x8a, 0x85, 0xff, 0x90, 0x94, 0x8f, 0xff,
0x95, 0x9c, 0x95, 0xff, 0x96, 0x9d, 0x95, 0xff, 0x99, 0x9e, 0x95, 0xff,
0x99, 0x9f, 0x94, 0xff, 0xa0, 0xa4, 0x99, 0xff, 0xa6, 0xac, 0x9c, 0xff,
0xa9, 0xaa, 0xa2, 0xff, 0xaa, 0xac, 0x9f, 0xff, 0xb0, 0xb2, 0x9e, 0xff,
0xa9, 0xa8, 0x9f, 0xff, 0x4b, 0x41, 0x51, 0xff, 0x3a, 0x30, 0x46, 0xff,
0x35, 0x2b, 0x44, 0xff, 0x31, 0x2b, 0x42, 0xff, 0x32, 0x2e, 0x42, 0xff,
0x32, 0x29, 0x43, 0xff, 0x31, 0x2a, 0x40, 0xff, 0x2a, 0x21, 0x3e, 0xff,
0x28, 0x20, 0x3b, 0xff, 0x2b, 0x25, 0x39, 0xff, 0x29, 0x21, 0x3d, 0xff,
0x2e, 0x25, 0x43, 0xff, 0x29, 0x1f, 0x3f, 0xff, 0x27, 0x1c, 0x3d, 0xff,
0x24, 0x1b, 0x3b, 0xff, 0x29, 0x1e, 0x3e, 0xff, 0x2c, 0x21, 0x41, 0xff,
0x25, 0x1a, 0x3a, 0xff, 0x26, 0x1b, 0x3b, 0xff, 0x2a, 0x20, 0x3f, 0xff,
0x2b, 0x20, 0x3e, 0xff, 0x28, 0x1e, 0x3b, 0xff, 0x2a, 0x21, 0x3e, 0xff,
0x28, 0x1f, 0x3b, 0xff, 0x2a, 0x1f, 0x3e, 0xff, 0x29, 0x1e, 0x3e, 0xff,
0x24, 0x1b, 0x37, 0xff, 0x27, 0x1d, 0x3a, 0xff, 0x28, 0x1d, 0x3d, 0xff,
0x28, 0x1c, 0x3c, 0xff, 0x2f, 0x22, 0x42, 0xff, 0x2e, 0x21, 0x43, 0xff,
0x2f, 0x22, 0x42, 0xff, 0x2e, 0x23, 0x3e, 0xff, 0x31, 0x24, 0x43, 0xff,
0x31, 0x24, 0x42, 0xff, 0x31, 0x25, 0x41, 0xff, 0x31, 0x26, 0x40, 0xff,
0x27, 0x1d, 0x36, 0xff, 0x2f, 0x23, 0x3d, 0xff, 0x32, 0x24, 0x40, 0xff,
0x31, 0x25, 0x3f, 0xff, 0x37, 0x2f, 0x3d, 0xff, 0x5f, 0x5a, 0x5f, 0xff,
0xc5, 0xc5, 0xb6, 0xff, 0xae, 0xad, 0xa3, 0xff, 0xb8, 0xb7, 0xab, 0xff,
0xb8, 0xb8, 0xa9, 0xff, 0xae, 0xad, 0xa0, 0xff, 0x88, 0x84, 0x71, 0xff,
0x45, 0x3f, 0x34, 0xff, 0x2a, 0x24, 0x1c, 0xff, 0x45, 0x41, 0x33, 0xff,
0x83, 0x83, 0x6c, 0xff, 0xb0, 0xb0, 0x9f, 0xff, 0xb6, 0xb6, 0xa8, 0xff,
0xb3, 0xb6, 0xa8, 0xff, 0xb2, 0xb5, 0xa6, 0xff, 0xb2, 0xb4, 0xa4, 0xff,
0xb3, 0xb3, 0xa5, 0xff, 0xb2, 0xb2, 0xa4, 0xff, 0xb2, 0xb2, 0xa4, 0xff,
0xb2, 0xb2, 0xa4, 0xff, 0xb1, 0xb1, 0xa3, 0xff, 0xb0, 0xb1, 0xa1, 0xff,
0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff,
0xb0, 0xb1, 0xa1, 0xff, 0x89, 0x91, 0x86, 0xff, 0x88, 0x90, 0x81, 0xff,
0x88, 0x8b, 0x7c, 0xff, 0x84, 0x87, 0x78, 0xff, 0x81, 0x84, 0x75, 0xff,
0x7c, 0x7f, 0x70, 0xff, 0x78, 0x7a, 0x6c, 0xff, 0x73, 0x75, 0x68, 0xff,
0x6f, 0x70, 0x64, 0xff, 0x6d, 0x6d, 0x63, 0xff, 0x69, 0x6a, 0x60, 0xff,
0x66, 0x69, 0x61, 0xff, 0x6a, 0x6e, 0x67, 0xff, 0x70, 0x73, 0x6a, 0xff,
0x71, 0x73, 0x69, 0xff, 0x6b, 0x6d, 0x64, 0xff, 0x6f, 0x6c, 0x66, 0xff,
0x75, 0x6f, 0x6b, 0xff, 0x7b, 0x79, 0x75, 0xff, 0x82, 0x85, 0x80, 0xff,
0x89, 0x8f, 0x8c, 0xff, 0x90, 0x94, 0x93, 0xff, 0x8f, 0x93, 0x92, 0xff,
0x91, 0x92, 0x90, 0xff, 0x91, 0x93, 0x8b, 0xff, 0x9a, 0x9c, 0x90, 0xff,
0xa1, 0xa5, 0x96, 0xff, 0xa7, 0xaa, 0x9d, 0xff, 0xaa, 0xad, 0x9f, 0xff,
0xa9, 0xac, 0x9b, 0xff, 0xad, 0xaf, 0xa0, 0xff, 0xa7, 0xa7, 0x9e, 0xff,
0x47, 0x45, 0x4b, 0xff, 0x36, 0x2f, 0x45, 0xff, 0x34, 0x2d, 0x46, 0xff,
0x34, 0x30, 0x45, 0xff, 0x39, 0x39, 0x4a, 0xff, 0x2f, 0x2a, 0x44, 0xff,
0x2f, 0x27, 0x42, 0xff, 0x30, 0x2a, 0x42, 0xff, 0x27, 0x21, 0x3d, 0xff,
0x2a, 0x20, 0x41, 0xff, 0x2a, 0x21, 0x43, 0xff, 0x2a, 0x21, 0x42, 0xff,
0x29, 0x21, 0x41, 0xff, 0x28, 0x20, 0x3e, 0xff, 0x27, 0x1d, 0x3b, 0xff,
0x27, 0x1e, 0x3a, 0xff, 0x2a, 0x20, 0x3c, 0xff, 0x26, 0x1d, 0x38, 0xff,
0x27, 0x20, 0x39, 0xff, 0x29, 0x23, 0x3b, 0xff, 0x2a, 0x25, 0x3c, 0xff,
0x2a, 0x25, 0x3c, 0xff, 0x2a, 0x25, 0x3c, 0xff, 0x29, 0x23, 0x3b, 0xff,
0x2c, 0x25, 0x3d, 0xff, 0x29, 0x20, 0x3b, 0xff, 0x26, 0x1c, 0x38, 0xff,
0x26, 0x1e, 0x39, 0xff, 0x27, 0x21, 0x3b, 0xff, 0x2c, 0x24, 0x3f, 0xff,
0x2a, 0x22, 0x3d, 0xff, 0x30, 0x28, 0x42, 0xff, 0x2d, 0x26, 0x3f, 0xff,
0x31, 0x2c, 0x42, 0xff, 0x30, 0x2a, 0x42, 0xff, 0x30, 0x28, 0x41, 0xff,
0x28, 0x1f, 0x39, 0xff, 0x2a, 0x22, 0x39, 0xff, 0x2e, 0x26, 0x3c, 0xff,
0x2e, 0x26, 0x3d, 0xff, 0x32, 0x2b, 0x3c, 0xff, 0x5c, 0x58, 0x5b, 0xff,
0xb6, 0xb6, 0xac, 0xff, 0xb6, 0xb9, 0xa7, 0xff, 0xb6, 0xb9, 0xaa, 0xff,
0xb8, 0xb8, 0xab, 0xff, 0xb0, 0xb0, 0xa3, 0xff, 0x96, 0x94, 0x89, 0xff,
0x60, 0x5a, 0x4c, 0xff, 0x2e, 0x27, 0x1f, 0xff, 0x3c, 0x38, 0x28, 0xff,
0x79, 0x79, 0x64, 0xff, 0xa9, 0xa8, 0x96, 0xff, 0xb6, 0xb6, 0xa7, 0xff,
0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa7, 0xff, 0xb5, 0xb6, 0xa6, 0xff,
0xb5, 0xb5, 0xa6, 0xff, 0xb5, 0xb5, 0xa5, 0xff, 0xb3, 0xb3, 0xa4, 0xff,
0xb3, 0xb3, 0xa4, 0xff, 0xb3, 0xb3, 0xa4, 0xff, 0xb1, 0xb2, 0xa3, 0xff,
0xb1, 0xb1, 0xa2, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb0, 0xb1, 0xa1, 0xff,
0xb0, 0xb1, 0x9f, 0xff, 0xae, 0xb1, 0xa0, 0xff, 0x89, 0x8f, 0x7e, 0xff,
0x88, 0x8d, 0x7b, 0xff, 0x87, 0x8b, 0x7a, 0xff, 0x85, 0x88, 0x78, 0xff,
0x82, 0x85, 0x76, 0xff, 0x7d, 0x80, 0x71, 0xff, 0x7a, 0x7c, 0x70, 0xff,
0x75, 0x78, 0x6c, 0xff, 0x71, 0x72, 0x67, 0xff, 0x6d, 0x6e, 0x64, 0xff,
0x6a, 0x6b, 0x62, 0xff, 0x66, 0x68, 0x60, 0xff, 0x69, 0x6a, 0x64, 0xff,
0x6c, 0x6c, 0x63, 0xff, 0x6b, 0x68, 0x5e, 0xff, 0x60, 0x5d, 0x53, 0xff,
0x60, 0x59, 0x51, 0xff, 0x64, 0x5a, 0x56, 0xff, 0x6d, 0x67, 0x63, 0xff,
0x75, 0x74, 0x70, 0xff, 0x7a, 0x7d, 0x7a, 0xff, 0x7c, 0x7e, 0x7e, 0xff,
0x7b, 0x7b, 0x7e, 0xff, 0x7a, 0x79, 0x7a, 0xff, 0x7f, 0x7e, 0x7b, 0xff,
0x8d, 0x8c, 0x82, 0xff, 0x97, 0x9a, 0x8b, 0xff, 0xa3, 0xa6, 0x97, 0xff,
0xaa, 0xad, 0x9e, 0xff, 0xab, 0xae, 0x9f, 0xff, 0xab, 0xae, 0x9f, 0xff,
0xae, 0xb0, 0xa1, 0xff, 0xb2, 0xb2, 0xac, 0xff, 0x56, 0x55, 0x5b, 0xff,
0x32, 0x2f, 0x3e, 0xff, 0x32, 0x2f, 0x3f, 0xff, 0x39, 0x3b, 0x4a, 0xff,
0x40, 0x40, 0x52, 0xff, 0x38, 0x34, 0x48, 0xff, 0x2c, 0x2a, 0x3d, 0xff,
0x38, 0x38, 0x48, 0xff, 0x38, 0x35, 0x4b, 0xff, 0x37, 0x33, 0x4c, 0xff,
0x32, 0x2d, 0x48, 0xff, 0x30, 0x2b, 0x47, 0xff, 0x32, 0x2d, 0x47, 0xff,
0x2d, 0x2a, 0x40, 0xff, 0x2b, 0x28, 0x3e, 0xff, 0x2b, 0x29, 0x3d, 0xff,
0x2b, 0x29, 0x3c, 0xff, 0x2a, 0x2a, 0x3c, 0xff, 0x29, 0x2e, 0x3c, 0xff,
0x28, 0x2c, 0x3a, 0xff, 0x2b, 0x30, 0x3e, 0xff, 0x2a, 0x2f, 0x3c, 0xff,
0x2b, 0x2f, 0x3d, 0xff, 0x25, 0x27, 0x36, 0xff, 0x28, 0x26, 0x3a, 0xff,
0x26, 0x24, 0x39, 0xff, 0x26, 0x26, 0x3a, 0xff, 0x28, 0x28, 0x3b, 0xff,
0x29, 0x28, 0x3c, 0xff, 0x26, 0x25, 0x39, 0xff, 0x2e, 0x2e, 0x42, 0xff,
0x2b, 0x2b, 0x3e, 0xff, 0x2e, 0x2c, 0x3f, 0xff, 0x29, 0x27, 0x3c, 0xff,
0x26, 0x20, 0x38, 0xff, 0x2c, 0x25, 0x3c, 0xff, 0x32, 0x2b, 0x40, 0xff,
0x2d, 0x27, 0x37, 0xff, 0x33, 0x2f, 0x39, 0xff, 0x65, 0x61, 0x63, 0xff,
0xbb, 0xbc, 0xb3, 0xff, 0xb5, 0xb6, 0xa8, 0xff, 0xb7, 0xb8, 0xa9, 0xff,
0xb6, 0xb8, 0xa9, 0xff, 0xb3, 0xb5, 0xa8, 0xff, 0xa3, 0xa5, 0x99, 0xff,
0x97, 0x99, 0x8c, 0xff, 0x4f, 0x4b, 0x3b, 0xff, 0x32, 0x2e, 0x21, 0xff,
0x6d, 0x6b, 0x58, 0xff, 0x9f, 0xa2, 0x8a, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb7, 0xb7, 0xa7, 0xff, 0xb7, 0xb7, 0xa7, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff, 0xb5, 0xb5, 0xa5, 0xff,
0xb4, 0xb4, 0xa4, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb1, 0xb3, 0xa3, 0xff, 0xaf, 0xb2, 0xa3, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xb0, 0xb0, 0x9f, 0xff, 0xad, 0xb1, 0x9e, 0xff, 0xad, 0xb1, 0x9f, 0xff,
0x8a, 0x8c, 0x79, 0xff, 0x89, 0x8b, 0x78, 0xff, 0x86, 0x8a, 0x78, 0xff,
0x86, 0x89, 0x79, 0xff, 0x83, 0x86, 0x77, 0xff, 0x7f, 0x82, 0x73, 0xff,
0x7b, 0x7d, 0x71, 0xff, 0x75, 0x79, 0x6e, 0xff, 0x72, 0x75, 0x6a, 0xff,
0x6f, 0x72, 0x69, 0xff, 0x6c, 0x6e, 0x66, 0xff, 0x68, 0x6a, 0x63, 0xff,
0x68, 0x68, 0x62, 0xff, 0x67, 0x64, 0x5c, 0xff, 0x5e, 0x5c, 0x52, 0xff,
0x53, 0x4d, 0x44, 0xff, 0x4f, 0x45, 0x3e, 0xff, 0x52, 0x48, 0x41, 0xff,
0x5d, 0x55, 0x50, 0xff, 0x65, 0x60, 0x5c, 0xff, 0x69, 0x66, 0x62, 0xff,
0x6d, 0x6a, 0x6a, 0xff, 0x6b, 0x68, 0x6a, 0xff, 0x6d, 0x6a, 0x6c, 0xff,
0x71, 0x70, 0x6e, 0xff, 0x80, 0x80, 0x7a, 0xff, 0x8b, 0x8e, 0x81, 0xff,
0x9a, 0x9d, 0x8e, 0xff, 0xa7, 0xaa, 0x9b, 0xff, 0xab, 0xae, 0x9f, 0xff,
0xab, 0xae, 0x9f, 0xff, 0xab, 0xae, 0x9e, 0xff, 0xab, 0xae, 0x9e, 0xff,
0xac, 0xaf, 0xa2, 0xff, 0x80, 0x81, 0x7f, 0xff, 0x3a, 0x39, 0x42, 0xff,
0x33, 0x36, 0x45, 0xff, 0x32, 0x39, 0x3f, 0xff, 0x39, 0x3e, 0x4a, 0xff,
0x39, 0x3b, 0x47, 0xff, 0x67, 0x6c, 0x6a, 0xff, 0x55, 0x5b, 0x61, 0xff,
0x41, 0x46, 0x51, 0xff, 0x42, 0x45, 0x55, 0xff, 0x4e, 0x50, 0x62, 0xff,
0x43, 0x45, 0x58, 0xff, 0x3f, 0x45, 0x53, 0xff, 0x37, 0x3d, 0x4b, 0xff,
0x30, 0x36, 0x42, 0xff, 0x2f, 0x35, 0x41, 0xff, 0x2b, 0x32, 0x3b, 0xff,
0x20, 0x2a, 0x30, 0xff, 0x1d, 0x26, 0x2d, 0xff, 0x28, 0x32, 0x38, 0xff,
0x2f, 0x38, 0x3f, 0xff, 0x30, 0x3b, 0x40, 0xff, 0x2a, 0x34, 0x3b, 0xff,
0x2d, 0x34, 0x3e, 0xff, 0x2a, 0x31, 0x3c, 0xff, 0x24, 0x2e, 0x37, 0xff,
0x28, 0x30, 0x3b, 0xff, 0x2f, 0x35, 0x42, 0xff, 0x31, 0x38, 0x44, 0xff,
0x2d, 0x33, 0x3f, 0xff, 0x29, 0x30, 0x3c, 0xff, 0x27, 0x28, 0x39, 0xff,
0x29, 0x28, 0x3a, 0xff, 0x26, 0x24, 0x38, 0xff, 0x2c, 0x29, 0x3b, 0xff,
0x2c, 0x29, 0x38, 0xff, 0x37, 0x33, 0x38, 0xff, 0x7b, 0x7b, 0x76, 0xff,
0xb6, 0xbb, 0xac, 0xff, 0xb1, 0xb7, 0xa8, 0xff, 0xb3, 0xb8, 0xab, 0xff,
0xb0, 0xb5, 0xae, 0xff, 0xaf, 0xb6, 0xad, 0xff, 0xaf, 0xb7, 0xae, 0xff,
0xa5, 0xb0, 0xa5, 0xff, 0x84, 0x8f, 0x83, 0xff, 0x37, 0x35, 0x22, 0xff,
0x47, 0x46, 0x34, 0xff, 0x8b, 0x8c, 0x78, 0xff, 0xb3, 0xb4, 0xa0, 0xff,
0xb6, 0xb8, 0xa4, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb5, 0xb5, 0xa5, 0xff, 0xb4, 0xb4, 0xa4, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb4, 0xb4, 0xa4, 0xff, 0xb0, 0xb3, 0xa2, 0xff, 0xb1, 0xb4, 0xa1, 0xff,
0xb1, 0xb1, 0xa0, 0xff, 0xb1, 0xb1, 0xa1, 0xff, 0xae, 0xb1, 0xa1, 0xff,
0xac, 0xb0, 0x9f, 0xff, 0x8b, 0x8b, 0x79, 0xff, 0x8b, 0x8c, 0x79, 0xff,
0x87, 0x8a, 0x79, 0xff, 0x86, 0x89, 0x79, 0xff, 0x83, 0x86, 0x77, 0xff,
0x80, 0x83, 0x74, 0xff, 0x7c, 0x7f, 0x73, 0xff, 0x76, 0x7c, 0x71, 0xff,
0x74, 0x78, 0x6f, 0xff, 0x71, 0x75, 0x6d, 0xff, 0x6e, 0x71, 0x6b, 0xff,
0x6b, 0x6e, 0x68, 0xff, 0x6c, 0x6c, 0x66, 0xff, 0x64, 0x63, 0x5b, 0xff,
0x5b, 0x59, 0x4f, 0xff, 0x51, 0x4c, 0x42, 0xff, 0x4b, 0x44, 0x3c, 0xff,
0x4b, 0x43, 0x3b, 0xff, 0x54, 0x4d, 0x46, 0xff, 0x56, 0x50, 0x4a, 0xff,
0x55, 0x51, 0x4c, 0xff, 0x56, 0x51, 0x4e, 0xff, 0x56, 0x51, 0x50, 0xff,
0x66, 0x62, 0x61, 0xff, 0x72, 0x70, 0x6d, 0xff, 0x73, 0x74, 0x6c, 0xff,
0x84, 0x86, 0x79, 0xff, 0x91, 0x94, 0x85, 0xff, 0xa2, 0xa5, 0x96, 0xff,
0xa9, 0xac, 0x9d, 0xff, 0xaa, 0xad, 0x9e, 0xff, 0xad, 0xad, 0x9f, 0xff,
0xac, 0xaf, 0x9c, 0xff, 0xac, 0xb1, 0x9d, 0xff, 0xb0, 0xb2, 0xa6, 0xff,
0x7f, 0x80, 0x7c, 0xff, 0x3d, 0x42, 0x4b, 0xff, 0x3a, 0x45, 0x4b, 0xff,
0x2d, 0x38, 0x41, 0xff, 0x36, 0x3b, 0x44, 0xff, 0x6e, 0x71, 0x72, 0xff,
0x62, 0x6b, 0x6e, 0xff, 0x50, 0x58, 0x60, 0xff, 0x57, 0x5e, 0x69, 0xff,
0x4e, 0x54, 0x60, 0xff, 0x51, 0x58, 0x63, 0xff, 0x25, 0x2e, 0x38, 0xff,
0x2d, 0x37, 0x40, 0xff, 0x20, 0x2b, 0x32, 0xff, 0x19, 0x24, 0x2b, 0xff,
0x1a, 0x24, 0x2a, 0xff, 0x13, 0x1a, 0x1e, 0xff, 0x23, 0x2a, 0x2e, 0xff,
0x28, 0x2e, 0x34, 0xff, 0x2c, 0x33, 0x38, 0xff, 0x2d, 0x37, 0x3a, 0xff,
0x25, 0x30, 0x34, 0xff, 0x25, 0x2a, 0x33, 0xff, 0x2d, 0x33, 0x3d, 0xff,
0x31, 0x3a, 0x42, 0xff, 0x39, 0x43, 0x4a, 0xff, 0x35, 0x40, 0x47, 0xff,
0x32, 0x3c, 0x44, 0xff, 0x2d, 0x37, 0x3e, 0xff, 0x27, 0x31, 0x39, 0xff,
0x2b, 0x2f, 0x3a, 0xff, 0x2a, 0x2c, 0x38, 0xff, 0x2b, 0x2c, 0x38, 0xff,
0x2f, 0x30, 0x39, 0xff, 0x38, 0x3a, 0x3e, 0xff, 0x82, 0x84, 0x80, 0xff,
0xb3, 0xb8, 0xae, 0xff, 0xae, 0xb6, 0xaa, 0xff, 0xae, 0xb9, 0xaf, 0xff,
0xab, 0xb6, 0xae, 0xff, 0xac, 0xb8, 0xb4, 0xff, 0xa9, 0xb6, 0xb0, 0xff,
0xa0, 0xac, 0xa4, 0xff, 0x89, 0x96, 0x8a, 0xff, 0x57, 0x62, 0x55, 0xff,
0x62, 0x61, 0x4d, 0xff, 0x7e, 0x80, 0x69, 0xff, 0xa2, 0xa3, 0x91, 0xff,
0xb7, 0xb8, 0xa8, 0xff, 0xb4, 0xb8, 0xa4, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb6, 0xb6, 0xa6, 0xff, 0xb4, 0xb4, 0xa4, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xa2, 0xa1, 0x91, 0xff, 0x93, 0x8d, 0x80, 0xff, 0x82, 0x7d, 0x72, 0xff,
0x75, 0x71, 0x69, 0xff, 0x95, 0x94, 0x8b, 0xff, 0x8b, 0x8b, 0x7b, 0xff,
0x8a, 0x8b, 0x7b, 0xff, 0x86, 0x8a, 0x78, 0xff, 0x86, 0x89, 0x79, 0xff,
0x84, 0x87, 0x78, 0xff, 0x82, 0x85, 0x76, 0xff, 0x7d, 0x81, 0x75, 0xff,
0x78, 0x7d, 0x74, 0xff, 0x75, 0x7a, 0x71, 0xff, 0x74, 0x78, 0x72, 0xff,
0x70, 0x74, 0x6f, 0xff, 0x6f, 0x73, 0x6d, 0xff, 0x71, 0x74, 0x6e, 0xff,
0x6c, 0x6f, 0x66, 0xff, 0x63, 0x62, 0x58, 0xff, 0x57, 0x55, 0x4b, 0xff,
0x4f, 0x4c, 0x42, 0xff, 0x49, 0x46, 0x3c, 0xff, 0x4e, 0x49, 0x41, 0xff,
0x4f, 0x4c, 0x45, 0xff, 0x4b, 0x47, 0x42, 0xff, 0x4c, 0x46, 0x3f, 0xff,
0x55, 0x50, 0x49, 0xff, 0x6e, 0x6a, 0x67, 0xff, 0x7c, 0x7c, 0x75, 0xff,
0x74, 0x77, 0x6d, 0xff, 0x7f, 0x82, 0x75, 0xff, 0x8c, 0x90, 0x80, 0xff,
0x9e, 0xa1, 0x92, 0xff, 0xa8, 0xab, 0x9c, 0xff, 0xaa, 0xae, 0x9f, 0xff,
0xae, 0xae, 0x9f, 0xff, 0xad, 0xae, 0x9f, 0xff, 0xab, 0xad, 0x9e, 0xff,
0xab, 0xad, 0xa1, 0xff, 0xb2, 0xb5, 0xab, 0xff, 0x48, 0x4f, 0x51, 0xff,
0x3b, 0x45, 0x52, 0xff, 0x29, 0x36, 0x43, 0xff, 0x35, 0x3d, 0x46, 0xff,
0x3e, 0x3c, 0x4b, 0xff, 0x3c, 0x43, 0x4d, 0xff, 0x33, 0x39, 0x45, 0xff,
0x33, 0x39, 0x45, 0xff, 0x2f, 0x36, 0x3f, 0xff, 0x2f, 0x37, 0x3f, 0xff,
0x28, 0x32, 0x3b, 0xff, 0x29, 0x33, 0x3c, 0xff, 0x1a, 0x25, 0x2c, 0xff,
0x2a, 0x35, 0x3b, 0xff, 0x2b, 0x35, 0x3a, 0xff, 0x25, 0x2c, 0x34, 0xff,
0x29, 0x31, 0x39, 0xff, 0x24, 0x2a, 0x32, 0xff, 0x2c, 0x34, 0x3c, 0xff,
0x2f, 0x37, 0x3d, 0xff, 0x2c, 0x30, 0x38, 0xff, 0x2a, 0x2b, 0x38, 0xff,
0x27, 0x27, 0x35, 0xff, 0x2b, 0x2e, 0x39, 0xff, 0x29, 0x31, 0x38, 0xff,
0x2e, 0x37, 0x3e, 0xff, 0x34, 0x3d, 0x44, 0xff, 0x33, 0x3c, 0x43, 0xff,
0x32, 0x3c, 0x43, 0xff, 0x30, 0x36, 0x3c, 0xff, 0x32, 0x36, 0x3d, 0xff,
0x32, 0x36, 0x3c, 0xff, 0x40, 0x45, 0x45, 0xff, 0xa4, 0xab, 0xa5, 0xff,
0xb0, 0xb8, 0xad, 0xff, 0xac, 0xb4, 0xaf, 0xff, 0xa9, 0xb3, 0xb4, 0xff,
0xae, 0xbb, 0xbc, 0xff, 0xa7, 0xb7, 0xb5, 0xff, 0xa2, 0xb1, 0xa5, 0xff,
0x99, 0xa6, 0x97, 0xff, 0x85, 0x8e, 0x7c, 0xff, 0x6e, 0x71, 0x5d, 0xff,
0x84, 0x84, 0x6f, 0xff, 0xa2, 0xa3, 0x91, 0xff, 0xaf, 0xb1, 0x9a, 0xff,
0xb5, 0xb5, 0xa8, 0xff, 0xb5, 0xb4, 0xab, 0xff, 0xb4, 0xb7, 0xa7, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb7, 0xb7, 0xa7, 0xff,
0xb7, 0xb7, 0xa7, 0xff, 0xb5, 0xb5, 0xa5, 0xff, 0xb7, 0xb7, 0xa7, 0xff,
0x88, 0x86, 0x77, 0xff, 0x52, 0x4a, 0x3f, 0xff, 0x52, 0x47, 0x3f, 0xff,
0x42, 0x36, 0x32, 0xff, 0x44, 0x39, 0x38, 0xff, 0x63, 0x5f, 0x5f, 0xff,
0x8a, 0x8a, 0x79, 0xff, 0x8a, 0x8c, 0x7a, 0xff, 0x89, 0x8a, 0x7a, 0xff,
0x86, 0x89, 0x79, 0xff, 0x82, 0x87, 0x78, 0xff, 0x81, 0x85, 0x78, 0xff,
0x7e, 0x82, 0x77, 0xff, 0x7a, 0x7f, 0x75, 0xff, 0x77, 0x7d, 0x72, 0xff,
0x77, 0x7b, 0x73, 0xff, 0x74, 0x78, 0x72, 0xff, 0x71, 0x75, 0x6f, 0xff,
0x71, 0x75, 0x70, 0xff, 0x73, 0x77, 0x6e, 0xff, 0x6b, 0x6d, 0x64, 0xff,
0x5d, 0x5e, 0x54, 0xff, 0x57, 0x56, 0x4b, 0xff, 0x4d, 0x4b, 0x40, 0xff,
0x4a, 0x4a, 0x3f, 0xff, 0x4d, 0x4c, 0x42, 0xff, 0x47, 0x47, 0x3f, 0xff,
0x47, 0x42, 0x3a, 0xff, 0x5e, 0x59, 0x4d, 0xff, 0x78, 0x77, 0x69, 0xff,
0x88, 0x89, 0x7b, 0xff, 0x85, 0x87, 0x7d, 0xff, 0x88, 0x89, 0x7a, 0xff,
0x93, 0x94, 0x85, 0xff, 0xa1, 0xa2, 0x92, 0xff, 0xaa, 0xab, 0x9b, 0xff,
0xae, 0xaf, 0x9f, 0xff, 0xad, 0xad, 0x9f, 0xff, 0xad, 0xad, 0x9f, 0xff,
0xae, 0xae, 0xa1, 0xff, 0xae, 0xaf, 0xa1, 0xff, 0xaf, 0xb0, 0xa2, 0xff,
0x7d, 0x7f, 0x7c, 0xff, 0x32, 0x3a, 0x42, 0xff, 0x37, 0x40, 0x4d, 0xff,
0x84, 0x8a, 0x8f, 0xff, 0xd7, 0xd6, 0xd7, 0xff, 0x6d, 0x6f, 0x6f, 0xff,
0x3b, 0x3d, 0x45, 0xff, 0x36, 0x38, 0x47, 0xff, 0x2d, 0x33, 0x3d, 0xff,
0x29, 0x34, 0x3b, 0xff, 0x2b, 0x38, 0x40, 0xff, 0x30, 0x3d, 0x46, 0xff,
0x2d, 0x3b, 0x43, 0xff, 0x2b, 0x38, 0x40, 0xff, 0x2c, 0x37, 0x3f, 0xff,
0x32, 0x3a, 0x43, 0xff, 0x2d, 0x35, 0x3d, 0xff, 0x23, 0x2c, 0x35, 0xff,
0x2b, 0x34, 0x3d, 0xff, 0x2e, 0x33, 0x3d, 0xff, 0x33, 0x35, 0x41, 0xff,
0x2f, 0x31, 0x3e, 0xff, 0x2b, 0x2b, 0x38, 0xff, 0x2b, 0x2a, 0x38, 0xff,
0x2b, 0x2d, 0x3a, 0xff, 0x2d, 0x32, 0x3a, 0xff, 0x3d, 0x43, 0x45, 0xff,
0x3f, 0x47, 0x47, 0xff, 0x39, 0x40, 0x43, 0xff, 0x2c, 0x32, 0x39, 0xff,
0x3a, 0x41, 0x43, 0xff, 0x83, 0x8a, 0x83, 0xff, 0xb4, 0xba, 0xb2, 0xff,
0xb5, 0xb9, 0xb2, 0xff, 0xb0, 0xbd, 0xb6, 0xff, 0xb0, 0xbf, 0xb7, 0xff,
0xa6, 0xb5, 0xad, 0xff, 0xa5, 0xb2, 0xa9, 0xff, 0x9e, 0xa8, 0x9e, 0xff,
0x96, 0x9f, 0x89, 0xff, 0x7b, 0x83, 0x6e, 0xff, 0x6e, 0x73, 0x5e, 0xff,
0x8a, 0x8c, 0x78, 0xff, 0xaa, 0xab, 0x97, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb7, 0xb7, 0xa6, 0xff, 0xb8, 0xb7, 0xa8, 0xff, 0xb7, 0xb7, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb8, 0xb6, 0xa9, 0xff, 0xb8, 0xb7, 0xa8, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb4, 0xb4, 0xa4, 0xff, 0x75, 0x6d, 0x61, 0xff, 0x3a, 0x2a, 0x26, 0xff,
0x2c, 0x1e, 0x1d, 0xff, 0x29, 0x20, 0x1f, 0xff, 0x2b, 0x27, 0x23, 0xff,
0x45, 0x42, 0x42, 0xff, 0x8a, 0x8b, 0x78, 0xff, 0x8a, 0x8c, 0x79, 0xff,
0x89, 0x8a, 0x7a, 0xff, 0x86, 0x89, 0x7a, 0xff, 0x83, 0x88, 0x79, 0xff,
0x82, 0x86, 0x7a, 0xff, 0x7f, 0x83, 0x77, 0xff, 0x7c, 0x82, 0x77, 0xff,
0x79, 0x7f, 0x74, 0xff, 0x79, 0x7e, 0x75, 0xff, 0x77, 0x7b, 0x74, 0xff,
0x75, 0x79, 0x73, 0xff, 0x75, 0x7a, 0x71, 0xff, 0x78, 0x7c, 0x72, 0xff,
0x75, 0x79, 0x6e, 0xff, 0x69, 0x6a, 0x60, 0xff, 0x60, 0x60, 0x55, 0xff,
0x58, 0x56, 0x4a, 0xff, 0x4b, 0x4b, 0x3f, 0xff, 0x4b, 0x4b, 0x41, 0xff,
0x48, 0x49, 0x40, 0xff, 0x45, 0x42, 0x38, 0xff, 0x61, 0x5e, 0x52, 0xff,
0x82, 0x82, 0x72, 0xff, 0x95, 0x95, 0x86, 0xff, 0x95, 0x97, 0x8b, 0xff,
0x97, 0x98, 0x89, 0xff, 0x9d, 0x9e, 0x8e, 0xff, 0xa6, 0xa7, 0x97, 0xff,
0xac, 0xad, 0x9d, 0xff, 0xae, 0xaf, 0x9e, 0xff, 0xad, 0xad, 0x9f, 0xff,
0xad, 0xad, 0x9f, 0xff, 0xae, 0xae, 0xa0, 0xff, 0xaf, 0xaf, 0xa1, 0xff,
0xaf, 0xaf, 0xa2, 0xff, 0xaf, 0xaf, 0xa5, 0xff, 0x5d, 0x60, 0x5f, 0xff,
0x39, 0x3f, 0x42, 0xff, 0x7e, 0x81, 0x7f, 0xff, 0xa8, 0xa8, 0x9c, 0xff,
0xaf, 0xb2, 0xa3, 0xff, 0xa3, 0xa5, 0x9f, 0xff, 0x7d, 0x80, 0x7f, 0xff,
0x7b, 0x83, 0x7e, 0xff, 0x72, 0x7c, 0x74, 0xff, 0x63, 0x6e, 0x6b, 0xff,
0x56, 0x5f, 0x5d, 0xff, 0x4a, 0x54, 0x51, 0xff, 0x44, 0x4e, 0x4c, 0xff,
0x3c, 0x45, 0x45, 0xff, 0x34, 0x3c, 0x43, 0xff, 0x38, 0x3f, 0x47, 0xff,
0x33, 0x3a, 0x42, 0xff, 0x31, 0x39, 0x41, 0xff, 0x3b, 0x40, 0x45, 0xff,
0x3f, 0x40, 0x45, 0xff, 0x4c, 0x4f, 0x56, 0xff, 0x3b, 0x3e, 0x47, 0xff,
0x2f, 0x33, 0x3f, 0xff, 0x27, 0x29, 0x37, 0xff, 0x2b, 0x2d, 0x38, 0xff,
0x3a, 0x3e, 0x44, 0xff, 0x31, 0x37, 0x3b, 0xff, 0x3e, 0x45, 0x4c, 0xff,
0x62, 0x6e, 0x74, 0xff, 0xa2, 0xae, 0xad, 0xff, 0xa3, 0xb2, 0xa8, 0xff,
0xb2, 0xbe, 0xb3, 0xff, 0xb1, 0xba, 0xb0, 0xff, 0xa4, 0xb0, 0xa4, 0xff,
0xa7, 0xb5, 0xa8, 0xff, 0xa0, 0xad, 0x9e, 0xff, 0x94, 0x9f, 0x8f, 0xff,
0x92, 0x98, 0x87, 0xff, 0x76, 0x7d, 0x67, 0xff, 0x6e, 0x73, 0x5e, 0xff,
0x93, 0x98, 0x84, 0xff, 0xb1, 0xb3, 0xa0, 0xff, 0xb7, 0xb7, 0xa7, 0xff,
0xb7, 0xb7, 0xa7, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb9, 0xb9, 0xa9, 0xff,
0xb9, 0xb9, 0xa9, 0xff, 0xb9, 0xb9, 0xa9, 0xff, 0xb9, 0xb9, 0xa9, 0xff,
0xb9, 0xb9, 0xa9, 0xff, 0xb8, 0xb8, 0xa9, 0xff, 0xb8, 0xb8, 0xa8, 0xff,
0xb6, 0xb6, 0xa5, 0xff, 0xb6, 0xb6, 0xa4, 0xff, 0x9b, 0x97, 0x85, 0xff,
0x31, 0x2a, 0x19, 0xff, 0x28, 0x1f, 0x15, 0xff, 0x1f, 0x17, 0x0f, 0xff,
0x23, 0x1e, 0x16, 0xff, 0x3d, 0x32, 0x2d, 0xff, 0x89, 0x8a, 0x77, 0xff,
0x8a, 0x8c, 0x79, 0xff, 0x89, 0x8a, 0x7a, 0xff, 0x87, 0x8a, 0x7b, 0xff,
0x84, 0x89, 0x7a, 0xff, 0x82, 0x86, 0x7a, 0xff, 0x80, 0x84, 0x78, 0xff,
0x7e, 0x84, 0x79, 0xff, 0x7b, 0x81, 0x76, 0xff, 0x7b, 0x80, 0x77, 0xff,
0x78, 0x7c, 0x76, 0xff, 0x78, 0x7c, 0x75, 0xff, 0x78, 0x7d, 0x74, 0xff,
0x7b, 0x7f, 0x75, 0xff, 0x7d, 0x81, 0x76, 0xff, 0x78, 0x7a, 0x6e, 0xff,
0x67, 0x68, 0x5a, 0xff, 0x5e, 0x5e, 0x51, 0xff, 0x53, 0x53, 0x46, 0xff,
0x4c, 0x4e, 0x43, 0xff, 0x4c, 0x4e, 0x43, 0xff, 0x4c, 0x4d, 0x41, 0xff,
0x66, 0x68, 0x59, 0xff, 0x89, 0x8a, 0x79, 0xff, 0x9f, 0xa0, 0x90, 0xff,
0xa4, 0xa3, 0x96, 0xff, 0xa5, 0xa6, 0x96, 0xff, 0xa7, 0xa8, 0x98, 0xff,
0xaa, 0xab, 0x9b, 0xff, 0xae, 0xaf, 0x9f, 0xff, 0xad, 0xae, 0x9e, 0xff,
0xad, 0xad, 0x9f, 0xff, 0xad, 0xad, 0x9f, 0xff, 0xae, 0xae, 0xa0, 0xff,
0xb0, 0xb0, 0xa2, 0xff, 0xb0, 0xb0, 0xa1, 0xff, 0xb1, 0xb1, 0x9f, 0xff,
0xaf, 0xaf, 0xa3, 0xff, 0xab, 0xac, 0xa3, 0xff, 0xaf, 0xaf, 0xa2, 0xff,
0xb3, 0xb3, 0xa0, 0xff, 0xb1, 0xb2, 0x9e, 0xff, 0xb0, 0xb1, 0x9f, 0xff,
0xac, 0xae, 0xa0, 0xff, 0xad, 0xb0, 0xa1, 0xff, 0xac, 0xb0, 0x9f, 0xff,
0xab, 0xae, 0xa0, 0xff, 0xac, 0xaf, 0xa2, 0xff, 0xa9, 0xad, 0x9f, 0xff,
0xab, 0xad, 0xa0, 0xff, 0xab, 0xae, 0xa0, 0xff, 0xa6, 0xa9, 0x9d, 0xff,
0xa4, 0xa7, 0x9a, 0xff, 0x9f, 0xa3, 0x96, 0xff, 0xa6, 0xa9, 0x9c, 0xff,
0xad, 0xaf, 0xa3, 0xff, 0x97, 0x98, 0x8e, 0xff, 0x97, 0x9a, 0x96, 0xff,
0x5d, 0x63, 0x63, 0xff, 0x41, 0x49, 0x4e, 0xff, 0x3c, 0x44, 0x45, 0xff,
0x72, 0x7c, 0x7a, 0xff, 0x7e, 0x8a, 0x87, 0xff, 0x82, 0x90, 0x8d, 0xff,
0x8c, 0x9c, 0x99, 0xff, 0x8e, 0x9f, 0x9e, 0xff, 0x8c, 0x9c, 0x9a, 0xff,
0x90, 0x9f, 0x9a, 0xff, 0x9f, 0xad, 0xa6, 0xff, 0xa3, 0xaf, 0xa6, 0xff,
0xa5, 0xae, 0x9f, 0xff, 0x9c, 0xa6, 0x94, 0xff, 0x9b, 0xa5, 0x90, 0xff,
0x82, 0x88, 0x72, 0xff, 0x6f, 0x70, 0x5a, 0xff, 0x7d, 0x81, 0x6d, 0xff,
0xa0, 0xa4, 0x90, 0xff, 0xb2, 0xb5, 0xa2, 0xff, 0xb7, 0xb8, 0xa8, 0xff,
0xb7, 0xb7, 0xa8, 0xff, 0xb8, 0xb8, 0xa8, 0xff, 0xb9, 0xb9, 0xa9, 0xff,
0xb9, 0xb9, 0xa9, 0xff, 0xba, 0xba, 0xaa, 0xff, 0xba, 0xba, 0xaa, 0xff,
0xba, 0xba, 0xaa, 0xff, 0xba, 0xba, 0xaa, 0xff, 0xbb, 0xbb, 0xab, 0xff,
0xbb, 0xbb, 0xab, 0xff, 0xbb, 0xbb, 0xaa, 0xff, 0xbb, 0xbb, 0xa8, 0xff,
0xba, 0xba, 0xa8, 0xff, 0xb9, 0xb9, 0xa8, 0xff, 0xb6, 0xb6, 0xa6, 0xff,
0xb3, 0xb4, 0xa1, 0xff, 0xab, 0xac, 0x99, 0xff, 0x9a, 0x95, 0x8a, 0xff,
0x5d, 0x52, 0x4d, 0xff, 0x56, 0x4b, 0x47, 0xff, 0x5c, 0x4c, 0x4c, 0xff,
0x89, 0x8a, 0x77, 0xff, 0x89, 0x8b, 0x78, 0xff, 0x89, 0x8a, 0x7a, 0xff,
0x87, 0x8a, 0x7b, 0xff, 0x84, 0x89, 0x7a, 0xff, 0x82, 0x86, 0x7a, 0xff,
0x80, 0x84, 0x79, 0xff, 0x7e, 0x84, 0x79, 0xff, 0x7d, 0x83, 0x78, 0xff,
0x7c, 0x81, 0x78, 0xff, 0x7a, 0x7f, 0x78, 0xff, 0x79, 0x7d, 0x76, 0xff,
0x78, 0x7d, 0x73, 0xff, 0x7c, 0x81, 0x75, 0xff, 0x80, 0x83, 0x77, 0xff,
0x83, 0x85, 0x78, 0xff, 0x74, 0x76, 0x66, 0xff, 0x67, 0x68, 0x59, 0xff,
0x5b, 0x5e, 0x4f, 0xff, 0x4f, 0x53, 0x45, 0xff, 0x4d, 0x52, 0x46, 0xff,
0x57, 0x5c, 0x4e, 0xff, 0x73, 0x78, 0x67, 0xff, 0x91, 0x95, 0x81, 0xff,
0xa4, 0xa6, 0x93, 0xff, 0xa8, 0xa9, 0x9a, 0xff, 0xab, 0xac, 0x9c, 0xff,
0xab, 0xac, 0x9c, 0xff, 0xac, 0xad, 0x9d, 0xff, 0xad, 0xae, 0x9e, 0xff,
0xad, 0xae, 0x9e, 0xff, 0xaf, 0xaf, 0xa1, 0xff, 0xaf, 0xaf, 0xa1, 0xff,
0xaf, 0xaf, 0xa1, 0xff, 0xb0, 0xb0, 0xa2, 0xff, 0xb0, 0xb1, 0xa2, 0xff,
0xb2, 0xb2, 0x9f, 0xff, 0xb3, 0xb1, 0xa0, 0xff, 0xb3, 0xb0, 0xa2, 0xff,
0xb3, 0xb2, 0xa1, 0xff, 0xb3, 0xb3, 0x9f, 0xff, 0xb1, 0xb0, 0xa1, 0xff,
0xb1, 0xb1, 0xa1, 0xff, 0xb0, 0xb0, 0xa0, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xb0, 0xb0, 0x9f, 0xff, 0xb0, 0xb0, 0x9f, 0xff, 0xb0, 0xb0, 0x9f, 0xff,
0xb0, 0xb0, 0x9f, 0xff, 0xb2, 0xb2, 0xa1, 0xff, 0xb3, 0xb2, 0xa0, 0xff,
0xb6, 0xb4, 0xa1, 0xff, 0xb7, 0xb4, 0xa2, 0xff, 0xb9, 0xb6, 0xa4, 0xff,
0xb8, 0xb6, 0xa3, 0xff, 0xb7, 0xb5, 0xa4, 0xff, 0xb3, 0xb4, 0xa4, 0xff,
0xab, 0xad, 0x9f, 0xff, 0x91, 0x95, 0x8b, 0xff, 0x94, 0x99, 0x92, 0xff,
0x9b, 0xa1, 0x9a, 0xff, 0x90, 0x98, 0x93, 0xff, 0x90, 0x9b, 0x99, 0xff,
0x92, 0xa0, 0x9f, 0xff, 0x90, 0xa3, 0x9f, 0xff, 0x8c, 0x9d, 0x8e, 0xff,
0x89, 0x98, 0x89, 0xff, 0x87, 0x93, 0x87, 0xff, 0x7e, 0x87, 0x78, 0xff,
0x7a, 0x82, 0x70, 0xff, 0x86, 0x8d, 0x7c, 0xff, 0x99, 0xa0, 0x8f, 0xff,
0x7e, 0x87, 0x73, 0xff, 0x69, 0x6b, 0x56, 0xff, 0x89, 0x8a, 0x73, 0xff,
0xa5, 0xa8, 0x95, 0xff, 0xb5, 0xb6, 0xa4, 0xff, 0xb7, 0xb8, 0xa7, 0xff,
0xb6, 0xb6, 0xa7, 0xff, 0xb8, 0xb5, 0xa7, 0xff, 0xb8, 0xb9, 0xa8, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb9, 0xb9, 0xa9, 0xff, 0xbb, 0xbb, 0xab, 0xff,
0xbb, 0xbb, 0xab, 0xff, 0xbc, 0xbc, 0xac, 0xff, 0xbc, 0xbc, 0xac, 0xff,
0xbb, 0xbb, 0xab, 0xff, 0xbb, 0xbb, 0xab, 0xff, 0xbb, 0xbb, 0xaa, 0xff,
0xbc, 0xbc, 0xa9, 0xff, 0xba, 0xba, 0xa9, 0xff, 0xba, 0xb8, 0xab, 0xff,
0xbb, 0xba, 0xae, 0xff, 0xb0, 0xae, 0xa4, 0xff, 0x95, 0x93, 0x8b, 0xff,
0x71, 0x6b, 0x69, 0xff, 0x67, 0x5c, 0x5e, 0xff, 0x63, 0x55, 0x58, 0xff,
0x49, 0x3e, 0x3f, 0xff, 0x89, 0x8a, 0x77, 0xff, 0x89, 0x8b, 0x78, 0xff,
0x89, 0x8a, 0x7a, 0xff, 0x87, 0x8a, 0x7b, 0xff, 0x85, 0x8a, 0x7b, 0xff,
0x84, 0x88, 0x7c, 0xff, 0x81, 0x85, 0x79, 0xff, 0x7f, 0x85, 0x7a, 0xff,
0x7e, 0x84, 0x79, 0xff, 0x7e, 0x83, 0x7a, 0xff, 0x7c, 0x80, 0x79, 0xff,
0x7a, 0x7f, 0x77, 0xff, 0x79, 0x7f, 0x74, 0xff, 0x7d, 0x81, 0x76, 0xff,
0x81, 0x84, 0x78, 0xff, 0x86, 0x89, 0x7a, 0xff, 0x7e, 0x81, 0x71, 0xff,
0x6b, 0x6e, 0x5e, 0xff, 0x63, 0x67, 0x58, 0xff, 0x59, 0x5e, 0x4e, 0xff,
0x56, 0x5d, 0x50, 0xff, 0x69, 0x6f, 0x61, 0xff, 0x83, 0x8a, 0x78, 0xff,
0x94, 0x9a, 0x85, 0xff, 0xa5, 0xa8, 0x95, 0xff, 0xab, 0xaa, 0x9b, 0xff,
0xab, 0xac, 0x9c, 0xff, 0xad, 0xae, 0x9e, 0xff, 0xad, 0xae, 0x9e, 0xff,
0xad, 0xae, 0x9e, 0xff, 0xad, 0xae, 0x9e, 0xff, 0xaf, 0xaf, 0xa1, 0xff,
0xaf, 0xaf, 0xa1, 0xff, 0xb0, 0xb0, 0xa1, 0xff, 0xb0, 0xb0, 0xa2, 0xff,
0xb0, 0xb0, 0xa2, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb3, 0xb0, 0xa1, 0xff,
0xb5, 0xb1, 0xa2, 0xff, 0xb4, 0xb1, 0xa2, 0xff, 0xb1, 0xb2, 0xa2, 0xff,
0xb0, 0xb0, 0xa2, 0xff, 0xb0, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0x9f, 0xff,
0xb2, 0xb1, 0x9f, 0xff, 0xb2, 0xb0, 0xa2, 0xff, 0xb0, 0xb1, 0xa2, 0xff,
0xb0, 0xb1, 0xa2, 0xff, 0xaf, 0xb0, 0xa1, 0xff, 0xb1, 0xb2, 0xa3, 0xff,
0xb1, 0xb2, 0xa2, 0xff, 0xb3, 0xb3, 0xa2, 0xff, 0xb4, 0xb4, 0xa3, 0xff,
0xb5, 0xb5, 0xa4, 0xff, 0xb5, 0xb5, 0xa4, 0xff, 0xb5, 0xb6, 0xa5, 0xff,
0xb8, 0xb9, 0xa6, 0xff, 0xb6, 0xb6, 0xa4, 0xff, 0xb9, 0xb8, 0xa6, 0xff,
0xb7, 0xb5, 0xa4, 0xff, 0xb8, 0xb6, 0xa4, 0xff, 0xb1, 0xb0, 0xa2, 0xff,
0xae, 0xaf, 0xa7, 0xff, 0xa1, 0xa7, 0xa0, 0xff, 0x99, 0xa5, 0x9a, 0xff,
0x8d, 0x93, 0x86, 0xff, 0x85, 0x89, 0x7f, 0xff, 0x7c, 0x7a, 0x75, 0xff,
0x7f, 0x7b, 0x75, 0xff, 0x65, 0x63, 0x58, 0xff, 0x52, 0x54, 0x49, 0xff,
0x7d, 0x84, 0x76, 0xff, 0x7c, 0x84, 0x74, 0xff, 0x92, 0x95, 0x83, 0xff,
0xab, 0xab, 0x99, 0xff, 0xb6, 0xb7, 0xa4, 0xff, 0xb5, 0xb6, 0xa6, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb8, 0xb7, 0xa9, 0xff, 0xba, 0xb7, 0xa9, 0xff,
0xba, 0xba, 0xaa, 0xff, 0xba, 0xba, 0xaa, 0xff, 0xb9, 0xb9, 0xa9, 0xff,
0xba, 0xbb, 0xaa, 0xff, 0xbb, 0xbb, 0xab, 0xff, 0xbc, 0xbc, 0xac, 0xff,
0xbc, 0xbc, 0xac, 0xff, 0xbd, 0xbd, 0xad, 0xff, 0xbd, 0xbd, 0xad, 0xff,
0xbd, 0xbd, 0xac, 0xff, 0xbc, 0xbc, 0xab, 0xff, 0xb9, 0xb7, 0xaa, 0xff,
0xac, 0xa9, 0xa0, 0xff, 0x95, 0x92, 0x8c, 0xff, 0x7c, 0x77, 0x75, 0xff,
0x69, 0x62, 0x63, 0xff, 0x6c, 0x63, 0x66, 0xff, 0x65, 0x5c, 0x5e, 0xff,
0x41, 0x38, 0x38, 0xff, 0x39, 0x37, 0x2b, 0xff, 0x87, 0x8a, 0x76, 0xff,
0x86, 0x8b, 0x78, 0xff, 0x87, 0x8a, 0x7b, 0xff, 0x87, 0x8a, 0x7b, 0xff,
0x85, 0x89, 0x7d, 0xff, 0x81, 0x88, 0x7c, 0xff, 0x81, 0x87, 0x7b, 0xff,
0x80, 0x86, 0x7b, 0xff, 0x81, 0x87, 0x7c, 0xff, 0x80, 0x87, 0x7c, 0xff,
0x7e, 0x84, 0x79, 0xff, 0x7b, 0x81, 0x77, 0xff, 0x7a, 0x7f, 0x76, 0xff,
0x7e, 0x82, 0x77, 0xff, 0x80, 0x83, 0x77, 0xff, 0x85, 0x88, 0x79, 0xff,
0x86, 0x87, 0x78, 0xff, 0x78, 0x78, 0x6a, 0xff, 0x6a, 0x6d, 0x5e, 0xff,
0x68, 0x6d, 0x5e, 0xff, 0x67, 0x6c, 0x5d, 0xff, 0x7e, 0x80, 0x70, 0xff,
0x90, 0x92, 0x82, 0xff, 0x9d, 0x9f, 0x8e, 0xff, 0xa6, 0xa7, 0x97, 0xff,
0xaa, 0xab, 0x9b, 0xff, 0xac, 0xac, 0x9c, 0xff, 0xad, 0xae, 0x9e, 0xff,
0xae, 0xae, 0x9e, 0xff, 0xb0, 0xb0, 0xa0, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xaf, 0xaf, 0x9d, 0xff, 0xb0, 0xb0, 0x9e, 0xff, 0xb1, 0xb1, 0x9f, 0xff,
0xb1, 0xb1, 0x9f, 0xff, 0xb1, 0xb1, 0x9f, 0xff, 0xb2, 0xb2, 0xa0, 0xff,
0xb2, 0xb2, 0xa0, 0xff, 0xb3, 0xb2, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff,
0xb1, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0xa1, 0xff,
0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff,
0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff, 0xb4, 0xb4, 0xa2, 0xff,
0xb4, 0xb5, 0xa3, 0xff, 0xb5, 0xb5, 0xa3, 0xff, 0xb6, 0xb6, 0xa4, 0xff,
0xb6, 0xb7, 0xa4, 0xff, 0xb6, 0xb6, 0xa4, 0xff, 0xb6, 0xb6, 0xa4, 0xff,
0xb6, 0xb6, 0xa3, 0xff, 0xb7, 0xb6, 0xa4, 0xff, 0xb6, 0xb7, 0xa4, 0xff,
0xb6, 0xb7, 0xa4, 0xff, 0xb5, 0xb5, 0xa6, 0xff, 0xb4, 0xb5, 0xa6, 0xff,
0xb4, 0xb5, 0xa7, 0xff, 0xa8, 0xa6, 0x9d, 0xff, 0x91, 0x8e, 0x87, 0xff,
0x75, 0x6f, 0x69, 0xff, 0x5f, 0x56, 0x4f, 0xff, 0x4c, 0x43, 0x39, 0xff,
0x60, 0x5e, 0x47, 0xff, 0x71, 0x76, 0x66, 0xff, 0x6e, 0x80, 0x81, 0xff,
0xad, 0xb1, 0xa5, 0xff, 0xb8, 0xb8, 0xaa, 0xff, 0xb8, 0xb7, 0xa9, 0xff,
0xb8, 0xb7, 0xa9, 0xff, 0xb8, 0xb7, 0xa9, 0xff, 0xb8, 0xb7, 0xa9, 0xff,
0xb8, 0xb7, 0xa9, 0xff, 0xb8, 0xb9, 0xaa, 0xff, 0xb8, 0xb9, 0xa9, 0xff,
0xb9, 0xba, 0xa9, 0xff, 0xba, 0xbc, 0xaa, 0xff, 0xbb, 0xbd, 0xaa, 0xff,
0xbb, 0xbc, 0xab, 0xff, 0xbe, 0xbf, 0xaf, 0xff, 0xbe, 0xbf, 0xaf, 0xff,
0xbe, 0xbf, 0xaf, 0xff, 0xb5, 0xb5, 0xa9, 0xff, 0xa2, 0x9e, 0x99, 0xff,
0x89, 0x84, 0x83, 0xff, 0x70, 0x6a, 0x6b, 0xff, 0x58, 0x51, 0x56, 0xff,
0x48, 0x3f, 0x44, 0xff, 0x35, 0x2a, 0x2d, 0xff, 0x43, 0x3a, 0x37, 0xff,
0x5e, 0x57, 0x50, 0xff, 0x84, 0x7f, 0x71, 0xff, 0xae, 0xad, 0x9b, 0xff,
0x89, 0x8a, 0x76, 0xff, 0x88, 0x8b, 0x78, 0xff, 0x87, 0x8a, 0x7b, 0xff,
0x87, 0x8a, 0x7b, 0xff, 0x85, 0x89, 0x7d, 0xff, 0x83, 0x89, 0x7d, 0xff,
0x82, 0x88, 0x7d, 0xff, 0x83, 0x86, 0x7d, 0xff, 0x84, 0x87, 0x7e, 0xff,
0x85, 0x88, 0x7f, 0xff, 0x82, 0x86, 0x7c, 0xff, 0x80, 0x84, 0x7a, 0xff,
0x7e, 0x82, 0x77, 0xff, 0x7f, 0x83, 0x76, 0xff, 0x83, 0x85, 0x76, 0xff,
0x88, 0x89, 0x79, 0xff, 0x8a, 0x8b, 0x7b, 0xff, 0x7f, 0x7f, 0x71, 0xff,
0x72, 0x75, 0x66, 0xff, 0x78, 0x7d, 0x6e, 0xff, 0x79, 0x7e, 0x6f, 0xff,
0x8c, 0x8d, 0x7d, 0xff, 0x9a, 0x9b, 0x8b, 0xff, 0xa1, 0xa2, 0x92, 0xff,
0xa5, 0xa6, 0x96, 0xff, 0xa9, 0xaa, 0x9a, 0xff, 0xac, 0xac, 0x9c, 0xff,
0xae, 0xae, 0x9e, 0xff, 0xae, 0xae, 0x9e, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xb0, 0xb0, 0xa0, 0xff, 0xb0, 0xb0, 0x9e, 0xff, 0xb1, 0xb1, 0x9f, 0xff,
0xb2, 0xb2, 0xa0, 0xff, 0xb2, 0xb2, 0xa0, 0xff, 0xb2, 0xb2, 0xa0, 0xff,
0xb2, 0xb2, 0xa0, 0xff, 0xb2, 0xb2, 0xa0, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb2, 0xb2, 0xa2, 0xff,
0xb2, 0xb2, 0xa2, 0xff, 0xb1, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0xa1, 0xff,
0xb1, 0xb1, 0xa1, 0xff, 0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb4, 0xb4, 0xa2, 0xff, 0xb5, 0xb5, 0xa3, 0xff, 0xb5, 0xb5, 0xa3, 0xff,
0xb6, 0xb6, 0xa4, 0xff, 0xb7, 0xb7, 0xa5, 0xff, 0xb6, 0xb6, 0xa4, 0xff,
0xb6, 0xb6, 0xa4, 0xff, 0xb6, 0xb6, 0xa4, 0xff, 0xb6, 0xb6, 0xa4, 0xff,
0xb7, 0xb8, 0xa5, 0xff, 0xb8, 0xb8, 0xa5, 0xff, 0xb8, 0xb7, 0xa7, 0xff,
0xb7, 0xb8, 0xa8, 0xff, 0xb3, 0xb2, 0xa4, 0xff, 0x9f, 0x9e, 0x8f, 0xff,
0x79, 0x75, 0x6c, 0xff, 0x56, 0x4f, 0x4c, 0xff, 0x4e, 0x47, 0x3c, 0xff,
0x6b, 0x69, 0x50, 0xff, 0x92, 0x92, 0x7f, 0xff, 0xa8, 0xa9, 0x94, 0xff,
0x65, 0x74, 0x71, 0xff, 0xa4, 0xaf, 0xaa, 0xff, 0xb8, 0xb8, 0xa9, 0xff,
0xb9, 0xb8, 0xab, 0xff, 0xba, 0xb9, 0xab, 0xff, 0xb9, 0xb8, 0xaa, 0xff,
0xb8, 0xb7, 0xa9, 0xff, 0xb8, 0xb7, 0xa9, 0xff, 0xba, 0xba, 0xaa, 0xff,
0xb9, 0xba, 0xaa, 0xff, 0xba, 0xbb, 0xa8, 0xff, 0xbc, 0xbc, 0xaa, 0xff,
0xbc, 0xbd, 0xab, 0xff, 0xbd, 0xbe, 0xac, 0xff, 0xb8, 0xb8, 0xab, 0xff,
0xa9, 0xa5, 0xa0, 0xff, 0x92, 0x8d, 0x8e, 0xff, 0x7d, 0x76, 0x7c, 0xff,
0x64, 0x5c, 0x63, 0xff, 0x4d, 0x47, 0x49, 0xff, 0x37, 0x33, 0x2f, 0xff,
0x2f, 0x2c, 0x25, 0xff, 0x42, 0x3e, 0x32, 0xff, 0x5d, 0x5a, 0x4b, 0xff,
0x4e, 0x4a, 0x3a, 0xff, 0x9a, 0x98, 0x85, 0xff, 0xbe, 0xbd, 0xa8, 0xff,
0xbb, 0xbb, 0xa8, 0xff, 0x8a, 0x89, 0x75, 0xff, 0x8b, 0x8b, 0x78, 0xff,
0x88, 0x8b, 0x7c, 0xff, 0x88, 0x8b, 0x7c, 0xff, 0x87, 0x8b, 0x7f, 0xff,
0x83, 0x8a, 0x7e, 0xff, 0x83, 0x89, 0x7e, 0xff, 0x85, 0x88, 0x7f, 0xff,
0x85, 0x88, 0x7f, 0xff, 0x86, 0x89, 0x80, 0xff, 0x85, 0x88, 0x7f, 0xff,
0x84, 0x87, 0x7e, 0xff, 0x81, 0x85, 0x7a, 0xff, 0x81, 0x84, 0x77, 0xff,
0x86, 0x87, 0x78, 0xff, 0x89, 0x8b, 0x79, 0xff, 0x8d, 0x8d, 0x7d, 0xff,
0x86, 0x87, 0x78, 0xff, 0x7d, 0x80, 0x71, 0xff, 0x84, 0x89, 0x7a, 0xff,
0x86, 0x8b, 0x7c, 0xff, 0x95, 0x97, 0x87, 0xff, 0x9d, 0x9e, 0x8e, 0xff,
0xa1, 0xa2, 0x92, 0xff, 0xa3, 0xa4, 0x94, 0xff, 0xa8, 0xa9, 0x99, 0xff,
0xac, 0xac, 0x9c, 0xff, 0xae, 0xae, 0x9e, 0xff, 0xaf, 0xaf, 0x9f, 0xff,
0xb0, 0xb0, 0xa0, 0xff, 0xb1, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0x9f, 0xff,
0xb2, 0xb2, 0xa0, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb2, 0xb2, 0xa0, 0xff,
0xb2, 0xb2, 0xa0, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb2, 0xb2, 0xa2, 0xff,
0xb2, 0xb2, 0xa2, 0xff, 0xb2, 0xb2, 0xa2, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb4, 0xb4, 0xa4, 0xff, 0xb4, 0xb4, 0xa4, 0xff,
0xb4, 0xb4, 0xa3, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb4, 0xb4, 0xa2, 0xff,
0xb6, 0xb6, 0xa4, 0xff, 0xb7, 0xb7, 0xa5, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb7, 0xb7, 0xa5, 0xff, 0xb7, 0xb7, 0xa5, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb7, 0xb7, 0xa5, 0xff, 0xb8, 0xb8, 0xa6, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb8, 0xb8, 0xa8, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xa3, 0xa2, 0x94, 0xff,
0x7e, 0x79, 0x6f, 0xff, 0x53, 0x4e, 0x42, 0xff, 0x47, 0x44, 0x33, 0xff,
0x70, 0x6d, 0x5b, 0xff, 0x9b, 0x9a, 0x83, 0xff, 0xaa, 0xad, 0x9e, 0xff,
0xc1, 0xbe, 0xa8, 0xff, 0x8b, 0x93, 0x89, 0xff, 0x83, 0x91, 0x94, 0xff,
0xb8, 0xba, 0xb0, 0xff, 0xbb, 0xb9, 0xab, 0xff, 0xb8, 0xb7, 0xa9, 0xff,
0xb9, 0xb8, 0xaa, 0xff, 0xb9, 0xb8, 0xaa, 0xff, 0xba, 0xb9, 0xab, 0xff,
0xba, 0xba, 0xa9, 0xff, 0xba, 0xba, 0xaa, 0xff, 0xba, 0xb9, 0xaa, 0xff,
0xbb, 0xb9, 0xad, 0xff, 0xb4, 0xb3, 0xa7, 0xff, 0x9f, 0x9b, 0x95, 0xff,
0x88, 0x83, 0x80, 0xff, 0x6f, 0x69, 0x69, 0xff, 0x52, 0x4b, 0x4e, 0xff,
0x40, 0x3a, 0x3b, 0xff, 0x2d, 0x29, 0x23, 0xff, 0x3e, 0x3c, 0x32, 0xff,
0x70, 0x6f, 0x61, 0xff, 0xa2, 0xa2, 0x90, 0xff, 0xbb, 0xbc, 0xa6, 0xff,
0xbe, 0xbd, 0xa7, 0xff, 0xbe, 0xbe, 0xa9, 0xff, 0xbe, 0xbd, 0xa9, 0xff,
0xbd, 0xbb, 0xa8, 0xff, 0xbb, 0xbb, 0xa9, 0xff, 0x88, 0x88, 0x77, 0xff,
0x8a, 0x88, 0x77, 0xff, 0x88, 0x8b, 0x7c, 0xff, 0x89, 0x8c, 0x7d, 0xff,
0x87, 0x8b, 0x7f, 0xff, 0x83, 0x8a, 0x7e, 0xff, 0x83, 0x89, 0x7e, 0xff,
0x83, 0x88, 0x81, 0xff, 0x84, 0x8a, 0x83, 0xff, 0x85, 0x8a, 0x84, 0xff,
0x85, 0x8a, 0x84, 0xff, 0x85, 0x8a, 0x84, 0xff, 0x83, 0x88, 0x80, 0xff,
0x83, 0x88, 0x7e, 0xff, 0x84, 0x88, 0x7c, 0xff, 0x88, 0x8b, 0x7d, 0xff,
0x8c, 0x8d, 0x7f, 0xff, 0x88, 0x88, 0x7a, 0xff, 0x83, 0x86, 0x77, 0xff,
0x8c, 0x91, 0x82, 0xff, 0x8b, 0x90, 0x81, 0xff, 0x98, 0x9a, 0x8a, 0xff,
0x9d, 0x9e, 0x8e, 0xff, 0x9f, 0xa0, 0x90, 0xff, 0xa3, 0xa4, 0x94, 0xff,
0xa7, 0xa8, 0x98, 0xff, 0xab, 0xab, 0x9b, 0xff, 0xae, 0xae, 0x9e, 0xff,
0xaf, 0xaf, 0x9f, 0xff, 0xb0, 0xb0, 0xa0, 0xff, 0xb1, 0xb1, 0xa1, 0xff,
0xb1, 0xb1, 0x9f, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb4, 0xb4, 0xa4, 0xff,
0xb4, 0xb4, 0xa4, 0xff, 0xb4, 0xb4, 0xa4, 0xff, 0xb5, 0xb5, 0xa3, 0xff,
0xb5, 0xb5, 0xa3, 0xff, 0xb7, 0xb7, 0xa5, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff,
0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff, 0xba, 0xb8, 0xa6, 0xff,
0xbb, 0xb9, 0xa7, 0xff, 0xba, 0xb7, 0xa8, 0xff, 0xaa, 0xa7, 0x98, 0xff,
0x86, 0x83, 0x75, 0xff, 0x59, 0x51, 0x47, 0xff, 0x4f, 0x4b, 0x3a, 0xff,
0x78, 0x77, 0x5e, 0xff, 0x9c, 0x9c, 0x86, 0xff, 0xb4, 0xb3, 0xa6, 0xff,
0xbc, 0xbd, 0xae, 0xff, 0xbd, 0xbd, 0xab, 0xff, 0xb4, 0xb6, 0xa5, 0xff,
0x61, 0x6e, 0x6f, 0xff, 0xad, 0xb4, 0xb3, 0xff, 0xbb, 0xba, 0xac, 0xff,
0xba, 0xb9, 0xab, 0xff, 0xbc, 0xbb, 0xad, 0xff, 0xbd, 0xbc, 0xae, 0xff,
0xbc, 0xbb, 0xad, 0xff, 0xbc, 0xb9, 0xab, 0xff, 0xb4, 0xb0, 0xa5, 0xff,
0xa5, 0xa0, 0x98, 0xff, 0x8f, 0x89, 0x83, 0xff, 0x76, 0x6f, 0x6d, 0xff,
0x5e, 0x55, 0x59, 0xff, 0x47, 0x40, 0x3f, 0xff, 0x33, 0x2d, 0x27, 0xff,
0x3d, 0x39, 0x2e, 0xff, 0x6b, 0x69, 0x59, 0xff, 0x9f, 0xa1, 0x8c, 0xff,
0xb9, 0xba, 0xa6, 0xff, 0xc1, 0xc2, 0xaf, 0xff, 0xbf, 0xc0, 0xad, 0xff,
0xbf, 0xbf, 0xad, 0xff, 0xbe, 0xbe, 0xac, 0xff, 0xbe, 0xbe, 0xac, 0xff,
0xbd, 0xbd, 0xac, 0xff, 0xbd, 0xbd, 0xad, 0xff, 0xbd, 0xbd, 0xab, 0xff,
0x8b, 0x8c, 0x7d, 0xff, 0x89, 0x8a, 0x7a, 0xff, 0x87, 0x8b, 0x7b, 0xff,
0x89, 0x8c, 0x7d, 0xff, 0x87, 0x8c, 0x7f, 0xff, 0x83, 0x8a, 0x7e, 0xff,
0x82, 0x89, 0x7f, 0xff, 0x82, 0x8a, 0x83, 0xff, 0x82, 0x8b, 0x84, 0xff,
0x86, 0x8e, 0x88, 0xff, 0x85, 0x8e, 0x88, 0xff, 0x84, 0x8d, 0x88, 0xff,
0x82, 0x8a, 0x85, 0xff, 0x81, 0x8a, 0x83, 0xff, 0x81, 0x88, 0x7f, 0xff,
0x85, 0x8b, 0x80, 0xff, 0x8b, 0x8f, 0x81, 0xff, 0x8a, 0x8b, 0x7d, 0xff,
0x88, 0x8b, 0x7c, 0xff, 0x90, 0x95, 0x86, 0xff, 0x8d, 0x92, 0x83, 0xff,
0x97, 0x99, 0x89, 0xff, 0x9c, 0x9d, 0x8d, 0xff, 0x9f, 0xa0, 0x90, 0xff,
0xa1, 0xa2, 0x92, 0xff, 0xa6, 0xa7, 0x97, 0xff, 0xab, 0xab, 0x9b, 0xff,
0xad, 0xae, 0x9d, 0xff, 0xaf, 0xaf, 0x9f, 0xff, 0xb0, 0xb0, 0xa0, 0xff,
0xb1, 0xb1, 0xa1, 0xff, 0xb1, 0xb1, 0x9f, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb4, 0xa1, 0xff, 0xb4, 0xb4, 0xa2, 0xff, 0xb4, 0xb4, 0xa2, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff, 0xb3, 0xb3, 0xa3, 0xff,
0xb4, 0xb4, 0xa4, 0xff, 0xb4, 0xb4, 0xa4, 0xff, 0xb5, 0xb4, 0xa4, 0xff,
0xb5, 0xb5, 0xa3, 0xff, 0xb6, 0xb5, 0xa3, 0xff, 0xb7, 0xb7, 0xa5, 0xff,
0xb7, 0xb7, 0xa5, 0xff, 0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff,
0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb8, 0xa6, 0xff,
0xbb, 0xba, 0xa9, 0xff, 0xb8, 0xb6, 0xa5, 0xff, 0xa9, 0xa6, 0x97, 0xff,
0x88, 0x85, 0x76, 0xff, 0x5f, 0x5b, 0x4d, 0xff, 0x57, 0x51, 0x3e, 0xff,
0x81, 0x7c, 0x69, 0xff, 0xa1, 0x9e, 0x8b, 0xff, 0xb6, 0xb5, 0xa6, 0xff,
0xbb, 0xb9, 0xae, 0xff, 0xbf, 0xbc, 0xaa, 0xff, 0xb6, 0xbb, 0xb0, 0xff,
0xc2, 0xc0, 0xac, 0xff, 0x85, 0x8d, 0x8a, 0xff, 0x8c, 0x97, 0x9c, 0xff,
0xb9, 0xba, 0xad, 0xff, 0xb6, 0xb5, 0xa6, 0xff, 0xae, 0xac, 0x9f, 0xff,
0xa5, 0xa4, 0x98, 0xff, 0x8d, 0x8b, 0x7e, 0xff, 0x80, 0x7b, 0x73, 0xff,
0x74, 0x6e, 0x68, 0xff, 0x6e, 0x67, 0x64, 0xff, 0x60, 0x58, 0x59, 0xff,
0x3b, 0x34, 0x34, 0xff, 0x34, 0x2e, 0x2a, 0xff, 0x50, 0x4c, 0x43, 0xff,
0x8b, 0x89, 0x7a, 0xff, 0xb9, 0xb8, 0xa5, 0xff, 0xc5, 0xc4, 0xb1, 0xff,
0xc1, 0xc0, 0xb0, 0xff, 0xbf, 0xbf, 0xaf, 0xff, 0xbf, 0xbf, 0xae, 0xff,
0xbe, 0xbe, 0xac, 0xff, 0xbe, 0xbe, 0xad, 0xff, 0xbf, 0xbf, 0xaf, 0xff,
0xbf, 0xbf, 0xae, 0xff, 0xbe, 0xbf, 0xac, 0xff, 0xbe, 0xbf, 0xab, 0xff,
0xbe, 0xbe, 0xac, 0xff, 0x8b, 0x94, 0x83, 0xff, 0x8a, 0x91, 0x81, 0xff,
0x87, 0x8d, 0x7f, 0xff, 0x86, 0x8c, 0x7c, 0xff, 0x87, 0x8c, 0x7d, 0xff,
0x83, 0x8a, 0x80, 0xff, 0x81, 0x8a, 0x83, 0xff, 0x82, 0x8c, 0x89, 0xff,
0x82, 0x8f, 0x8d, 0xff, 0x7d, 0x8c, 0x8e, 0xff, 0x7a, 0x8c, 0x91, 0xff,
0x78, 0x8b, 0x8f, 0xff, 0x74, 0x87, 0x8c, 0xff, 0x74, 0x86, 0x8a, 0xff,
0x75, 0x84, 0x86, 0xff, 0x7d, 0x87, 0x81, 0xff, 0x87, 0x8d, 0x83, 0xff,
0x86, 0x8b, 0x80, 0xff, 0x8a, 0x8d, 0x81, 0xff, 0x91, 0x95, 0x88, 0xff,
0x90, 0x91, 0x84, 0xff, 0x96, 0x99, 0x88, 0xff, 0x99, 0x9d, 0x8a, 0xff,
0x9b, 0x9f, 0x8c, 0xff, 0xa1, 0xa3, 0x90, 0xff, 0xa7, 0xa8, 0x95, 0xff,
0xa9, 0xac, 0x99, 0xff, 0xac, 0xae, 0x9b, 0xff, 0xad, 0xaf, 0x9c, 0xff,
0xb0, 0xb0, 0x9e, 0xff, 0xb2, 0xb1, 0x9f, 0xff, 0xb1, 0xb2, 0x9e, 0xff,
0xb3, 0xb4, 0xa0, 0xff, 0xb3, 0xb4, 0xa0, 0xff, 0xb3, 0xb4, 0xa0, 0xff,
0xb3, 0xb4, 0xa0, 0xff, 0xb3, 0xb4, 0xa1, 0xff, 0xb3, 0xb4, 0xa1, 0xff,
0xb4, 0xb5, 0xa2, 0xff, 0xb4, 0xb5, 0xa2, 0xff, 0xb4, 0xb4, 0xa2, 0xff,
0xb4, 0xb4, 0xa0, 0xff, 0xb4, 0xb4, 0xa0, 0xff, 0xb4, 0xb4, 0xa0, 0xff,
0xb4, 0xb4, 0xa0, 0xff, 0xb4, 0xb4, 0xa1, 0xff, 0xb5, 0xb3, 0xa5, 0xff,
0xb5, 0xb3, 0xa5, 0xff, 0xb6, 0xb4, 0xa6, 0xff, 0xb6, 0xb4, 0xa6, 0xff,
0xb6, 0xb4, 0xa4, 0xff, 0xb7, 0xb6, 0xa3, 0xff, 0xb8, 0xb8, 0xa5, 0xff,
0xb7, 0xb7, 0xa4, 0xff, 0xb9, 0xb8, 0xa5, 0xff, 0xba, 0xba, 0xa6, 0xff,
0xbb, 0xba, 0xa6, 0xff, 0xb9, 0xb9, 0xa7, 0xff, 0xb7, 0xb8, 0xa7, 0xff,
0xb6, 0xb7, 0xa7, 0xff, 0xb6, 0xb5, 0xa7, 0xff, 0xa9, 0xa7, 0x9a, 0xff,
0x8a, 0x87, 0x79, 0xff, 0x5e, 0x5b, 0x4a, 0xff, 0x57, 0x53, 0x40, 0xff,
0x7c, 0x7c, 0x68, 0xff, 0xa3, 0xa4, 0x8f, 0xff, 0xb8, 0xb8, 0xa6, 0xff,
0xbd, 0xbd, 0xac, 0xff, 0xbd, 0xbd, 0xad, 0xff, 0xbc, 0xbe, 0xac, 0xff,
0xbe, 0xbd, 0xab, 0xff, 0xbe, 0xbd, 0xae, 0xff, 0xb2, 0xb5, 0xac, 0xff,
0x6b, 0x74, 0x70, 0xff, 0xa7, 0xb3, 0xab, 0xff, 0x8d, 0x8a, 0x7f, 0xff,
0x72, 0x6b, 0x68, 0xff, 0x69, 0x63, 0x67, 0xff, 0x51, 0x4a, 0x48, 0xff,
0x36, 0x32, 0x32, 0xff, 0x34, 0x2d, 0x31, 0xff, 0x39, 0x30, 0x33, 0xff,
0x2d, 0x2a, 0x23, 0xff, 0x56, 0x57, 0x48, 0xff, 0xa3, 0xa3, 0x91, 0xff,
0xbd, 0xbd, 0xab, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xbf, 0xbf, 0xad, 0xff,
0xbf, 0xbf, 0xad, 0xff, 0xbf, 0xbf, 0xad, 0xff, 0x96, 0xa0, 0x95, 0xff,
0x92, 0x9a, 0x91, 0xff, 0x8f, 0x92, 0x8b, 0xff, 0x89, 0x8c, 0x83, 0xff,
0x86, 0x8b, 0x83, 0xff, 0x84, 0x8d, 0x86, 0xff, 0x81, 0x8d, 0x8a, 0xff,
0x81, 0x8e, 0x92, 0xff, 0x7d, 0x8c, 0x95, 0xff, 0x75, 0x89, 0x98, 0xff,
0x6d, 0x85, 0x98, 0xff, 0x66, 0x81, 0x99, 0xff, 0x64, 0x80, 0x9a, 0xff,
0x63, 0x7e, 0x97, 0xff, 0x64, 0x7c, 0x8c, 0xff, 0x6b, 0x81, 0x84, 0xff,
0x7a, 0x88, 0x82, 0xff, 0x81, 0x88, 0x82, 0xff, 0x86, 0x8d, 0x85, 0xff,
0x8e, 0x95, 0x8b, 0xff, 0x8c, 0x91, 0x87, 0xff, 0x95, 0x9a, 0x8b, 0xff,
0x98, 0x9d, 0x8c, 0xff, 0x9c, 0x9f, 0x8f, 0xff, 0xa0, 0xa2, 0x92, 0xff,
0xa3, 0xa4, 0x94, 0xff, 0xa6, 0xab, 0x97, 0xff, 0xab, 0xad, 0x99, 0xff,
0xad, 0xaf, 0x9b, 0xff, 0xb0, 0xb1, 0x9d, 0xff, 0xb2, 0xb2, 0x9e, 0xff,
0xb1, 0xb1, 0x9f, 0xff, 0xb3, 0xb3, 0xa0, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb5, 0xb4, 0xa0, 0xff,
0xb5, 0xb4, 0xa0, 0xff, 0xb5, 0xb5, 0xa1, 0xff, 0xb6, 0xb5, 0xa1, 0xff,
0xb5, 0xb5, 0xa1, 0xff, 0xb2, 0xb3, 0xa2, 0xff, 0xb2, 0xb4, 0xa2, 0xff,
0xb2, 0xb3, 0xa2, 0xff, 0xb2, 0xb3, 0xa2, 0xff, 0xb2, 0xb4, 0xa3, 0xff,
0xb4, 0xb3, 0xa4, 0xff, 0xb4, 0xb3, 0xa5, 0xff, 0xb5, 0xb5, 0xa6, 0xff,
0xb5, 0xb5, 0xa6, 0xff, 0xb5, 0xb5, 0xa5, 0xff, 0xb5, 0xb6, 0xa5, 0xff,
0xb6, 0xb7, 0xa6, 0xff, 0xb5, 0xb6, 0xa5, 0xff, 0xb7, 0xb8, 0xa7, 0xff,
0xb8, 0xb8, 0xa6, 0xff, 0xb8, 0xb9, 0xa4, 0xff, 0xb8, 0xb8, 0xa5, 0xff,
0xb6, 0xb7, 0xa3, 0xff, 0xb2, 0xb3, 0x9e, 0xff, 0xa8, 0xa5, 0x93, 0xff,
0x8e, 0x89, 0x77, 0xff, 0x60, 0x5c, 0x49, 0xff, 0x57, 0x52, 0x3e, 0xff,
0x85, 0x80, 0x6b, 0xff, 0xa6, 0xa5, 0x91, 0xff, 0xba, 0xba, 0xa7, 0xff,
0xbe, 0xbe, 0xac, 0xff, 0xbe, 0xbe, 0xad, 0xff, 0xbd, 0xbe, 0xae, 0xff,
0xbf, 0xbd, 0xaf, 0xff, 0xc1, 0xbe, 0xae, 0xff, 0xc0, 0xbe, 0xad, 0xff,
0xbb, 0xbc, 0xae, 0xff, 0x8a, 0x8f, 0x84, 0xff, 0x71, 0x74, 0x78, 0xff,
0x7c, 0x75, 0x7c, 0xff, 0x61, 0x58, 0x59, 0xff, 0x39, 0x34, 0x2f, 0xff,
0x40, 0x36, 0x33, 0xff, 0x27, 0x1f, 0x1d, 0xff, 0x28, 0x22, 0x20, 0xff,
0x2a, 0x25, 0x20, 0xff, 0x78, 0x77, 0x6b, 0xff, 0xbf, 0xbf, 0xaf, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc1, 0xc1, 0xaf, 0xff,
0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff,
0xc1, 0xc1, 0xaf, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0x98, 0xa2, 0x99, 0xff, 0x93, 0x9b, 0x94, 0xff, 0x8c, 0x93, 0x8c, 0xff,
0x88, 0x8e, 0x88, 0xff, 0x89, 0x91, 0x8a, 0xff, 0x81, 0x8e, 0x8c, 0xff,
0x7b, 0x8d, 0x8f, 0xff, 0x78, 0x8a, 0x9a, 0xff, 0x72, 0x89, 0x9d, 0xff,
0x6a, 0x86, 0xa0, 0xff, 0x61, 0x80, 0xa0, 0xff, 0x5a, 0x7c, 0x9d, 0xff,
0x56, 0x78, 0x9a, 0xff, 0x56, 0x76, 0x98, 0xff, 0x56, 0x74, 0x92, 0xff,
0x5f, 0x79, 0x8c, 0xff, 0x6f, 0x80, 0x84, 0xff, 0x7a, 0x85, 0x80, 0xff,
0x80, 0x88, 0x84, 0xff, 0x8b, 0x93, 0x8d, 0xff, 0x8a, 0x91, 0x8b, 0xff,
0x94, 0x9a, 0x8f, 0xff, 0x9a, 0x9e, 0x91, 0xff, 0x9d, 0xa1, 0x93, 0xff,
0xa0, 0xa3, 0x95, 0xff, 0xa2, 0xa4, 0x97, 0xff, 0xa5, 0xa9, 0x95, 0xff,
0xa9, 0xab, 0x97, 0xff, 0xad, 0xae, 0x9a, 0xff, 0xb0, 0xb1, 0x9d, 0xff,
0xb2, 0xb1, 0x9d, 0xff, 0xb2, 0xb2, 0xa0, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff, 0xb3, 0xb3, 0xa1, 0xff,
0xb5, 0xb5, 0xa1, 0xff, 0xb5, 0xb5, 0xa1, 0xff, 0xb5, 0xb5, 0xa1, 0xff,
0xb6, 0xb6, 0xa2, 0xff, 0xb4, 0xb5, 0xa1, 0xff, 0xb5, 0xb5, 0xa2, 0xff,
0xb3, 0xb4, 0xa0, 0xff, 0xb4, 0xb5, 0xa2, 0xff, 0xb4, 0xb5, 0xa1, 0xff,
0xb4, 0xb4, 0xa1, 0xff, 0xb5, 0xb5, 0xa2, 0xff, 0xb5, 0xb5, 0xa2, 0xff,
0xb6, 0xb6, 0xa3, 0xff, 0xb6, 0xb5, 0xa2, 0xff, 0xb5, 0xb5, 0xa2, 0xff,
0xb6, 0xb6, 0xa3, 0xff, 0xb7, 0xb8, 0xa5, 0xff, 0xb8, 0xb7, 0xa4, 0xff,
0xb8, 0xb9, 0xa6, 0xff, 0xb7, 0xb7, 0xa6, 0xff, 0xb6, 0xb6, 0xa4, 0xff,
0xb4, 0xb4, 0xa1, 0xff, 0xa9, 0xa7, 0x93, 0xff, 0x9c, 0x9a, 0x85, 0xff,
0x85, 0x7f, 0x6a, 0xff, 0x66, 0x5f, 0x4a, 0xff, 0x52, 0x4d, 0x38, 0xff,
0x7e, 0x7a, 0x65, 0xff, 0xa4, 0xa0, 0x8b, 0xff, 0xbb, 0xba, 0xa7, 0xff,
0xbf, 0xbf, 0xae, 0xff, 0xbe, 0xbe, 0xad, 0xff, 0xbe, 0xbe, 0xaf, 0xff,
0xbe, 0xbd, 0xaf, 0xff, 0xc2, 0xbd, 0xb2, 0xff, 0xc1, 0xbe, 0xaf, 0xff,
0xc0, 0xc0, 0xad, 0xff, 0xbe, 0xbe, 0xac, 0xff, 0xa2, 0xa1, 0x93, 0xff,
0x82, 0x7e, 0x81, 0xff, 0x63, 0x5b, 0x64, 0xff, 0x3f, 0x39, 0x34, 0xff,
0x89, 0x83, 0x71, 0xff, 0x54, 0x49, 0x40, 0xff, 0x49, 0x3c, 0x39, 0xff,
0x46, 0x40, 0x38, 0xff, 0x56, 0x55, 0x49, 0xff, 0xb8, 0xb9, 0xa9, 0xff,
0xbf, 0xbf, 0xad, 0xff, 0xbf, 0xbf, 0xad, 0xff, 0xc2, 0xc2, 0xb0, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff,
0xc1, 0xc1, 0xaf, 0xff, 0xc1, 0xc1, 0xaf, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff, 0xc0, 0xc0, 0xae, 0xff,
0xc0, 0xc0, 0xae, 0xff, };

#include "RkPainter.h"

int main(int arc, char **argv)
{
        RkMain app(arc, argv);

        // Create main window.
        RK_LOG_DEBUG("create main widget");
        auto widget = new RkWidget(&app);
        widget->setTitle("Label Example");
        //        widget->setBackgroundColor({255, 255, 255, 255});
        widget->setSize(250, 250);

        // RK_LOG_DEBUG("create label");
        // auto label = new RkLabel(widget);
        // label->setTitle("Label with text"); // for debugging only, no effect on label.
        // label->setText("Text");
        // label->setX(10);
        // label->setY(10);
        // label->setSize(100, 94);
        // label->setBackgroundColor(200, 200, 200);
        // label->show();

        auto label = new RkLabel(widget);
        label->setBackgroundColor({255, 255, 255, 255});
        label->setTitle("Label with image");
        label->setImage(RkImage(100, 94, rk_image));
        label->setX(10 + 100 + 5);
        label->setY(10);
        label->setSize(100, 94);
        label->show();

        auto child = new RkLabel(label);
        child->setBackgroundColor({0, 0, 0, 50});
        child->setSize(40, 40);
        child->setPosition(5, 5);
        RkImage img(40, 40);// = RkImage(100, 94, rk_image);
        RkPainter paint(&img);
        paint.fillRect(RkRect(0, 0, 40, 40), {0, 255, 0, 100});
        child->setImage(img);
        child->show();

        // label = new RkLabel(widget);
        // label->setTitle("Label with text & image");
        // label->setText("Text");
        // label->setImage(RkImage(100, 94, rk_image));
        // label->setX(10);
        // label->setY(10 + 94 + 5);
        // label->setSize(100, 94);
        // label->setBackgroundColor(200, 200, 200);
        // label->show();

        widget->show();
        int res = app.exec();
        return res;
}
