#!/bin/sh -e

# $1 version
MAINTAR=../red5_$1.orig.tar.gz
DOCTAR=../red5_$1.orig-doc.tar.gz
PLUGINSTAR=../red5_$1.orig-plugins.tar.gz

# 1) Extract tag from package version
# VERSION=`echo $1 | sed -e 's/[+~].*//g' | sed -e 's/\./_/g'`
# 2) Extract everything after "svn" in $1
REVISION=`echo $1 | sed 's/.*svn//'`

SVN="svn export --ignore-externals -r $REVISION"

# main tarball
DIR=red5-$1.orig
$SVN http://red5.googlecode.com/svn/java/server/trunk/ $DIR
rm -rf $DIR/plugins
GZIP=--best tar -c -z -f $MAINTAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# doc tarball
DIR=red5-$1.orig-doc
$SVN http://red5.googlecode.com/svn/doc/trunk/ $DIR
GZIP=--best tar -c -z -f $DOCTAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# plugins tarball
DIR=red5-$1.orig-plugins
$SVN http://red5.googlecode.com/svn/java/plugins/trunk/ $DIR
GZIP=--best tar -c -z -f $PLUGINSTAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $MAINTAR $origDir
  mv $DOCTAR $origDir
  echo "moved tarballs to $origDir"
fi

exit 0
