#!/bin/sh -e

# $1 version
MAINTAR=../red5_$1.orig.tar.gz
DOCTAR=../red5_$1.orig-doc.tar.gz
DIR=red5-$1.orig

VERSION=`echo $1 | sed -e 's/[+~].*//g' | sed -e 's/\./_/g'`
# Extract everything after "svn" in $1
# REVISION=`echo $1 | sed 's/.*svn//'`

# main tarball
svn export http://red5.googlecode.com/svn/java/server/tags/$VERSION $DIR
GZIP=--best tar -c -z -f $MAINTAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# doc tarball
svn export http://red5.googlecode.com/svn/doc/trunk/ $DIR
GZIP=--best tar -c -z -f $DOCTAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $MAINTAR $origDir
  mv $DOCTAR $origDir
  echo "moved tarballs to $origDir"
fi

exit 0
