.TH get\-edid 1 "2002-10-03" "Debian GNU/Linux"
.SH NAME
get\-edid, parse\-edid \- read\-edid tools to retrieve and interpret
monitor specifications using the VESA VBE DDC protocol
.SH SYNOPSIS
.B get\-edid
|
.B parse\-edid
.br
.B get\-edid
>
.I filename
.br
.B parse\-edid
<
.I filename
.SH DESCRIPTION
The
.I read\-edid
utility comprises two tools:
.B get\-edid
and
.BR parse\-edid .
.PP
.B get\-edid
uses Linux's
.BR vm86 (2)
system call to enter virtual 8086 mode and perform Data Display Channel
(DDC) transfers using the VESA BIOS Extensions (VBE) to retrieve
information from monitors, including identification strings, supported sync
ranges, available video modes, and video mode parameters.  Such information
is often useful for configuring X Window System servers such as XFree86.
.PP
The data obtained by
.B get\-edid
is in a binary format, so the
.B parse\-edid
command is available to interpret it and generate a human-readable block of
text information that can also be included in an XFree86 XF86Config file.
.PP
It is customary to invoke get\-edid and parse\-edid together in a pipeline.
.PP
.B get\-edid
and
.B parse\-edid
accept no options, recognize no environment variables, read no input files,
and create no output files.
.SH AUTHOR
.B get\-edid
and
.B parse\-edid
were written by John Fremlin, Dan Hugo, and Martin Kavalec, using the LRMI
(Linux Real-Mode Interface) library by Josh Vanderhoof.  This manual page
was written by Branden Robinson, originally for Debian GNU/Linux.
.SH "SEE ALSO"
.BR vm86 (2)
.PP
.UR "http://john.fremlin.de/programs/linux/read-edid/"
John Fremlin's
.B read-edid
website
.UE
at http://john.fremlin.de/programs/linux/read-edid/
