/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdstest.h"

QList<RdsTest *> *RdsTest::tests = NULL;

ReturnValue testForErrorFalse(const QString &function, const ReturnValue& ret)
{
	Q_ASSERT_X(ret.isError(), qPrintable(function), qPrintable("Expected error, got: " + ret.toString()));
	return ret;
}

ReturnValue testForError(const QString &function, const ReturnValue& ret)
{
	Q_ASSERT_X(!ret.isError(), qPrintable(function), qPrintable(ret.errString()));
	return ret;
}

RdsTest::RdsTest()
{
}


RdsTest::~RdsTest()
{
}

void RdsTest::runTests()
{
	QStringList args = qApp->arguments();
	QList<RdsTest*> tests;
	for (QStringList::iterator i = args.begin(); i != args.end(); ++i)
	{
		foreach(RdsTest *test, *RdsTest::tests)
		{
			if (*i == test->testName())
			{
				tests << test;
				i = args.erase(i);
				i--;
				break;
			}
		}
	}

	if (tests.count() == 0)
		tests = *RdsTest::tests;
	qDebug() << "Tests to run:" << tests.size();
	foreach(RdsTest *test, tests)
	{
		test->runTest(args);
	}
}

