/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QCoreApplication>
#include <QDebug>
#include <QList>
#include <QPair>
#include <QHostAddress>
#include <QMetaType>
#include <QVariant>
#include "AutomaticMetatypeRegistry"

typedef QPair<QHostAddress, QHostAddress> AddressPair;

Q_DECLARE_METATYPE(QHostAddress);
Q_DECLARE_METATYPE(AddressPair);
Q_DECLARE_METATYPE(QList<AddressPair>);
QTRPC_REGISTER_METATYPE(QHostAddress);
QTRPC_REGISTER_METATYPE(AddressPair);
QTRPC_REGISTER_METATYPE(QList<AddressPair>);

int main(int argc, char *argv[])
{
	QCoreApplication app(argc, argv);

	QByteArray buff;
	{
		QDataStream stream(&buff, QIODevice::WriteOnly);
		QList<AddressPair> listofpairs;
		listofpairs << AddressPair(QHostAddress("1.2.3.4"), QHostAddress("1.2.3.4"));
		listofpairs << AddressPair(QHostAddress("1.2.3.4"), QHostAddress("1.2.3.4"));
		stream << QVariant::fromValue(listofpairs);
	}
	{
		QDataStream stream(&buff, QIODevice::ReadOnly);
		QList<AddressPair> listofpairs;
		QVariant var;
		stream >> var;
		listofpairs = var.value<QList<AddressPair> >();
		qDebug() << listofpairs;
	}
	return 0;
}


