/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSGROUP_H
#define RDSGROUP_H

#include <RdsAdObject>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsGroupPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_SHARED_EXPORT RdsGroup : public RdsAdObject
{
	QXT_DECLARE_PRIVATE(RdsGroup);
public:
	RdsGroup();
	RdsGroup(const RdsGroup &group);
	RdsGroup(const QString &dn);
	~RdsGroup();

	static ReturnValue createGroup(const QString &dn);
	/**
	 *        Gets the common name of the group
	 * @return QString with the cn on success, error on failure.
	 */
	ReturnValue cn() const;
	/**
	 *        Sets the common name of the group
	 * @param cn the commmon name
	 * @return QString with the new dn on success, error on failure.
	 */
	ReturnValue setCn(const QString &cn);
	/**
	 *        Gets a list of members in the group
	 * @return QStringList of members on success, error on failure.
	 */
	ReturnValue members() const;
	/**
	 *        Adds a member to the group
	 * @param dn the distinguished name of the member to add
	 * @return true on success, error on failure.
	 */
	ReturnValue addMember(const QString &dn);
	/**
	 *        Removes a memeber from the group
	 * @param dn the distinguished name of the member to remove
	 * @return true on success, error on failure.
	 */
	ReturnValue removeMember(const QString &dn);
	/**
	 *        Gets a list of groups it is a part of
	 * @return QStringList of groups on success, error on failure.
	 */
	ReturnValue groups() const;
	/**
	 *        Joins a group
	 * @param groupdn the dn of the group to join
	 * @return true on success, error on failure.
	 */
	ReturnValue joinGroup(const QString &groupdn);
	/**
	 *        Leaves a group
	 * @param groupdn the dn of the group to leave
	 * @return true on success, error on failure.
	 */
	ReturnValue leaveGroup(const QString &groupdn);

	/**
	 *        Gets the first description from the "description" attribute
	 * @return QbyteArray containing the description on success, error on failure
	 */
	ReturnValue description() const;
	/**
	 *        Sets the "description" attribute for the group.
	 * @param desc the description
	 * @return true on success, error on failure.
	 */
	ReturnValue setDescription(const QString &desc);
	/**
	 *        Gets the notes for the group from the "info" attribute
	 * @return QString on success, error on failure.
	 */
	ReturnValue notes() const;
	/**
	 *        Sets the "info" attribute for the group. passing and empty string removes the attribute.
	 * @param notes the notes for the group
	 * @return true on success, error on failure.
	 */
	ReturnValue setNotes(const QString &notes);
	/**
	*        Gets the email address for this group
	* @return QString on success, error on failure.
	*/
	ReturnValue email() const;
	/**
	*        Sets the mail attribute for the group
	* @param mail the email address for the group
	* @return true on success, error on failure.
	*/
	ReturnValue displayName() const;
	ReturnValue setDisplayName(const QString &name);
	ReturnValue office() const;
	ReturnValue setOffice(const QString &office);
	ReturnValue phoneNumber() const;
	ReturnValue setPhoneNumber(const QString &number);
	ReturnValue webPage() const;
	ReturnValue setWebPage(const QString &url);
	ReturnValue street() const;
	ReturnValue setStreet(const QString &street);
	ReturnValue poBox() const;
	ReturnValue setPoBox(const QString &po);
	ReturnValue city() const;
	ReturnValue setCity(const QString &city);
	ReturnValue state() const;
	ReturnValue setState(const QString &state);
	ReturnValue country() const;
	ReturnValue setCountry(const QString &country);
	ReturnValue postalCode() const;
	ReturnValue setPostalCode(const QString &code);
	ReturnValue pagerNumber() const;
	ReturnValue setPagerNumber(const QString &pager);
	ReturnValue mobileNumber() const;
	ReturnValue setMobileNumber(const QString &number);
	ReturnValue faxNumber() const;
	ReturnValue setFaxNumber(const QString &number);
	ReturnValue homeNumber() const;
	ReturnValue setHomeNumber(const QString &Number);
	ReturnValue title() const;
	ReturnValue setTitle(const QString &title);
	ReturnValue department() const;
	ReturnValue setDepartment(const QString &department);
	ReturnValue company() const;
	ReturnValue setCompany(const QString &company);
	ReturnValue setEmail(const QString &mail);
	ReturnValue emailAliases();
	ReturnValue setEmailAliases(QStringList aliases);
	ReturnValue accountName();
	ReturnValue setAccountName(QString name);
};

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsGroup& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsGroup& object);
Q_DECLARE_METATYPE(RdsGroup);

#endif
