/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "config.h"
#include "rdsdnsrecord.h"
#include "rdsdnsrecord_p.h"
#include <QDebug>

RdsDnsRecord::RdsDnsRecord()
{
}

RdsDnsRecord::RdsDnsRecord(const RdsDnsRecord& other)
{
	operator=(other);
}

RdsDnsRecord::RdsDnsRecord(QString id)
{
	qxt_d().data->origin = id;
	qxt_d().data->key = id;

	qxt_d().data->origin = qxt_d().data->origin.left(qxt_d().data->origin.indexOf('#'));
	QStringList originPath = qxt_d().data->origin.split(':', QString::SkipEmptyParts);
	qxt_d().data->origin = QString();
	foreach(QString path, originPath)
	{
		qxt_d().data->origin.prepend(path);
		qxt_d().data->origin.prepend('.');
	}
	qxt_d().data->origin = qxt_d().data->origin.mid(1);

	qxt_d().data->key = qxt_d().data->key.left(qxt_d().data->key.lastIndexOf('#'));
	qxt_d().data->key = qxt_d().data->key.mid(qxt_d().data->key.indexOf('#') + 1);

	if (qxt_d().data->key != "IN")
		qxt_d().data->key = qxt_d().data->key.toLower();

	QString typeStr = id;
	typeStr = typeStr.mid(typeStr.lastIndexOf('#') + 1);
	qxt_d().data->type = (RdsDnsZone::RecordType)typeStr.toInt();
}

RdsDnsRecord& RdsDnsRecord::operator=(const RdsDnsRecord & other)
{
	qxt_d().data = other.qxt_d().data;
	return *this;
}

bool RdsDnsRecord::operator==(const RdsDnsRecord& other) const
{
	return qxt_d().data->operator==(*other.qxt_d().data);
}

RdsDnsZone::RecordType RdsDnsRecord::type() const
{
	return qxt_d().data->type;
}

void RdsDnsRecord::setType(RdsDnsZone::RecordType type)
{
	qxt_d().data->type = type;
}

QString RdsDnsRecord::key() const
{
	return qxt_d().data->key;
}

void RdsDnsRecord::setKey(const QString& key)
{
	qxt_d().data->key = key;
	RdsDnsRecordPrivate::normalizeRecord(qxt_d().data->key, qxt_d().data->origin);
}

QString RdsDnsRecord::value() const
{
	return qxt_d().data->value;
}

void RdsDnsRecord::setValue(const QString& value)
{
	qxt_d().data->value = value;
}

QStringList RdsDnsRecord::comments() const
{
	return qxt_d().data->comments;
}

void RdsDnsRecord::setComments(const QStringList& comments)
{
	qxt_d().data->comments = comments;
}

QString RdsDnsRecord::origin() const
{
	return qxt_d().data->origin;
}

void RdsDnsRecord::setOrigin(const QString& origin)
{
	qxt_d().data->origin = origin;
}

QString RdsDnsRecord::ttl() const
{
	return qxt_d().data->ttl;
}

void RdsDnsRecord::setTtl(const QString& ttl)
{
	qxt_d().data->ttl = ttl;
}

QString RdsDnsRecord::id(QString domain)
{
	QString origin = qxt_d().data->origin;
	QString id; //outputs
	if (!qxt_d().data->origin.endsWith('.'))
		origin = origin + '.';
	if (origin.endsWith(domain))
		origin = origin.left(origin.indexOf(domain));
	foreach(QString section, origin.split('.', QString::SkipEmptyParts))
	{
		id.prepend(section + ':');
	}
	id.prepend(domain + ':');
	id = id.left(id.count() - 1);
	id += '#' + qxt_d().data->key + '#' + QString::number(qxt_d().data->type);

	return(id);
}


QDataStream& operator>> (QDataStream& s, RdsDnsRecord& p)
{
	int type = 0;
	s >> type;
	s >> p.qxt_d().data->key;
	s >> p.qxt_d().data->value;
	s >> p.qxt_d().data->comments;
	s >> p.qxt_d().data->origin;
	p.qxt_d().data->type = static_cast<RdsDnsZone::RecordType>(type);
	return s;
}

QDataStream& operator<< (QDataStream& s, const RdsDnsRecord& p)
{
	s << static_cast<int>(p.qxt_d().data->type);
	s << p.qxt_d().data->key;
	s << p.qxt_d().data->value;
	s << p.qxt_d().data->comments;
	s << p.qxt_d().data->origin;
	return s;
}

void RdsDnsRecordPrivate::normalizeRecord(QString& key, QString& origin)
{
	if (key != "IN")
		key = key.toLower();
	origin = origin.toLower();

	if (!key.contains('.'))
		return;
	if (key.endsWith('.'))
	{
		if (!key.endsWith(origin))
		{
			origin = key.mid(key.indexOf(".") + 1);
		}
		return;
	}
	QStringList keyChunks = key.split('.', QString::SkipEmptyParts);

	if (keyChunks.count() < 1)
		return;
	key = keyChunks.at(0);

	if (keyChunks.count() < 2)
		return;

	for (int i = 1; i < keyChunks.count(); ++i)
	{
		origin = keyChunks.at(i) + '.' + origin;
	}
	if (origin == ".")
		origin = QString();
}

