/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef RDSUDISKSEXPANDERINTERFACE_H_1281371800
#define RDSUDISKSEXPANDERINTERFACE_H_1281371800

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

/*
 * Proxy class for interface org.freedesktop.UDisks.Expander
 */
class RdsUDisksExpanderInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "org.freedesktop.UDisks.Expander"; }

public:
    RdsUDisksExpanderInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = 0);

    ~RdsUDisksExpanderInterface();

    Q_PROPERTY(QDBusObjectPath Adapter READ adapter)
    inline QDBusObjectPath adapter() const
    { return qvariant_cast< QDBusObjectPath >(property("Adapter")); }

    Q_PROPERTY(QString Model READ model)
    inline QString model() const
    { return qvariant_cast< QString >(property("Model")); }

    Q_PROPERTY(QString NativePath READ nativePath)
    inline QString nativePath() const
    { return qvariant_cast< QString >(property("NativePath")); }

    Q_PROPERTY(uint NumPorts READ numPorts)
    inline uint numPorts() const
    { return qvariant_cast< uint >(property("NumPorts")); }

    Q_PROPERTY(QString Revision READ revision)
    inline QString revision() const
    { return qvariant_cast< QString >(property("Revision")); }

    Q_PROPERTY(QList<QDBusObjectPath> UpstreamPorts READ upstreamPorts)
    inline QList<QDBusObjectPath> upstreamPorts() const
    { return qvariant_cast< QList<QDBusObjectPath> >(property("UpstreamPorts")); }

    Q_PROPERTY(QString Vendor READ vendor)
    inline QString vendor() const
    { return qvariant_cast< QString >(property("Vendor")); }

public Q_SLOTS: // METHODS
Q_SIGNALS: // SIGNALS
    void Changed();
};

#endif
