/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSCHEDULEMANAGER_P_H
#define RDSSCHEDULEMANAGER_P_H

#include <QxtPimpl>
#include "rdsschedulemanager.h"
#include "rdsschedule.h"

#include <QMutex>

class RdsScheduledEvent;

/**
	@author Chris Vickery <chris@resara.com>
 */
// This is the class that actually does all the schedule magic!
class RdsScheduler : public QObject
{
	Q_OBJECT;
	friend class RdsScheduleManagerPrivate;
public:
	QMutex mutex;
	QHash<QString, RdsScheduledEvent*> eventHash;
	QList<RdsScheduledEvent> events;
protected:
	RdsScheduler();
public slots:
	void processSchedule();
	void executeTask(RdsScheduledEvent* event);
};

class RdsScheduledEvent
{
	friend class RdsScheduler;
public:
	RdsScheduledEvent(const QString& name, const RdsSchedule& schedule, QObject* obj, const char* slot);
	RdsScheduledEvent(const RdsScheduledEvent& other);
	~RdsScheduledEvent();
	QString name();
	void setName(const QString& name);
	RdsSchedule schedule();
	void setSchedule(const RdsSchedule& schedule);
	QWeakPointer<QObject> object();
	void setObject(QWeakPointer<QObject> object);
	QtRpc::Signature slot();
	void setSlot(const QtRpc::Signature& slot);
	QDateTime nextEvent();
	RdsScheduledEvent& operator=(const RdsScheduledEvent& other);
	bool operator==(const RdsScheduledEvent& other) const;
	bool operator<(const RdsScheduledEvent& other) const;
	bool operator<=(const RdsScheduledEvent& other) const;
private:
	QString _name;
	RdsSchedule _schedule;
	QWeakPointer<QObject> _object;
	QtRpc::Signature _slot;
	QDateTime _nextEvent;
};

class RdsScheduleManagerPrivate : public QxtPrivate<RdsScheduleManager>
{
public:
	RdsScheduleManagerPrivate()
	{
	}

	static RdsScheduler& scheduler();
};

#endif
