/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "config.h"
#include "rdsdhcpsubnet.h"
#include "rdsdhcpsubnet_p.h"
#include <QPair>

#define RDS_LOCK \
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex()); \
	if(!qxt_d().values) \
		return ReturnValue(1, "Internal data object is missing in RdsDhcpSubnet");

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsDhcpSubnet);


RdsDhcpSubnet::RdsDhcpSubnet()
		: RdsDhcpValues()
{
}

RdsDhcpSubnet::RdsDhcpSubnet(const RdsDhcpSubnet &other)
		: RdsDhcpValues(other)
{
}

RdsDhcpSubnet::~RdsDhcpSubnet()
{
}

RdsDhcpSubnet& RdsDhcpSubnet::operator=(const RdsDhcpSubnet & other)
{
	RdsDhcpValues::operator=(other);
	return *this;
}

void RdsDhcpSubnet::setData(void* data)
{
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex());
	qxt_d().values = static_cast<RdsDhcpManagerPrivate::Subnet*>(data);
	RdsDhcpValues::setData(data);
}

ReturnValue RdsDhcpSubnet::name() const
{
	RDS_LOCK;
	return qxt_d().values->name;
}

ReturnValue RdsDhcpSubnet::setName(const QString &name)
{
	RDS_LOCK;
	if (qxt_d().values->parent)
	{
		qxt_d().values->parent->subnets.remove(qxt_d().values->name);
		qxt_d().values->parent->subnets.insert(name, qxt_d().values);
	}
	qxt_d().values->name = name;
	return true;
}

ReturnValue RdsDhcpSubnet::address() const
{
	RDS_LOCK;
	return ReturnValue::fromValue(qxt_d().values->address);
}

ReturnValue RdsDhcpSubnet::setAddress(const QHostAddress &addr)
{
	RDS_LOCK;
	qxt_d().values->address = addr;
	return true;
}

ReturnValue RdsDhcpSubnet::netmask() const
{
	RDS_LOCK;
	return ReturnValue::fromValue(qxt_d().values->netmask);
}

ReturnValue RdsDhcpSubnet::setNetmask(const QHostAddress &addr)
{
	RDS_LOCK;
	qxt_d().values->netmask = addr;
	return true;
}

ReturnValue RdsDhcpSubnet::ranges() const
{
	RDS_LOCK;
	return ReturnValue::fromValue(qxt_d().values->getFullRanges());
}

ReturnValue RdsDhcpSubnet::setRanges(const QVariant &r)
{
	RDS_LOCK;
	RangeList ranges = r.value<QList<QPair<QHostAddress, QHostAddress> > >();
	qxt_d().values->addresses.clear();
	foreach(Range range, ranges)
	{
		qxt_d().values->addRange(range.first, range.second);
	}
	return true;
}

ReturnValue RdsDhcpSubnet::setRanges(const RangeList &ranges)
{
	return setRanges(QVariant::fromValue(ranges));
}

