/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
 
#ifndef LOGMANAGER_H
#define LOGMANAGER_H

#include <QObject>
#include <QMap>
#include <QList>
#include <QTextStream>
#include <QDebug>
#include <QMutex>
#include <qxtpimpl.h>

class LogManagerPrivate;
class LogWriterPrivate;

class LogManager
{

public:
	enum LogPriority
	{
		None = -0,
		Critical = 1,
		Error = 2,
		Warning = 4,
		Info = 8,
		Debug = 16,
		ALL = 0xff
	};

	LogManager(const char *name);
	~LogManager();
	void addFile(QString name, bool append = true, int p = ALL, QString s = "");
	void removeFile(QString name);
	void writeLog(LogPriority p, QString section, QString text);
	static LogManager * instance();
	void setMap(QString dest, QString section, int priority);

protected:
	void removeMap(QString dest, QString section, int priority);
	static void messageHandler(QtMsgType type, const char *msg);

private:
	QXT_DECLARE_PRIVATE(LogManager);

	//QMap<QString, LogDest *> logs;
	//QMap<QString, LogMap> maps;
	//QMutex logmutex;
};

class LogDest
{
	public:
		LogDest() { }
		virtual void writeLog(LogManager::LogPriority priority, QString section, QString text) = 0;
		virtual ~LogDest() { }
};

class LogWriter : public QDebug
{
	public:
		LogWriter(LogManager::LogPriority p, QString s);
		LogWriter(const LogWriter& other);
		~LogWriter();

	private:
		LogWriter();
		QXT_DECLARE_PRIVATE(LogWriter);
		QString _data;
};

inline LogWriter lCritical(QString section = "")
{
	return LogWriter(LogManager::Critical, section);
}
inline LogWriter lError(QString section = "")
{
	return LogWriter(LogManager::Error, section);
}
inline LogWriter lWarning(QString section = "")
{
	return LogWriter(LogManager::Warning, section);
}
inline LogWriter lInfo(QString section = "")
{
	return LogWriter(LogManager::Info, section);
}
inline LogWriter qInfo(QString section = "")
{
	return LogWriter(LogManager::Info, section);
}
inline LogWriter lDebug(QString section = "")
{
	return LogWriter(LogManager::Debug, section);
}

#endif
