/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYWIDGET_H
#define RDSENTITYWIDGET_H

#include <QWidget>
#include <QxtPimpl>
#include <QVariant>
#include <QVariant>
#include <ReturnValue>

class QAbstractButton;
class QPushButton;
class QComboBox;
class QLineEdit;
class QTextEdit;
class QSpinBox;
class QDoubleSpinBox;
class QTimeEdit;
class QDateEdit;
class QDateTimeEdit;
class QAbstractSlider;
class RdsEntityManager;
class QPlainTextEdit;
class QLabel;

class RdsEntityWidgetPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsEntityWidget : public QWidget
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsEntityWidget);
public:
	enum Flags
	{
		None = 0,
		NoMulti = 1 << 0
	};

	RdsEntityWidget(RdsEntityManager *manager, QWidget *parent = 0);
	~RdsEntityWidget();

	QPushButton *applyButton();
	void setApplyButton(QPushButton *button);
	QPushButton *discardButton();
	void setDiscardButton(QPushButton *button);

	void addWidget(QString name, QLabel *w, Flags flags = None);
	void addWidget(QString name, QAbstractButton *w, Flags flags = None);
	void addWidget(QString name, QComboBox *w, Flags flags = None);
	void addWidget(QString name, QLineEdit *w, Flags flags = None, QString regex = "", QString errtext = "");
	void addWidget(QString name, QTextEdit *w, Flags flags = None);
	void addWidget(QString name, QPlainTextEdit *w, Flags flags = None);
	void addWidget(QString name, QSpinBox *w, Flags flags = None);
	void addWidget(QString name, QDoubleSpinBox *w, Flags flags = None);
	void addWidget(QString name, QDateTimeEdit *w, Flags flags = None);
	void addWidget(QString name, QAbstractSlider *w, Flags flags = None);
	virtual void addWidget(QString name, QObject *w, QString property, const char * slot = "", Flags flags = None, QVariant null = "");
	virtual void setInput(QString input);
	virtual void setOutputs(QStringList outputs);
	virtual bool unsavedChanges();
	QString input();
	QStringList outputs();
	virtual void setField(QString field, QVariant value);
	virtual void setFieldEnabled(QString field, bool enabled);
	
public slots:
	virtual void apply();
	virtual void discard();
	
protected slots:
	virtual void fieldChanged();
	virtual void fieldChanged(QObject *widget);
	virtual void entityUpdated(QString id);

protected:
	virtual ReturnValue getData() = 0;
	virtual bool beginSetData();
	virtual bool endSetData();
	virtual bool setData(QString id, QVariantMap fields) = 0;
	RdsEntityManager *manager();
	virtual bool validate();
};

#endif
