/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "changepassworddialog.h"
#include <RdsUser>
#include <QMessageBox>
#include <QDebug>
#include <QSettings>
#include <QFile>
#include <QTime>

#include "multigeneratedpassworddialog.h"

ChangePasswordDialog::ChangePasswordDialog(QStringList users, QWidget* parent, Qt::WFlags fl)
		: QDialog(parent, fl), Ui::ChangePasswordDialog()
{
	setupUi(this);
	_users = users;

	if (_users.size() > 1)
	{
		setWindowTitle("Change Passwords");
		ChangeButton->setText("Change &Passwords");
		GenerateButton->setText("&Generate Passwords");
	}

	ReturnValue ret;

	foreach(QString dn, users)
	{
		RdsUser user(dn);
		QString name;
		ret = user.cn();
		if (ret.isError()) name = dn;
		else name = ret.toString();

		_names << name;
	}
}

ChangePasswordDialog::~ChangePasswordDialog()
{
}

void ChangePasswordDialog::accept()
{
	if (PasswordEntry1->text() != PasswordEntry2->text())
	{
		QMessageBox::warning(this, "Error", "The passwords you entered do not match.");
		return;
	}
	
	for (int i = 0; i < _users.size(); i++)
	{
		QString dn = _users[i];
		QString name = _names[i];
		RdsUser user(dn);

		ReturnValue ret = user.setPassword(PasswordEntry1->text());
		if (ret.isError())
		{
			if (ret.errNumber() == 19)
			{
				QMessageBox::warning(this, "Error", QString() + "The password must be at least 6 characters long, not contain the user name, and  contain at least 3 of the following categories of characters.\n" +
				                     "Lowercase Letters [a-z]\n" +
				                     "Upercase Letters [A-Z]\n" +
				                     "Numbers [0-9]\n" +
				                     "Non-Aplhanumeric Characters [!#$^@...]");
				if(_users.size() == 1) return;
				else {
					QDialog::accept();
					continue;
				}
			}
			else
			{
				QMessageBox::critical(this, "Error", "Failed to set password for " + name + ": " + ret.errString());
				QDialog::accept();
				if(_users.size() == 1) return;
				else {
					QDialog::accept();
					continue;
				}
			}
		}

		if (MustChangePassword->isChecked())
		{
			ret = user.setFlag(RdsUser::MustChangePassword);
			if (ret.isError())
			{
				QMessageBox::critical(this, "Error", "Failed to set flag " + name + ": " + ret.errString());
			}
		}
	}

	QDialog::accept();
}

QStringList ChangePasswordDialog::getWordList()
{
        QStringList ret;
        //qDebug() << "Opening my word list";
	QFile file(":/wordList.txt");
	file.open(QFile::ReadOnly);
	while (!file.atEnd())
	{
		ret << QString(file.readLine()).trimmed();
	}
        //qDebug() << "Got these words" << ret.count();
	return ret;
}

QString ChangePasswordDialog::randomCapitolization(QString str, int complexity)
{
	complexity++;
	switch (qrand() % complexity)
	{
		case 0:
		case 1:
			break;
		case 2:
			str = str.at(0).toUpper() + str.mid(1);
			break;
		case 3:
		case 4:
		{
			QString::iterator i = str.begin();
			i += qrand() % str.count();
			*i = (*i).toUpper();
			break;
		}
		default:
			for (int i = qrand() % complexity; i < complexity; ++i)
			{
				QString::iterator it = str.begin();
				it += qrand() % str.count();
				if ((qrand() % complexity) > str.count())
					*it = (*it).toLower();
				else
					*it = (*it).toUpper();
			}
			break;
	}
	return str;
}

QString ChangePasswordDialog::genPassword()
{
	qsrand(QTime::currentTime().msec());
	
	QSettings settings;
	int complexity = settings.value("User/passwordComplexity", 4).toInt();
	QString password;
	for (int i = 1; i <= complexity; ++i)
	{
		password += "%" + QString::number(i);
	}
	complexity--;
	QStringList wordList = getWordList();
        if (wordList.count() < 1)
        {
            qCritical() << "Failed to load a word list! Populating will BS";
            return QString();
        }
	QStringList symbolList = QStringList() << "!" << "@" << "#" << "$" << "%" << "^" << "&" << "*" << "(" << ")" << "_" << "+" << "-" << "=" << "{" << "}" << "[" << "]" << ":" << "," << "." << "/" << "<" << ">" << "?";
	QStringList numberList = QStringList() << "0" << "1" << "2" << "3" << "4" << "5" << "6" << "7" << "8" << "9";
	for (int i = 0; i <= complexity; ++i)
	{
		if (i < complexity)
		{
			password = password.arg(randomCapitolization(wordList.at(qrand() % wordList.count()), complexity));
			i++;
		}
		switch (qrand() % 6)
		{
			case 0:
				password = password.arg(symbolList.at(qrand() % symbolList.count()));
				break;
			case 1:
				password = password.arg(symbolList.at(qrand() % symbolList.count()));
				if (i < complexity && (qrand() % complexity > 3))
				{
					password = password.arg(symbolList.at(qrand() % symbolList.count()));
					i++;
				}
				break;
			case 2:
				password = password.arg(numberList.at(qrand() % numberList.count()));
				break;
			case 3:
				password = password.arg(numberList.at(qrand() % numberList.count()));
				if (i < complexity && (qrand() % complexity > 2))
				{
					password = password.arg(numberList.at(qrand() % numberList.count()));
					i++;
				}
				break;
			case 4:
				password = password.arg(numberList.at(qrand() % numberList.count()));
				if (i < complexity && (qrand() % complexity > 3))
				{
					password = password.arg(symbolList.at(qrand() % symbolList.count()));
					i++;
				}
				break;
			case 5:
				password = password.arg(symbolList.at(qrand() % symbolList.count()));
				if (i < complexity && (qrand() % complexity > 2))
				{
					password = password.arg(numberList.at(qrand() % numberList.count()));
					i++;
				}
				break;
			case 6:
				--i;
				break;
			default:
				password = password.arg("FUUUUUUUUUUUUUUUUUUUUUUUUUUUUCK");
		}
	}
	return password;
}

void ChangePasswordDialog::on_PasswordEntry1_textEdited(QString)
{
	PasswordEntry1->setEchoMode(QLineEdit::Password);
}

void ChangePasswordDialog::on_GenerateButton_clicked()
{
	if (_users.size() > 1)
	{
		MultiGeneratedPasswordDialog dialog(_users, this);
		if (dialog.exec()) accept();

		return;
	}

	QString pwd = genPassword();
	PasswordEntry1->setText(pwd);
	PasswordEntry2->setText(pwd);
	PasswordEntry1->setEchoMode(QLineEdit::Normal);
}

int ChangePasswordDialog::exec()
{
	if (_users.size() > 1)
	{
		if (QMessageBox::question(this, "Question", "You are about to change the password for more than one user. Do you want to continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::No) return(QDialog::Rejected);
	}

	return(QDialog::exec());
}
