/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYMANAGER_H
#define RDSENTITYMANAGER_H

#include <ClientProxy>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsEntityManagerPrivate;
class RdsEntity;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsEntityManager : public QtRpc::ClientProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsEntityManager);
	QTRPC_CLIENTPROXY_PIMPL(RdsEntityManager);
public:
	RdsEntityManager(QObject *parent = 0);
	RdsEntityManager(const RdsEntityManager &other);
	~RdsEntityManager();

	RdsEntityManager &operator=(const RdsEntityManager &other);
	virtual ReturnValue init();

signals:
	QtRpc::ReturnValue addEntity(const QString &entity);
	QtRpc::ReturnValue removeEntity(const QString &entity);
	QtRpc::ReturnValue renameEntity(const QString &oldentity, const QString &newentity);
	QtRpc::ReturnValue updateEntity(const QString &entity);
	QtRpc::ReturnValue updateEntityMetadata(const QString &entity, const QVariantMap &metadata = QVariantMap());
	QtRpc::ReturnValue listEntities(const QString &base);
	QtRpc::ReturnValue listEntities(const QString &base, bool loadmore);
	QtRpc::ReturnValue listEntities(QObject *object, const char *slot, const QString &base);
	QtRpc::ReturnValue listEntities(QObject *object, const char *slot, const QString &base, bool loadmore);
	QtRpc::ReturnValue startEditing(const QString &entity);
	QtRpc::ReturnValue stopEditing(const QString &entity);
	QtRpc::ReturnValue editingList();
	QtRpc::Event entityAdded(const QString &entity);
	QtRpc::Event entityRemoved(const QString &entity);
	QtRpc::Event entityRenamed(const QString &oldentity, const QString &newentity);
	QtRpc::Event entityUpdated(const QString &entity);
	QtRpc::Event entityMetadataUpdated(const QString &entity, const QVariantMap &metadata);
	QtRpc::Event editingStarted(const QString &entity);
	QtRpc::Event editingStopped(const QString &entity);
};

#endif
