#!/bin/bash
# Insert the rc docs into docs/content/rc.md

set -e

go install
mkdir -p /tmp/rclone_cache_test
export RCLONE_CONFIG_RCDOCS_TYPE=cache
export RCLONE_CONFIG_RCDOCS_REMOTE=/tmp/rclone/cache_test
rclone -q --rc mount rcdocs: /mnt/tmp/ &
sleep 0.5
rclone rc > /tmp/z.md
fusermount -z -u /mnt/tmp/

awk '
    BEGIN       {p=1}
    /^<!--- autogenerated start/  {print;system("cat /tmp/z.md");p=0}
    /^<!--- autogenerated stop/   {p=1}
    p' docs/content/rc.md > /tmp/rc.md

mv /tmp/rc.md docs/content/rc.md
