NAME
  ratfor77 - ratfor preprocessor for fortran77

SYNOPSIS
 ratfor [-l n] [-C] [-o output] input

PARAMETERS
 -l n        user sets strating label n
 -o output   specify output file, otherwise it is stdout 
 -C          keep comments in (useful for compiler directives)


DESCRIPTION
Ratfor has the following syntax:

prog:   stat
        prog stat

stat:   if (...) stat
        if (...) stat else stat
        while (...) stat
        repeat stat
        repeat stat until (...)
        for (...;...;...) stat
        do ... stat
        switch (intexpr) { case val[,val]: stmt ... default: stmt }
        break n
        next n
        return (...)
        digits stat
        { prog }  or  [ prog ]  or  $( prog $)
        anything unrecognizable

where stat is any Fortran or Ratfor statement, and intexpr is an
expression that resolves into an integer value.  A statement is
terminated by an end-of-line or a semicolon.  The following translations
are also performed.

        <       .lt.    <=      .le.
        ==      .eq.
        !=      .ne.    ^=      .ne.    ~=      .ne.
        >=      .ge.    >       .gt.
        |       .or.    &       .and.
        !       .not.   ^       .not.   ~       .not.

Integer constants in bases other that decimal may be specified as
n%dddd...  where n is a decimal number indicating the base and dddd...
are digits in that base.  For bases > 10, letters are used for digits
above 9.  Examples:  8%77, 16%2ff, 2%0010011.  The number is converted
the equivalent decimal value using multiplication; this may cause sign
problems if the number has too many digits.

String literals ("..." or '...') can be continued across line boundaries
by ending the line to be continued with an underline.  The underline is
not included as part of the literal.  Leading blanks and tabs on the
next line are ignored; this facilitates consistent indentation.

        include file

will include the named file in the input.

        define (name,value)     or
        define name value

defines name as a symbolic parameter with the indicated value.  Names of
symbolic parameters may contain letters, digits, periods, and underline
character but must begin with a letter (e.g.  B.FLAG).  Upper case is
not equivalent to lower case in parameter names.

        string name "character string"          or
        string name(size) "character string"

defines name to be an integer array long enough to accomodate the ascii
codes for the given character string, one per word.  The last word of
name is initialized to the symbolic parameter EOS, and indicates the end
of string.

KEYWORDS
ratfor fortran preprocessor fortran77 ratfor77 spp

