/* src/hook.c
 *   Contains code for "hooks"
 *
 * Copyright (C) 2004-2005 Lee Hardy <leeh@leeh.co.uk>
 * Copyright (C) 2004-2005 ircd-ratbox development team
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1.Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * 2.Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * 3.The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: hook.c 20234 2005-04-07 13:12:33Z leeh $
 */
#include "stdinc.h"
#include "rserv.h"
#include "hook.h"

static dlink_list hooks[HOOK_LAST_HOOK];

void
hook_add(hook_func func, int hook)
{
	if(hook >= HOOK_LAST_HOOK)
		return;

	dlink_add_tail_alloc(func, &hooks[hook]);
}

int
hook_call(int hook, void *arg, void *arg2)
{
	hook_func func;
	dlink_node *ptr;

	if(hook >= HOOK_LAST_HOOK)
		return 0;

	DLINK_FOREACH(ptr, hooks[hook].head)
	{
		func = ptr->data;
		if((*func)(arg, arg2) < 0)
			return -1;
	}

	return 0;
}
