/*
   Name: $RCSfile: mime.h,v $
   Author: Alan Moran
   $Date: 2005/09/16 21:31:54 $
   $Revision: 1.5 $
   $Id: mime.h,v 1.5 2005/09/16 21:31:54 a_j_moran Exp $

   Description:
   macros and function prototypes to support MIME functionality.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */
#ifndef INCLUDE_MIME_H
#define INCLUDE_MIME_H

BEGIN_C_DECLS

typedef struct _rpl_mime_type {
    rpl_str_t   name;
    int         transformable;  /* 0 = non-transformable, 1=transformable */
}
rpl_mime_type;

typedef struct _rpl_mime_mapping {
    rpl_c_str_t extension;
    rpl_c_str_t mime_type;
}
rpl_mime_mapping;


rpl_str_t   rpl_mime_get_type(rpl_c_str_t filename);
int         rpl_mime_is_transformable(rpl_str_t mime_type);
int         rpl_mime_is_supported_type(rpl_str_t mime_type);

END_C_DECLS

#endif
