/*
   Name: $RCSfile: messages.h,v $
   Author: Alan Moran
   $Date: 2005/07/15 14:38:56 $
   $Revision: 1.7 $
   $Id: messages.h,v 1.7 2005/07/15 14:38:56 nloyola Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_MESSAGES_H
#define INCLUDE_MESSAGES_H

BEGIN_C_DECLS

/**
   @file

   @brief Resource file for application messages.

*/

#include "strutil.h"

#define RPL_EOM (rpl_str_t)NULL

/**  @brief Global message data descriptor. */
typedef struct rpl_msg_global_s {
    /** Init indicator */
    int init;
    /** Static message str ptr */
    char *tptr;
    /** Size of single message */
    int size;
    /** "Not found" prefix*/
    rpl_c_str_t ns_prefix;
}
rpl_msg_global_t;

typedef struct _rpl_message {
    rpl_c_str_t label;
    rpl_c_str_t message;
}
Message;

void rpl_message_init(void);

void rpl_message_done(void);

rpl_str_t rpl_message_get(rpl_c_str_t label, ...);

END_C_DECLS

#endif
