/*
   Name: $RCSfile: http.h,v $
   Author: Alan Moran
   $Date: 2005/07/18 21:44:40 $
   $Revision: 1.6 $
   $Id: http.h,v 1.6 2005/07/18 21:44:40 nloyola Exp $

   Description:
   Function prototypes, macros and structures to support HTTP processing.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_HTTP_H
#define INCLUDE_HTTP_H

BEGIN_C_DECLS

#ifndef BYTE
typedef unsigned char BYTE;
#endif

#define RPL_STR_LF 10
#define RPL_STR_CR 13
#define RPL_HTTP_HDR_SEP "\r\n\r\n"
#define RPL_HTTP_HDR_CRLF "\r\n"
/*
   For details on form content types consult
   http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type
   for details also see
   http://www.ietf.org/rfc/rfc2046.txt
 */
#define RPL_HTTP_DFT_FORM_CONTENT_TYPE "application/x-www-form-urlencoded"
#define RPL_HTTP_MTP_FORM_BDY "boundary="
#define RPL_HTTP_MTP_FORM_BDY_PREFIX "--"
#define RPL_HTTP_MTP_FORM_CONTENT_TYPE "multipart/form-data"
#define RPL_HTTP_MTP_FORM_NAME "name="
#define RPL_HTTP_MTP_FORM_DATA "form-data;"
#define RPL_HTTP_MTP_FORM_FILENAME "filename="
#define RPL_HTTP_MTP_CONTENT_TYPE "Content-Type: "

#define RPL_HTTP_RESP_HDR_CTNT_TYPE "Content-Type:"
#define RPL_HTTP_RESP_HDR "Content-Type:text/html;charset=iso-8859-1\r\n\r\n"
#define RPL_HTTP_RESP_HDR_CHAR_SET ";charset=iso-8859-1"
/* maximum file upload size 1048576 = 1024 * 1024 = 1Mb */
#define RPL_HTTP_MAX_FILE_UPLOAD_SIZE 1048576

/* details http://www.w3.org/TR/REC-html40/interact/forms.html */
#define RPL_HTTP_FILE_UPLOAD_CONTROL_NAME "rapple-filename"

/* A redirect is issued when a datastore resource cannot be found */
#define RPL_HTTP_REDIRECT_HDR "Location: "

/* TODO: consider using a list, e.g., as defined in list.* files */
typedef struct _kvPair {
    rpl_str_t key;
    rpl_str_t value;
    struct _kvPair *next;
}
rpl_http_form_data;

void        rpl_http_parse_query(void);
rpl_str_t   rpl_http_get_parameter(rpl_c_str_t key);
rpl_str_t   rpl_http_get_filename(void);
rpl_str_t   rpl_http_get_remote_user(void);
rpl_str_t   rpl_http_get_content_type(void);
rpl_str_t   rpl_http_get_upload_filename(void);
rpl_str_t   rpl_http_get_local_filename(void);

END_C_DECLS

#endif
