/*
   Name: $RCSfile: globals.h,v $
   Author: Alan Moran
   $Date: 2005/09/16 21:31:54 $
   $Revision: 1.8 $
   $Id: globals.h,v 1.8 2005/09/16 21:31:54 a_j_moran Exp $

   Description:
   Convenience header for commonly required includes.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_GLOBALS_H
#define INCLUDE_GLOBALS_H

#ifdef __cplusplus
#	define BEGIN_C_DECLS 	extern "C" {
#   define END_C_DECLS 		}
#else
#	define BEGIN_C_DECLS
#   define END_C_DECLS
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

BEGIN_C_DECLS

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#include <time.h>

/* order is important since strutil declares types used by other includes */
#include "xmlcommon.h"
#include "list.h"
#include "str_list.h"
#include "strutil.h"
#include "messages.h"
#include "logger.h"
#include "memory.h"
#include "html.h"
#include "fsutil.h"
#include "confp.h"
#include "webasset.h"
#include "digestp.h"
#include "dbm.h"
#include "workflow.h"
#include "registry.h"

END_C_DECLS

#endif
