# Announce: Rakudo Perl 6 compiler, Release #111 (2017.05)

On behalf of the Rakudo development team, I’m very happy to announce the
May 2017 release of Rakudo Perl 6 #111. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.05:
 + Fixes:
    + Made Promise subclass-friendly [a61746fe][a7c23aa2]
    + Fixed unwanted warnings on Windows with `$*HOME` [4ae7c697]
    + Fixed handling of `<1` and NaN in Baggy.pick/.roll [40e4e132][e5d2c6f6]
    + Fixed NaN and empty Baggy handling with Baggy.pick/.(pick|grab)pairs
        [abc0509c][22ba2317][22ba2317][44c89ed9]
    + Fixed SetHash.(iterator|values|kv) to have same semantics
        as (Bag|Mix)Hashes [e5b5d346][e9ae0047]
    + Fixed off-by-one in `lines` routines when `:close` is given [bf399380]
    + Fixed `$*CWD` inside IO::Path.dir's :test Callable [b2a64a13]
    + Fixed regression with IO::Handle.close's value sunked in .slurp [84eb3599]
    + Made spaces and quotes escaped in MAIN() usage message [22bd2bbd]
    + Fixed dispatch hang in Str.match: Nil [1c21974d]
    + Made &slurp/&spurt/&get/&getc/&close `fail` instead of throwing [6fa4bbcb]
    + Made &lines/&words/&slurp/&spurt/&get/&getc/&close pass all of the
        given arguments to the methods they use [6fa4bbcb][34b58d1b]
    + Fixed handling of 8 digit hex literals in 32-bit systems [01dd2138]
    + Fixed $?BITS on 32-bit systems [d057efdb]
    + Fixed time stamp check interfering with packaging modules [ff4a034d]
    + Made perl6 usage message print to STDERR instead of STDOUT when an
      invalid cmd line option is used [2a6d3d1e]
    + Made sure Setty (^) Setty always returns a Set [4e37e7c5]
    + Fixed typed optional Array and Hash parameters [9f5c8e94][6231ecb0]
    + Made `$*HOME` default to Nil, not Any [7412184f]
    + Fixed crash on ^D to `$*IN` when reading with IO::ArgFiles [4b8fd4a4]
    + Fixed REPL crash when `$*HOME` is not set [1b0e41f9]
    + Fixed Test.pm6's &like crash when a non-Str is passed [ba3cf4e5]
    + Fixed Seq.perl for cached Seqs [54f50956]
    + Fixed crash in `eqv`, .iterator, .Slip, .join, .List, .list, .eager, .Array, .is-lazy,
        and .sink on cached Seqs [400f4ec8][c13d89b3]
    + Fixed role mixins with native attrs with defaults [6179ab34]
    + Fixed `andthen`-`orelse` chaining [37316f82][e1994d94][1ed76a90]
    + Fixed issues when `Empty` passed as arg to `andthen`/`notandthen` or postfix `with`/`without`
        [3c8822e8][e1994d94][1ed76a90][fdb2b2ab]
    + Fixed error in Iterable (+) Iterable if the Iterable contained Pairs [3d99321f]
    + Fixed .perl for IO::Path and subclasses [134efd83]
    + Fixed .IO on :U of IO::Path subclasses [69320e7f]
    + Fixed SetHash retaining the containers [551b8a69]
    + Fixed (Bag|Mix)Hash.values/.iterator/.pairs/.kv failing to check validity of assigned
        values [c1bd844e][0e0ac2fb][0338ce46][14e09532][c61c7f88]
    + Fixed 'ambiguous call' error in `eqv` and `cmp` with mixed allomorphs [e5870c11]
    + Fixed IO::Path.copy/move when source/target are same [08a8075f]
    + Fixed premature deletion of bin wrappers [c7aef59a]
    + Fixed ghost elements remaining when popping off an Array [c776c087]
    + Fixed rotate on empty list [b5c14bd1]
    + Fixed hang in .join/.gist in certain cases of flat slurpy positional arg [5e6b3878]
    + Fixed Str.comb(Int, $limit) for `<1` combers [a9959666]
    + Fixed Str.comb with empty-string comber [aa711c14]
    + Fixed unwanted split on read-chunk-size boundaries in IO::Handle.comb/.split by
        making them .slurp the entire file [973338a6]
    + Fixed crash in BagHash.pickpairs when given negative arguments [08b5c101]
    + Fixed incorrect results in `+>` for large negative numbers [ef29bb9f][66e8e72c]
    + Fixed is-deeply for Junction args [1c4d8451][dc5eece9]
    + Fixed crash in is-deeply when Seq type objects are given [f3f99b3a]
    + Fixed dispatch infiniloop in (elem) and (cont) [407bce1d]
    + Fixed issues with combiners on `/` in IO::Spec::Unix.is-absolute [f4309de9]
    + Fixed issues with combiners on `/` in IO::Spec::Win32.rel2abs [c96727aa]
    + Fixed crash when setting .nl-in/.encoding on unopened IO::Handle [06d8800e][70038855]
    + Made IO::Handle.open respect attribute values [95e49dcb]
    + Made IO::Path.parts a Map instead of Hash [9021a486]
    + Made IO::Spec::Unix.path consistently return a Seq in all cases [05479793]
    + Fixed IO::Spec::Win32.path failing to flatten resultant Seq [8992af13][816b2d4b]
    + Fixed IO::Handle.perl.EVAL round-trip [a282b8c8]
    + Made IO::Path.resolve set CWD to $!SPEC.dir-sep [a4127884]
    + Fixed unwanted padding Nils from Str.words($limit) [4bcf84a2]
    + Various improvements to warnings and error reporting
        [9962d2b6][9ed89d94][d87de586][6d28d788][8511081f][4f9fa6b0][12cec7a7][d1a81b30]
        [85c54db8][fc5698bd][1cf7ccba][0bd39de2][12c50b63]
 + Additions:
    + Made user grammars work more like real classes [db42d62f]
    + Loading deps no longer uses file timestamps [ca0a7439]
    + Changed type constraint on &slurp/&dir from Cool:D to IO() [6fa4bbcb][d0cd1372]
    + Added IO::Handle candidate for &spurt [6fa4bbcb]
    + Added Pair.Pair method [bd9e5730]
    + Added Seq.Capture method (makes it possible to unpack Seqs in signatures) [98e137b1]
    + Added QuantHash.Capture [5e74017d]
    + Made `(^)`, `(+)`, `(.)` multis [8b8f66c0][44893e6a][48ce8701]
    + Added primary and foreign key constraints and renamed some fields in
        profiler's SQL output [c776c087]
    + Added WhateverCode candidates to Map.roll and (Bag|Mix)Hash.grabpairs [1e58925c][2bda2703]
    + Made Baggy.roll/.pick/.grab Int-ify their $count arguments [31be5128]
    + Added big int support for `+<` and `+>` ops [6409ee58][ef29bb9f][66e8e72c]
    + Made Date.clone take a formatter [a9a161ae]
    + Added `$*DISTRO` and `$*KERNEL` information to `perl6 -V` output [94c4e7bf][b6496eda]
    + Made `perl6 -V` sort its output [85230d06]
    + Added support for `$*KERNEL.archname` [0c46aff2]
    + Added `$*PERL.compiler.verbose-config` [85230d06][c3b47280]
    + Added typed exceptions to IO::Handle.flush [b43ed18f]
    + Added support for building the dist in install-dist.pl [4298dd5e]
    + Simplified getting osname from VM.config [7c8f8d3e][18706852]
    + Added VM.osname as a rough equivalent to Perl 5's `$^O` [e79d7498][505ee33d]
    + Now show `System::Info` information with -V if module is installed [5feb3906][541597b8]
    + Made IO::Handle.encoding settable via .new [7e9496dd]
    + Added Proc::Async.ready [d76206e7]
    + Implemented $limit arg for IO::Handle.words [84502dc2]
 + Removals:
    + Removed IO::Handle.iterator that existed for a couple of releases [eb8d006e]
    + Removed unspecced Seq.is-ready method [59f6f485]
    + Removed broken Exception.resumable method [f2af3db1]
    + Removed argument forwarding from Instant.DateTime coercer [6bb1b5b4]
    + Removed IO::Path.dir's :absolute and :Str arguments [aa72bdef]
    + Removed .tell info in IO::Handle.gist [276d4a7e]
    + Removed `:directory` from Map returned by `IO::Spec::*.split` [6ed14ef6]
 + Efficiency:
    + Made Mixy (^) Mixy about 150x faster [9f0b1218][bea8ac68]
    + Made Baggy (^) Baggy about 150x faster [ee459360]
    + Made IO::Spec::Win32.is-absolute about 63x faster [c6fd7361]
    + Made Map (^) Map about 50x faster [13924397]
    + Made Setty (+) Setty about 45x faster [14568496]
    + Made Baggy (+) Baggy about 50x faster [ab5cd11b]
    + Made Mixy (+) Mixy about 45x faster [92df7d5c]
    + Made Setty (.) Setty about 35x faster [1562da07]
    + Made Baggy (.) Baggy about 35x faster [3f97831d]
    + Made Mixy (.) Mixy about 35x faster [226cd8b6]
    + Made IO::Spec::Win32.path 26x faster [8992af13][816b2d4b]
    + Made IO::Spec::Cygwin.is-absolute 21x faster [48cf0e67]
    + Made Setty (^) Setty about 20x faster [d92a2123]
    + Made Iterable (+) Iterable about 18x faster [6de08933]
    + Made Map.pick()/roll() about 7x faster [2fb6872b]
    + Made Baggy.pickpairs about 5x faster [c0270c66]
    + Made IO::Spec::Unix.path 4.6x faster [05479793]
    + Made (Bag|Mix)Hash.grabpairs/.grabpairs(N) about 4x faster [911b43de][3670720a]
    + Made Str.words/.lines with $limit arg lazy and up to 3.6x faster [4bcf84a2]
    + Made Iterable (^) Iterable about 3.5x faster [b2332816]
    + Made Map.roll(N) up to 3x faster [c74d37ba]
    + Made Mixy.roll(N) about 3x faster [b9222061]
    + Made IO::Spec::Unix.rel2abs 2.9x faster [277b6e5b]
    + Made Map (+) Map about 2.5x faster [a85b654d]
    + Made Map (.) Map about 2.5x faster [9c9ebd0b]
    + Made Iterable (.) Iterable 2.5x faster [3d99321f]
    + Made Mix.roll() about 2.5x faster [a2602b9c]
    + Made `notandthen` and postfix `without` 2.5x faster [fdb2b2ab]
    + Made `andthen` and postfix `with` 2.5x faster [3c8822e8]
    + Made `orelse` 2.4x faster [37316f82]
    + Made IO::Path.is-relative about 2.1x faster [ff23416b]
    + Made Baggy.pickpairs(N) about 2x faster [0f21f511]
    + Made 1-arg IO::Handle.say up to 2x faster [76af5367]
    + Made BagHash.roll 1.7x faster [07feca67]
    + Made MixHash.total 1.4x faster [5e459bce][4c813666]
    + Made IO::Spec::Win32.split about 82% faster [894ba82d]
    + Made IO::Path.is-absolute about 80% faster [74680d44]
    + Made `&say(**@args)` up to 70% faster [204ea59b]
    + Made `&put(**@args)` up to 70% faster [6d7fc8e6]
    + Made `+>` about 55% faster [ef29bb9f]
    + Made `<+` about 12% faster [6409ee58]
    + Made IO::Spec::Unix.join about 40% faster [d2726676]
    + Made IO::Handle.put($x) about 5%-35% faster [50429b13]
    + Made BagHash.grab 30% faster [2df7060c]
    + Made IO::Path.dir up to 23% faster [aa72bdef]
    + Made Baggy.roll about 15% faster [9e7d0b36]
    + Made BagHash.grab(N) about 10% faster [87a95fc1]
    + Made Baggy.EXISTS-KEY about 8% faster [451a2380]
    + Made List.AT-POS about 5% faster for common path [736be4d4]
    + Made IO::Spec::Win32.rel2abs 6% faster [c96727aa]
    + Made Hash.EXISTS-KEY about 1% faster [eb1ce414]
    + Micro-optimized reg/init dynamic [1d6a0023]
    + Speeded up module loading a bit by persisting source checksum [3829488f]
    + Assorted internal improvements to CPU/memory use [89f2ae4f][3c7cd933][aa23a91f]
        [7c531835][ccedd6b1][3dc08553][514124e3][146f3a39][9cb26c09][afd24a88][f2fc5674]
        [6641df83][d6cf518c][f18d0dc0][1a920dcc][bdb5391b][b1fbd133][7404c706][762fd239]
        [fec547a1][5ec8a464][8088f080][45305eca][e7087f29][f4017c32][3f7d1334][6ea2f12e]
        [788e6de6][3fb3c27e][09506dc8]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Pawel Murias, Daniel Green, Samantha McVey, 
Stefan Seifert, Jan-Olof Hendig, Larry Wall, Tom Browder, Timo Paulssen, 
Christian Bartolomäus, Jonathan Worthington, Will "Coke" Coleda, eater, 
Curt Tilmes, Nick Logan, Trey Harris, Brian S. Julin, Lloyd Fournier, 
Robert Lemmen, Brad Gilbert, Antonio Quinonez, Carl Mäsak, 
Christopher Bottoms, Moritz Lenz, David Warring

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#112), is tentatively scheduled for 2017-06-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation, 
and other software that can be used with the Rakudo compiler to enhance its utility.

