# Announce: Rakudo Perl 6 compiler, Development Release #79 ("Minsk")

On behalf of the Rakudo development team, I'm happy to announce the
August 2014 release of Rakudo Perl 6 #79 "Minsk". Rakudo is an
implementation of Perl 6 on the Moar Virtual Machine[^1], the Java Virtual
Machine and the Parrot Virtual Machine. The tarball for this release
is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it's announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each release
named after a Perl Mongers group. This release is named after Minsk, the
capital and largest city of Belarus.

Some of the changes in this release are outlined below:

+ Many optimizations in both rakudo and the underlying VMs.
+ remove speed penalty of large ranges in character classes
+ quote words syntax \<a b c\> splits on breakable space only
+ Add HyperWhatever / **
+ ∅ is finally recognized as the empty set
+ If the LOLLY envar is set, have (;;), [;;], etc., turn into LoLs. Otherwise, parsefail
+ Add SEQ(a; b) to emulate the old behavior of (a; b)
+ Make &infix:\<xx\> many times faster
+ NaN === NaN (but still NaN != NaN)
+ fix multi-dimensional slice assignment
+ can now call exit() in END blocks without hanging or affecting END block execution

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Elizabeth Mattijsen, Tobias Leich, Jonathan Worthington, Alexander Moquin,
Larry Wall, Rob Hoelz, Jonathan Scott Duff, Will "Coke" Coleda, Timo
Paulssen, Pepe Schwarz, Moritz Lenz, Carlin, sergot, Carl Mäsak, Geoff Broadwell

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC
\#perl6 on freenode.

The next release of Rakudo (#80), is scheduled for September 18, 2014.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

On behalf of the development team, we encourage you to enjoy the new release,
try awesome stuff, have the appropriate amount of fun, and get back to us
with feedback.

[^1]: See <http://moarvm.org/>

[^2]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Nothing else.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.
