/*
 * Test in and out state actions.
 */

#include <stdio.h>

struct state_act 
{
	int cs;

	// Initialize the machine. Invokes any init statement blocks. Returns 0
	// if the machine begins in a non-accepting state and 1 if the machine
	// begins in an accepting state.
	int init( );

	// Execute the machine on a block of data. Returns -1 if after processing
	// the data, the machine is in the error state and can never accept, 0 if
	// the machine is in a non-accepting state and 1 if the machine is in an
	// accepting state.
	int execute( const char *data, int len );

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( );
};

%%{
	machine state_act;

	action a1 { printf( "a1\n"); }
	action a2 { printf( "a2\n"); }
	action b1 { printf( "b1\n"); }
	action b2 { printf( "b2\n"); }
	action c1 { printf( "c1\n"); }
	action c2 { printf( "c2\n"); }

	hi = 'hi';
	main := ( again: hi >~b1 >*b2 '\n' >~c1 >*c2 @{fnext again;} )* >~a1 >*a2;
}%%

%% write data;

int state_act::init( )
{
	%% write init;
	return 1;
}

int state_act::execute( const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;

	if ( cs == state_act_error )
		return -1;
	if ( cs >= state_act_first_final )
		return 1;
	return 0;
}

int state_act::finish( )
{
	%% write eof;
	if ( cs == state_act_error )
		return -1;
	if ( cs >= state_act_first_final )
		return 1;
	return 0;
}

#define BUFSIZE 3
char buf[BUFSIZE];

struct state_act sa;

int main()
{
	sa.init();
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		sa.execute( buf, len );
		if ( len != BUFSIZE )
			break;
	}
	sa.finish( );
/*	if ( state_act_finish( &sa ) <= 0 )*/
/*		printf("Tokenizer FAIL\n");*/
	
	return 0;
}
