/*
 * Test in and out state actions.
 */

#include <stdio.h>

struct state_act 
{
	int cs;
};

%%{
	machine state_act;
	variable curstate fsm->cs;

	action a1 { printf( "a1\n"); }
	action a2 { printf( "a2\n"); }
	action b1 { printf( "b1\n"); }
	action b2 { printf( "b2\n"); }
	action c1 { printf( "c1\n"); }
	action c2 { printf( "c2\n"); }

	hi = 'hi';
	main := ( again: hi >~b1 >*b2 '\n' >~c1 >*c2 @{fnext again;} )* >~a1 >*a2;
}%%

%% write data;

void state_act_init( struct state_act *fsm )
{
	%% write init;
}

void state_act_execute( struct state_act *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;
}

int state_act_finish( struct state_act *fsm )
{
	%% write eof;

	if ( fsm->cs == state_act_error )
		return -1;
	if ( fsm->cs >= state_act_first_final )
		return 1;
	return 0;
}


#define BUFSIZE 3
char buf[BUFSIZE];

struct state_act sa;

int main()
{
	state_act_init( &sa );

	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		state_act_execute( &sa, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	state_act_finish( &sa );
/*	if ( state_act_finish( &sa ) <= 0 )*/
/*		printf("Tokenizer FAIL\n");*/
	
	return 0;
}
