/* This implementes an atoi machine using the statechart paradigm. */

#include <iostream>
#include <stdlib.h>
#include <stdio.h>

using namespace std;

class StateChart
{
	bool neg;
	int val;
	int cs;

public:
	// Initialize the machine. Invokes any init statement blocks. Returns 0
	// if the machine begins in a non-accepting state and 1 if the machine
	// begins in an accepting state.
	void init( );

	// Execute the machine on a block of data. Returns -1 if after processing
	// the data, the machine is in the error state and can never accept, 0 if
	// the machine is in a non-accepting state and 1 if the machine is in an
	// accepting state.
	void execute( const char *data, int len );

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( );
};

%%{
	machine StateChart;

	action begin {
		neg = false;
		val = 0;
	}

	action see_neg {
		neg = true;
	}

	action add_digit { 
		val = val * 10 + (fc - '0');
	}

	action finish {
		if ( neg )
			val = -1 * val;
	}

	atoi = (
		start: (
			'-' @see_neg ->om_num | 
			'+' ->om_num |
			[0-9] @add_digit ->more_nums
		),

		# One or more nums.
		om_num: (
			[0-9] @add_digit ->more_nums
		),

		# Zero ore more nums.
		more_nums: (
			[0-9] @add_digit ->more_nums |
			'' -> final
		)
	) >begin %finish;

	main := ( atoi '\n' @{ cout << val << endl; } )*;
}%%

%% write data;

void StateChart::init( )
{
	%% write init;
}

void StateChart::execute( const char *data, int len )
{
	const char *p = data;
	const char *pe = data+len;

	%% write exec;
}

int StateChart::finish( )
{
	%% write eof;
	if ( cs == StateChart_error )
		return -1;
	if ( cs >= StateChart_first_final )
		return 1;
	return 0;
}

#define BUFSIZE 1024

int main()
{
	char buf[BUFSIZE];
	StateChart atoi;

	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		atoi.init();
		atoi.execute( buf, strlen(buf) );
		if ( atoi.finish() <= 0 )
			cout << "FAIL" << endl;
	}
	return 0;
}
