
#include <stdio.h>
#include <string.h>

int num = 0;

struct CallTest
{
	int curs, top, stack[32];

	%% interface;
};

%% CallTest
{
	init { num = 0; }

	action check_num {
		if ( num & 1 )
			fcall *fentry(odd);
		else
			fcall even;
	}

	# Test call and return functionality.
	even := 'even' any @{fhold; fret;};
	odd := 'odd' any @{fhold; fret;};
	num = [0-9]+ ${ num = num * 10 + (fc - '0'); };
	even_odd = num ' ' @check_num "\n";

	# Test calls in out actions.
	fail := !(any*);
	out_acts = 'OA ok\n' | 
		'OA error1\n' %/{fgoto fail;} |
		'OA error2\n' %/{fcall fail;};

	main := even_odd | out_acts;
}

#define BUFSIZE 1024

int main()
{   
	char buf[BUFSIZE];

	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		CallTest test;

		test.init();
		test.execute( buf, strlen(buf) );
		if ( test.finish() > 0 )
			printf( "ACCEPT\n" );
		else
			printf( "FAIL\n" );
	}
	return 0;
}
