" Vim syntax file
"
" Language: Ragel
" Author: Adrian Thurston

syntax clear

"
" Outside code
"

" Comments
syntax region ocComment start="\/\*" end="\*\/"
syntax match ocComment "\/\/.*$"

" Anything preprocessor
syntax match ocPreproc "#.*$"

" Strings
syntax match ocLiteral "'\(\\.\|[^'\\]\)*'"
syntax match ocLiteral "\"\(\\.\|[^\"\\]\)*\""

" Keywords
syntax keyword ocType unsigned signed void char short int long float double bool
syntax keyword ocType inline static extern register const volatile auto
syntax keyword ocType union enum struct class typedef
syntax keyword ocType namespace template typename mutable
syntax keyword ocKeyword break continue default do else for
syntax keyword ocKeyword goto if return switch while
syntax keyword ocKeyword new delete this using friend public private protected sizeof
syntax keyword ocKeyword throw try catch operator typeid
syntax keyword ocKeyword and bitor xor compl bitand and_eq or_eq xor_eq not not_eq
syntax keyword ocKeyword static_cast dynamic_cast
syntax match ocObjCDirective "@public\|@private\|@protected"
syntax match ocObjCDirective "@interface\|@implementation"
syntax match ocObjCDirective "@class\|@end\|@defs"
syntax match ocObjCDirective "@encode\|@protocol\|@selector"


" Numbers
syntax match ocNumber "[0-9][0-9]*"
syntax match ocNumber "0x[0-9a-fA-F][0-9a-fA-F]*"

" Booleans
syntax keyword ocBoolean true false

" Identifiers
syntax match anyId "[a-zA-Z_][a-zA-Z_0-9]*"

" Inline code only
syntax keyword fsmType fpc fc fcurs fbuf fblen ftargs fstack
syntax keyword fsmKeyword fhold fgoto fcall fret fentry fnext fexec

syntax cluster rlItems contains=rlComment,rlLiteral,rlAugmentOps,rlOtherOps,rlKeywords,anyLabelColon,rlCodeCurly,rlCodeSemi,rlNumber,anyId

" Machine Specification
syntax region machineSpec1 matchgroup=Type start="%%" matchgroup=NONE end=";" keepend contains=@rlItems
syntax match machineSpec2 "%%[\n\t ]*[a-zA-Z_0-9]*[\t ]*$" contains=beginRL nextgroup=rlBlock skipnl
syntax match machineSpec3 "%%[\n\t ]*[a-zA-Z_0-9]*[\n\t ]*{" contains=beginRl,rlBlock
syntax match machineSpec4 "%%[\n\t ]*[a-zA-Z_0-9]*[\n\t ]*init[\n\t ]*{" contains=beginRl,rlActInit,rlCodeCurly
syntax match machineSpec5 "%%[\n\t ]*[a-zA-Z_0-9]*[\n\t ]*action[\n\t ]\+[_a-zA-Z0-9]\+[\n\t ]*{" contains=beginRl,rlActInit,rlCodeCurly

syntax region rlBlock matchgroup=White start="{" end="}" contained contains=@rlItems
syntax match beginRl "%%" contained

" Comments
syntax match rlComment "#.*$" contained

" Literals
syntax match rlLiteral "'\(\\.\|[^'\\]\)*'" contained
syntax match rlLiteral "\"\(\\.\|[^\"\\]\)*\"" contained
syntax match rlLiteral /\/\(\\.\|[^\/\\]\)*\// contained
syntax match rlLiteral "\[\(\\.\|[^\]\\]\)*\]" contained

" Numbers
syntax match rlNumber "[0-9][0-9]*" contained
syntax match rlNumber "0x[0-9a-fA-F][0-9a-fA-F]*" contained

" Operators
syntax match rlAugmentOps "[>$@%][\!\^:\/]\?" contained
syntax match rlOtherOps "->" contained

" Keywords
syntax keyword rlKeywords action init context interface include contained
syntax keyword rlActInit action init contained

" Case Labels
syntax keyword caseLabelKeyword case contained
syntax cluster caseLabelItems contains=ocComment,ocPreproc,ocLiteral,ocType,ocKeyword,caseLabelKeyword,ocNumber,ocBoolean,anyId,fsmType,fsmKeyword
syntax match caseLabelColon "case" contains=@caseLabelItems
syntax match caseLabelColon "case[\t ]\+.*:$" contains=@caseLabelItems
syntax match caseLabelColon "case[\t ]\+.*:[^=:]"me=e-1 contains=@caseLabelItems

" Labels
syntax match anyLabelColon "^[\t ]*[a-zA-Z_][a-zA-Z_0-9]*[ \t]*:$" contains=anyLabel
syntax match anyLabelColon "^[\t ]*[a-zA-Z_][a-zA-Z_0-9]*[ \t]*:[^=:]"me=e-1 contains=anyLabel
syntax match anyLabel "[a-zA-Z_][a-zA-Z_0-9]*" contained

" All items that can go in a code block.

syntax cluster inlineItems contains=rlCodeCurly,ocComment,ocPreproc,ocLiteral,ocType,ocKeyword,ocNumber,ocBoolean,anyId,fsmType,fsmKeyword,caseLabelColon,anyLabelColon

" Blocks of code. rlCodeCurly is recursive.
syntax region rlCodeCurly matchgroup=NONE start="{" end="}" contained contains=@inlineItems
syntax region rlCodeSemi matchgroup=Type start="\<alphtype\>" start="\<getkey\>" start="\<element\>" matchgroup=NONE end=";" contained contains=@inlineItems

"
" Sync at the start of machine specs.
"
syntax sync match ragelSyncPat grouphere NONE "%%&"

"
" Specifying Groups
"
hi link ocComment Comment
hi link ocPreproc Macro
hi link ocLiteral String
hi link ocType Type
hi link ocKeyword Keyword
hi link ocObjCDirective Keyword
hi link ocNumber Number
hi link ocBoolean Boolean
hi link rlComment Comment
hi link rlNumber Number
hi link rlLiteral String
hi link rlAugmentOps Keyword
hi link rlKeywords Type
hi link rlActInit Type
hi link fsmType Type
hi link fsmKeyword Keyword
hi link anyLabel Label
hi link caseLabelKeyword Keyword
hi link beginRl Type
 
let b:current_syntax = "ragel"
