#include <stdio.h>

/*
 * After the fact start and ending transitions. Behaves like constructors of
 * and destructors in c++.
 */

%% forder
	struct {};

	inner = 'inner'
		>{printf("enter inner\n");}
		${printf("inside inner\n");}
		%{printf("leave inner\n");}
	;

	outter = inner
		>{printf("enter outter\n");}
		${printf("inside outter\n");}
		%{printf("leave outter\n");}
	;

	main := outter . '\n';
%%

#include <stdio.h>
#define BUFSIZE 2048

struct forder fsm;
char buf[BUFSIZE];

int main()
{
	forder_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		forder_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( forder_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

