/*
 * Test of a transition going to the error state.
 */

#include <stdio.h>
#define BUFSIZE 2048

%% errintrans
	struct {};

	char = any - (digit | '\n');
	line = char* "\n";
	main := line+;
%%


struct errintrans fsm;
char buf[BUFSIZE];

int main()
{
	errintrans_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		errintrans_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( errintrans_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
		
	return 0;
}

