/*
 * Test error actions.
 */

#include <iostream>
#include <stdio.h>
#import <objc/Object.h>

using namespace std;

#define DIGIT   0x01
#define PLUS    0x02
#define MINUS   0x04
#define DECIMAL 0x08

int expt = 0;

%% ErrAct
	struct : Object {};

	action err_start { 
		if ( fpc != 0 )
			printf("err_start\n");
		else
			printf("eof_start\n");
	}
	action err_all { 
		if ( fpc != 0 )
			printf("err_all\n");
		else
			printf("eof_all\n");
	}
	action err_finish { 
		if ( fpc != 0 )
			printf("err_finish\n"); 
		else
			printf("eof_finish\n");
	}
	action err_out { 
		if ( fpc != 0 )
			printf("err_out\n"); 
		else
			printf("eof_out\n");
	}


	main := ( 'hello' 
			>!err_start $!err_all @!err_finish %!err_out
		) '\n';
%%

#define BUFSIZE 1024

int main()
{
	char buf[BUFSIZE];
	
	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		/* Take the first character to be the length. */
		int len = buf[0] - '0';
		ErrAct *errAct = [[ErrAct alloc] init];

		[errAct start];
		[errAct executeWithElements:buf+1 length:len];
		if ( [errAct finish] > 0 )
			cout << "ACCEPT" << endl;
		else
			cout << "FAIL" << endl;
	}
	
	return 0;
}
