/*
 *  Copyright 2003 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _PTREETYPES_H
#define _PTREETYPES_H

/* Leaf type. */
struct Literal;

/* Tree nodes. */

struct Term;
struct FactorWithAug;
struct FactorWithRep;
struct FactorWithNeg;
struct Factor;
struct Expression;
struct Join;

/* Type of augmentation. Describes locations in the machine. */
enum AugType
{
	at_start,
	at_all,
	at_fin,
	at_leave,

	at_start_gbl_error,
	at_all_gbl_error,
	at_finish_gbl_error,
	at_leave_gbl_error,
	at_start_finish_gbl_error,
	at_finish_leave_gbl_error,

	at_start_local_error,
	at_all_local_error,
	at_finish_local_error,
	at_leave_local_error,
	at_start_finish_local_error,
	at_finish_leave_local_error
};

struct Action;
struct PriorDesc;
struct RegExpr;
struct ReItem;
struct ReOrBlock;
struct ReOrItem;
struct ExplicitMachine;

#endif /* _PTREETYPES_H */
