/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_myid.c,v 1.11.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_myid) = {
	"m_myid",
	"/MYID protocol",
	6, "$Revision: 1.11.2.2 $"
};

int MOD_LOAD(m_myid)()
{
	if (register_command(&MOD_HEADER(m_myid), &CMD_MYID, m_myid) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_myid)()
{
	return MOD_SUCCESS;
}

/*
 * m_myid
 *	parv[0] = source
 *	parv[1] = base64 server id
 */
int m_myid(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!(IsUnknown(sptr) || IsServer(sptr) || IsHandshake(sptr) || IsConnecting(sptr))
	  || !BadPtr(sptr->id.string) || (parc != 2) || !CapID(sptr) || (cptr != sptr)) {
		return 0;
	}

	if (is_id(parv[1]) && valid_servid(parv[1])) {
		strncpyzt(cptr->id.string, parv[1], IDLEN + 1);
	}

	return 0;
}
