/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: packet.c,v 1.29.2.1 2004/12/07 03:05:30 pneumatus Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "msg.h"
#include "h.h"
#include "ssl.h"
#include "zlink.h"
#include "memory.h"

int serv_dopacket(aClient *cptr, char *buffer, int length)
{
	char *ch1, *ch2, *cptrbuf, *nbuf = NULL;
	int nlen;

	ASSERT(cptr != NULL);
	ASSERT(cptr->localClient != NULL);

	cptrbuf = cptr->localClient->buffer;

#ifdef USE_OPENSSL
	if (InputRC4(cptr)) {
		rc4_process_stream(cptr->serv->rc4_in, buffer, length);
	}
#endif

	cptr->localClient->receiveB += length;
	me.localClient->receiveB += length;

	if (cptr->localClient->receiveB > 1023) {
		cptr->localClient->receiveK += (cptr->localClient->receiveB >> 10);
		cptr->localClient->receiveB &= 0x03ff;
	}
	if (me.localClient->receiveB > 1023) {
		me.localClient->receiveK += (me.localClient->receiveB >> 10);
		me.localClient->receiveB &= 0x03ff;
	}

zcontinue:
	ch1 = cptrbuf + cptr->localClient->count;
	ch2 = buffer;

	if (InputZIP(cptr)) {
		int err;

		ch2 = zip_input(cptr->serv->zip_in, ch2, &length, &err, &nbuf, &nlen);
		if (length == -1) {
			sendto_realops("ZipIn error for %s: (%d) %s", cptr->name, err, ch2);
			return exit_client(cptr, cptr, &me, "Fatal error in zip_input()");
		}
	}
	while (--length >= 0) {
		char g = (*ch1 = *ch2++);
		if (g < '\16' && (g == '\n' || g == '\r')) {
			if (ch1 == cptrbuf) {
				continue;
			}

			*ch1 = '\0';

			me.localClient->receiveM++;
			cptr->localClient->receiveM++;
			if (cptr->localClient->listener != NULL) {
				cptr->localClient->listener->receiveM++;
			}

			cptr->localClient->count = 0;

			switch (serv_parse(cptr, cptr->localClient->buffer, ch1)) {
				case FLUSH_BUFFER:
					return FLUSH_BUFFER;
				case ZIP_NEXT_BUFFER:
					if (length) {
						int err;

						ch2 = zip_input(cptr->serv->zip_in, ch2, &length, &err, &nbuf, &nlen);
						if (length == -1) {
							sendto_realops("ZipIn error for %s: (%d) %s", cptr->name,
								err, ch2);
							return exit_client(cptr, cptr, &me, "Fatal error in zip_input()");
						}
					}
					break;
#ifdef USE_OPENSSL
				case RC4_NEXT_BUFFER:
					if (length) {
						rc4_process_stream(cptr->serv->rc4_in, ch2, length);
					}
					break;
#endif
				default:
					break;
			}

			if (DeadSocket(cptr)) {
				return exit_client(cptr, cptr, &me, SendQEx(cptr) ? "SendQ Exceeded" : "Dead Socket");
			}

			ch1 = cptrbuf;
		}
		else if (ch1 < cptrbuf + (BUFSIZE - 1)) {
			ch1++;
		}
	}

	cptr->localClient->count = ch1 - cptrbuf;

	if (nbuf != NULL) {
		buffer = nbuf;
		length = nlen;
		nbuf = NULL;
		goto zcontinue;
	}

	return 1;
}

int user_dopacket(aClient *cptr, char *buffer, int length)
{
	ASSERT(cptr != NULL);
	ASSERT(cptr->localClient != NULL);

	strncpy(cptr->localClient->buffer, buffer, BUFSIZE);
	length = strlen(cptr->localClient->buffer);

	me.localClient->receiveM++;
	cptr->localClient->receiveM++;

	cptr->localClient->receiveB += length;
	if (cptr->localClient->receiveB & 0x0400) {
		cptr->localClient->receiveK += (cptr->localClient->receiveB >> 10);
		cptr->localClient->receiveB &= 0x03ff;
	}

	me.localClient->receiveB += length;
	if (me.localClient->receiveB > 1023) {
		me.localClient->receiveK += (me.localClient->receiveB >> 10);
		me.localClient->receiveB &= 0x03ff;
	}

	cptr->localClient->count = 0;

	if (user_parse(cptr, cptr->localClient->buffer, (cptr->localClient->buffer + length)) == FLUSH_BUFFER) {
		return FLUSH_BUFFER;
	}
	if (DeadSocket(cptr)) {
		return exit_client(cptr, cptr, &me,
			SendQEx(cptr) ? "SendQ Exceeded" : "Dead Socket");
	}

	return 1;
}
