#include "move.h"
#include "spaceobj.h"
#include "trigtable.h"
#include "defs.h"
#include <vector>

using namespace std;

//{
Move::Move( double _dx, double _dy ):
o_dx( _dx ),
o_dy( _dy ){
	dx = _dx;
	dy = _dy;

	actualx = NULL;
	actualy = NULL;
	virtualx = NULL;
	virtualy = NULL;

	accel_x = 0;
	accel_y = 0;
}

int Move::AX(){
	if ( actualx != NULL ) 
		return *actualx;
	return 0;
}

int Move::AY(){
	if ( actualy != NULL )
		return *actualy;
	return 0;
}

void Move::setP( int & ax, int & ay, double & vx, double & vy ) {
	actualx = &ax;
	actualy = &ay;
	virtualx = &vx;
	virtualy = &vy;
}


double Move::Accel_X(){
	return accel_x;
}

double Move::Accel_Y(){
	return accel_y;
}

void Move::setD( double _dx, double _dy ) {
	dx = _dx;
	dy = _dy;
}


bool Move::action( vector< SpaceObject * > * fight ) {
	return MoveReal();
}


double Move::DX() {
	return dx;
}


double Move::DY() {
	return dy;
}


bool Move::MoveReal() {

	*virtualx += dx;
	*virtualy += dy;
	*actualx = (int)*virtualx;
	*actualy = (int)*virtualy;

	if ( *actualy >= screen_y+100 || *actualx < -100 || *actualx > screen_x+100 || *actualy < -500 ) return true;
	return false;
}


//}
//{
MoveHorizontal::MoveHorizontal( double _dx, double _dy ):
Move( _dx, _dy ) {
	dir = 1;
	//dx = 2.3;
}


bool MoveHorizontal::action( vector< SpaceObject * > * fight ) {

	if ( *actualx > screen_x-20 ) dir = -1;
	if ( *actualx < 20 ) dir = 1;

	dx = dir * o_dx;
	dy = o_dy;
	return MoveReal();
}


//}
//{
MoveMine::MoveMine( double _dx, double _dy ):
Move( _dx, _dy ),
fx( -1 ),
fy( -1 ),
sx( _dx ),
sy( dy ){}

bool MoveMine::action( vector< SpaceObject * > * fight ) {

	if ( fight->empty() ) return MoveReal();

	if ( fx == -1 || fy == -1 || (rnd(30)==rnd(30)) ) {
		SpaceObject * attack = fight->front();
		if ( attack != NULL ) {
			fx = attack->getX() + rnd(20) - 10;
			fy = attack->getY() + rnd(20) - 10;
			int sang = gang( *actualx, *actualy, fx, fy );
			double gm = fabs( sx ) > fabs( sy ) ? fabs(sx) : fabs( sy );

			accel_x = tcos[sang];
			accel_y = tsine[sang];

			dx = accel_x * gm;
			dy = accel_y * gm;
		}
	}

	return MoveReal();

}


//}
//{
MoveAngular::MoveAngular( double _dx, double _dy ):
Move( _dx, _dy ),
ang( 0 ),
dir( rnd(10) + 2 ) {
	if ( dx == 0 ) dx = dy;
}


bool MoveAngular::action( vector< SpaceObject * > * fight ) {

	ang += dir;
	while ( ang >= 360 ) ang -= 360;
	while ( ang < 0 ) ang += 360;

	accel_x = tcos[ang];
	accel_y = tsine[ang];

	dx = accel_x * fabs(o_dx);
	dy = accel_y * fabs(o_dy) + 2;
	return MoveReal();

}


//}
//{
MoveSwingRight::MoveSwingRight( double _dx, double _dy ):
Move( _dx, _dy ){
	accel_x = 0.15;
	accel_y = 0;
}

bool MoveSwingRight::action( vector< SpaceObject * > * fight ) {
	if ( *actualy > 0 ) dx += accel_x;
	return MoveReal();
}


//}
//{
MoveSwingLeft::MoveSwingLeft( double _dx, double _dy ):
Move( _dx, _dy ){
	accel_x = -0.15;
	accel_y = 0;
}

bool MoveSwingLeft::action( vector< SpaceObject * > * fight ) {

	if ( *actualy > 0 ) dx += accel_x;
	return MoveReal();
}


//}
//{
MoveSwingDown::MoveSwingDown( double _dx, double _dy ):
Move( _dx, _dy ){
	accel_x = 0;
	accel_y = 0.13;
}

bool MoveSwingDown::action( vector< SpaceObject * > * fight ) {

	//if ( *actualy > 0 ) dy += 0.35;
	dy += accel_y;
	return MoveReal();
}


//}
//{
MoveSine::MoveSine( double _dx, double _dy ):
Move( _dx, _dy ),
ang( 0 ){}

bool MoveSine::action( vector< SpaceObject * > * fight ) {
	accel_x = tcos[ang];
	dx = accel_x * fabs( o_dx );
	ang = (ang+6) % 360;
	return MoveReal();
}


//}
//{
MoveCircle_Player::MoveCircle_Player( double _dx, double _dy ):
Move( _dx, _dy ),
ang( 90 ) {

	find_circle = rnd( 4 ) + 3;

}


bool MoveCircle_Player::action( vector< SpaceObject * > * fight ) {

	if ( fight->empty() ) return MoveReal();
	SpaceObject * s = fight->front();

	int sang = gang( s->getX(), s->getY(), *actualx, *actualy );
	ang = (sang + find_circle) % 360;
	int fx = (int)( s->getX() + tcos[ ang ] * 150 );
	int fy = (int)( s->getY() + tsine[ang ] * 150 );
	sang = gang( *actualx, *actualy, fx, fy );
	double fmax = fabs( o_dx ) > fabs( o_dy ) ? fabs( o_dx ) : fabs( o_dy );

	accel_x = tcos[sang];
	accel_y = tsine[sang];
	
	dx = accel_x * fmax;
	dy = accel_y * fmax;

	return MoveReal();
}


//}
