#include "defs.h"
#include "allegro.h"
#include "hull_player.h"
#include "hull_rotate.h"
#include "ebox.h"
#include "section.h"
#include "gunobj.h"

#include <stdio.h>

#define MAX_INTERNAL_DAMAGE 30

PlayerHull::PlayerHull( BITMAP ** _pics, int _max_pics, int _maxlife, int _maxshield, int _number_of_guns, int _hull_number, ECollide * eb ):
HullObject( NULL, _maxlife, SHIP_DAMAGE, _number_of_guns, 1, 10, false, eb ),
shield( 0 ),
cloak( 0 ),
MAX_SHIELD( _maxshield ),
MAX_LIFE( _maxlife ),
hull_num( _hull_number ),
internal_damage( 0 ),
current_accessory( 0 ),
animation_pic( _max_pics/2 ),
max_pics( _max_pics ) {
	pics = _pics;

	pics_shadow = new BITMAP*[ max_pics ];
	for ( int q = 0; q < max_pics; q++ ){
		pics_shadow[q] = create_bitmap( pics[q]->w, pics[q]->h );
		int m = 22;
		clear_to_color( pics_shadow[q], makecol(m,m,m) );
		draw_mask( pics_shadow[q], pics[q], 0, 0 );
	}
	
	Bitmap = pics[ max_pics / 2 ];
	for ( int q = 0; q < MAX_ROTATE; q++ ) {
		rotate[q] = NULL;
		rotate_damage[q] = NULL;
	}
	shade_damage = new int[ MAX_INTERNAL_DAMAGE ];
	blend_palette( shade_damage, MAX_INTERNAL_DAMAGE*3/5, makecol(5,5,20),makecol(60,60,250) );
	blend_palette( shade_damage+MAX_INTERNAL_DAMAGE*3/5, MAX_INTERNAL_DAMAGE-MAX_INTERNAL_DAMAGE*3/5,
		makecol(60,60,250), makecol(255,255,255) );

	for ( int q = 0; q < MAX_ACCESSORY; q++ )
		accessory[q] = NULL;

	true_guns = new WeaponObject*[ _number_of_guns + 1 ];
}


PlayerHull::~PlayerHull() {

	for ( int q = 0; q < MAX_ROTATE; q++ ) {
		if ( rotate[q] != NULL )
			delete rotate[q];
		if ( rotate_damage[q] != NULL )
			delete rotate_damage[q];
	}

	for ( int q = 0; q < MAX_ACCESSORY; q++ )
		if ( accessory[q] != NULL )
			delete accessory[q];

	for ( int q = 0; q < max_pics; q++ )
		destroy_bitmap( pics_shadow[q] );
	delete[] pics_shadow;

	if ( collide ) delete collide;
	delete[] shade_damage;
	delete[] true_guns;
	delete[] pics;
	Shadow_Bitmap = NULL;

}


HullObject * PlayerHull::copy() {

	BITMAP ** s_pics = new BITMAP*[ max_pics ];
	for ( int q = 0; q < max_pics; q++ )
		s_pics[q] = pics[q];
	HullObject * who = new PlayerHull( s_pics, max_pics, MAX_LIFE, MAX_SHIELD, this->maxGuns()-1, hull_num, collide->copy() );
	((PlayerHull *)who)->life = life;
	((PlayerHull *)who)->shield = shield;
	for ( int q = 0; q < this->maxGuns()-1; q++ )
		if ( this->Guns()[q] != NULL )
			who->guns[q] = this->Guns()[q]->copy();
	else    who->guns[q] = NULL;

	for ( int q = 0; q < MAX_ACCESSORY; q++ )
		if ( this->accessory[q] != NULL )
			((PlayerHull *)who)->accessory[q] = this->accessory[q]->copy();
	else    ((PlayerHull *)who)->accessory[q] = NULL;
	return who;
}


void PlayerHull::Moved( double _dx, double _dy, double _ax, double _ay ) {
	if ( cloak > 0 ) cloak--;

	/*
	if ( _dx < 0 && animation_pic > 0 )
		animation_pic--;
	if ( _dx > 0 && animation_pic < max_pics-1 )
		animation_pic++;
	if ( _dx == 0 ){

		if ( animation_pic < max_pics/2 ) animation_pic++;
		else if ( animation_pic > max_pics/2 ) animation_pic--;
		
	}
	*/
	if ( _ax > 0 && animation_pic < max_pics-1 )
		animation_pic++;
	if ( _ax < 0 && animation_pic > 0 )
		animation_pic--;
	if ( _ax == 0 ){
		if ( animation_pic < max_pics/2 ) animation_pic++;
		else if ( animation_pic > max_pics/2 ) animation_pic--;
	}
	
	HullObject::Moved(_dx,_dy,_ax,_ay);
}


int PlayerHull::max( int q ) {
	switch( q ) {
		case 0  :       return MAX_LIFE;
		case 1  :       return MAX_SHIELD;
	}
	return 0;
}


int PlayerHull::rank() {
	return hull_num;
}


void PlayerHull::addSection( SpaceObject * who, Section * onscreen, int x, int y ) {
	if ( cloak > 0 ) return;
	HullObject::addSection( who, onscreen, x, y );

	/*

	if ( Translucent() ) return;
	if ( onscreen == NULL ) return;

	int y1 = y;
	int y2 = y;
	if ( collide ) {
		y1 = collide->CY1( collide->ul_y + y );
		y2 = collide->CY1( collide->lr_y + y );
	}

	onscreen->add( who, x, y1 );
	for ( int q = y1+onscreen->spacer(); q < y2; q += onscreen->spacer() )
	onscreen->add( who, x, q );
	if ( y2 != y1 )
	onscreen->add( who, x, y2 );
	*/

}


int PlayerHull::maxGuns() {
	return max_guns+1;
}


WeaponObject ** PlayerHull::Guns() {
	for ( int q = 0; q < maxGuns()-1; q++ )
		true_guns[q] = HullObject::Guns()[q];
	true_guns[ maxGuns()-1 ] = accessory[ current_accessory ];
	return true_guns;
}


WeaponObject ** PlayerHull::Accessories() {
	return accessory;
}


void PlayerHull::NextAccessory() {

	//if ( pcount( (char **)accessory, MAX_ACCESSORY ) == 0 ) return;

	int old = current_accessory;
	for ( old = current_accessory+1; old != current_accessory; old %= MAX_ACCESSORY ) {
		if ( accessory[old] != NULL ) {
			current_accessory = old;
		} else old++;
	}

}


void PlayerHull::giveWeapon( WeaponObject * weap, int num ) {

	if ( num < maxGuns()-1 ) {
		guns[ num ] = weap;
		return;
	}

	for ( int q = 0; q < MAX_ACCESSORY; q++ )
	if ( accessory[q] == NULL ) {
		accessory[q] = weap;
		return;
	}
}

BITMAP * PlayerHull::getShadow(){
	return pics_shadow[ animation_pic ];
}

/*
void PlayerHull::Shadow( BITMAP * who, int x, int y ) {
	//int mx = ((BITMAP *)dat[ drawNum ].dat)->w/2;
	//int my = ((BITMAP *)dat[ drawNum ].dat)->h/2;
	//draw_lit_sprite( who, (BITMAP *)dat[ drawNum ].dat, (int)(x-mx+dx), (int)(y-my+dy), 250 );
	Bitmap = pics[ animation_pic ];
	//int mx = Bitmap->w/2;
	//int my = Bitmap->h/2;
	//draw_lit_sprite( who, Bitmap, (int)(x-mx+dx), (int)(y-my+dy), 250 );
	HullObject::Shadow( who, x, y );
}
*/

void PlayerHull::Draw( BITMAP * who, int x, int y ) {

	//int xpl = ((BITMAP *)dat[ drawNum ].dat)->w;
	//int ypl = ((BITMAP *)dat[ drawNum ].dat)->h;
	Bitmap = pics[ animation_pic ];
	int xpl = Bitmap->w;
	int ypl = Bitmap->h;

	if ( internal_damage ) {
		internal_damage--;

		for ( int q = 0; q < MAX_ROTATE; q++ ) {
			if ( rotate_damage[q] == NULL )
				rotate_damage[q] = new RotateHull(MAX_INTERNAL_DAMAGE,xpl,ypl,7,shade_damage);
			if ( rotate_damage[q] )
				rotate_damage[q]->color = internal_damage;
		}

	}
	else {
		for ( int q = 0; q < MAX_ROTATE; q++ )
		if ( rotate_damage[q] ) {
			delete rotate_damage[q];
			rotate_damage[q] = NULL;
		}
	}

	for ( int q = 0; q < MAX_ROTATE; q++ )
	if ( shield <= MAX_SHIELD*q/MAX_ROTATE && rotate[q] != NULL ) {
		delete rotate[q];
		rotate[q] = NULL;
	}

	for ( int q = 0; q < MAX_ROTATE; q++ )
		if ( shield > MAX_SHIELD*q/MAX_ROTATE && rotate[q] == NULL )
			rotate[q] = new RotateHull((MAX_E_COLOR-1)*(q+1)/MAX_ROTATE,xpl,ypl,15,e_color);

	if ( cloak == 0 )
		HullObject::Draw( who, x, y );
	else {
		//int mx = ((BITMAP *)dat[ drawNum ].dat)->w/2;
		//int my = ((BITMAP *)dat[ drawNum ].dat)->h/2;
		//draw_trans_sprite( who, (BITMAP *)dat[ drawNum ].dat, x-mx, y-my );
		//draw_lit_sprite( who, (BITMAP *)dat[ drawNum ].dat, x-mx, y-my, 150 );
		int mx = xpl / 2;
		int my = ypl / 2;
		draw_lit_sprite( who, Bitmap, x-mx, y-my, 150 );
	}

	for ( int q = 0; q < MAX_ROTATE; q++ ) {
		if ( rotate[q] != NULL )
			rotate[q]->Draw( who, x, y );
		if ( rotate_damage[q] != NULL )
			rotate_damage[q]->Draw( who, x, y );
	}

}


void PlayerHull::frameLeft() {
	if ( animation_pic > 0 ) animation_pic--;
}


void PlayerHull::frameRight() {
	if ( animation_pic < max_pics-1 ) animation_pic++;
}


void PlayerHull::frameStable() {
	if ( animation_pic < max_pics / 2 ) animation_pic++;
	if ( animation_pic > max_pics / 2 ) animation_pic--;
}


double PlayerHull::Damage( double r ) {

	double dam = 0;
	if ( r > shield ) {
		shield = 0;
		dam = r-shield;
	} else shield -= r;

	if ( dam > 0 )
		internal_damage = MAX_INTERNAL_DAMAGE;
	return dam;
	//life -= dam;

}


void PlayerHull::drawGun( BITMAP * who, int x, int y ) {
}


void PlayerHull::showAttribute( BITMAP * who, int amount, int MAX, int start_x, int offset ) {
	#define start_attr 470
	for ( int z = 0; z < amount; z++ ) {
		int base = expl_color - 60;
		base += z * 60 / MAX;
		int start = start_attr * z / MAX;
		base = (int)( (double)z / (double)MAX * (double)(MAX_E_COLOR-15) + 15 );
		rectfill( who, start_x, start_attr-start+offset, start_x+9, start_attr-start+1+offset, e_color[base] );
	}
}
